/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.gen;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.gen.MapGenBase;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.util.BlockPosition;

public class WorldGenSwampTree
extends MapGenBase {
    Map<BlockPosition, BlockMeta> cachedCanopy;
    Map<BlockPosition, BlockMeta> cachedRoots;
    private static final double arcSize = 16.0;
    int chancePerChunk;

    public WorldGenSwampTree(int chancePerChunk) {
        chancePerChunk = 10;
        this.cachedCanopy = new HashMap<BlockPosition, BlockMeta>();
        this.cachedRoots = new HashMap<BlockPosition, BlockMeta>();
        this.chancePerChunk = chancePerChunk;
        this.buildCanopy();
        this.buildRoots();
    }

    private void buildRoots() {
        this.cachedRoots.clear();
        for (double Yangle = 0.0; Yangle < Math.PI * 2; Yangle += 1.0471975511965976) {
            int yOffset = (int)(20.0 * Math.sin(Math.PI)) + 1;
            int xOffset = (int)(17.6 * Math.cos(Math.PI) * Math.cos(Yangle));
            int zOffset = (int)(17.6 * Math.cos(Math.PI) * Math.sin(Yangle));
            for (double angle = Math.PI; angle > 0.0; angle -= 0.07853981633974483) {
                int zz;
                int yy = (int)(20.0 * Math.sin(angle));
                double xzRadius = 12.0 * Math.cos(angle);
                int xx = (int)(xzRadius * Math.cos(Yangle));
                if (!this.cachedRoots.containsKey(new BlockPosition(2 + xx - xOffset, yy - yOffset + 2, (zz = (int)(xzRadius * Math.sin(Yangle))) - zOffset))) {
                    this.cachedRoots.put(new BlockPosition(2 + xx - xOffset, yy - yOffset + 2, zz - zOffset), new BlockMeta(Blocks.field_150364_r, 3));
                }
                if (!this.cachedRoots.containsKey(new BlockPosition(3 + xx - xOffset, yy - yOffset + 2, zz - zOffset))) {
                    this.cachedRoots.put(new BlockPosition(3 + xx - xOffset, yy - yOffset + 2, zz - zOffset), new BlockMeta(Blocks.field_150364_r, 3));
                }
                if (!this.cachedRoots.containsKey(new BlockPosition(2 + xx - xOffset, yy - yOffset + 2, 1 + zz - zOffset))) {
                    this.cachedRoots.put(new BlockPosition(2 + xx - xOffset, yy - yOffset + 2, 1 + zz - zOffset), new BlockMeta(Blocks.field_150364_r, 3));
                }
                if (!this.cachedRoots.containsKey(new BlockPosition(2 + xx - xOffset, yy - yOffset + 3, 1 + zz - zOffset))) {
                    this.cachedRoots.put(new BlockPosition(2 + xx - xOffset, yy - yOffset + 3, 1 + zz - zOffset), new BlockMeta(Blocks.field_150364_r, 3));
                }
                if (!this.cachedRoots.containsKey(new BlockPosition(1 + xx - xOffset, yy - yOffset + 2, zz - zOffset))) {
                    this.cachedRoots.put(new BlockPosition(1 + xx - xOffset, yy - yOffset + 2, zz - zOffset), new BlockMeta(Blocks.field_150364_r, 3));
                }
                if (this.cachedRoots.containsKey(new BlockPosition(2 + xx - xOffset, yy - yOffset + 2, zz - zOffset - 1))) continue;
                this.cachedRoots.put(new BlockPosition(2 + xx - xOffset, yy - yOffset + 2, zz - zOffset - 1), new BlockMeta(Blocks.field_150364_r, 3));
            }
        }
    }

    private void buildCanopy() {
        this.cachedCanopy.clear();
        for (double Yangle = 0.0; Yangle < Math.PI * 2; Yangle += 0.006135923151542565) {
            int yOffset = (int)(16.0 * Math.sin(2.356194490192345));
            int xOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.cos(Yangle));
            int zOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.sin(Yangle));
            for (double angle = 2.356194490192345; angle > -0.5235987755982988; angle -= 0.02454369260617026) {
                int yy = (int)(16.0 * Math.sin(angle));
                double xzRadius = 20.8 * Math.cos(angle);
                int xx = (int)(xzRadius * Math.cos(Yangle));
                int zz = (int)(xzRadius * Math.sin(Yangle));
                for (int yyy = -2; yyy < 4; ++yyy) {
                    if (this.cachedCanopy.containsKey(new BlockPosition(2 + xx - xOffset, yyy + yy - yOffset + 2, zz - zOffset))) continue;
                    this.cachedCanopy.put(new BlockPosition(2 + xx - xOffset, yyy + yy - yOffset + 2, zz - zOffset), new BlockMeta((Block)Blocks.field_150362_t, 3));
                }
            }
        }
    }

    protected void func_151538_a(World world2, int rangeX, int rangeZ, int chunkX, int chunkZ, Block[] blocks) {
        if (this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(rangeX) % this.chancePerChunk && this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(rangeZ) % this.chancePerChunk) {
            int x = (rangeX - chunkX) * 16;
            int z = (rangeZ - chunkZ) * 16;
            int y = 56;
            int treeHeight = this.field_75038_b.nextInt(10) + 40;
            int radius = 4;
            int edgeRadius = 1;
            int numDiag = edgeRadius + 1;
            int meta = 3;
            Block block = Blocks.field_150364_r;
            float SHAPE = 0.1f;
            int currentEdgeRadius = (int)(0.1f * (float)(edgeRadius * treeHeight) + 0.9f * (float)edgeRadius);
            ++y;
            for (int yOff = -20; yOff < treeHeight; ++yOff) {
                int xOff;
                int zOff;
                currentEdgeRadius = (int)(0.1f * (float)(edgeRadius * (treeHeight - yOff)) + 0.9f * (float)edgeRadius);
                for (zOff = -numDiag - currentEdgeRadius / 2; zOff <= -currentEdgeRadius / 2; ++zOff) {
                    for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                        this.setBlock(x + xOff, y + yOff, z + zOff, block, blocks);
                    }
                    ++currentEdgeRadius;
                }
                for (zOff = -currentEdgeRadius / 2; zOff <= currentEdgeRadius / 2; ++zOff) {
                    for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                        this.setBlock(x + xOff, y + yOff, z + zOff, block, blocks);
                    }
                }
                for (zOff = currentEdgeRadius / 2; zOff <= numDiag + currentEdgeRadius / 2; ++zOff) {
                    for (xOff = -numDiag - --currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                        this.setBlock(x + xOff, y + yOff, z + zOff, block, blocks);
                    }
                }
            }
            for (Map.Entry<BlockPosition, BlockMeta> entry : this.cachedCanopy.entrySet()) {
                this.setBlock(entry.getKey().x + x - radius / 2, y + treeHeight + entry.getKey().y, z + entry.getKey().z, entry.getValue().getBlock(), blocks);
            }
            for (double Yangle = 0.0; Yangle < Math.PI * 2; Yangle += 0.39269908169872414) {
                int yOffset = (int)(16.0 * Math.sin(2.356194490192345));
                int xOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.cos(Yangle));
                int zOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.sin(Yangle));
                for (double angle = 2.356194490192345; angle > -0.5235987755982988; angle -= 0.07853981633974483) {
                    int yy = (int)(16.0 * Math.sin(angle));
                    double xzRadius = 20.0 * Math.cos(angle);
                    int xx = (int)(xzRadius * Math.cos(Yangle));
                    int zz = (int)(xzRadius * Math.sin(Yangle));
                    this.setBlock(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset, Blocks.field_150364_r, blocks);
                    this.setBlock(x + 3 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset, Blocks.field_150364_r, blocks);
                    this.setBlock(x + 1 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset, Blocks.field_150364_r, blocks);
                    this.setBlock(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 3, z + zz - zOffset, Blocks.field_150364_r, blocks);
                    this.setBlock(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset + 1, Blocks.field_150364_r, blocks);
                    this.setBlock(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset - 1, Blocks.field_150364_r, blocks);
                }
                if (this.field_75038_b.nextInt(4) != 0) continue;
                int yy = (int)(16.0 * Math.sin(1.0471975511965976));
                double xzRadius = 20.0 * Math.cos(1.5707963267948966);
                int xx = (int)(xzRadius * Math.cos(Yangle));
                int zz = (int)(xzRadius * Math.sin(Yangle));
                int xxx = xx;
                int zzz = zz;
                for (zz = -1; zz < 2; ++zz) {
                    for (xx = -1; xx < 2; ++xx) {
                        this.setBlock(x + 2 + xx - xOffset - radius / 2, y + treeHeight - 10 + yy - yOffset + 2, z + zz - zOffset, (Block)Blocks.field_150362_t, blocks);
                    }
                }
                xx = xxx;
                zz = zzz;
                for (int yyy = 0; yyy < 10; ++yyy) {
                    for (zz = -2; zz < 3; ++zz) {
                        for (xx = -2; xx < 3; ++xx) {
                            this.setBlock(x + 2 + xx - xOffset - radius / 2, y + treeHeight - yyy + yy - yOffset + 2, z + zz - zOffset, (Block)Blocks.field_150362_t, blocks);
                        }
                    }
                    xx = xxx;
                    zz = zzz;
                    this.setBlock(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset, Blocks.field_150364_r, blocks);
                    this.setBlock(x + 3 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset, Blocks.field_150364_r, blocks);
                    this.setBlock(x + 1 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset, Blocks.field_150364_r, blocks);
                    this.setBlock(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 3, z + zz - zOffset, Blocks.field_150364_r, blocks);
                    this.setBlock(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset + 1, Blocks.field_150364_r, blocks);
                    this.setBlock(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset - 1, Blocks.field_150364_r, blocks);
                }
            }
            for (Map.Entry<BlockPosition, BlockMeta> entry : this.cachedRoots.entrySet()) {
                this.setBlock(entry.getKey().x + x - radius / 2, y + entry.getKey().y, z + entry.getKey().z, entry.getValue().getBlock(), blocks);
            }
        }
    }

    private void setBlock(int x, int y, int z, Block block, Block[] blocks) {
        if (x > 15 || x < 0 || z > 15 || z < 0 || y < 0 || y > 255) {
            return;
        }
        int index = (x * 16 + z) * 256 + y;
        blocks[index] = block;
    }

    private Block getBlock(int x, int y, int z, Block block, Block[] blocks) {
        if (x > 15 || x < 0 || z > 15 || z < 0 || y < 0 || y > 255) {
            return Blocks.field_150350_a;
        }
        int index = (x * 16 + z) * 256 + y;
        return blocks[index];
    }

    public boolean generate(World world, Random rand, int x, int y, int z) {
        int yOff;
        int xOff;
        int zOff;
        int treeHeight = rand.nextInt(10) + 40;
        int radius = 4;
        boolean flag = true;
        Block block2 = world.func_147439_a(x, y - 1, z);
        int edgeRadius = 1;
        int numDiag = edgeRadius + 1;
        int meta = 3;
        Block block = Blocks.field_150364_r;
        float SHAPE = 0.1f;
        int currentEdgeRadius = (int)(0.1f * (float)(edgeRadius * treeHeight) + 0.9f * (float)edgeRadius);
        for (zOff = -numDiag - currentEdgeRadius / 2; zOff <= -currentEdgeRadius / 2; ++zOff) {
            for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                for (yOff = world.func_72976_f(x + xOff, z + zOff); yOff < y; ++yOff) {
                    world.func_147449_b(x + xOff, yOff, z + zOff, block);
                }
                world.func_147449_b(x + xOff, y, z + zOff, block);
            }
            ++currentEdgeRadius;
        }
        for (zOff = -currentEdgeRadius / 2; zOff <= currentEdgeRadius / 2; ++zOff) {
            for (xOff = -numDiag - currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                for (yOff = world.func_72976_f(x + xOff, z + zOff); yOff < y; ++yOff) {
                    world.func_147449_b(x + xOff, yOff, z + zOff, block);
                }
                world.func_147449_b(x + xOff, y, z + zOff, block);
            }
        }
        for (zOff = currentEdgeRadius / 2; zOff <= numDiag + currentEdgeRadius / 2; ++zOff) {
            for (xOff = -numDiag - --currentEdgeRadius / 2; xOff <= numDiag + currentEdgeRadius / 2; ++xOff) {
                for (yOff = world.func_72976_f(x + xOff, z + zOff); yOff < y; ++yOff) {
                    world.func_147449_b(x + xOff, yOff, z + zOff, block);
                }
                world.func_147449_b(x + xOff, y, z + zOff, block);
            }
        }
        ++y;
        for (int yOff2 = 0; yOff2 < treeHeight; ++yOff2) {
            int xOff2;
            int zOff2;
            currentEdgeRadius = (int)(0.1f * (float)(edgeRadius * (treeHeight - yOff2)) + 0.9f * (float)edgeRadius);
            for (zOff2 = -numDiag - currentEdgeRadius / 2; zOff2 <= -currentEdgeRadius / 2; ++zOff2) {
                for (xOff2 = -numDiag - currentEdgeRadius / 2; xOff2 <= numDiag + currentEdgeRadius / 2; ++xOff2) {
                    world.func_147465_d(x + xOff2, y + yOff2, z + zOff2, block, meta, 3);
                }
                ++currentEdgeRadius;
            }
            for (zOff2 = -currentEdgeRadius / 2; zOff2 <= currentEdgeRadius / 2; ++zOff2) {
                for (xOff2 = -numDiag - currentEdgeRadius / 2; xOff2 <= numDiag + currentEdgeRadius / 2; ++xOff2) {
                    world.func_147465_d(x + xOff2, y + yOff2, z + zOff2, block, meta, 3);
                }
            }
            for (zOff2 = currentEdgeRadius / 2; zOff2 <= numDiag + currentEdgeRadius / 2; ++zOff2) {
                for (xOff2 = -numDiag - --currentEdgeRadius / 2; xOff2 <= numDiag + currentEdgeRadius / 2; ++xOff2) {
                    world.func_147465_d(x + xOff2, y + yOff2, z + zOff2, block, meta, 3);
                }
            }
        }
        for (Map.Entry<BlockPosition, BlockMeta> entry : this.cachedCanopy.entrySet()) {
            world.func_147465_d(entry.getKey().x + x - radius / 2, y + treeHeight + entry.getKey().y, z + entry.getKey().z, entry.getValue().getBlock(), (int)entry.getValue().getMeta(), 2);
        }
        for (double Yangle = 0.0; Yangle < Math.PI * 2; Yangle += 0.39269908169872414) {
            int yOffset = (int)(16.0 * Math.sin(2.356194490192345));
            int xOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.cos(Yangle));
            int zOffset = (int)(20.0 * Math.cos(2.356194490192345) * Math.sin(Yangle));
            for (double angle = 2.356194490192345; angle > -0.5235987755982988; angle -= 0.07853981633974483) {
                int yy = (int)(16.0 * Math.sin(angle));
                double xzRadius = 20.0 * Math.cos(angle);
                int xx = (int)(xzRadius * Math.cos(Yangle));
                int zz = (int)(xzRadius * Math.sin(Yangle));
                world.func_147465_d(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset, Blocks.field_150364_r, 3, 5);
                world.func_147465_d(x + 3 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset, Blocks.field_150364_r, 3, 5);
                world.func_147465_d(x + 1 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset, Blocks.field_150364_r, 3, 5);
                world.func_147465_d(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 3, z + zz - zOffset, Blocks.field_150364_r, 3, 5);
                world.func_147465_d(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset + 1, Blocks.field_150364_r, 3, 5);
                world.func_147465_d(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yOffset + 2, z + zz - zOffset - 1, Blocks.field_150364_r, 3, 5);
            }
            if (rand.nextInt(4) != 0) continue;
            int yy = (int)(16.0 * Math.sin(1.0471975511965976));
            double xzRadius = 20.0 * Math.cos(1.5707963267948966);
            int xx = (int)(xzRadius * Math.cos(Yangle));
            int zz = (int)(xzRadius * Math.sin(Yangle));
            int xxx = xx;
            int zzz = zz;
            for (zz = -1; zz < 2; ++zz) {
                for (xx = -1; xx < 2; ++xx) {
                    world.func_147465_d(x + 2 + xx - xOffset - radius / 2, y + treeHeight - 10 + yy - yOffset + 2, z + zz - zOffset, (Block)Blocks.field_150362_t, 3, 5);
                }
            }
            xx = xxx;
            zz = zzz;
            for (int yyy = 0; yyy < 10; ++yyy) {
                for (zz = -2; zz < 3; ++zz) {
                    for (xx = -2; xx < 3; ++xx) {
                        world.func_147465_d(x + 2 + xx - xOffset - radius / 2, y + treeHeight - yyy + yy - yOffset + 2, z + zz - zOffset, (Block)Blocks.field_150362_t, 3, 5);
                    }
                }
                xx = xxx;
                zz = zzz;
                world.func_147465_d(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset, Blocks.field_150364_r, 3, 5);
                world.func_147465_d(x + 3 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset, Blocks.field_150364_r, 3, 5);
                world.func_147465_d(x + 1 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset, Blocks.field_150364_r, 3, 5);
                world.func_147465_d(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 3, z + zz - zOffset, Blocks.field_150364_r, 3, 5);
                world.func_147465_d(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset + 1, Blocks.field_150364_r, 3, 5);
                world.func_147465_d(x + 2 + xx - xOffset - radius / 2, y + treeHeight + yy - yyy - yOffset + 2, z + zz - zOffset - 1, Blocks.field_150364_r, 3, 5);
            }
        }
        for (Map.Entry<BlockPosition, BlockMeta> entry : this.cachedRoots.entrySet()) {
            world.func_147465_d(entry.getKey().x + x - radius / 2, y + entry.getKey().y, z + entry.getKey().z, entry.getValue().getBlock(), (int)entry.getValue().getMeta(), 2);
        }
        return true;
    }

    private void onPlantGrow(World world, int x, int y, int z, int sourceX, int sourceY, int sourceZ) {
        world.func_147439_a(x, y, z).onPlantGrow(world, x, y, z, sourceX, sourceY, sourceZ);
    }
}

