/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.gen;

import cpw.mods.fml.common.IWorldGenerator;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.feature.WorldGenMinable;
import zmaster587.advancedRocketry.util.OreGenProperties;
import zmaster587.libVulpes.block.BlockMeta;

public class CustomizableOreGen
implements IWorldGenerator {
    BlockMeta oreToGen;
    int numPerChunk;
    int clumpSize;
    int heightLevel;
    int difference;

    public CustomizableOreGen(BlockMeta oreToGen, int numPerChunk, int clumpSize, int minHeight, int maxHeight) {
        this.oreToGen = oreToGen;
        this.numPerChunk = numPerChunk;
        this.clumpSize = clumpSize;
        this.difference = maxHeight - minHeight;
        this.heightLevel = minHeight;
    }

    public CustomizableOreGen(OreGenProperties.OreEntry genProps) {
        this.oreToGen = genProps.getBlockState();
        this.clumpSize = genProps.getClumpSize();
        this.heightLevel = genProps.getMinHeight();
        this.difference = genProps.getMaxHeight() - this.heightLevel;
        this.numPerChunk = genProps.getChancePerChunk();
    }

    public void generate(Random random, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        for (int i = 0; i < this.numPerChunk; ++i) {
            int coordX = 16 * chunkX + random.nextInt(16);
            int coordY = this.heightLevel + random.nextInt(this.difference);
            int coordZ = 16 * chunkZ + random.nextInt(16);
            new WorldGenMinable(this.oreToGen.getBlock(), (int)this.oreToGen.getMeta(), this.clumpSize, Blocks.field_150348_b).func_76484_a(world, random, coordX, coordY, coordZ);
        }
    }
}

