/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world.decoration;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.util.BlockPosition;

public class MapGenGeode
extends MapGenBase {
    int chancePerChunk;
    private static List<BlockMeta> ores;
    private HashMap<BlockPosition, Byte> metaPos = new HashMap();

    public MapGenGeode(int chancePerChunk) {
        this.chancePerChunk = chancePerChunk;
        if (ores == null) {
            ores = new LinkedList<BlockMeta>();
            for (int i = 0; i < Configuration.standardGeodeOres.size(); ++i) {
                Block block;
                String oreDictName = Configuration.standardGeodeOres.get(i);
                ArrayList ores2 = OreDictionary.getOres((String)oreDictName);
                if (ores2 == null || ores2.isEmpty() || (block = Block.func_149634_a((Item)((ItemStack)ores2.get(0)).func_77973_b())) == null) continue;
                ores.add(new BlockMeta(block, ((ItemStack)ores2.get(0)).func_77960_j()));
            }
        }
    }

    public void setMetaPos(Chunk chunk, int x, int z) {
        Iterator<Map.Entry<BlockPosition, Byte>> itr = this.metaPos.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<BlockPosition, Byte> entry = itr.next();
            BlockPosition pos = entry.getKey();
            if (pos.x >> 4 != x || pos.z >> 4 != z) continue;
            chunk.func_76589_b(pos.x & 0xF, (int)pos.y, pos.z & 0xF, (int)entry.getValue().byteValue());
            itr.remove();
        }
    }

    protected void func_151538_a(World world, int rangeX, int rangeZ, int chunkX, int chunkZ, Block[] chunkArray) {
        if (this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(rangeX) % this.chancePerChunk || this.field_75038_b.nextInt(this.chancePerChunk) == Math.abs(rangeZ) % this.chancePerChunk) {
            int radius = this.field_75038_b.nextInt(Configuration.geodeVariation) + Configuration.geodeBaseSize - Configuration.geodeVariation / 2;
            int depth = radius * radius;
            int xCoord = -rangeX + chunkX;
            int zCoord = -rangeZ + chunkZ;
            int avgY = (int)((world.func_72807_a((int)rangeX, (int)rangeZ).field_76748_D + 2.0f) * 32.0f) - 3 * radius / 4;
            for (int x = 15; x >= 0; --x) {
                for (int z = 15; z >= 0; --z) {
                    int index;
                    for (int y = 255; y >= 0 && chunkArray[index = (x * 16 + z) * 256 + y] == null; --y) {
                    }
                    int count = (depth - ((xCoord * 16 + x) * (xCoord * 16 + x) + (zCoord * 16 + z) * (zCoord * 16 + z))) / (radius * 2);
                    if (avgY - count < 1 || avgY + count > 255) continue;
                    for (int dist = -count; dist < Math.min(count, 3); ++dist) {
                        index = (x * 16 + z) * 256 + avgY - dist;
                        chunkArray[index] = null;
                    }
                    if (count < 0) continue;
                    if (count > 4) {
                        byte meta;
                        int i;
                        int size = this.field_75038_b.nextInt(4) + 4;
                        if (x % 4 > 0 && z % 4 > 0) {
                            for (i = 1; i < size; ++i) {
                                chunkArray[(x * 16 + z) * 256 + avgY + count - i] = ores.get((x / 4 + z / 4) % ores.size()).getBlock();
                                meta = ores.get((x / 4 + z / 4) % ores.size()).getMeta();
                                if (meta == 0) continue;
                                this.metaPos.put(new BlockPosition((chunkX << 4) + x, avgY + count - i, (chunkZ << 4) + z), meta);
                            }
                        } else {
                            size -= 2;
                            for (i = 1; i < size; ++i) {
                                chunkArray[(x * 16 + z) * 256 + avgY + count - i] = Blocks.field_150348_b;
                            }
                        }
                        if ((x + 2) % 4 > 0 && (z + 2) % 4 > 0) {
                            for (i = 1; i < size; ++i) {
                                chunkArray[(x * 16 + z) * 256 + avgY - count + i] = ores.get(((x + 2) / 4 + (z + 2) / 4) % ores.size()).getBlock();
                                meta = ores.get((x / 4 + z / 4) % ores.size()).getMeta();
                                if (meta == 0) continue;
                                this.metaPos.put(new BlockPosition((chunkX << 4) + x, avgY - count + i, (chunkZ << 4) + z), meta);
                            }
                        }
                    }
                    chunkArray[(x * 16 + z) * 256 + avgY - count] = AdvancedRocketryBlocks.blocksGeode;
                    chunkArray[(x * 16 + z) * 256 + avgY + count] = AdvancedRocketryBlocks.blocksGeode;
                }
            }
        }
    }
}

