/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.world;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.LongHashMap;
import net.minecraft.util.ReportedException;
import net.minecraft.world.World;
import net.minecraft.world.WorldType;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.GenLayerAddIsland;
import net.minecraft.world.gen.layer.GenLayerAddMushroomIsland;
import net.minecraft.world.gen.layer.GenLayerAddSnow;
import net.minecraft.world.gen.layer.GenLayerDeepOcean;
import net.minecraft.world.gen.layer.GenLayerEdge;
import net.minecraft.world.gen.layer.GenLayerFuzzyZoom;
import net.minecraft.world.gen.layer.GenLayerIsland;
import net.minecraft.world.gen.layer.GenLayerRareBiome;
import net.minecraft.world.gen.layer.GenLayerRemoveTooMuchOcean;
import net.minecraft.world.gen.layer.GenLayerRiver;
import net.minecraft.world.gen.layer.GenLayerRiverInit;
import net.minecraft.world.gen.layer.GenLayerRiverMix;
import net.minecraft.world.gen.layer.GenLayerSmooth;
import net.minecraft.world.gen.layer.GenLayerZoom;
import net.minecraft.world.gen.layer.IntCache;
import net.minecraftforge.common.BiomeManager;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.world.GenLayerBiomePlanet;
import zmaster587.advancedRocketry.world.gen.GenLayerHillsExtended;
import zmaster587.advancedRocketry.world.gen.GenLayerShoreExtended;
import zmaster587.advancedRocketry.world.gen.GenLayerVoronoiExtended;
import zmaster587.advancedRocketry.world.type.WorldTypePlanetGen;

public class ChunkManagerPlanet
extends WorldChunkManager {
    private GenLayer biomeIndexLayer;
    private BiomeCache biomeCache = new BiomeCache((WorldChunkManager)this);
    private GenLayer genBiomes;
    private List<BiomeManager.BiomeEntry> biomes;
    private static Field fBiomeCacheMap;
    private static Field fBiomeCache;

    public ChunkManagerPlanet(long seed, WorldType default1, DimensionProperties properties) {
        GenLayer[] agenlayer = ChunkManagerPlanet.initializeAllBiomeGenerators(seed, default1, properties);
        agenlayer = this.getModdedBiomeGenerators(default1, seed, agenlayer);
        this.genBiomes = agenlayer[0];
        this.biomeIndexLayer = agenlayer[1];
        fBiomeCache = ReflectionHelper.findField(BiomeCache.class, (String[])new String[]{"cache", "field_76841_d"});
        fBiomeCache.setAccessible(true);
        fBiomeCacheMap = ReflectionHelper.findField(BiomeCache.class, (String[])new String[]{"cacheMap", "field_76843_c"});
        fBiomeCacheMap.setAccessible(true);
    }

    public ChunkManagerPlanet(World world, List biomes) {
        this(world.func_72905_C(), (WorldTypePlanetGen)world.func_72912_H().func_76067_t(), DimensionManager.getInstance().getDimensionProperties(world.field_73011_w.field_76574_g));
        this.biomes = biomes;
    }

    public static GenLayer[] initializeAllBiomeGenerators(long seed, WorldType type, DimensionProperties properties) {
        GenLayerVoronoiExtended genlayervoronoizoom;
        GenLayerSmooth genlayersmooth;
        GenLayer genlayer1;
        boolean flag = false;
        boolean hasRivers = properties.hasRivers();
        GenLayerIsland genlayerisland = new GenLayerIsland(1L);
        GenLayerFuzzyZoom genlayerfuzzyzoom = new GenLayerFuzzyZoom(2000L, (GenLayer)genlayerisland);
        GenLayerAddIsland genlayeraddisland = new GenLayerAddIsland(1L, (GenLayer)genlayerfuzzyzoom);
        GenLayerZoom genlayerzoom = new GenLayerZoom(2001L, (GenLayer)genlayeraddisland);
        genlayeraddisland = new GenLayerAddIsland(2L, (GenLayer)genlayerzoom);
        genlayeraddisland = new GenLayerAddIsland(50L, (GenLayer)genlayeraddisland);
        genlayeraddisland = new GenLayerAddIsland(70L, (GenLayer)genlayeraddisland);
        GenLayerRemoveTooMuchOcean genlayerremovetoomuchocean = new GenLayerRemoveTooMuchOcean(2L, (GenLayer)genlayeraddisland);
        GenLayerAddSnow genlayeraddsnow = new GenLayerAddSnow(2L, (GenLayer)genlayerremovetoomuchocean);
        genlayeraddisland = new GenLayerAddIsland(3L, (GenLayer)genlayeraddsnow);
        GenLayerEdge genlayeredge = new GenLayerEdge(2L, (GenLayer)genlayeraddisland, GenLayerEdge.Mode.COOL_WARM);
        genlayeredge = new GenLayerEdge(2L, (GenLayer)genlayeredge, GenLayerEdge.Mode.HEAT_ICE);
        genlayeredge = new GenLayerEdge(3L, (GenLayer)genlayeredge, GenLayerEdge.Mode.SPECIAL);
        genlayerzoom = new GenLayerZoom(2002L, (GenLayer)genlayeredge);
        genlayerzoom = new GenLayerZoom(2003L, (GenLayer)genlayerzoom);
        genlayeraddisland = new GenLayerAddIsland(4L, (GenLayer)genlayerzoom);
        GenLayerAddMushroomIsland genlayeraddmushroomisland = new GenLayerAddMushroomIsland(5L, (GenLayer)genlayeraddisland);
        GenLayerDeepOcean genlayerdeepocean = new GenLayerDeepOcean(4L, (GenLayer)genlayeraddmushroomisland);
        GenLayer genlayer2 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerdeepocean, (int)0);
        int b0 = 4;
        if (type == WorldType.field_77135_d) {
            b0 = 6;
        }
        if (flag) {
            b0 = 4;
        }
        b0 = GenLayer.getModdedBiomeSize((WorldType)type, (byte)b0);
        GenLayer genlayer = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer2, (int)0);
        GenLayer object = type.getBiomeLayer(seed, genlayer2);
        if (hasRivers) {
            GenLayerRiverInit genlayerriverinit = new GenLayerRiverInit(100L, genlayer);
            genlayer1 = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
            genlayer = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayerriverinit, (int)2);
        } else {
            genlayer1 = genlayer;
        }
        GenLayerHillsExtended genlayerhills = new GenLayerHillsExtended(1000L, object, genlayer1);
        genlayer = GenLayerZoom.func_75915_a((long)1000L, (GenLayer)genlayer, (int)b0);
        if (hasRivers) {
            GenLayerRiver genlayerriver = new GenLayerRiver(1L, genlayer);
            genlayersmooth = new GenLayerSmooth(1000L, (GenLayer)genlayerriver);
        } else {
            genlayersmooth = new GenLayerSmooth(1000L, genlayer);
        }
        object = new GenLayerRareBiome(1001L, (GenLayer)genlayerhills);
        for (int j = 0; j < b0; ++j) {
            object = new GenLayerZoom((long)(1000 + j), object);
            if (j == 0) {
                object = new GenLayerAddIsland(3L, object);
            }
            if (j != 1) continue;
            object = new GenLayerShoreExtended(1000L, object);
        }
        GenLayerSmooth genlayersmooth1 = new GenLayerSmooth(1000L, object);
        if (hasRivers) {
            GenLayerRiverMix genlayerrivermix = new GenLayerRiverMix(100L, (GenLayer)genlayersmooth1, (GenLayer)genlayersmooth);
            genlayervoronoizoom = new GenLayerVoronoiExtended(10L, (GenLayer)genlayerrivermix);
            genlayerrivermix.func_75905_a(seed);
            genlayer = genlayerrivermix;
        } else {
            genlayervoronoizoom = new GenLayerVoronoiExtended(10L, (GenLayer)genlayersmooth1);
            genlayer = genlayervoronoizoom;
        }
        genlayervoronoizoom.func_75905_a(seed);
        return new GenLayer[]{genlayer, genlayervoronoizoom, genlayer};
    }

    public float[] func_76936_a(float[] p_76936_1_, int p_76936_2_, int p_76936_3_, int p_76936_4_, int p_76936_5_) {
        IntCache.func_76446_a();
        if (p_76936_1_ == null || p_76936_1_.length < p_76936_4_ * p_76936_5_) {
            p_76936_1_ = new float[p_76936_4_ * p_76936_5_];
        }
        int[] aint = this.biomeIndexLayer.func_75904_a(p_76936_2_, p_76936_3_, p_76936_4_, p_76936_5_);
        for (int i1 = 0; i1 < p_76936_4_ * p_76936_5_; ++i1) {
            try {
                float f;
                BiomeGenBase biome = AdvancedRocketryBiomes.instance.getBiomeById(aint[i1]);
                if (biome == null) {
                    System.out.println("shit");
                }
                if ((f = (float)biome.func_76744_g() / 65536.0f) > 1.0f) {
                    f = 1.0f;
                }
                p_76936_1_[i1] = f;
                continue;
            }
            catch (Throwable throwable) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("DownfallBlock");
                crashreportcategory.func_71507_a("biome id", (Object)i1);
                crashreportcategory.func_71507_a("downfalls[] size", (Object)p_76936_1_.length);
                crashreportcategory.func_71507_a("x", (Object)p_76936_2_);
                crashreportcategory.func_71507_a("z", (Object)p_76936_3_);
                crashreportcategory.func_71507_a("w", (Object)p_76936_4_);
                crashreportcategory.func_71507_a("h", (Object)p_76936_5_);
                throw new ReportedException(crashreport);
            }
        }
        return p_76936_1_;
    }

    public BiomeGenBase func_76935_a(int p_76935_1_, int p_76935_2_) {
        return this.biomeCache.func_76837_b(p_76935_1_, p_76935_2_);
    }

    public void resetCache() {
        try {
            fBiomeCacheMap.set(this.biomeCache, new LongHashMap());
            ((List)fBiomeCache.get(this.biomeCache)).clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public BiomeGenBase[] getBiomesForGeneration(BiomeGenBase[] p_76937_1_, int p_76937_2_, int p_76937_3_, int p_76937_4_, int p_76937_5_, DimensionProperties properties) {
        GenLayerBiomePlanet.setupBiomesForUse(this.biomes);
        IntCache.func_76446_a();
        if (p_76937_1_ == null || p_76937_1_.length < p_76937_4_ * p_76937_5_) {
            p_76937_1_ = new BiomeGenBase[p_76937_4_ * p_76937_5_];
        }
        int[] aint = this.genBiomes.func_75904_a(p_76937_2_, p_76937_3_, p_76937_4_, p_76937_5_);
        try {
            for (int i1 = 0; i1 < p_76937_4_ * p_76937_5_; ++i1) {
                p_76937_1_[i1] = AdvancedRocketryBiomes.instance.getBiomeById(aint[i1]);
            }
            return p_76937_1_;
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
            crashreportcategory.func_71507_a("biomes[] size", (Object)p_76937_1_.length);
            crashreportcategory.func_71507_a("x", (Object)p_76937_2_);
            crashreportcategory.func_71507_a("z", (Object)p_76937_3_);
            crashreportcategory.func_71507_a("w", (Object)p_76937_4_);
            crashreportcategory.func_71507_a("h", (Object)p_76937_5_);
            throw new ReportedException(crashreport);
        }
    }

    public BiomeGenBase[] func_76933_b(BiomeGenBase[] p_76933_1_, int p_76933_2_, int p_76933_3_, int p_76933_4_, int p_76933_5_) {
        return this.func_76931_a(p_76933_1_, p_76933_2_, p_76933_3_, p_76933_4_, p_76933_5_, true);
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] biomeGenBase, int x, int y, int width, int length, boolean p_76931_6_) {
        GenLayerBiomePlanet.setupBiomesForUse(this.biomes);
        IntCache.func_76446_a();
        if (biomeGenBase == null || biomeGenBase.length < width * length) {
            biomeGenBase = new BiomeGenBase[width * length];
        }
        if (p_76931_6_ && width == 16 && length == 16 && (x & 0xF) == 0 && (y & 0xF) == 0) {
            BiomeGenBase[] abiomegenbase1 = this.biomeCache.func_76839_e(x, y);
            System.arraycopy(abiomegenbase1, 0, biomeGenBase, 0, width * length);
            return biomeGenBase;
        }
        int[] aint = this.biomeIndexLayer.func_75904_a(x, y, width, length);
        for (int i1 = 0; i1 < width * length; ++i1) {
            if (aint[i1] > 255) {
                System.out.println("s");
            }
            biomeGenBase[i1] = AdvancedRocketryBiomes.instance.getBiomeById(aint[i1]);
        }
        return biomeGenBase;
    }

    public void func_76938_b() {
        super.func_76938_b();
        this.biomeCache.func_76838_a();
    }
}

