/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.IGalaxy;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.util.XMLAsteroidLoader;
import zmaster587.advancedRocketry.util.XMLOreLoader;

public class XMLPlanetLoader {
    Document doc = null;
    NodeList currentList;
    int currentNodeIndex = -1;
    int starId = 0;
    int offset;
    HashMap<StellarBody, Integer> maxPlanetNumber = new HashMap();
    HashMap<StellarBody, Integer> maxGasPlanetNumber = new HashMap();

    public boolean loadFile(File xmlFile) throws IOException {
        DocumentBuilder docBuilder;
        this.doc = null;
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            return false;
        }
        try {
            this.doc = docBuilder.parse(xmlFile);
        }
        catch (SAXException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public boolean isValid() {
        return this.doc != null;
    }

    public int getMaxNumPlanets(StellarBody body) {
        return this.maxPlanetNumber.get(body);
    }

    public int getMaxNumGasGiants(StellarBody body) {
        return this.maxGasPlanetNumber.get(body);
    }

    private List<DimensionProperties> readPlanetFromNode(Node planetNode, StellarBody star) {
        ArrayList<DimensionProperties> list = new ArrayList<DimensionProperties>();
        Node planetPropertyNode = planetNode.getFirstChild();
        DimensionProperties properties = new DimensionProperties(DimensionManager.getInstance().getNextFreeDim(this.offset));
        if (properties == null) {
            return list;
        }
        list.add(properties);
        ++this.offset;
        if (planetNode.hasAttributes()) {
            Node nameNode = planetNode.getAttributes().getNamedItem("name");
            if (nameNode != null && !nameNode.getNodeValue().isEmpty()) {
                properties.setName(nameNode.getNodeValue());
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem("DIMID")) != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    if (nameNode.getTextContent().isEmpty()) {
                        throw new NumberFormatException();
                    }
                    properties.setId(Integer.parseInt(nameNode.getTextContent()));
                    --this.offset;
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Invalid DIMID specified for planet " + properties.getName());
                    list.remove(properties);
                    --this.offset;
                    return list;
                }
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem("dimMapping")) != null) {
                properties.isNativeDimension = false;
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem("customIcon")) != null) {
                properties.customIcon = nameNode.getTextContent();
            }
        }
        while (planetPropertyNode != null) {
            block80: {
                String text;
                int j;
                String[] colors;
                if (planetPropertyNode.getNodeName().equalsIgnoreCase("fogcolor")) {
                    colors = planetPropertyNode.getTextContent().split(",");
                    try {
                        if (colors.length >= 3) {
                            float[] rgb = new float[3];
                            for (j = 0; j < 3; ++j) {
                                rgb[j] = Float.parseFloat(colors[j]);
                            }
                            properties.fogColor = rgb;
                            break block80;
                        }
                        if (colors.length == 1) {
                            int cols = Integer.parseUnsignedInt(colors[0].substring(2), 16);
                            float[] rgb = new float[]{(float)(cols >>> 16 & 0xFF) / 255.0f, (float)(cols >>> 8 & 0xFF) / 255.0f, (float)(cols & 0xFF) / 255.0f};
                            properties.fogColor = rgb;
                            break block80;
                        }
                        AdvancedRocketry.logger.warn("Invalid number of floats specified for fog color (Required 3, comma sperated)");
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid fog color specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("gas")) {
                    Fluid f = FluidRegistry.getFluid((String)planetPropertyNode.getTextContent());
                    if (f == null) {
                        AdvancedRocketry.logger.warn("\"" + planetPropertyNode.getTextContent() + "\" is not a valid fluid");
                    } else {
                        properties.getHarvestableGasses().add(f);
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("skycolor")) {
                    colors = planetPropertyNode.getTextContent().split(",");
                    try {
                        if (colors.length >= 3) {
                            float[] rgb = new float[3];
                            for (j = 0; j < 3; ++j) {
                                rgb[j] = Float.parseFloat(colors[j]);
                            }
                            properties.skyColor = rgb;
                            break block80;
                        }
                        if (colors.length == 1) {
                            int cols = Integer.parseUnsignedInt(colors[0].substring(2), 16);
                            float[] rgb = new float[]{(float)(cols >>> 16 & 0xFF) / 255.0f, (float)(cols >>> 8 & 0xFF) / 255.0f, (float)(cols & 0xFF) / 255.0f};
                            properties.skyColor = rgb;
                            break block80;
                        }
                        AdvancedRocketry.logger.warn("Invalid number of floats specified for sky color (Required 3, comma sperated)");
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid sky color specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("atmosphereDensity")) {
                    try {
                        properties.setAtmosphereDensityDirect(Math.min(Math.max(Integer.parseInt(planetPropertyNode.getTextContent()), 0), 200));
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid atmosphereDensity specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("gravitationalmultiplier")) {
                    try {
                        properties.gravitationalMultiplier = (float)Math.min(Math.max(Integer.parseInt(planetPropertyNode.getTextContent()), 0), 200) / 100.0f;
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid gravitationalMultiplier specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("orbitaldistance")) {
                    try {
                        properties.orbitalDist = Math.min(Math.max(Integer.parseInt(planetPropertyNode.getTextContent()), 0), 200);
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid orbitalDist specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("orbitaltheta")) {
                    try {
                        properties.orbitTheta = (double)(Integer.parseInt(planetPropertyNode.getTextContent()) % 360 * 2) / Math.PI;
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid orbitalTheta specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("rotationalperiod")) {
                    try {
                        int rotationalPeriod = Integer.parseInt(planetPropertyNode.getTextContent());
                        if (properties.rotationalPeriod > 0) {
                            properties.rotationalPeriod = rotationalPeriod;
                            break block80;
                        }
                        AdvancedRocketry.logger.warn("rotational Period must be greater than 0");
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid rotational period specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("biomeids")) {
                    String[] biomeList = planetPropertyNode.getTextContent().split(",");
                    for (int j2 = 0; j2 < biomeList.length; ++j2) {
                        try {
                            int biome = Integer.parseInt(biomeList[j2]);
                            if (properties.addBiome(biome)) continue;
                            AdvancedRocketry.logger.warn(biomeList[j2] + " is not a valid biome id");
                            continue;
                        }
                        catch (NumberFormatException e) {
                            AdvancedRocketry.logger.warn(biomeList[j2] + " is not a valid biome id");
                        }
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("artifact")) {
                    ItemStack stack = XMLAsteroidLoader.getStack(planetPropertyNode.getTextContent());
                    if (stack != null) {
                        properties.getRequiredArtifacts().add(stack);
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("planet")) {
                    List<DimensionProperties> childList = this.readPlanetFromNode(planetPropertyNode, star);
                    if (childList.size() > 0) {
                        DimensionProperties child = childList.get(childList.size() - 1);
                        properties.addChildPlanet(child);
                        list.addAll(childList);
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("orbitalPhi")) {
                    try {
                        properties.orbitalPhi = (double)(Integer.parseInt(planetPropertyNode.getTextContent()) % 360 * 180) / Math.PI;
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid orbitalTheta specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("oreGen")) {
                    properties.oreProperties = XMLOreLoader.loadOre(planetPropertyNode);
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("hasRings")) {
                    properties.hasRings = Boolean.parseBoolean(planetPropertyNode.getTextContent());
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("ringColor")) {
                    colors = planetPropertyNode.getTextContent().split(",");
                    try {
                        if (colors.length >= 3) {
                            float[] rgb = new float[3];
                            for (j = 0; j < 3; ++j) {
                                rgb[j] = Float.parseFloat(colors[j]);
                            }
                            properties.ringColor = rgb;
                            break block80;
                        }
                        if (colors.length == 1) {
                            int cols = Integer.parseUnsignedInt(colors[0].substring(2), 16);
                            float[] rgb = new float[]{(float)(cols >>> 16 & 0xFF) / 255.0f, (float)(cols >>> 8 & 0xFF) / 255.0f, (float)(cols & 0xFF) / 255.0f};
                            properties.ringColor = rgb;
                            break block80;
                        }
                        AdvancedRocketry.logger.warn("Invalid number of floats specified for ring color (Required 3, comma sperated)");
                    }
                    catch (NumberFormatException e) {
                        AdvancedRocketry.logger.warn("Invalid sky color specified");
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("GasGiant")) {
                    text = planetPropertyNode.getTextContent();
                    if (text != null && !text.isEmpty() && text.equalsIgnoreCase("true")) {
                        properties.setGasGiant();
                    }
                } else if (planetPropertyNode.getNodeName().equalsIgnoreCase("isKnown") && (text = planetPropertyNode.getTextContent()) != null && !text.isEmpty() && text.equalsIgnoreCase("true")) {
                    Configuration.initiallyKnownPlanets.add(properties.getId());
                }
            }
            planetPropertyNode = planetPropertyNode.getNextSibling();
        }
        properties.setStar(star.getId());
        properties.averageTemperature = DimensionManager.getInstance().getTemperature(star, properties.getOrbitalDist(), properties.getAtmosphereDensity());
        if (properties.getBiomes().isEmpty()) {
            properties.addBiomes(properties.getViableBiomes());
        }
        return list;
    }

    public StellarBody readStar(Node planetNode) {
        StellarBody star = this.readSubStar(planetNode);
        if (planetNode.hasAttributes()) {
            Node nameNode = planetNode.getAttributes().getNamedItem("x");
            if (nameNode != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    star.setPosX(Integer.parseInt(nameNode.getNodeValue()));
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Error Reading star " + star.getName());
                }
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem("y")) != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    star.setPosZ(Integer.parseInt(nameNode.getNodeValue()));
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Error Reading star " + star.getName());
                }
            }
            nameNode = planetNode.getAttributes().getNamedItem("numPlanets");
            try {
                this.maxPlanetNumber.put(star, Integer.parseInt(nameNode.getNodeValue()));
            }
            catch (Exception e) {
                AdvancedRocketry.logger.warn("Invalid number of planets specified in xml config!");
            }
            nameNode = planetNode.getAttributes().getNamedItem("numGasGiants");
            try {
                this.maxGasPlanetNumber.put(star, Integer.parseInt(nameNode.getNodeValue()));
            }
            catch (Exception e) {
                AdvancedRocketry.logger.warn("Invalid number of planets specified in xml config!");
            }
        }
        star.setId(this.starId++);
        return star;
    }

    public StellarBody readSubStar(Node planetNode) {
        StellarBody star = new StellarBody();
        if (planetNode.hasAttributes()) {
            Node nameNode = planetNode.getAttributes().getNamedItem("name");
            if (nameNode != null && !nameNode.getNodeValue().isEmpty()) {
                star.setName(nameNode.getNodeValue());
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem("temp")) != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    star.setTemperature(Integer.parseInt(nameNode.getNodeValue()));
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Error Reading star " + star.getName());
                }
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem("size")) != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    star.setSize(Float.parseFloat(nameNode.getNodeValue()));
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Error Reading star " + star.getName());
                }
            }
            if ((nameNode = planetNode.getAttributes().getNamedItem("seperation")) != null && !nameNode.getNodeValue().isEmpty()) {
                try {
                    star.setStarSeperation(Float.parseFloat(nameNode.getNodeValue()));
                }
                catch (NumberFormatException e) {
                    AdvancedRocketry.logger.warn("Error Reading star " + star.getName());
                }
            }
        }
        return star;
    }

    public DimensionPropertyCoupling readAllPlanets() {
        DimensionPropertyCoupling coupling = new DimensionPropertyCoupling();
        Node masterNode = this.doc.getElementsByTagName("galaxy").item(0).getFirstChild();
        this.offset = DimensionManager.dimOffset;
        while (masterNode != null) {
            if (!masterNode.getNodeName().equals("star")) {
                masterNode = masterNode.getNextSibling();
                continue;
            }
            StellarBody star = this.readStar(masterNode);
            coupling.stars.add(star);
            NodeList planetNodeList = masterNode.getChildNodes();
            for (Node planetNode = planetNodeList.item(0); planetNode != null; planetNode = planetNode.getNextSibling()) {
                if (planetNode.getNodeName().equalsIgnoreCase("planet")) {
                    coupling.dims.addAll(this.readPlanetFromNode(planetNode, star));
                }
                if (!planetNode.getNodeName().equalsIgnoreCase("star")) continue;
                StellarBody star2 = this.readSubStar(planetNode);
                star.addSubStar(star2);
            }
            masterNode = masterNode.getNextSibling();
        }
        return coupling;
    }

    public static String writeXML(IGalaxy galaxy) {
        String outputString = "<galaxy>\n";
        Collection<StellarBody> stars = galaxy.getStars();
        for (StellarBody star : stars) {
            outputString = outputString + "\t<star name=\"" + star.getName() + "\" temp=\"" + star.getTemperature() + "\" x=\"" + star.getPosX() + "\" y=\"" + star.getPosZ() + "\" size=\"" + star.getSize() + "\" numPlanets=\"0\" numGasGiants=\"0\">\n";
            for (StellarBody star2 : star.getSubStars()) {
                outputString = outputString + "\t\t<star temp=\"" + star2.getTemperature() + "\" size=\"" + star2.getSize() + "\" seperation=\"" + star2.getStarSeperation() + "\" />\n";
            }
            for (IDimensionProperties properties : star.getPlanets()) {
                if (properties.isMoon()) continue;
                outputString = outputString + XMLPlanetLoader.writePlanet((DimensionProperties)properties, 2);
            }
            outputString = outputString + "\t</star>\n";
        }
        outputString = outputString + "</galaxy>";
        return outputString;
    }

    private static String writePlanet(DimensionProperties properties, int numTabs) {
        String outputString = "";
        String tabLen = "";
        for (int i = 0; i < numTabs; ++i) {
            tabLen = tabLen + "\t";
        }
        outputString = tabLen + "<planet name=\"" + properties.getName() + "\" DIMID=\"" + properties.getId() + "\"" + (properties.isNativeDimension ? "" : " dimMapping=\"\"") + (properties.customIcon.isEmpty() ? "" : " customIcon=\"" + properties.customIcon + "\"") + ">\n";
        outputString = outputString + tabLen + "\t<isKnown>" + Configuration.initiallyKnownPlanets.contains(properties.getId()) + "</isKnown>\n";
        if (properties.hasRings) {
            outputString = outputString + tabLen + "\t<hasRings>true</hasRings>\n";
            outputString = outputString + tabLen + "\t<ringColor>" + properties.ringColor[0] + "," + properties.ringColor[1] + "," + properties.ringColor[2] + "</ringColor>\n";
        }
        if (properties.isGasGiant()) {
            outputString = outputString + tabLen + "\t<GasGiant>true</GasGiant>\n";
        }
        outputString = outputString + tabLen + "\t<fogColor>" + properties.fogColor[0] + "," + properties.fogColor[1] + "," + properties.fogColor[2] + "</fogColor>\n";
        outputString = outputString + tabLen + "\t<skyColor>" + properties.skyColor[0] + "," + properties.skyColor[1] + "," + properties.skyColor[2] + "</skyColor>\n";
        outputString = outputString + tabLen + "\t<gravitationalMultiplier>" + (int)(properties.getGravitationalMultiplier() * 100.0f) + "</gravitationalMultiplier>\n";
        outputString = outputString + tabLen + "\t<orbitalDistance>" + properties.getOrbitalDist() + "</orbitalDistance>\n";
        outputString = outputString + tabLen + "\t<orbitalPhi>" + (int)(properties.orbitalPhi * Math.PI / 180.0) + "</orbitalPhi>\n";
        outputString = outputString + tabLen + "\t<rotationalPeriod>" + properties.rotationalPeriod + "</rotationalPeriod>\n";
        outputString = outputString + tabLen + "\t<atmosphereDensity>" + properties.getAtmosphereDensity() + "</atmosphereDensity>\n";
        if (properties.oreProperties != null) {
            outputString = outputString + tabLen + "\t<oreGen>\n";
            outputString = outputString + XMLOreLoader.writeOreEntryXML(properties.oreProperties, numTabs + 2);
            outputString = outputString + tabLen + "\t</oreGen>\n";
        }
        if (properties.isNativeDimension && !properties.isGasGiant()) {
            String biomeIds = "";
            for (BiomeManager.BiomeEntry biome : properties.getBiomes()) {
                biomeIds = biomeIds + "," + biome.biome.field_76756_M;
            }
            if (!biomeIds.isEmpty()) {
                biomeIds = biomeIds.substring(1);
            } else {
                AdvancedRocketry.logger.warn("Dim " + properties.getId() + " has no biomes to save!");
            }
            outputString = outputString + tabLen + "\t<biomeIds>" + biomeIds + "</biomeIds>\n";
        }
        for (ItemStack stack : properties.getRequiredArtifacts()) {
            outputString = outputString + tabLen + "\t<artifact>" + Item.field_150901_e.func_148750_c((Object)stack.func_77973_b()) + " " + stack.func_77960_j() + "</artifact>\n";
        }
        for (Integer properties2 : properties.getChildPlanets()) {
            outputString = outputString + XMLPlanetLoader.writePlanet(DimensionManager.getInstance().getDimensionProperties(properties2), numTabs + 1);
        }
        outputString = outputString + tabLen + "</planet>\n";
        return outputString;
    }

    public static class DimensionPropertyCoupling {
        public List<StellarBody> stars = new LinkedList<StellarBody>();
        public List<DimensionProperties> dims = new LinkedList<DimensionProperties>();
    }
}

