/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.IFluidHandler;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.stations.IStorageChunk;
import zmaster587.advancedRocketry.tile.TileGuidanceComputer;
import zmaster587.advancedRocketry.tile.hatch.TileSatelliteHatch;
import zmaster587.advancedRocketry.tile.multiblock.TileWarpCore;
import zmaster587.advancedRocketry.world.util.WorldDummy;
import zmaster587.libVulpes.util.BlockPosition;
import zmaster587.libVulpes.util.Vector3F;

public class StorageChunk
implements IBlockAccess,
IStorageChunk {
    Block[][][] blocks;
    short[][][] metas;
    int sizeX;
    int sizeY;
    int sizeZ;
    ArrayList<TileEntity> tileEntities;
    ArrayList<TileEntity> inventoryTiles;
    ArrayList<TileEntity> liquidTiles;
    public WorldDummy world;
    private Entity entity;

    public StorageChunk() {
        this.sizeX = 0;
        this.sizeY = 0;
        this.sizeZ = 0;
        this.tileEntities = new ArrayList();
        this.inventoryTiles = new ArrayList();
        this.liquidTiles = new ArrayList();
        this.world = new WorldDummy(AdvancedRocketry.proxy.getProfiler(), this);
    }

    protected StorageChunk(int xSize, int ySize, int zSize) {
        this.blocks = new Block[xSize][ySize][zSize];
        this.metas = new short[xSize][ySize][zSize];
        this.sizeX = xSize;
        this.sizeY = ySize;
        this.sizeZ = zSize;
        this.tileEntities = new ArrayList();
        this.inventoryTiles = new ArrayList();
        this.liquidTiles = new ArrayList();
        this.world = new WorldDummy(AdvancedRocketry.proxy.getProfiler(), this);
    }

    public void setEntity(EntityRocketBase entity) {
        this.entity = entity;
        this.world.field_72995_K = entity.field_70170_p.field_72995_K;
    }

    public EntityRocketBase getEntity() {
        return (EntityRocketBase)this.entity;
    }

    @Override
    public int getSizeX() {
        return this.sizeX;
    }

    @Override
    public int getSizeY() {
        return this.sizeY;
    }

    @Override
    public int getSizeZ() {
        return this.sizeZ;
    }

    @Override
    public List<TileEntity> getTileEntityList() {
        return this.tileEntities;
    }

    @Override
    public void rotateBy(ForgeDirection dir) {
        BlockPosition newSizes = new BlockPosition(this.getSizeX(), this.getSizeY(), this.getSizeZ());
        BlockPosition newerSize = this.remapCoord(newSizes, dir);
        newSizes = this.remapCoord(newSizes, dir);
        Block[][][] blocks = new Block[newSizes.x][newSizes.y][newSizes.z];
        short[][][] metas = new short[newSizes.x][newSizes.y][newSizes.z];
        for (int y = 0; y < this.getSizeY(); ++y) {
            for (int z = 0; z < this.getSizeZ(); ++z) {
                for (int x = 0; x < this.getSizeX(); ++x) {
                    newSizes = this.getNewCoord(new BlockPosition(x, y, z), dir);
                    blocks[newSizes.x][newSizes.y][newSizes.z] = this.blocks[x][y][z];
                    metas[newSizes.x][newSizes.y][newSizes.z] = this.metas[x][y][z];
                }
            }
        }
        this.blocks = blocks;
        this.metas = metas;
        for (TileEntity e : this.tileEntities) {
            newSizes = this.getNewCoord(new BlockPosition(e.field_145851_c, e.field_145848_d, e.field_145849_e), dir);
            e.field_145851_c = newSizes.x;
            e.field_145848_d = newSizes.y;
            e.field_145849_e = newSizes.z;
        }
        this.sizeX = newerSize.x;
        this.sizeY = newerSize.y;
        this.sizeZ = newerSize.z;
    }

    private BlockPosition remapCoord(BlockPosition in, ForgeDirection dir) {
        BlockPosition out = new BlockPosition(0, 0, 0);
        switch (dir) {
            case DOWN: {
                out.x = in.z;
                out.y = in.y;
                out.z = in.x;
                break;
            }
            case UP: {
                out.x = in.z;
                out.y = in.y;
                out.z = in.x;
                break;
            }
            case NORTH: {
                out.x = in.y;
                out.y = (short)in.x;
                out.z = in.z;
                break;
            }
            case SOUTH: {
                out.x = in.y;
                out.y = (short)in.x;
                out.z = in.z;
                break;
            }
            case EAST: {
                out.x = in.x;
                out.y = (short)in.z;
                out.z = in.y;
                break;
            }
            case WEST: {
                out.x = in.x;
                out.y = (short)in.z;
                out.z = in.y;
            }
        }
        return out;
    }

    public BlockPosition getNewCoord(BlockPosition in, ForgeDirection dir) {
        BlockPosition out = new BlockPosition(0, 0, 0);
        switch (dir) {
            case DOWN: {
                out.x = in.z;
                out.y = in.y;
                out.z = this.getSizeX() - in.x - 1;
                break;
            }
            case UP: {
                out.x = this.getSizeZ() - in.z - 1;
                out.y = in.y;
                out.z = in.x;
                break;
            }
            case NORTH: {
                out.x = in.y;
                out.y = (short)(this.getSizeX() - in.x - 1);
                out.z = in.z;
                break;
            }
            case SOUTH: {
                out.x = this.getSizeY() - in.y - 1;
                out.y = (short)in.x;
                out.z = in.z;
                break;
            }
            case EAST: {
                out.x = in.x;
                out.y = (short)(this.getSizeZ() - in.z - 1);
                out.z = in.y;
                break;
            }
            case WEST: {
                out.x = in.x;
                out.y = (short)in.z;
                out.z = this.getSizeY() - in.y - 1;
            }
        }
        return out;
    }

    public List<TileEntity> getFluidTiles() {
        return this.liquidTiles;
    }

    public List<TileEntity> getInventoryTiles() {
        return this.inventoryTiles;
    }

    public List<TileEntity> getGUItiles() {
        LinkedList<TileEntity> list = new LinkedList<TileEntity>(this.inventoryTiles);
        TileGuidanceComputer guidanceComputer = this.getGuidanceComputer();
        if (guidanceComputer != null) {
            list.add((TileEntity)this.getGuidanceComputer());
        }
        return list;
    }

    public Block func_147439_a(int x, int y, int z) {
        if (x < 0 || x >= this.sizeX || y < 0 || y >= this.sizeY || z < 0 || z >= this.sizeZ) {
            return Blocks.field_150350_a;
        }
        if (this.blocks[x][y][z] != Blocks.field_150350_a) {
            return this.blocks[x][y][z];
        }
        return this.blocks[x][y][z];
    }

    public void setBlockMeta(int x, int y, int z, int meta) {
        if (x < 0 || x >= this.sizeX || y < 0 || y >= this.sizeY || z < 0 || z >= this.sizeZ) {
            return;
        }
        this.metas[x][y][z] = (short)meta;
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("xSize", this.sizeX);
        nbt.func_74768_a("ySize", this.sizeY);
        nbt.func_74768_a("zSize", this.sizeZ);
        Iterator<TileEntity> tileEntityIterator = this.tileEntities.iterator();
        NBTTagList tileList = new NBTTagList();
        while (tileEntityIterator.hasNext()) {
            TileEntity tile = tileEntityIterator.next();
            try {
                NBTTagCompound tileNbt = new NBTTagCompound();
                tile.func_145841_b(tileNbt);
                tileList.func_74742_a((NBTBase)tileNbt);
            }
            catch (RuntimeException e) {
                AdvancedRocketry.logger.warn("A tile entity has thrown an error: " + tile.getClass().getCanonicalName());
                this.blocks[tile.field_145851_c][tile.field_145848_d][tile.field_145849_e] = Blocks.field_150350_a;
                this.metas[tile.field_145851_c][tile.field_145848_d][tile.field_145849_e] = 0;
                tileEntityIterator.remove();
            }
        }
        int[] blockId = new int[this.sizeX * this.sizeY * this.sizeZ];
        int[] metasId = new int[this.sizeX * this.sizeY * this.sizeZ];
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    blockId[z + this.sizeZ * y + this.sizeZ * this.sizeY * x] = Block.func_149682_b((Block)this.blocks[x][y][z]);
                    metasId[z + this.sizeZ * y + this.sizeZ * this.sizeY * x] = this.metas[x][y][z];
                }
            }
        }
        NBTTagIntArray idList = new NBTTagIntArray(blockId);
        NBTTagIntArray metaList = new NBTTagIntArray(metasId);
        nbt.func_74782_a("idList", (NBTBase)idList);
        nbt.func_74782_a("metaList", (NBTBase)metaList);
        nbt.func_74782_a("tiles", (NBTBase)tileList);
    }

    private static boolean isInventoryBlock(TileEntity tile) {
        return tile instanceof IInventory && !(tile instanceof TileGuidanceComputer);
    }

    private static boolean isLiquidContainerBlock(TileEntity tile) {
        return tile instanceof IFluidHandler;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.sizeX = nbt.func_74762_e("xSize");
        this.sizeY = nbt.func_74762_e("ySize");
        this.sizeZ = nbt.func_74762_e("zSize");
        this.blocks = new Block[this.sizeX][this.sizeY][this.sizeZ];
        this.metas = new short[this.sizeX][this.sizeY][this.sizeZ];
        this.tileEntities.clear();
        this.inventoryTiles.clear();
        this.liquidTiles.clear();
        int[] blockId = nbt.func_74759_k("idList");
        int[] metasId = nbt.func_74759_k("metaList");
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    this.blocks[x][y][z] = Block.func_149729_e((int)blockId[z + this.sizeZ * y + this.sizeZ * this.sizeY * x]);
                    this.metas[x][y][z] = (short)metasId[z + this.sizeZ * y + this.sizeZ * this.sizeY * x];
                }
            }
        }
        NBTTagList tileList = nbt.func_150295_c("tiles", 10);
        for (int i = 0; i < tileList.func_74745_c(); ++i) {
            try {
                TileEntity tile = TileEntity.func_145827_c((NBTTagCompound)tileList.func_150305_b(i));
                tile.func_145834_a((World)this.world);
                if (StorageChunk.isInventoryBlock(tile)) {
                    this.inventoryTiles.add(tile);
                }
                if (StorageChunk.isLiquidContainerBlock(tile)) {
                    this.liquidTiles.add(tile);
                }
                this.tileEntities.add(tile);
                tile.func_145834_a((World)this.world);
                continue;
            }
            catch (Exception e) {
                AdvancedRocketry.logger.warn("Rocket missing Tile (was a mod removed?)");
            }
        }
    }

    public static StorageChunk copyWorldBB(World world, AxisAlignedBB bb) {
        int actualMinX = (int)bb.field_72336_d;
        int actualMinY = (int)bb.field_72337_e;
        int actualMinZ = (int)bb.field_72334_f;
        int actualMaxX = (int)bb.field_72340_a;
        int actualMaxY = (int)bb.field_72338_b;
        int actualMaxZ = (int)bb.field_72339_c;
        int x = (int)bb.field_72340_a;
        while ((double)x <= bb.field_72336_d) {
            int z = (int)bb.field_72339_c;
            while ((double)z <= bb.field_72334_f) {
                int y = (int)bb.field_72338_b;
                while ((double)y <= bb.field_72337_e) {
                    Block block = world.func_147439_a(x, y, z);
                    if (!block.isAir((IBlockAccess)world, x, y, z)) {
                        if (x < actualMinX) {
                            actualMinX = x;
                        }
                        if (y < actualMinY) {
                            actualMinY = y;
                        }
                        if (z < actualMinZ) {
                            actualMinZ = z;
                        }
                        if (x > actualMaxX) {
                            actualMaxX = x;
                        }
                        if (y > actualMaxY) {
                            actualMaxY = y;
                        }
                        if (z > actualMaxZ) {
                            actualMaxZ = z;
                        }
                    }
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        bb.func_72324_b((double)actualMinX, (double)actualMinY, (double)actualMinZ, (double)actualMaxX, (double)actualMaxY, (double)actualMaxZ);
        StorageChunk ret = new StorageChunk(actualMaxX - actualMinX + 1, actualMaxY - actualMinY + 1, actualMaxZ - actualMinZ + 1);
        for (int x2 = actualMinX; x2 <= actualMaxX; ++x2) {
            for (int z = actualMinZ; z <= actualMaxZ; ++z) {
                for (int y = actualMinY; y <= actualMaxY; ++y) {
                    ret.blocks[x2 - actualMinX][y - actualMinY][z - actualMinZ] = world.func_147439_a(x2, y, z);
                    ret.metas[x2 - actualMinX][y - actualMinY][z - actualMinZ] = (short)world.func_72805_g(x2, y, z);
                    TileEntity entity = world.func_147438_o(x2, y, z);
                    if (entity == null) continue;
                    NBTTagCompound nbt = new NBTTagCompound();
                    entity.func_145841_b(nbt);
                    nbt.func_74768_a("x", nbt.func_74762_e("x") - actualMinX);
                    nbt.func_74768_a("y", nbt.func_74762_e("y") - actualMinY);
                    nbt.func_74768_a("z", nbt.func_74762_e("z") - actualMinZ);
                    TileEntity newTile = TileEntity.func_145827_c((NBTTagCompound)nbt);
                    newTile.func_145834_a((World)ret.world);
                    if (StorageChunk.isInventoryBlock(newTile)) {
                        ret.inventoryTiles.add(newTile);
                    }
                    if (StorageChunk.isLiquidContainerBlock(newTile)) {
                        ret.liquidTiles.add(newTile);
                    }
                    ret.tileEntities.add(newTile);
                }
            }
        }
        return ret;
    }

    @Override
    public void pasteInWorld(World world, int xCoord, int yCoord, int zCoord) {
        for (int x = 0; x < this.sizeX; ++x) {
            for (int z = 0; z < this.sizeZ; ++z) {
                for (int y = 0; y < this.sizeY; ++y) {
                    if (this.blocks[x][y][z] == null) continue;
                    world.func_147465_d(xCoord + x, yCoord + y, zCoord + z, this.blocks[x][y][z], (int)this.metas[x][y][z], 2);
                }
            }
        }
        for (TileEntity tile : this.tileEntities) {
            NBTTagCompound nbt = new NBTTagCompound();
            tile.func_145841_b(nbt);
            int x = nbt.func_74762_e("x");
            int y = nbt.func_74762_e("y");
            int z = nbt.func_74762_e("z");
            int tmpX = x + xCoord;
            int tmpY = y + yCoord;
            int tmpZ = z + zCoord;
            nbt.func_74768_a("x", tmpX);
            nbt.func_74768_a("y", tmpY);
            nbt.func_74768_a("z", tmpZ);
            TileEntity entity = world.func_147438_o(tmpX, tmpY, tmpZ);
            if (entity == null) continue;
            entity.func_145839_a(nbt);
        }
    }

    public TileEntity func_147438_o(int x, int y, int z) {
        for (TileEntity tileE : this.tileEntities) {
            if (tileE.field_145851_c != x || tileE.field_145848_d != y || tileE.field_145849_e != z) continue;
            return tileE;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_72802_i(int x, int y, int z, int meta) {
        EntityLivingBase ent = Minecraft.func_71410_x().field_71451_h;
        return Minecraft.func_71410_x().field_71441_e.func_72802_i((int)ent.field_70165_t, (int)ent.field_70163_u, (int)ent.field_70161_v, meta);
    }

    public int func_72805_g(int x, int y, int z) {
        if (x < 0 || x >= this.sizeX || y < 0 || y >= this.sizeY || z < 0 || z >= this.sizeZ) {
            return 0;
        }
        return this.metas[x][y][z];
    }

    public int func_72879_k(int p_72879_1_, int p_72879_2_, int p_72879_3_, int p_72879_4_) {
        return 0;
    }

    public boolean func_147437_c(int x, int y, int z) {
        if (x >= this.blocks.length || y >= this.blocks[0].length || z >= this.blocks[0][0].length) {
            return true;
        }
        return this.blocks[x][y][z] == Blocks.field_150350_a;
    }

    public BiomeGenBase func_72807_a(int p_72807_1_, int p_72807_2_) {
        return BiomeGenBase.field_76771_b;
    }

    public int func_72800_K() {
        return this.sizeY;
    }

    public boolean func_72806_N() {
        return false;
    }

    public boolean isSideSolid(int x, int y, int z, ForgeDirection side, boolean _default) {
        if (x < 0 || x >= this.sizeX || y < 0 || y >= this.sizeY || z < 0 || z >= this.sizeZ || x + side.offsetX < 0 || x + side.offsetX >= this.sizeX || y + side.offsetY < 0 || y + side.offsetY >= this.sizeY || z + side.offsetZ < 0 || z + side.offsetZ >= this.sizeZ) {
            return false;
        }
        return this.blocks[x + side.offsetX][y + side.offsetY][z + side.offsetZ].func_149747_d((IBlockAccess)this, x, y, z, (int)this.metas[x][y][z]);
    }

    public static StorageChunk cutWorldBB(World worldObj, AxisAlignedBB bb) {
        StorageChunk chunk = StorageChunk.copyWorldBB(worldObj, bb);
        int x = (int)bb.field_72340_a;
        while ((double)x <= bb.field_72336_d) {
            int z = (int)bb.field_72339_c;
            while ((double)z <= bb.field_72334_f) {
                int y = (int)bb.field_72338_b;
                while ((double)y <= bb.field_72337_e) {
                    TileEntity tile = worldObj.func_147438_o(x, y, z);
                    if (tile instanceof IInventory) {
                        IInventory inv = (IInventory)tile;
                        for (int i = 0; i < inv.func_70302_i_(); ++i) {
                            inv.func_70299_a(i, null);
                        }
                    }
                    worldObj.func_147465_d(x, y, z, Blocks.field_150350_a, 0, 2);
                    ++y;
                }
                ++z;
            }
            ++x;
        }
        for (Object entity : worldObj.func_72872_a(EntityItem.class, bb.func_72314_b(5.0, 5.0, 5.0))) {
            ((Entity)entity).func_70106_y();
        }
        return chunk;
    }

    public List<TileSatelliteHatch> getSatelliteHatches() {
        LinkedList<TileSatelliteHatch> satelliteHatches = new LinkedList<TileSatelliteHatch>();
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileSatelliteHatch)) continue;
            satelliteHatches.add((TileSatelliteHatch)tile);
        }
        return satelliteHatches;
    }

    @Deprecated
    public List<SatelliteBase> getSatellites() {
        LinkedList<SatelliteBase> satellites = new LinkedList<SatelliteBase>();
        LinkedList<TileSatelliteHatch> satelliteHatches = new LinkedList<TileSatelliteHatch>();
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileSatelliteHatch)) continue;
            satelliteHatches.add((TileSatelliteHatch)tile);
        }
        for (TileSatelliteHatch tile : satelliteHatches) {
            SatelliteBase satellite = tile.getSatellite();
            if (satellite == null) continue;
            satellites.add(satellite);
        }
        return satellites;
    }

    @Deprecated
    public TileGuidanceComputer getGuidanceComputer() {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileGuidanceComputer)) continue;
            return (TileGuidanceComputer)tile;
        }
        return null;
    }

    public boolean hasWarpCore() {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileWarpCore)) continue;
            return true;
        }
        return false;
    }

    public int getDestinationDimId(int currentDimId, int x, int z) {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileGuidanceComputer)) continue;
            return ((TileGuidanceComputer)tile).getDestinationDimId(currentDimId, x, z);
        }
        return -1;
    }

    public Vector3F<Float> getDestinationCoordinates(int destDimID, boolean commit) {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileGuidanceComputer)) continue;
            return ((TileGuidanceComputer)tile).getLandingLocation(destDimID, commit);
        }
        return null;
    }

    public void setDestinationCoordinates(Vector3F<Float> vec, int dimid) {
        for (TileEntity tile : this.getTileEntityList()) {
            if (!(tile instanceof TileGuidanceComputer)) continue;
            ((TileGuidanceComputer)tile).setReturnPosition(vec, dimid);
        }
    }

    public void writeToNetwork(ByteBuf out) {
        PacketBuffer buffer = new PacketBuffer(out);
        buffer.writeByte(this.sizeX);
        buffer.writeByte(this.sizeY);
        buffer.writeByte(this.sizeZ);
        buffer.writeShort(this.tileEntities.size());
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    buffer.writeInt(Block.func_149682_b((Block)this.blocks[x][y][z]));
                    buffer.writeShort((int)this.metas[x][y][z]);
                }
            }
        }
        Iterator<TileEntity> tileIterator = this.tileEntities.iterator();
        while (tileIterator.hasNext()) {
            TileEntity tile = tileIterator.next();
            NBTTagCompound nbt = new NBTTagCompound();
            try {
                tile.func_145841_b(nbt);
                try {
                    buffer.func_150786_a(nbt);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (RuntimeException e) {
                AdvancedRocketry.logger.warn("A tile entity has thrown an error while writing to network: " + tile.getClass().getCanonicalName());
                tileIterator.remove();
            }
        }
    }

    public void readFromNetwork(ByteBuf in) {
        PacketBuffer buffer = new PacketBuffer(in);
        this.sizeX = buffer.readByte();
        this.sizeY = buffer.readByte();
        this.sizeZ = buffer.readByte();
        short numTiles = buffer.readShort();
        this.blocks = new Block[this.sizeX][this.sizeY][this.sizeZ];
        this.metas = new short[this.sizeX][this.sizeY][this.sizeZ];
        for (int x = 0; x < this.sizeX; ++x) {
            for (int y = 0; y < this.sizeY; ++y) {
                for (int z = 0; z < this.sizeZ; ++z) {
                    this.blocks[x][y][z] = Block.func_149729_e((int)buffer.readInt());
                    this.metas[x][y][z] = buffer.readShort();
                }
            }
        }
        for (short i = 0; i < numTiles; i = (short)(i + 1)) {
            try {
                NBTTagCompound nbt = buffer.func_150793_b();
                TileEntity tile = TileEntity.func_145827_c((NBTTagCompound)nbt);
                tile.func_145834_a((World)this.world);
                this.tileEntities.add(tile);
                if (StorageChunk.isInventoryBlock(tile)) {
                    this.inventoryTiles.add(tile);
                }
                if (StorageChunk.isLiquidContainerBlock(tile)) {
                    this.liquidTiles.add(tile);
                }
                tile.func_145834_a((World)this.world);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

