/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.IFluidBlock;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.atmosphere.IAtmosphereSealHandler;
import zmaster587.libVulpes.util.BlockPosition;

public final class SealableBlockHandler
implements IAtmosphereSealHandler {
    private List<Block> blockBanList = new ArrayList<Block>();
    private List<Block> blockAllowList = new ArrayList<Block>();
    private List<Material> materialBanList = new ArrayList<Material>();
    private List<Material> materialAllowList = new ArrayList<Material>();
    private HashSet<BlockPosition> doorPositions = new HashSet();
    public static final SealableBlockHandler INSTANCE = new SealableBlockHandler();

    private SealableBlockHandler() {
    }

    @Override
    public boolean isBlockSealed(World world, int x, int y, int z) {
        return this.isBlockSealed(world, new BlockPosition(x, y, z));
    }

    public boolean isBlockSealed(World world, BlockPosition pos) {
        if (pos.y >= 0 && pos.y <= 256) {
            if (world instanceof WorldServer && !((WorldServer)world).field_73059_b.func_73149_a(pos.x >> 4, pos.z >> 4)) {
                return false;
            }
            Block block = world.func_147439_a(pos.x, (int)pos.y, pos.z);
            int meta = world.func_72805_g(pos.x, (int)pos.y, pos.z);
            Material material = block.func_149688_o();
            if (this.blockAllowList.contains(block) || this.materialAllowList.contains(material)) {
                return true;
            }
            if (this.blockBanList.contains(block) || this.materialBanList.contains(material)) {
                return false;
            }
            if (material.func_76224_d() || !material.func_76220_a()) {
                return false;
            }
            if (world.func_147437_c(pos.x, (int)pos.y, pos.z) || block instanceof IFluidBlock) {
                return false;
            }
            if (block == AdvancedRocketryBlocks.blockAirLock) {
                if (this.doorPositions.contains(pos)) {
                    return true;
                }
                this.doorPositions.add(pos);
                boolean doorIsSealed = this.checkDoorIsSealed(world, pos, meta);
                this.doorPositions.remove(pos);
                return doorIsSealed;
            }
            return SealableBlockHandler.isFulBlock(world, pos);
        }
        return false;
    }

    @Override
    public void addUnsealableBlock(Block block) {
        if (!this.blockBanList.contains(block)) {
            this.blockBanList.add(block);
        }
        if (this.blockAllowList.contains(block)) {
            this.blockAllowList.remove(block);
        }
    }

    @Override
    public void addSealableBlock(Block block) {
        if (!this.blockAllowList.contains(block)) {
            this.blockAllowList.add(block);
        }
        if (this.blockBanList.contains(block)) {
            this.blockBanList.remove(block);
        }
    }

    public static boolean isFulBlock(World world, BlockPosition pos) {
        return SealableBlockHandler.isFulBlock(world, world.func_147439_a(pos.x, (int)pos.y, pos.z), pos);
    }

    public static boolean isFulBlock(World world, Block block, BlockPosition pos) {
        AxisAlignedBB bb = block.func_149668_a(world, pos.x, (int)pos.y, pos.z);
        if (bb == null) {
            return false;
        }
        int minX = (int)((bb.field_72340_a - (double)pos.x) * 100.0);
        int minY = (int)((bb.field_72338_b - (double)pos.y) * 100.0);
        int minZ = (int)((bb.field_72339_c - (double)pos.z) * 100.0);
        int maxX = (int)((bb.field_72336_d - (double)pos.x) * 100.0);
        int maxY = (int)((bb.field_72337_e - (double)pos.y) * 100.0);
        int maxZ = (int)((bb.field_72334_f - (double)pos.z) * 100.0);
        return minX == 0 && minY == 0 && minZ == 0 && maxX == 100 && maxY == 100 && maxZ == 100;
    }

    private boolean checkDoorIsSealed(World world, BlockPosition pos, int meta) {
        return (meta & 8) == 8 || (meta & 4) >> 2 == (meta & 1) && this.checkDoorSeal(world, pos.getPositionAtOffset(0, 0, 1), meta) && this.checkDoorSeal(world, pos.getPositionAtOffset(0, 0, -1), meta) || (meta & 4) >> 2 != (meta & 1) && this.checkDoorSeal(world, pos.getPositionAtOffset(1, 0, 0), meta) && this.checkDoorSeal(world, pos.getPositionAtOffset(-1, 0, 0), meta);
    }

    private boolean checkDoorSeal(World world, BlockPosition pos, int meta) {
        Block otherBlock = world.func_147439_a(pos.x, (int)pos.y, pos.z);
        int otherMeta = world.func_72805_g(pos.x, (int)pos.y, pos.z);
        return otherBlock == AdvancedRocketryBlocks.blockAirLock && (otherMeta & 1) == (meta & 1) || otherBlock != AdvancedRocketryBlocks.blockAirLock && this.isBlockSealed(world, pos);
    }

    public boolean isBlockBanned(Block block) {
        return this.blockBanList.contains(block);
    }

    public boolean isMaterialBanned(Material mat) {
        return this.materialBanList.contains(mat);
    }

    public void loadDefaultData() {
        this.materialBanList.add(Material.field_151579_a);
        this.materialBanList.add(Material.field_151570_A);
        this.materialBanList.add(Material.field_151596_z);
        this.materialBanList.add(Material.field_151581_o);
        this.materialBanList.add(Material.field_151584_j);
        this.materialBanList.add(Material.field_151567_E);
        this.materialBanList.add(Material.field_151582_l);
        this.materialBanList.add(Material.field_151585_k);
        this.materialBanList.add(Material.field_151589_v);
        this.materialBanList.add(Material.field_151569_G);
        this.materialBanList.add(Material.field_151583_m);
        this.materialBanList.add(Material.field_151595_p);
    }
}

