/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AreaBlob;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.util.IBlobHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.util.SealableBlockHandler;
import zmaster587.libVulpes.util.AdjacencyGraph;
import zmaster587.libVulpes.util.BlockPosition;

public class AtmosphereBlob
extends AreaBlob
implements Runnable {
    static ThreadPoolExecutor pool = (Configuration.atmosphereHandleBitMask & 1) == 1 ? new ThreadPoolExecutor(3, 16, 60L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(32)) : null;
    boolean executing = false;
    BlockPosition blockPos;
    List<AreaBlob> nearbyBlobs;

    public AtmosphereBlob(IBlobHandler blobHandler) {
        super(blobHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeBlock(int x, int y, int z) {
        BlockPosition blockPos = new BlockPosition(x, y, z);
        AdjacencyGraph adjacencyGraph = this.graph;
        synchronized (adjacencyGraph) {
            this.graph.remove((Object)blockPos);
            this.graph.contains((Object)blockPos);
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                BlockPosition newBlock = blockPos.getPositionAtOffset(direction.offsetX, direction.offsetY, direction.offsetZ);
                if (!this.graph.contains((Object)newBlock) || this.graph.doesPathExist((Object)newBlock, (Object)this.blobHandler.getRootPosition())) continue;
                this.runEffectOnWorldBlocks(this.blobHandler.getWorld(), this.graph.removeAllNodesConnectedTo((Object)newBlock));
            }
        }
    }

    @Override
    public boolean isPositionAllowed(World world, BlockPosition pos, List<AreaBlob> otherBlobs) {
        for (AreaBlob blob : otherBlobs) {
            if (!blob.contains(pos) || blob == this) continue;
            return false;
        }
        return !SealableBlockHandler.INSTANCE.isBlockSealed(world, pos);
    }

    @Override
    public void addBlock(BlockPosition blockPos, List<AreaBlob> otherBlobs) {
        if (this.blobHandler.canFormBlob() && !this.contains(blockPos) && (this.graph.size() == 0 || this.contains(blockPos.getPositionAtOffset(0, 1, 0)) || this.contains(blockPos.getPositionAtOffset(0, -1, 0)) || this.contains(blockPos.getPositionAtOffset(1, 0, 0)) || this.contains(blockPos.getPositionAtOffset(-1, 0, 0)) || this.contains(blockPos.getPositionAtOffset(0, 0, 1)) || this.contains(blockPos.getPositionAtOffset(0, 0, -1))) && !this.executing) {
            this.nearbyBlobs = otherBlobs;
            this.blockPos = blockPos;
            this.executing = true;
            if ((Configuration.atmosphereHandleBitMask & 1) == 1) {
                try {
                    pool.execute(this);
                }
                catch (RejectedExecutionException e) {
                    AdvancedRocketry.logger.warn("Atmosphere calculation at " + this.getRootPosition() + " aborted due to oversize queue!");
                }
            } else {
                this.run();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Stack<BlockPosition> stack = new Stack<BlockPosition>();
        stack.push(this.blockPos);
        int maxSize = (Configuration.atmosphereHandleBitMask & 2) != 0 ? (int)(Math.pow(this.getBlobMaxRadius(), 3.0) * 4.1887903296220665) : this.getBlobMaxRadius();
        HashSet<BlockPosition> addableBlocks = new HashSet<BlockPosition>();
        while (!stack.isEmpty()) {
            BlockPosition stackElement = (BlockPosition)stack.pop();
            addableBlocks.add(stackElement);
            for (ForgeDirection dir2 : ForgeDirection.VALID_DIRECTIONS) {
                BlockPosition searchNextPosition = stackElement.getPositionAtOffset(dir2.offsetX, dir2.offsetY, dir2.offsetZ);
                if (this.graph.contains((Object)searchNextPosition) || addableBlocks.contains(searchNextPosition)) continue;
                try {
                    boolean sealed;
                    boolean bl = sealed = !this.isPositionAllowed(this.blobHandler.getWorld(), searchNextPosition, this.nearbyBlobs);
                    if (sealed) continue;
                    if ((Configuration.atmosphereHandleBitMask & 2) == 0 && searchNextPosition.getDistance(this.getRootPosition()) <= (double)maxSize || (Configuration.atmosphereHandleBitMask & 2) != 0 && addableBlocks.size() <= maxSize) {
                        stack.push(searchNextPosition);
                        addableBlocks.add(searchNextPosition);
                        continue;
                    }
                    this.clearBlob();
                    this.executing = false;
                    return;
                }
                catch (Exception e) {
                    AdvancedRocketry.logger.info("Error: AtmosphereBlob has failed to form correctly due to an error. \nCurrentBlock: " + stackElement + "\tNextPos: " + searchNextPosition + "\tDir: " + dir2 + "\tStackSize: " + stack.size());
                    e.printStackTrace();
                    this.clearBlob();
                    this.executing = false;
                    return;
                }
            }
        }
        AdjacencyGraph adjacencyGraph = this.graph;
        synchronized (adjacencyGraph) {
            for (BlockPosition blockPos2 : addableBlocks) {
                super.addBlock(blockPos2, this.nearbyBlobs);
            }
        }
        this.executing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runEffectOnWorldBlocks(World world, Collection<BlockPosition> blocks) {
        if (!AtmosphereHandler.getOxygenHandler(world.field_73011_w.field_76574_g).getDefaultAtmosphereType().allowsCombustion()) {
            LinkedList<BlockPosition> list;
            AdjacencyGraph adjacencyGraph = this.graph;
            synchronized (adjacencyGraph) {
                list = new LinkedList<BlockPosition>(blocks);
            }
            for (BlockPosition pos : list) {
                Block block = world.func_147439_a(pos.x, (int)pos.y, pos.z);
                if (block == Blocks.field_150478_aa) {
                    world.func_147449_b(pos.x, (int)pos.y, pos.z, AdvancedRocketryBlocks.blockUnlitTorch);
                    continue;
                }
                if (!Configuration.torchBlocks.contains(block)) continue;
                EntityItem item = new EntityItem(world, (double)pos.x, (double)pos.y, (double)pos.z, new ItemStack(block));
                world.func_147468_f(pos.x, (int)pos.y, pos.z);
                world.func_72838_d((Entity)item);
            }
        }
    }

    @Override
    public void clearBlob() {
        World world = this.blobHandler.getWorld();
        this.runEffectOnWorldBlocks(world, this.getLocations());
        super.clearBlob();
    }

    public int getPressure() {
        return 100;
    }
}

