/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.station;

import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.network.PacketStationUpdate;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.world.provider.WorldProviderSpace;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ISliderBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleSlider;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileStationOrientationControl
extends TileEntity
implements IModularInventory,
INetworkMachine,
ISliderBar {
    int[] numRotationsPerHour;
    int[] progress;
    private ModuleText moduleAngularVelocity = new ModuleText(6, 15, "Angular Velocity: ", 0xAA2020);
    private ModuleText numThrusters;
    private ModuleText maxAngularAcceleration;
    private ModuleText targetRotations = new ModuleText(6, 25, "Target Ang Vel:", 0x202020);

    public TileStationOrientationControl() {
        this.progress = new int[3];
        this.numRotationsPerHour = new int[3];
        this.progress[0] = this.getTotalProgress(0) / 2;
        this.progress[1] = this.getTotalProgress(1) / 2;
        this.progress[2] = this.getTotalProgress(2) / 2;
    }

    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)this.moduleAngularVelocity);
        modules.add((ModuleBase)this.targetRotations);
        modules.add((ModuleBase)new ModuleText(10, 54, "X:", 0x202020));
        modules.add((ModuleBase)new ModuleText(10, 69, "Y:", 0x202020));
        modules.add((ModuleBase)new ModuleSlider(24, 50, 0, TextureResources.doubleWarningSideBarIndicator, (ISliderBar)this));
        modules.add((ModuleBase)new ModuleSlider(24, 65, 1, TextureResources.doubleWarningSideBarIndicator, (ISliderBar)this));
        this.updateText();
        return modules;
    }

    public boolean canUpdate() {
        return true;
    }

    private void updateText() {
        if (this.field_145850_b.field_72995_K) {
            ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_145851_c, this.field_145849_e);
            if (object != null) {
                this.moduleAngularVelocity.setText(String.format("Angular Velocity: %.1f %.1f %.1f", 72000.0 * object.getDeltaRotation(ForgeDirection.EAST), 72000.0 * object.getDeltaRotation(ForgeDirection.UP), 7200.0 * object.getDeltaRotation(ForgeDirection.NORTH)));
            }
            this.targetRotations.setText(String.format("Target Ang Vel: %d %d %d", this.numRotationsPerHour[0], this.numRotationsPerHour[1], this.numRotationsPerHour[2]));
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_73011_w instanceof WorldProviderSpace) {
            if (!this.field_145850_b.field_72995_K) {
                ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_145851_c, this.field_145849_e);
                boolean update = false;
                if (object != null) {
                    ForgeDirection[] dirs = new ForgeDirection[]{ForgeDirection.EAST, ForgeDirection.UP, ForgeDirection.NORTH};
                    for (int i = 0; i < 3; ++i) {
                        double targetAngularVelocity = (double)this.numRotationsPerHour[i] / 72000.0;
                        double angVel = object.getDeltaRotation(dirs[i]);
                        double acc = object.getMaxRotationalAcceleration();
                        double difference = targetAngularVelocity - angVel;
                        if (difference == 0.0) continue;
                        double finalVel = angVel;
                        if (difference < 0.0) {
                            finalVel = angVel + Math.max(difference, -acc);
                        } else if (difference > 0.0) {
                            finalVel = angVel + Math.min(difference, acc);
                        }
                        object.setDeltaRotation(finalVel, dirs[i]);
                        update = true;
                    }
                    if (!this.field_145850_b.field_72995_K && update) {
                        PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(object, PacketStationUpdate.Type.ROTANGLE_UPDATE));
                    }
                } else {
                    this.updateText();
                }
            } else {
                this.updateText();
            }
        }
    }

    public String getModularInventoryName() {
        return "tile.orientationControl.name";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 0) {
            out.writeShort(this.progress[0]);
            out.writeShort(this.progress[1]);
            out.writeShort(this.progress[2]);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 0) {
            this.setProgress(0, in.readShort());
            this.setProgress(1, in.readShort());
            this.setProgress(2, in.readShort());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("numRotationsX", (short)this.numRotationsPerHour[0]);
        nbt.func_74777_a("numRotationsY", (short)this.numRotationsPerHour[1]);
        nbt.func_74777_a("numRotationsZ", (short)this.numRotationsPerHour[2]);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.numRotationsPerHour[0] = nbt.func_74765_d("numRotationsX");
        this.progress[0] = this.numRotationsPerHour[0] + this.getTotalProgress(0) / 2;
        this.numRotationsPerHour[1] = nbt.func_74765_d("numRotationsX");
        this.progress[1] = this.numRotationsPerHour[1] + this.getTotalProgress(1) / 2;
        this.numRotationsPerHour[2] = nbt.func_74765_d("numRotationsX");
        this.progress[2] = this.numRotationsPerHour[2] + this.getTotalProgress(2) / 2;
    }

    public float getNormallizedProgress(int id) {
        return (float)this.getProgress(id) / (float)this.getTotalProgress(id);
    }

    public void setProgress(int id, int progress) {
        this.progress[id] = progress;
        this.numRotationsPerHour[id] = progress - this.getTotalProgress(id) / 2;
    }

    public int getProgress(int id) {
        return this.progress[id];
    }

    public int getTotalProgress(int id) {
        return 120;
    }

    public void setTotalProgress(int id, int progress) {
    }

    public void setProgressByUser(int id, int progress) {
        this.setProgress(id, progress);
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }
}

