/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.station;

import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.network.PacketStationUpdate;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.world.provider.WorldProviderSpace;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ISliderBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleSlider;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileStationGravityController
extends TileEntity
implements IModularInventory,
INetworkMachine,
ISliderBar {
    int gravity;
    int progress;
    private ModuleText moduleGrav = new ModuleText(6, 15, "Artifical Gravity: ", 0xAA2020);
    private ModuleText numGravPylons;
    private ModuleText maxGravBuildSpeed = new ModuleText(6, 25, "Max Gravity Change Rate: ", 0xAA2020);
    private ModuleText targetGrav = new ModuleText(6, 35, "Target Gravity:", 0x202020);

    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)this.moduleGrav);
        modules.add((ModuleBase)this.maxGravBuildSpeed);
        modules.add((ModuleBase)this.targetGrav);
        modules.add((ModuleBase)new ModuleSlider(6, 60, 0, TextureResources.doubleWarningSideBarIndicator, (ISliderBar)this));
        this.updateText();
        return modules;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("gravity", this.gravity);
        S35PacketUpdateTileEntity packet = new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
        return super.func_145844_m();
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        super.onDataPacket(net, pkt);
        this.gravity = pkt.func_148857_g().func_74762_e("gravity");
    }

    public boolean canUpdate() {
        return true;
    }

    private void updateText() {
        if (this.field_145850_b.field_72995_K) {
            ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_145851_c, this.field_145849_e);
            if (object != null) {
                this.moduleGrav.setText(String.format("Artifical Gravity: %.2f", Float.valueOf(object.getProperties().getGravitationalMultiplier())));
                this.maxGravBuildSpeed.setText(String.format("Max Gravity Change Rate: %.1f", 7200.0 * object.getMaxRotationalAcceleration()));
            }
            this.targetGrav.setText(String.format("Target Gravity: %d", this.gravity));
        }
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (this.field_145850_b.field_73011_w instanceof WorldProviderSpace) {
            if (!this.field_145850_b.field_72995_K) {
                ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(this.field_145851_c, this.field_145849_e);
                if (object != null) {
                    if (this.gravity == 0) {
                        this.gravity = 15;
                    }
                    double targetGravity = (double)this.gravity / 100.0;
                    double angVel = object.getProperties().getGravitationalMultiplier();
                    double acc = 0.001;
                    double difference = targetGravity - angVel;
                    if (difference != 0.0) {
                        double finalVel = angVel;
                        if (difference < 0.0) {
                            finalVel = angVel + Math.max(difference, -acc);
                        } else if (difference > 0.0) {
                            finalVel = angVel + Math.min(difference, acc);
                        }
                        object.getProperties().setGravitationalMultiplier((float)finalVel);
                        if (!this.field_145850_b.field_72995_K) {
                            PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(object, PacketStationUpdate.Type.DIM_PROPERTY_UPDATE));
                        } else {
                            this.updateText();
                        }
                    }
                }
            } else {
                this.updateText();
            }
        }
    }

    public String getModularInventoryName() {
        return "tile.gravityControl.name";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 0) {
            out.writeShort(this.progress);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 0) {
            this.setProgress(0, in.readShort());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("numRotations", (short)this.gravity);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.gravity = nbt.func_74765_d("numRotations");
        this.progress = this.gravity - 10;
    }

    public float getNormallizedProgress(int id) {
        return (float)this.getProgress(0) / (float)this.getTotalProgress(0);
    }

    public void setProgress(int id, int progress) {
        this.progress = progress;
        this.gravity = progress + 10;
    }

    public int getProgress(int id) {
        return this.progress;
    }

    public int getTotalProgress(int id) {
        return 90;
    }

    public void setTotalProgress(int id, int progress) {
    }

    public void setProgressByUser(int id, int progress) {
        this.setProgress(id, progress);
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }
}

