/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.oxygen;

import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryFluids;
import zmaster587.advancedRocketry.api.AreaBlob;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.util.IBlobHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.tile.oxygen.TileCO2Scrubber;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IToggleableMachine;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.client.RepeatingSound;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleLiquidIndicator;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleRedstoneOutputButton;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.TileInventoriedRFConsumerTank;
import zmaster587.libVulpes.util.BlockPosition;
import zmaster587.libVulpes.util.IAdjBlockUpdate;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileOxygenVent
extends TileInventoriedRFConsumerTank
implements INetworkMachine,
IBlobHandler,
IModularInventory,
IAdjBlockUpdate,
IToggleableMachine,
IButtonInventory {
    boolean isSealed;
    boolean firstRun;
    boolean hasFluid;
    boolean soundInit;
    int numScrubbers;
    List<TileCO2Scrubber> scrubbers;
    ZUtils.RedstoneState state;
    ModuleRedstoneOutputButton redstoneControl;

    public TileOxygenVent() {
        super(1000, 2, 1000);
        this.isSealed = true;
        this.firstRun = true;
        this.hasFluid = true;
        this.soundInit = false;
        this.numScrubbers = 0;
        this.scrubbers = new LinkedList<TileCO2Scrubber>();
        this.state = ZUtils.RedstoneState.ON;
        this.redstoneControl = new ModuleRedstoneOutputButton(174, 4, 0, "", (IButtonInventory)this);
    }

    public TileOxygenVent(int energy, int invSize, int tankSize) {
        super(energy, invSize, tankSize);
        this.isSealed = false;
        this.firstRun = false;
        this.hasFluid = true;
        this.soundInit = false;
        this.scrubbers = new LinkedList<TileCO2Scrubber>();
        this.state = ZUtils.RedstoneState.ON;
        this.redstoneControl = new ModuleRedstoneOutputButton(174, 4, 0, "", (IButtonInventory)this);
    }

    public boolean canPerformFunction() {
        return AtmosphereHandler.hasAtmosphereHandler(this.field_145850_b.field_73011_w.field_76574_g);
    }

    public void func_145845_h() {
        if (this.canPerformFunction()) {
            if (this.hasEnoughEnergy(this.getPowerPerOperation())) {
                this.performFunction();
                if (!this.field_145850_b.field_72995_K && this.isSealed) {
                    this.energy.extractEnergy(this.getPowerPerOperation(), false);
                }
            } else {
                this.notEnoughEnergyForFunction();
            }
        }
        if (!this.soundInit && this.field_145850_b.field_72995_K) {
            LibVulpes.proxy.playSound((Object)new RepeatingSound(TextureResources.sndHiss, (TileEntity)this));
        }
        this.soundInit = true;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("sealed", this.isSealed);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.isSealed = pkt.func_148857_g().func_74767_n("sealed");
    }

    @Override
    public World getWorld() {
        return this.func_145831_w();
    }

    public void onAdjacentBlockUpdated() {
        if (this.isSealed) {
            this.activateAdjblocks();
        }
        this.scrubbers.clear();
        TileEntity[] tiles = new TileEntity[]{this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e), this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e), this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1), this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1)};
        for (TileEntity tile : tiles) {
            if (!(tile instanceof TileCO2Scrubber) || this.field_145850_b.func_147439_a(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e) != AdvancedRocketryBlocks.blockOxygenScrubber) continue;
            this.scrubbers.add((TileCO2Scrubber)tile);
        }
    }

    private void activateAdjblocks() {
        this.numScrubbers = 0;
        this.numScrubbers = this.toggleAdjBlock(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, true) ? this.numScrubbers + 1 : this.numScrubbers;
        this.numScrubbers = this.toggleAdjBlock(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, true) ? this.numScrubbers + 1 : this.numScrubbers;
        this.numScrubbers = this.toggleAdjBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, true) ? this.numScrubbers + 1 : this.numScrubbers;
        this.numScrubbers = this.toggleAdjBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, true) ? this.numScrubbers + 1 : this.numScrubbers;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void deactivateAdjblocks() {
        this.toggleAdjBlock(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, false);
        this.toggleAdjBlock(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, false);
        this.toggleAdjBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, false);
        this.toggleAdjBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, false);
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private boolean toggleAdjBlock(int x, int y, int z, boolean on) {
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        if (block == AdvancedRocketryBlocks.blockOxygenScrubber) {
            int meta = this.field_145850_b.func_72805_g(x, y, z);
            if (on && (meta & 8) == 0) {
                this.field_145850_b.func_72921_c(x, y, z, 8, 2);
            } else if (!on && (meta & 8) == 8) {
                this.field_145850_b.func_72921_c(x, y, z, 0, 2);
            }
            return true;
        }
        return false;
    }

    public void func_145843_s() {
        super.func_145843_s();
        AtmosphereHandler handler = AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.field_76574_g);
        if (handler != null) {
            AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.field_76574_g).unregisterBlob(this);
        }
        this.deactivateAdjblocks();
    }

    public int getPowerPerOperation() {
        return this.isSealed ? this.numScrubbers * 10 + 1 : 1;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid.getID() == AdvancedRocketryFluids.fluidOxygen.getID() && super.canFill(from, fluid);
    }

    public boolean getEquivilentPower() {
        if (this.state == ZUtils.RedstoneState.OFF) {
            return true;
        }
        boolean state2 = this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        if (this.state == ZUtils.RedstoneState.INVERTED) {
            state2 = !state2;
        }
        return state2;
    }

    public void performFunction() {
        if (this.firstRun) {
            if (!this.field_145850_b.field_72995_K) {
                AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.field_76574_g).registerBlob(this, this.field_145851_c, this.field_145848_d, this.field_145849_e);
                this.onAdjacentBlockUpdated();
                this.isSealed = false;
            }
            this.firstRun = false;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.isSealed && !this.getEquivilentPower()) {
                AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.field_76574_g).clearBlob(this);
                this.deactivateAdjblocks();
                this.isSealed = false;
            } else if (!this.isSealed && this.getEquivilentPower()) {
                AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.field_76574_g).addBlock(this, new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e));
                this.isSealed = true;
                this.activateAdjblocks();
            }
            if (this.isSealed) {
                int amtToDrain;
                FluidStack drainedFluid;
                if (Configuration.scrubberRequiresCartrige && this.field_145850_b.func_82737_E() % 200L == 0L) {
                    this.numScrubbers = 0;
                    for (TileCO2Scrubber scrubber : this.scrubbers) {
                        this.numScrubbers = scrubber.useCharge() ? this.numScrubbers + 1 : this.numScrubbers;
                    }
                }
                if ((drainedFluid = this.drain(ForgeDirection.UNKNOWN, amtToDrain = (int)((float)AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.field_76574_g).getBlobSize(this) * this.getGasUsageMultiplier()), false)) != null && drainedFluid.amount >= amtToDrain || amtToDrain == 0) {
                    this.drain(ForgeDirection.UNKNOWN, amtToDrain, true);
                    if (!this.hasFluid) {
                        this.hasFluid = true;
                        this.activateAdjblocks();
                        AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.field_76574_g).setAtmosphereType(this, AtmosphereType.PRESSURIZEDAIR);
                    }
                } else if (this.hasFluid) {
                    AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.field_76574_g).setAtmosphereType(this, DimensionManager.getInstance().getDimensionProperties(this.field_145850_b.field_73011_w.field_76574_g).getAtmosphere());
                    this.deactivateAdjblocks();
                    this.hasFluid = false;
                }
            }
        }
    }

    public float getGasUsageMultiplier() {
        return (float)((double)Math.max(0.01f - (float)this.numScrubbers * 0.005f, 0.0f) * Configuration.oxygenVentConsumptionMult);
    }

    public void notEnoughEnergyForFunction() {
        if (!this.field_145850_b.field_72995_K) {
            AtmosphereHandler handler = AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.field_76574_g);
            if (handler != null) {
                handler.clearBlob(this);
            }
            this.deactivateAdjblocks();
            this.isSealed = false;
        }
    }

    public int[] func_94128_d(int p_94128_1_) {
        return new int[0];
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean canBlobsOverlap(BlockPosition blockPosition, AreaBlob blob) {
        return false;
    }

    @Override
    public int getMaxBlobRadius() {
        return Configuration.oxygenVentSize;
    }

    @Override
    public BlockPosition getRootPosition() {
        return new BlockPosition(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        ArrayList<ModuleBase> modules = new ArrayList<ModuleBase>();
        modules.add((ModuleBase)new ModulePower(18, 20, (IUniversalEnergy)this));
        modules.add((ModuleBase)new ModuleLiquidIndicator(32, 20, (IFluidHandler)this));
        return modules;
    }

    public String getModularInventoryName() {
        return "OxygenVent";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    @Override
    public boolean canFormBlob() {
        return this.getEquivilentPower();
    }

    public boolean isRunning() {
        return this.isSealed;
    }

    public void onInventoryButtonPressed(int buttonId) {
        this.state = this.redstoneControl.getState();
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 2));
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        out.writeByte(this.state.ordinal());
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        nbt.func_74774_a("state", in.readByte());
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("state")];
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        this.redstoneControl.setRedstoneState(this.state);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("redstoneState", (byte)this.state.ordinal());
    }
}

