/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock.energy;

import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.libVulpes.api.IUniversalEnergyTransmitter;
import zmaster587.libVulpes.block.BlockMeta;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiBlock;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerProducer;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.Vector3F;

public class TileMicrowaveReciever
extends TileMultiPowerProducer {
    static final BlockMeta iron_block = new BlockMeta(AdvancedRocketryBlocks.blockSolarPanel);
    static final Object[][][] structure = new Object[][][]{{{iron_block, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), iron_block}, {Character.valueOf('*'), iron_block, iron_block, iron_block, Character.valueOf('*')}, {Character.valueOf('*'), iron_block, Character.valueOf('c'), iron_block, Character.valueOf('*')}, {Character.valueOf('*'), iron_block, iron_block, iron_block, Character.valueOf('*')}, {iron_block, Character.valueOf('*'), Character.valueOf('*'), Character.valueOf('*'), iron_block}}};
    List<Long> connectedSatellites = new LinkedList<Long>();
    boolean initialCheck = false;
    int powerMadeLastTick;
    int prevPowerMadeLastTick;
    ModuleText textModule = new ModuleText(40, 20, "Generating 0 RF/t", 0x2B2B2B);

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        List modules = super.getModules(ID, player);
        modules.add(this.textModule);
        return modules;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return super.getRenderBoundingBox().func_72314_b(0.0, 2000.0, 0.0).func_72317_d(0.0, 1000.0, 0.0);
    }

    public boolean shouldHideBlock(World world, int x, int y, int z, Block tile) {
        return false;
    }

    public Object[][][] getStructure() {
        return structure;
    }

    public List<BlockMeta> getAllowableWildCardBlocks() {
        List blocks = super.getAllowableWildCardBlocks();
        blocks.addAll(TileMultiBlock.getMapping((char)'I'));
        blocks.add(iron_block);
        blocks.addAll(TileMultiBlock.getMapping((char)'p'));
        return blocks;
    }

    public boolean canUpdate() {
        return true;
    }

    public String getMachineName() {
        return "tile.microwaveReciever.name";
    }

    public int getPowerMadeLastTick() {
        return this.powerMadeLastTick;
    }

    public void onInventoryUpdated() {
        super.onInventoryUpdated();
        LinkedList<Long> list = new LinkedList<Long>();
        for (IInventory inv : this.itemInPorts) {
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof ItemSatelliteIdentificationChip)) continue;
                ItemSatelliteIdentificationChip item = (ItemSatelliteIdentificationChip)stack.func_77973_b();
                list.add(item.getSatelliteId(stack));
            }
        }
        this.connectedSatellites = list;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.initialCheck && !this.field_145850_b.field_72995_K) {
            this.completeStructure = this.attemptCompleteStructure();
            this.onInventoryUpdated();
            this.initialCheck = true;
        }
        if (!this.isComplete()) {
            return;
        }
        if (!this.field_145850_b.field_72995_K && this.getPowerMadeLastTick() > 0 && this.field_145850_b.func_82737_E() % 100L == 0L) {
            Vector3F offset = this.getControllerOffset(this.getStructure());
            List entityList = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)(this.field_145851_c - (Integer)offset.x), (double)this.field_145848_d, (double)(this.field_145849_e - (Integer)offset.z), (double)(this.field_145851_c - (Integer)offset.x + this.getStructure()[0][0].length), (double)256.0, (double)(this.field_145849_e - (Integer)offset.z + this.getStructure()[0].length)));
            for (Entity e : entityList) {
                e.func_70015_d(5);
            }
            for (int x = 0; x < this.getStructure()[0][0].length; ++x) {
                for (int z = 0; z < this.getStructure()[0].length; ++z) {
                    int y = this.field_145850_b.func_72976_f(this.field_145851_c + x - (Integer)offset.x, this.field_145849_e + z - (Integer)offset.z);
                    Block block = this.field_145850_b.func_147439_a(this.field_145851_c + x - (Integer)offset.x, y - 1, this.field_145849_e + z - (Integer)offset.z);
                    if (y <= this.field_145848_d + 1 || block.isAir((IBlockAccess)this.field_145850_b, this.field_145851_c + x - (Integer)offset.x, y, this.field_145849_e + z - (Integer)offset.z)) continue;
                    this.field_145850_b.func_147468_f(this.field_145851_c + x - (Integer)offset.x, y - 1, this.field_145849_e + z - (Integer)offset.z);
                    this.field_145850_b.func_72908_a((double)(this.field_145851_c + x - (Integer)offset.x), (double)(y - 1), (double)(this.field_145849_e + z - (Integer)offset.z), "fire.fire", 1.0f, 3.0f);
                }
            }
        }
        if (!this.field_145850_b.field_72995_K && (DimensionManager.getInstance().isDimensionCreated(this.field_145850_b.field_73011_w.field_76574_g) || this.field_145850_b.field_73011_w.field_76574_g == 0)) {
            DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(this.field_145850_b.field_73011_w.field_76574_g);
            int energyRecieved = 0;
            if (this.enabled) {
                for (long lng : this.connectedSatellites) {
                    SatelliteBase satellite = properties.getSatellite(lng);
                    if (!(satellite instanceof IUniversalEnergyTransmitter)) continue;
                    energyRecieved += ((IUniversalEnergyTransmitter)satellite).transmitEnergy(ForgeDirection.UNKNOWN, false);
                }
            }
            this.powerMadeLastTick = (int)((float)energyRecieved * Configuration.microwaveRecieverMulitplier);
            if (this.powerMadeLastTick != this.prevPowerMadeLastTick) {
                this.prevPowerMadeLastTick = this.powerMadeLastTick;
                PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 1), (int)this.field_145850_b.field_73011_w.field_76574_g, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (double)128.0);
            }
            this.producePower(this.powerMadeLastTick);
        }
        if (this.field_145850_b.field_72995_K) {
            this.textModule.setText("Generating " + this.powerMadeLastTick + " RF/t");
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74757_a("canRender", this.canRender);
        nbt.func_74768_a("amtPwr", this.powerMadeLastTick);
        this.writeNetworkData(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.canRender = nbt.func_74767_n("canRender");
        this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        this.readNetworkData(nbt);
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        super.writeDataToNetwork(out, id);
        if (id == 1) {
            out.writeInt(this.powerMadeLastTick);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        super.readDataFromNetwork(in, packetId, nbt);
        if (packetId == 1) {
            nbt.func_74768_a("amtPwr", in.readInt());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        super.useNetworkData(player, side, id, nbt);
        if (id == 1) {
            this.powerMadeLastTick = nbt.func_74762_e("amtPwr");
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        int[] intArray = new int[this.connectedSatellites.size() * 2];
        for (int i = 0; i < this.connectedSatellites.size() * 2; i += 2) {
            this.connectedSatellites.get(i / 2);
            intArray[i] = (int)(this.connectedSatellites.get(i / 2) & 0xFFFFFFFFFFFFFFFFL);
            intArray[i + 1] = (int)(this.connectedSatellites.get(i / 2) >>> 32 & 0xFFFFFFFFFFFFFFFFL);
        }
        nbt.func_74783_a("satilliteList", intArray);
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        int[] intArray = nbt.func_74759_k("satilliteList");
        this.connectedSatellites.clear();
        for (int i = 0; i < intArray.length / 2; i += 2) {
            this.connectedSatellites.add((long)intArray[i] | (long)intArray[i + 1] << 32);
        }
    }
}

