/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.multiblock;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.integration.CompatibilityMgr;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.satellite.SatelliteLaser;
import zmaster587.advancedRocketry.satellite.SatelliteLaserNoDrill;
import zmaster587.advancedRocketry.world.provider.WorldProviderSpace;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.api.LibVulpesBlocks;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.compat.InventoryCompat;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModuleNumericTextbox;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleTextBox;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.TileMultiPowerConsumer;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.MultiInventory;

public class TileSpaceLaser
extends TileMultiPowerConsumer
implements ISidedInventory,
INetworkMachine,
IModularInventory,
IGuiCallback,
IButtonInventory {
    private static final int INVSIZE = 9;
    ItemStack glassPanel = null;
    SatelliteLaserNoDrill laserSat;
    protected boolean isRunning = false;
    protected boolean finished = false;
    protected IInventory adjInv;
    private int radius = 0;
    private int xCenter = 0;
    private int yCenter = 0;
    private int numSteps = 0;
    private ForgeDirection prevDir;
    public int laserX = 0;
    public int laserZ = 0;
    public int tickSinceLastOperation = 0;
    private static final ForgeDirection[] VALID_INVENTORY_DIRECTIONS = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    private static final int POWER_PER_OPERATION = (int)(10000.0f * Configuration.spaceLaserPowerMult);
    private ModuleTextBox locationX;
    private ModuleTextBox locationZ;
    private ModuleText updateText;
    MultiInventory inv;
    Object[][][] structure = new Object[][][]{{{null, null, null, null, null}, {null, null, LibVulpesBlocks.blockAdvStructureBlock, null, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, null, LibVulpesBlocks.blockAdvStructureBlock, null, null}, {null, null, null, null, null}}, {{null, null, Character.valueOf('c'), null, null}, {null, Character.valueOf('P'), Blocks.field_150359_w, Character.valueOf('P'), null}, {Character.valueOf('P'), LibVulpesBlocks.blockAdvStructureBlock, Blocks.field_150359_w, LibVulpesBlocks.blockAdvStructureBlock, Character.valueOf('P')}, {null, Character.valueOf('P'), LibVulpesBlocks.blockAdvStructureBlock, Character.valueOf('P'), null}, {null, null, Character.valueOf('P'), null, null}}, {{null, null, LibVulpesBlocks.blockAdvStructureBlock, null, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, null}, {LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, Blocks.field_150359_w, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock}, {null, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, null, LibVulpesBlocks.blockAdvStructureBlock, null, null}}, {{null, null, Character.valueOf('O'), null, null}, {null, LibVulpesBlocks.blockAdvStructureBlock, Blocks.field_150359_w, LibVulpesBlocks.blockAdvStructureBlock, null}, {Character.valueOf('O'), Blocks.field_150359_w, Blocks.field_150359_w, Blocks.field_150359_w, Character.valueOf('O')}, {null, LibVulpesBlocks.blockAdvStructureBlock, Blocks.field_150359_w, LibVulpesBlocks.blockAdvStructureBlock, null}, {null, null, Character.valueOf('O'), null, null}}};
    private MODE mode;
    ForgeChunkManager.Ticket ticket;

    public TileSpaceLaser() {
        this.prevDir = ForgeDirection.UNKNOWN;
        this.inv = new MultiInventory((List)this.itemOutPorts);
        this.laserSat = Configuration.laserDrillPlanet ? new SatelliteLaser((IInventory)this.inv) : new SatelliteLaserNoDrill((IInventory)this.inv);
        this.mode = MODE.SINGLE;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 5), (double)(this.field_145848_d - 100), (double)(this.field_145849_e - 5), (double)(this.field_145851_c + 5), (double)(this.field_145848_d + 5), (double)(this.field_145849_e + 5));
    }

    public Object[][][] getStructure() {
        return this.structure;
    }

    public String getMachineName() {
        return this.func_145825_b();
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        super.writeDataToNetwork(out, id);
        if (id == 10) {
            out.writeInt(this.laserX);
        } else if (id == 11) {
            out.writeInt(this.laserZ);
        } else if (id == 12) {
            out.writeBoolean(this.isRunning);
        } else if (id == 13) {
            out.writeInt(this.mode.ordinal());
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte id, NBTTagCompound nbt) {
        super.readDataFromNetwork(in, id, nbt);
        if (id == 10) {
            nbt.func_74768_a("laserX", in.readInt());
        } else if (id == 11) {
            nbt.func_74768_a("laserZ", in.readInt());
        } else if (id == 12) {
            nbt.func_74757_a("isRunning", in.readBoolean());
        } else if (id == 13) {
            nbt.func_74768_a("mode", in.readInt());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        super.useNetworkData(player, side, id, nbt);
        if (id == 10) {
            this.laserX = nbt.func_74762_e("laserX");
            this.finished = false;
            if (this.mode == MODE.SPIRAL) {
                this.resetSpiral();
            }
        } else if (id == 11) {
            this.laserZ = nbt.func_74762_e("laserZ");
            this.finished = false;
            if (this.mode == MODE.SPIRAL) {
                this.resetSpiral();
            }
        } else if (id == 12) {
            this.isRunning = nbt.func_74767_n("isRunning");
        } else if (id == 13 && !this.isRunning()) {
            this.mode = MODE.values()[nbt.func_74762_e("mode")];
        } else if (id == 14) {
            this.attempUnjam();
        }
        this.func_70296_d();
    }

    private void resetSpiral() {
        this.radius = 0;
        this.prevDir = ForgeDirection.UNKNOWN;
        this.xCenter = 0;
        this.yCenter = 0;
        this.numSteps = 0;
    }

    public boolean isRunning() {
        return this.isRunning && this.isComplete();
    }

    public boolean isFinished() {
        return this.finished;
    }

    public MODE getMode() {
        return this.mode;
    }

    public void incrementMode() {
        if (this.mode == MODE.SPIRAL) {
            this.resetSpiral();
        }
        int num = this.mode.ordinal();
        if (++num >= MODE.values().length) {
            num = 0;
        }
        this.mode = MODE.values()[num];
    }

    public void decrementMode() {
        if (this.mode == MODE.SPIRAL) {
            this.resetSpiral();
        }
        int num = this.mode.ordinal();
        if (--num < 0) {
            num = MODE.values().length - 1;
        }
        this.mode = MODE.values()[num];
    }

    public void setMode(MODE m) {
        this.mode = m;
    }

    public boolean canUpdate() {
        return true;
    }

    public void setFinished(boolean value) {
        this.finished = value;
    }

    private void setRunning(boolean value) {
        this.isRunning = value;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (this.timeAlive == 0 && !this.field_145850_b.field_72995_K) {
            if (this.isComplete()) {
                this.canRender = this.completeStructure = this.completeStructure();
            }
            this.timeAlive = 1;
            this.checkCanRun();
        }
        if (!this.field_145850_b.field_72995_K) {
            ++this.tickSinceLastOperation;
            if (!this.isAllowedToRun()) {
                this.laserSat.deactivateLaser();
                this.setFinished(true);
                this.setRunning(false);
            } else if (this.hasPowerForOperation() && this.isReadyForOperation() && this.laserSat.isAlive() && !this.laserSat.getJammed()) {
                this.laserSat.performOperation();
                this.batteries.extractEnergy(POWER_PER_OPERATION, false);
                this.tickSinceLastOperation = 0;
            }
        }
        if (this.laserSat.isFinished()) {
            this.setRunning(false);
            this.laserSat.deactivateLaser();
            if (!this.laserSat.getJammed()) {
                if (this.mode == MODE.SINGLE) {
                    this.finished = true;
                }
                if (this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) != 0) {
                    if (this.mode == MODE.LINE_X) {
                        this.laserX += 3;
                    } else if (this.mode == MODE.LINE_Z) {
                        this.laserZ += 3;
                    } else if (this.mode == MODE.SPIRAL) {
                        ++this.numSteps;
                        if (this.radius < this.numSteps) {
                            this.numSteps = 0;
                            if (this.prevDir == ForgeDirection.NORTH) {
                                this.prevDir = ForgeDirection.EAST;
                            } else if (this.prevDir == ForgeDirection.EAST) {
                                this.prevDir = ForgeDirection.SOUTH;
                                ++this.radius;
                            } else if (this.prevDir == ForgeDirection.SOUTH) {
                                this.prevDir = ForgeDirection.WEST;
                            } else {
                                this.prevDir = ForgeDirection.NORTH;
                                ++this.radius;
                            }
                        }
                        this.laserX += 3 * this.prevDir.offsetX;
                        this.laserZ += 3 * this.prevDir.offsetZ;
                    }
                }
                this.checkCanRun();
            }
        }
    }

    public boolean isReadyForOperation() {
        if (this.batteries.getEnergyStored() == 0) {
            return false;
        }
        return (float)this.tickSinceLastOperation > (float)(3 * this.batteries.getMaxEnergyStored()) / (float)this.batteries.getEnergyStored();
    }

    public void onDestroy() {
        if (this.laserSat != null) {
            this.laserSat.deactivateLaser();
        }
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticket);
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        if (this.laserSat != null) {
            this.laserSat.deactivateLaser();
        }
        this.isRunning = false;
    }

    protected void writeNetworkData(NBTTagCompound nbt) {
        super.writeNetworkData(nbt);
        nbt.func_74757_a("IsRunning", this.isRunning);
    }

    protected void readNetworkData(NBTTagCompound nbt) {
        super.readNetworkData(nbt);
        this.isRunning = nbt.func_74767_n("IsRunning");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagCompound laser = new NBTTagCompound();
        this.laserSat.writeToNBT(laser);
        nbt.func_74782_a("laser", (NBTBase)laser);
        NBTTagList list = new NBTTagList();
        if (this.glassPanel != null) {
            NBTTagCompound tag = new NBTTagCompound();
            this.glassPanel.func_77955_b(tag);
            nbt.func_74782_a("GlassPane", (NBTBase)tag);
        }
        nbt.func_74768_a("laserX", this.laserX);
        nbt.func_74768_a("laserZ", this.laserZ);
        nbt.func_74774_a("mode", (byte)this.mode.ordinal());
        if (this.mode == MODE.SPIRAL && this.prevDir != null) {
            nbt.func_74768_a("CenterX", this.xCenter);
            nbt.func_74768_a("CenterY", this.yCenter);
            nbt.func_74768_a("radius", this.radius);
            nbt.func_74768_a("numSteps", this.numSteps);
            nbt.func_74768_a("prevDir", this.prevDir.ordinal());
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.laserSat.readFromNBT(nbt.func_74775_l("laser"));
        if (nbt.func_74764_b("GlassPane")) {
            NBTTagCompound tag = nbt.func_74775_l("GlassPane");
            this.glassPanel = ItemStack.func_77949_a((NBTTagCompound)tag);
        }
        this.laserX = nbt.func_74762_e("laserX");
        this.laserZ = nbt.func_74762_e("laserZ");
        this.mode = MODE.values()[nbt.func_74771_c("mode")];
        if (this.mode == MODE.SPIRAL && nbt.func_74764_b("prevDir")) {
            this.xCenter = nbt.func_74762_e("CenterX");
            this.yCenter = nbt.func_74762_e("CenterY");
            this.radius = nbt.func_74762_e("radius");
            this.numSteps = nbt.func_74762_e("numSteps");
            this.prevDir = ForgeDirection.values()[nbt.func_74762_e("prevDir")];
        }
    }

    public void onLaserFinish() {
    }

    public void attempUnjam() {
        if (!this.laserSat.getJammed()) {
            return;
        }
        this.laserSat.setJammed(false);
        this.finished = false;
        this.checkCanRun();
    }

    private Object getAvalibleInv() {
        ForgeDirection front = RotatableBlock.getFront((int)this.func_145832_p());
        for (ForgeDirection f : VALID_INVENTORY_DIRECTIONS) {
            TileEntity e;
            if (f == front || !InventoryCompat.canInjectItems((TileEntity)(e = this.field_145850_b.func_147438_o(this.field_145851_c + f.offsetX, this.field_145848_d + f.offsetY, this.field_145849_e + f.offsetZ)))) continue;
            return (IInventory)e;
        }
        return null;
    }

    private Object getAvalibleInv(ItemStack item) {
        if (item == null) {
            return this.getAvalibleInv();
        }
        ForgeDirection front = RotatableBlock.getFront((int)this.func_145832_p());
        for (ForgeDirection f : VALID_INVENTORY_DIRECTIONS) {
            TileEntity e;
            if (f == front || !InventoryCompat.canInjectItems((TileEntity)(e = this.field_145850_b.func_147438_o(this.field_145851_c + f.offsetX, this.field_145848_d + f.offsetY, this.field_145849_e + f.offsetZ)), (ItemStack)item)) continue;
            return e;
        }
        return null;
    }

    private boolean canMachineSeeEarth() {
        return true;
    }

    private boolean isAllowedToRun() {
        return this.glassPanel != null && this.batteries.getEnergyStored() != 0 && this.field_145850_b.field_73011_w instanceof WorldProviderSpace && DimensionManager.getInstance().canTravelTo(((WorldProviderSpace)this.field_145850_b.field_73011_w).getDimensionProperties(this.field_145851_c, this.field_145849_e).getParentPlanet()) && !Configuration.laserBlackListDims.contains(((WorldProviderSpace)this.field_145850_b.field_73011_w).getDimensionProperties(this.field_145851_c, this.field_145849_e).getParentPlanet());
    }

    public void checkCanRun() {
        if (!this.isAllowedToRun() || !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            if (this.laserSat.isAlive()) {
                this.laserSat.deactivateLaser();
            }
            this.setRunning(false);
        } else if (!this.laserSat.isAlive() && !this.finished && !this.laserSat.getJammed() && this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.canMachineSeeEarth()) {
            int orbitDimId = ((WorldProviderSpace)this.field_145850_b.field_73011_w).getDimensionProperties(this.field_145851_c, this.field_145849_e).getParentPlanet();
            if (orbitDimId == Integer.MIN_VALUE) {
                return;
            }
            WorldServer orbitWorld = net.minecraftforge.common.DimensionManager.getWorld((int)orbitDimId);
            if (orbitWorld == null) {
                net.minecraftforge.common.DimensionManager.initDimension((int)orbitDimId);
                orbitWorld = net.minecraftforge.common.DimensionManager.getWorld((int)orbitDimId);
                if (orbitWorld == null) {
                    return;
                }
            }
            if (this.ticket == null) {
                this.ticket = ForgeChunkManager.requestTicket((Object)AdvancedRocketry.instance, (World)this.field_145850_b, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
                if (this.ticket != null) {
                    ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(this.field_145851_c / 16 - (this.field_145851_c < 0 ? 1 : 0), this.field_145849_e / 16 - (this.field_145849_e < 0 ? 1 : 0)));
                }
            }
            this.setRunning(this.laserSat.activateLaser((World)orbitWorld, this.laserX, this.laserZ));
        }
        if (!this.field_145850_b.field_72995_K) {
            PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 12), (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (int)128, (double)this.field_145850_b.field_73011_w.field_76574_g);
        }
    }

    public int getEnergyPercentScaled(int max) {
        return (int)((float)max * ((float)this.batteries.getEnergyStored() / (float)this.batteries.getMaxEnergyStored()));
    }

    public boolean hasEnergy() {
        return this.batteries.getEnergyStored() != 0;
    }

    public int func_70302_i_() {
        return this.inv.func_70302_i_();
    }

    public ItemStack func_70301_a(int i) {
        if (i == 0) {
            return this.glassPanel;
        }
        return this.inv.func_70301_a(--i);
    }

    public ItemStack func_70298_a(int i, int j) {
        if (i == 0) {
            ItemStack ret = this.glassPanel.func_77946_l();
            this.glassPanel = null;
            return ret;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        if (i == 0) {
            return this.glassPanel;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemstack) {
        if (i == 0) {
            this.glassPanel = itemstack;
        } else {
            if (InventoryCompat.canInjectItems((IInventory)this.inv, (ItemStack)itemstack)) {
                InventoryCompat.injectItem((IInventory)this.inv, (ItemStack)itemstack);
            }
            this.checkCanRun();
        }
    }

    public String func_145825_b() {
        return LibVulpes.proxy.getLocalizedString("tile.spaceLaser.name");
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer entityplayer) {
        return entityplayer.func_70092_e((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public int[] func_94128_d(int var1) {
        return new int[0];
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return false;
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return false;
    }

    public boolean func_94041_b(int i, ItemStack itemstack) {
        if (i == 0) {
            return CompatibilityMgr.gregtechLoaded ? OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)itemstack)).equals("lenseRuby") : AdvancedRocketryItems.itemLens == itemstack.func_77973_b();
        }
        return this.inv.func_94041_b(i, itemstack);
    }

    public boolean hasPowerForOperation() {
        return POWER_PER_OPERATION <= this.batteries.getEnergyStored();
    }

    public boolean isJammed() {
        return this.laserSat.getJammed();
    }

    public void setJammed(boolean b) {
        this.laserSat.setJammed(b);
    }

    public boolean func_145818_k_() {
        return false;
    }

    public void onModuleUpdated(ModuleBase module) {
        if (module == this.locationX) {
            if (!((ModuleTextBox)module).getText().isEmpty() && !((ModuleTextBox)module).getText().contentEquals("-")) {
                this.laserX = Integer.parseInt(((ModuleTextBox)module).getText());
            }
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 10));
        } else if (module == this.locationZ) {
            if (!((ModuleTextBox)module).getText().isEmpty() && !((ModuleTextBox)module).getText().contentEquals("-")) {
                this.laserZ = Integer.parseInt(((ModuleTextBox)module).getText());
            }
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 11));
        }
    }

    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        if (this.field_145850_b.field_72995_K) {
            this.locationX = new ModuleNumericTextbox((IGuiCallback)this, 113, 31, 50, 10, 16);
            modules.add((ModuleBase)this.locationX);
            this.locationZ = new ModuleNumericTextbox((IGuiCallback)this, 113, 41, 50, 10, 16);
            modules.add((ModuleBase)this.locationZ);
            this.locationX.setText(String.valueOf(this.laserX));
            this.locationZ.setText(String.valueOf(this.laserZ));
            this.updateText = new ModuleText(130, 20, this.getMode().toString(), 723723, true);
            modules.add((ModuleBase)this.updateText);
            modules.add((ModuleBase)new ModuleText(103, 33, "X:", 723723));
            modules.add((ModuleBase)new ModuleText(103, 43, "Z:", 723723));
            modules.add((ModuleBase)new ModuleImage(8, 16, TextureResources.laserGuiBG));
        }
        modules.add((ModuleBase)new ModuleButton(103, 20, 0, "", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonLeft, 5, 8));
        modules.add((ModuleBase)new ModuleButton(157, 20, 1, "", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonRight, 5, 8));
        modules.add((ModuleBase)new ModuleButton(103, 62, 2, "Reset", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild, 34, 20));
        modules.add((ModuleBase)new ModulePower(11, 25, (IUniversalEnergy)this.getBatteries()));
        modules.add((ModuleBase)new ModuleSlotArray(56, 54, (IInventory)this, 0, 1));
        return modules;
    }

    public String getModularInventoryName() {
        return "tile.spaceLaser.name";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public void onInventoryButtonPressed(int buttonId) {
        if (buttonId == 0) {
            this.decrementMode();
            this.updateText.setText(this.getMode().toString());
        } else if (buttonId == 1) {
            this.incrementMode();
            this.updateText.setText(this.getMode().toString());
        } else {
            if (buttonId == 2) {
                PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 14));
                return;
            }
            return;
        }
        if (!this.isRunning()) {
            PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 13));
        }
    }

    public static enum MODE {
        SINGLE,
        LINE_X,
        LINE_Z,
        SPIRAL;

    }
}

