/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.infrastructure;

import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IMission;
import zmaster587.advancedRocketry.block.multiblock.BlockARHatch;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.tile.TileGuidanceComputer;
import zmaster587.advancedRocketry.tile.TileRocketBuilder;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IGuiCallback;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleBlockSideSelector;
import zmaster587.libVulpes.inventory.modules.ModuleRedstoneOutputButton;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.multiblock.hatch.TileInventoryHatch;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileRocketLoader
extends TileInventoryHatch
implements IInfrastructure,
IButtonInventory,
INetworkMachine,
IGuiCallback {
    EntityRocket rocket;
    ModuleRedstoneOutputButton redstoneControl = new ModuleRedstoneOutputButton(174, 4, 0, "", (IButtonInventory)this, "Loading State: ");
    ZUtils.RedstoneState state = ZUtils.RedstoneState.ON;
    ModuleRedstoneOutputButton inputRedstoneControl = new ModuleRedstoneOutputButton(174, 32, 1, "", (IButtonInventory)this, "Allow Loading: ");
    ZUtils.RedstoneState inputstate = ZUtils.RedstoneState.OFF;
    ModuleBlockSideSelector sideSelectorModule;
    private static int ALLOW_REDSTONEOUT = 2;

    public TileRocketLoader() {
        this.inputRedstoneControl.setRedstoneState(this.inputstate);
        this.sideSelectorModule = new ModuleBlockSideSelector(90, 15, (IGuiCallback)this, new String[]{"None", "Allow redstone output", "Allow redstone input"});
    }

    public TileRocketLoader(int size) {
        super(size);
        this.inputRedstoneControl.setRedstoneState(this.inputstate);
        this.sideSelectorModule = new ModuleBlockSideSelector(90, 15, (IGuiCallback)this, new String[]{"None", "Allow redstone output", "Allow redstone input"});
    }

    public boolean allowRedstoneOutputOnSide(ForgeDirection facing) {
        return this.sideSelectorModule.getStateForSide(facing.getOpposite()) == 1;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.getMasterBlock() instanceof TileRocketBuilder) {
            ((TileRocketBuilder)this.getMasterBlock()).removeConnectedInfrastructure((TileEntity)this);
        }
    }

    public String getModularInventoryName() {
        return "tile.loader.3.name";
    }

    protected void setRedstoneState(boolean condition) {
        condition = this.isStateActive(this.state, condition);
        ((BlockARHatch)AdvancedRocketryBlocks.blockLoader).setRedstoneState(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, condition);
    }

    protected boolean isStateActive(ZUtils.RedstoneState state, boolean condition) {
        if (state == ZUtils.RedstoneState.INVERTED) {
            return !condition;
        }
        if (state == ZUtils.RedstoneState.OFF) {
            return false;
        }
        return condition;
    }

    protected boolean getStrongPowerForSides(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)i);
            if (this.sideSelectorModule.getStateForSide(i) != ALLOW_REDSTONEOUT || world.func_72878_l(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, i) <= 0) continue;
            return true;
        }
        return false;
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        List list = super.getModules(ID, player);
        list.add(this.redstoneControl);
        list.add(this.inputRedstoneControl);
        list.add(this.sideSelectorModule);
        return list;
    }

    public void func_145845_h() {
        super.func_145845_h();
        if (!this.field_145850_b.field_72995_K && this.rocket != null) {
            boolean isAllowedToOperate = this.inputstate == ZUtils.RedstoneState.OFF || this.isStateActive(this.inputstate, this.getStrongPowerForSides(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
            List<TileEntity> tiles = this.rocket.storage.getInventoryTiles();
            boolean foundStack = false;
            boolean rocketContainsItems = false;
            block0: for (TileEntity tile : tiles) {
                if (!(tile instanceof IInventory) || tile instanceof TileGuidanceComputer) continue;
                IInventory inv = (IInventory)tile;
                for (int i = 0; i < inv.func_70302_i_(); ++i) {
                    if (inv.func_70301_a(i) == null) {
                        rocketContainsItems = true;
                    }
                    for (int j = 0; j < this.func_70302_i_(); ++j) {
                        if (inv.func_70301_a(i) == null && this.inventory.func_70301_a(j) != null) {
                            if (isAllowedToOperate) {
                                inv.func_70299_a(i, this.inventory.func_70301_a(j));
                                this.inventory.func_70299_a(j, null);
                            }
                            rocketContainsItems = true;
                            break block0;
                        }
                        if (this.func_70301_a(j) == null || inv.func_70301_a(i) == null || !inv.func_94041_b(i, this.func_70301_a(j)) || inv.func_70301_a(i).func_77973_b() != this.func_70301_a(j).func_77973_b() || inv.func_70301_a(i).func_77976_d() == inv.func_70301_a((int)i).field_77994_a) continue;
                        if (isAllowedToOperate) {
                            ItemStack stack2 = this.inventory.func_70298_a(j, inv.func_70301_a(i).func_77976_d() - inv.func_70301_a((int)i).field_77994_a);
                            inv.func_70301_a((int)i).field_77994_a += stack2.field_77994_a;
                        }
                        rocketContainsItems = true;
                        if (this.inventory.func_70301_a(j) == null) break block0;
                        foundStack = true;
                    }
                    if (foundStack) break block0;
                }
            }
            this.setRedstoneState(!rocketContainsItems);
        }
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("state", (byte)this.state.ordinal());
        nbt.func_74774_a("inputRedstoneState", (byte)this.inputstate.ordinal());
        this.sideSelectorModule.writeToNBT(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("state")];
        this.redstoneControl.setRedstoneState(this.state);
        this.inputstate = ZUtils.RedstoneState.values()[nbt.func_74771_c("inputRedstoneState")];
        this.inputRedstoneControl.setRedstoneState(this.inputstate);
        this.sideSelectorModule.readFromNBT(nbt);
        super.onDataPacket(net, pkt);
    }

    public boolean onLinkStart(ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        if (this.rocket != null) {
            this.rocket.unlinkInfrastructure(this);
            this.unlinkRocket();
        }
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText("You program the linker with the rocket loader at: " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e));
        }
        return true;
    }

    public boolean onLinkComplete(ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText("This must be the first machine to link!"));
        }
        return false;
    }

    @Override
    public void unlinkRocket() {
        this.rocket = null;
        ((BlockARHatch)AdvancedRocketryBlocks.blockLoader).setRedstoneState(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
    }

    @Override
    public boolean disconnectOnLiftOff() {
        return true;
    }

    @Override
    public boolean linkRocket(EntityRocketBase rocket) {
        this.rocket = (EntityRocket)rocket;
        return true;
    }

    public boolean canUpdate() {
        return true;
    }

    @Override
    public boolean linkMission(IMission misson) {
        return false;
    }

    @Override
    public void unlinkMission() {
    }

    @Override
    public int getMaxLinkDistance() {
        return 32;
    }

    @Override
    public boolean canRenderConnection() {
        return true;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        this.redstoneControl.setRedstoneState(this.state);
        this.inputstate = ZUtils.RedstoneState.values()[nbt.func_74771_c("inputRedstoneState")];
        this.inputRedstoneControl.setRedstoneState(this.inputstate);
        this.sideSelectorModule.readFromNBT(nbt);
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("redstoneState", (byte)this.state.ordinal());
        nbt.func_74774_a("inputRedstoneState", (byte)this.inputstate.ordinal());
        this.sideSelectorModule.writeToNBT(nbt);
    }

    public void onInventoryButtonPressed(int buttonId) {
        if (buttonId == 0) {
            this.state = this.redstoneControl.getState();
        }
        if (buttonId == 1) {
            this.inputstate = this.inputRedstoneControl.getState();
        }
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        out.writeByte(this.state.ordinal());
        out.writeByte(this.inputstate.ordinal());
        for (int i = 0; i < 6; ++i) {
            out.writeByte(this.sideSelectorModule.getStateForSide(i));
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        nbt.func_74774_a("state", in.readByte());
        nbt.func_74774_a("inputstate", in.readByte());
        byte[] bytes = new byte[6];
        for (int i = 0; i < 6; ++i) {
            bytes[i] = in.readByte();
        }
        nbt.func_74773_a("bytes", bytes);
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("state")];
        this.inputstate = ZUtils.RedstoneState.values()[nbt.func_74771_c("inputstate")];
        byte[] bytes = nbt.func_74770_j("bytes");
        for (int i = 0; i < 6; ++i) {
            this.sideSelectorModule.setStateForSide(i, (int)bytes[i]);
        }
        if (this.rocket == null) {
            this.setRedstoneState(this.state == ZUtils.RedstoneState.INVERTED);
        }
        this.func_70296_d();
        this.field_145850_b.func_147444_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e));
    }

    public void onModuleUpdated(ModuleBase module) {
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }
}

