/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.infrastructure;

import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidHandler;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.tile.infrastructure.TileRocketFluidLoader;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.ZUtils;

public class TileRocketFluidUnloader
extends TileRocketFluidLoader
implements IInfrastructure,
IButtonInventory,
INetworkMachine {
    public TileRocketFluidUnloader() {
    }

    public TileRocketFluidUnloader(int size) {
        super(size);
    }

    @Override
    public String getModularInventoryName() {
        return "tile.loader.4.name";
    }

    @Override
    public void func_145845_h() {
        super.func_145845_h();
        if (this.rocket != null) {
            boolean isAllowedToOperate = this.inputstate == ZUtils.RedstoneState.OFF || this.isStateActive(this.inputstate, this.getStrongPowerForSides(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e));
            List<TileEntity> tiles = this.rocket.storage.getFluidTiles();
            boolean rocketContainsItems = false;
            for (TileEntity tile : tiles) {
                IFluidHandler handler = (IFluidHandler)tile;
                if (handler.drain(ForgeDirection.DOWN, 1, false) != null) {
                    rocketContainsItems = true;
                }
                if (!isAllowedToOperate) continue;
                FluidStack stack = this.fluidTank.getFluid();
                if (stack == null) {
                    this.fill(ForgeDirection.UNKNOWN, handler.drain(ForgeDirection.DOWN, this.fluidTank.getCapacity(), true), true);
                    continue;
                }
                stack = stack.copy();
                stack.amount = this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount();
                if (stack.amount == 0) continue;
                this.fill(ForgeDirection.UNKNOWN, handler.drain(ForgeDirection.DOWN, stack, true), true);
            }
            this.setRedstoneState(!rocketContainsItems);
        }
    }
}

