/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.infrastructure;

import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.IFluidHandler;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IMission;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.block.BlockTileRedstoneEmitter;
import zmaster587.advancedRocketry.tile.TileRocketBuilder;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.gui.CommonResources;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModuleLiquidIndicator;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleRedstoneOutputButton;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.IMultiblock;
import zmaster587.libVulpes.tile.TileInventoriedRFConsumerTank;
import zmaster587.libVulpes.util.BlockPosition;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.IconResource;
import zmaster587.libVulpes.util.ZUtils;

public class TileEntityFuelingStation
extends TileInventoriedRFConsumerTank
implements IModularInventory,
IMultiblock,
IInfrastructure,
ILinkableTile,
IButtonInventory,
INetworkMachine {
    EntityRocketBase linkedRocket;
    BlockPosition masterBlock = new BlockPosition(0, -1, 0);
    ModuleRedstoneOutputButton redstoneControl = new ModuleRedstoneOutputButton(174, 4, 0, "", (IButtonInventory)this);
    ZUtils.RedstoneState state = ZUtils.RedstoneState.ON;

    public TileEntityFuelingStation() {
        super(1000, 3, 5000);
    }

    @Override
    public int getMaxLinkDistance() {
        return 10;
    }

    private void setRedstoneState(boolean condition) {
        if (this.state == ZUtils.RedstoneState.INVERTED) {
            condition = !condition;
        } else if (this.state == ZUtils.RedstoneState.OFF) {
            condition = false;
        }
        ((BlockTileRedstoneEmitter)AdvancedRocketryBlocks.blockFuelingStation).setRedstoneState(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, condition);
    }

    public void performFunction() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.tank.getFluid() != null) {
                float multiplier = FuelRegistry.instance.getMultiplier(FuelRegistry.FuelType.LIQUID, this.tank.getFluid().getFluid());
                this.tank.drain(this.linkedRocket.addFuelAmount((int)(multiplier * (float)Configuration.fuelPointsPer10Mb)), true);
            }
            this.setRedstoneState(this.linkedRocket.getFuelAmount() == this.linkedRocket.getFuelCapacity());
        }
        this.useBucket(0, this.inventory.func_70301_a(0));
    }

    public int getPowerPerOperation() {
        return 30;
    }

    public Packet func_145844_m() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("state", (byte)this.state.ordinal());
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.state = ZUtils.RedstoneState.values()[pkt.func_148857_g().func_74771_c("state")];
        this.redstoneControl.setRedstoneState(this.state);
        super.onDataPacket(net, pkt);
    }

    public void func_145845_h() {
        super.func_145845_h();
    }

    public boolean canPerformFunction() {
        return this.linkedRocket != null && this.tank.getFluid() != null && this.tank.getFluidAmount() > 9 && this.linkedRocket.getRocketStats().getFuelAmount(FuelRegistry.FuelType.LIQUID) < this.linkedRocket.getRocketStats().getFuelCapacity(FuelRegistry.FuelType.LIQUID);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID, fluid);
    }

    public String getModularInventoryName() {
        return "Fueling Station";
    }

    public boolean func_145818_k_() {
        return true;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        super.func_70299_a(slot, stack);
        while (this.useBucket(0, this.func_70301_a(0))) {
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean useBucket(int slot, ItemStack stack) {
        if (slot != 0 || !FluidContainerRegistry.isFilledContainer((ItemStack)stack) || !FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID, FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack).getFluid()) || this.tank.getFluidAmount() + FluidContainerRegistry.getContainerCapacity((ItemStack)stack) > this.tank.getCapacity()) return false;
        ItemStack emptyContainer = FluidContainerRegistry.drainFluidContainer((ItemStack)stack);
        if ((emptyContainer == null || this.inventory.func_70301_a(1) != null) && (!emptyContainer.func_77969_a(this.inventory.func_70301_a(1)) || this.inventory.func_70301_a((int)1).field_77994_a >= this.inventory.func_70301_a(1).func_77976_d())) return false;
        this.tank.fill(FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack), true);
        if (this.inventory.func_70301_a(1) == null) {
            super.func_70299_a(1, emptyContainer);
        } else {
            ++this.inventory.func_70301_a((int)1).field_77994_a;
        }
        this.func_70298_a(0, 1);
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
            return FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID, FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack).getFluid());
        }
        return FuelRegistry.instance.isFuel(FuelRegistry.FuelType.LIQUID, stack);
    }

    @Override
    public void unlinkRocket() {
        this.linkedRocket = null;
        ((BlockTileRedstoneEmitter)AdvancedRocketryBlocks.blockFuelingStation).setRedstoneState(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
    }

    @Override
    public boolean disconnectOnLiftOff() {
        return true;
    }

    @Override
    public boolean linkRocket(EntityRocketBase rocket) {
        this.linkedRocket = rocket;
        this.setRedstoneState(this.linkedRocket.getFuelAmount() == this.linkedRocket.getFuelCapacity());
        return true;
    }

    public boolean onLinkStart(ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        ItemLinker.setMasterCoords((ItemStack)item, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e);
        if (this.linkedRocket != null) {
            this.linkedRocket.unlinkInfrastructure(this);
            this.unlinkRocket();
        }
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText("You program the linker with the fueling station at: " + this.field_145851_c + " " + this.field_145848_d + " " + this.field_145849_e));
        }
        return true;
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.getMasterBlock() instanceof TileRocketBuilder) {
            ((TileRocketBuilder)this.getMasterBlock()).removeConnectedInfrastructure((TileEntity)this);
        }
        if (this.linkedRocket != null) {
            this.linkedRocket.unlinkInfrastructure(this);
        }
    }

    public boolean onLinkComplete(ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        if (player.field_70170_p.field_72995_K) {
            Minecraft.func_71410_x().field_71456_v.func_146158_b().func_146227_a((IChatComponent)new ChatComponentText("This must be the first machine to link!"));
        }
        return false;
    }

    public int[] func_94128_d(int side) {
        if (ForgeDirection.getOrientation((int)side) == ForgeDirection.DOWN) {
            return new int[]{1};
        }
        return new int[]{0};
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        ArrayList<ModuleBase> list = new ArrayList<ModuleBase>();
        list.add((ModuleBase)new ModulePower(156, 12, (IUniversalEnergy)this));
        list.add((ModuleBase)this.redstoneControl);
        list.add((ModuleBase)new ModuleSlotArray(45, 18, (IInventory)this, 0, 1));
        list.add((ModuleBase)new ModuleSlotArray(45, 54, (IInventory)this, 1, 2));
        if (this.field_145850_b.field_72995_K) {
            list.add((ModuleBase)new ModuleImage(44, 35, new IconResource(194, 0, 18, 18, CommonResources.genericBackground)));
        }
        list.add((ModuleBase)new ModuleLiquidIndicator(27, 18, (IFluidHandler)this));
        return list;
    }

    public String func_145825_b() {
        return null;
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    @Override
    public boolean linkMission(IMission misson) {
        return false;
    }

    @Override
    public void unlinkMission() {
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74774_a("redstoneState", (byte)this.state.ordinal());
        if (this.hasMaster()) {
            nbt.func_74783_a("masterPos", new int[]{this.masterBlock.x, this.masterBlock.y, this.masterBlock.z});
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("redstoneState")];
        this.redstoneControl.setRedstoneState(this.state);
        if (nbt.func_74764_b("masterPos")) {
            int[] pos = nbt.func_74759_k("masterPos");
            this.setMasterBlock(pos[0], pos[1], pos[2]);
        }
    }

    public boolean hasMaster() {
        return this.masterBlock.y > -1;
    }

    public TileEntity getMasterBlock() {
        return this.field_145850_b.func_147438_o(this.masterBlock.x, (int)this.masterBlock.y, this.masterBlock.z);
    }

    public void setComplete(int x, int y, int z) {
    }

    public void setIncomplete() {
        this.masterBlock.y = (short)-1;
    }

    public void setMasterBlock(int x, int y, int z) {
        this.masterBlock = new BlockPosition(x, y, z);
    }

    @Override
    public boolean canRenderConnection() {
        return true;
    }

    public void onInventoryButtonPressed(int buttonId) {
        this.state = this.redstoneControl.getState();
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        out.writeByte(this.state.ordinal());
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        nbt.func_74774_a("state", in.readByte());
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        this.state = ZUtils.RedstoneState.values()[nbt.func_74771_c("state")];
        if (this.linkedRocket != null) {
            this.setRedstoneState(this.linkedRocket.getFuelAmount() == this.linkedRocket.getFuelCapacity());
        }
    }
}

