/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile.cables;

import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.cable.HandlerCableNetwork;
import zmaster587.advancedRocketry.cable.NetworkRegistry;

public class TilePipe
extends TileEntity {
    int networkID;
    boolean initialized = false;
    boolean destroyed = false;
    boolean[] connectedSides = new boolean[6];

    public void initialize(int id) {
        this.networkID = id;
        this.initialized = true;
        this.getNetworkHandler().getNetwork(id).addPipeToNetwork(this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.removePipeFromSystem();
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        this.removePipeFromSystem();
    }

    public void removePipeFromSystem() {
        if (!this.isInitialized()) {
            return;
        }
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (tile == null) continue;
            this.getNetworkHandler().removeFromAllTypes(this, tile);
        }
        if (this.getNetworkHandler().getNetwork(this.networkID) != null) {
            this.getNetworkHandler().getNetwork(this.networkID).removePipeFromNetwork(this);
            this.getNetworkHandler().removeNetworkByID(this.networkID);
        }
    }

    public void markForUpdate() {
        if (!this.field_145850_b.field_72995_K) {
            this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e), 20);
        }
    }

    public void onPlaced() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (tile == null || !(tile instanceof TilePipe) || tile.getClass() != ((Object)((Object)this)).getClass()) continue;
            TilePipe pipe = (TilePipe)tile;
            if (this.destroyed) continue;
            if (this.isInitialized() && pipe.isInitialized() && pipe.getNetworkID() != this.networkID) {
                this.getNetworkHandler().mergeNetworks(this.networkID, pipe.getNetworkID());
                continue;
            }
            if (this.isInitialized() || !pipe.isInitialized()) continue;
            this.initialize(pipe.getNetworkID());
        }
        if (!this.isInitialized()) {
            this.initialize(this.getNetworkHandler().getNewNetworkID());
        }
        this.linkSystems();
    }

    public void linkSystems() {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d + dir.offsetY, this.field_145849_e + dir.offsetZ);
            if (tile == null) continue;
            this.attemptLink(dir, tile);
        }
    }

    protected void attemptLink(ForgeDirection dir, TileEntity tile) {
        if (this.canExtract(dir, tile) && (this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) > 0 || this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e))) {
            if (this.field_145850_b.field_72995_K) {
                this.connectedSides[dir.ordinal()] = true;
            } else {
                this.getNetworkHandler().removeFromAllTypes(this, tile);
                this.getNetworkHandler().addSource(this, tile, dir);
            }
        }
        if (this.canInject(dir, tile) && this.field_145850_b.func_94577_B(this.field_145851_c, this.field_145848_d, this.field_145849_e) == 0 && !this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            if (this.field_145850_b.field_72995_K) {
                this.connectedSides[dir.ordinal()] = true;
            } else {
                this.getNetworkHandler().removeFromAllTypes(this, tile);
                this.getNetworkHandler().addSink(this, tile, dir);
            }
        }
    }

    public int getNetworkID() {
        return this.networkID;
    }

    public boolean isInitialized() {
        return this.initialized && this.getNetworkHandler().doesNetworkExist(this.networkID);
    }

    public void onNeighborTileChange(int x, int y, int z) {
        TileEntity tile = this.field_145850_b.func_147438_o(x, y, z);
        if (!this.field_145850_b.field_72995_K && !this.getNetworkHandler().doesNetworkExist(this.networkID)) {
            this.initialized = false;
        }
        if (tile != null) {
            if (tile instanceof TilePipe && tile.getClass() == ((Object)((Object)this)).getClass()) {
                TilePipe pipe = (TilePipe)tile;
                if (this.field_145850_b.field_72995_K) {
                    ForgeDirection dir = ForgeDirection.UNKNOWN;
                    for (ForgeDirection dir2 : ForgeDirection.VALID_DIRECTIONS) {
                        if (dir2.offsetX != x - this.field_145851_c || dir2.offsetY != y - this.field_145848_d || dir2.offsetZ != z - this.field_145849_e) continue;
                        dir = dir2;
                    }
                    this.connectedSides[dir.ordinal()] = true;
                } else {
                    if (this.destroyed) {
                        return;
                    }
                    if (pipe.isInitialized()) {
                        if (!this.isInitialized()) {
                            this.initialize(pipe.getNetworkID());
                            this.linkSystems();
                            this.func_70296_d();
                        } else if (pipe.getNetworkID() != this.networkID) {
                            this.mergeNetworks(pipe.getNetworkID(), this.networkID);
                        }
                    } else if (pipe.destroyed) {
                        this.getNetworkHandler().removeNetworkByID(pipe.networkID);
                        this.onPlaced();
                        this.func_70296_d();
                    } else if (this.isInitialized()) {
                        pipe.initialize(this.networkID);
                    } else {
                        this.onPlaced();
                        this.func_70296_d();
                    }
                }
            } else {
                if (!this.field_145850_b.field_72995_K && !this.isInitialized()) {
                    this.networkID = this.getNetworkHandler().getNewNetworkID();
                    this.initialized = true;
                }
                ForgeDirection dir = ForgeDirection.UNKNOWN;
                for (ForgeDirection dir2 : ForgeDirection.VALID_DIRECTIONS) {
                    if (dir2.offsetX != x - this.field_145851_c || dir2.offsetY != y - this.field_145848_d || dir2.offsetZ != z - this.field_145849_e) continue;
                    dir = dir2;
                }
                this.attemptLink(dir, tile);
            }
        } else if (this.field_145850_b.field_72995_K) {
            ForgeDirection dir = ForgeDirection.UNKNOWN;
            for (ForgeDirection dir2 : ForgeDirection.VALID_DIRECTIONS) {
                if (dir2.offsetX != x - this.field_145851_c || dir2.offsetY != y - this.field_145848_d || dir2.offsetZ != z - this.field_145849_e) continue;
                dir = dir2;
            }
            this.connectedSides[dir.ordinal()] = false;
        }
    }

    public HandlerCableNetwork getNetworkHandler() {
        return NetworkRegistry.liquidNetwork;
    }

    public boolean canConnect(int side) {
        return this.connectedSides[side];
    }

    public boolean canExtract(ForgeDirection dir, TileEntity e) {
        return false;
    }

    public boolean canInject(ForgeDirection dir, TileEntity e) {
        return false;
    }

    public void mergeNetworks(int a, int b) {
        this.networkID = this.getNetworkHandler().mergeNetworks(a, b);
        this.func_70296_d();
    }

    public String toString() {
        return "ID: " + this.networkID + "   " + this.getNetworkHandler().toString(this.networkID);
    }

    public void setDestroyed() {
        this.destroyed = true;
    }

    public void setInvalid() {
        this.initialized = false;
    }
}

