/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.IFuelTank;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IIntake;
import zmaster587.advancedRocketry.api.IMiningDrill;
import zmaster587.advancedRocketry.api.IRocketEngine;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.block.BlockRocketMotor;
import zmaster587.advancedRocketry.block.BlockSeat;
import zmaster587.advancedRocketry.entity.EntityStationDeployedRocket;
import zmaster587.advancedRocketry.tile.TileGuidanceComputer;
import zmaster587.advancedRocketry.tile.TileRocketBuilder;
import zmaster587.advancedRocketry.tile.hatch.TileSatelliteHatch;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.tile.TileModelRenderRotatable;
import zmaster587.libVulpes.util.ZUtils;

public class TileStationDeployedAssembler
extends TileRocketBuilder {
    private static final int MAX_SIZE = 17;
    private static final int MAX_SIZE_Y = 17;
    private static final int MIN_SIZE = 3;
    private static final int MIN_SIZE_Y = 3;

    @Override
    public AxisAlignedBB getRocketPadBounds(World world, int x, int y, int z) {
        int zSize;
        int xSize;
        int zMin;
        int xMin;
        ForgeDirection direction = RotatableBlock.getFront((int)world.func_72805_g(x, y, z)).getOpposite();
        int yCurrent = y;
        int xCurrent = x;
        int zCurrent = z;
        int xMax = xMin = xCurrent;
        int zMax = zMin = zCurrent;
        int yMax = ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)ForgeDirection.UP, (int)this.field_145851_c, (int)(this.field_145848_d + 1), (int)this.field_145849_e, (int)17, (Block)AdvancedRocketryBlocks.blockStructureTower);
        if (direction.offsetX != 0) {
            xSize = ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)direction, (int)xCurrent, (int)(yCurrent + yMax), (int)zCurrent, (int)17, (Block)AdvancedRocketryBlocks.blockStructureTower);
            zMin = ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)ForgeDirection.NORTH, (int)xCurrent, (int)yCurrent, (int)(zCurrent - 1), (int)17, (Block)AdvancedRocketryBlocks.blockStructureTower) + 1;
            zMax = ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)ForgeDirection.SOUTH, (int)xCurrent, (int)yCurrent, (int)(zCurrent + 1), (int)(17 - zMin), (Block)AdvancedRocketryBlocks.blockStructureTower);
            zSize = zMin + zMax;
            zMin = zCurrent - zMin + 1;
            zMax = zCurrent + zMax;
            if (direction.offsetX > 0) {
                xMax = xCurrent + xSize - 1;
                ++xMin;
            }
            if (direction.offsetX < 0) {
                xMin = xCurrent - xSize + 1;
                --xMax;
            }
        } else {
            zSize = ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)direction, (int)xCurrent, (int)(yCurrent + yMax), (int)zCurrent, (int)17, (Block)AdvancedRocketryBlocks.blockStructureTower);
            xMin = ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)ForgeDirection.WEST, (int)(xCurrent - 1), (int)yCurrent, (int)zCurrent, (int)17, (Block)AdvancedRocketryBlocks.blockStructureTower) + 1;
            xMax = ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)ForgeDirection.EAST, (int)(xCurrent + 1), (int)yCurrent, (int)zCurrent, (int)(17 - xMin), (Block)AdvancedRocketryBlocks.blockStructureTower);
            xSize = xMin + xMax;
            xMin = xCurrent - xMin + 1;
            xMax = xCurrent + xMax;
            if (direction.offsetZ > 0) {
                zMax = zCurrent + zSize - 1;
                ++zMin;
            }
            if (direction.offsetZ < 0) {
                zMin = zCurrent - zSize + 1;
                --zMax;
            }
        }
        if (yMax < 3 || xSize < 3 || zSize < 3) {
            return null;
        }
        return AxisAlignedBB.func_72330_a((double)xMin, (double)yCurrent, (double)zMin, (double)xMax, (double)(yCurrent + yMax - 1), (double)zMax);
    }

    @Override
    public void assembleRocket() {
        StorageChunk storageChunk;
        if (this.bbCache == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.scanRocket(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.bbCache);
        if (this.status != TileRocketBuilder.ErrorCodes.SUCCESS) {
            return;
        }
        try {
            storageChunk = StorageChunk.cutWorldBB(this.field_145850_b, this.bbCache);
        }
        catch (NegativeArraySizeException e) {
            return;
        }
        EntityStationDeployedRocket rocket = new EntityStationDeployedRocket(this.field_145850_b, storageChunk, this.stats.copy(), this.bbCache.field_72340_a + (this.bbCache.field_72336_d - this.bbCache.field_72340_a) / 2.0 + 0.5, this.field_145848_d, this.bbCache.field_72339_c + (this.bbCache.field_72334_f - this.bbCache.field_72339_c) / 2.0 + 0.5);
        rocket.forwardDirection = RotatableBlock.getFront((int)this.field_145847_g).getOpposite();
        rocket.launchDirection = ForgeDirection.DOWN;
        for (int x = 0; x < storageChunk.getSizeX(); ++x) {
            for (int y = 0; y < storageChunk.getSizeY(); ++y) {
                for (int z = 0; z < storageChunk.getSizeZ(); ++z) {
                    if (!(storageChunk.func_147439_a(x, y, z) instanceof BlockRocketMotor)) continue;
                    storageChunk.setBlockMeta(x, y, z, rocket.forwardDirection.ordinal());
                    storageChunk.func_147438_o((int)x, (int)y, (int)z).field_145847_g = rocket.forwardDirection.ordinal();
                    ((TileModelRenderRotatable)storageChunk.func_147438_o((int)x, (int)y, (int)z)).rotation = rocket.forwardDirection;
                }
            }
        }
        this.field_145850_b.func_72838_d((Entity)rocket);
        NBTTagCompound nbtdata = new NBTTagCompound();
        rocket.func_70109_d(nbtdata);
        PacketHandler.sendToNearby((BasePacket)new PacketEntity((INetworkEntity)rocket, 0, nbtdata), (int)rocket.field_70170_p.field_73011_w.field_76574_g, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (double)64.0);
        this.stats.reset();
        this.status = TileRocketBuilder.ErrorCodes.UNSCANNED;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (IInfrastructure infrastructure : this.getConnectedInfrastructure()) {
            rocket.linkInfrastructure(infrastructure);
        }
    }

    @Override
    public void scanRocket(World world, int x, int y, int z, AxisAlignedBB bb) {
        int thrust = 0;
        int fuelUse = 0;
        int fuel = 0;
        int numBlocks = 0;
        float drillPower = 0.0f;
        this.stats.reset();
        int actualMinX = (int)bb.field_72336_d;
        int actualMinY = (int)bb.field_72337_e;
        int actualMinZ = (int)bb.field_72334_f;
        int actualMaxX = (int)bb.field_72340_a;
        int actualMaxY = (int)bb.field_72338_b;
        int actualMaxZ = (int)bb.field_72339_c;
        int xCurr = (int)bb.field_72340_a;
        while ((double)xCurr <= bb.field_72336_d) {
            int zCurr = (int)bb.field_72339_c;
            while ((double)zCurr <= bb.field_72334_f) {
                int yCurr = (int)bb.field_72338_b;
                while ((double)yCurr <= bb.field_72337_e) {
                    Block block = world.func_147439_a(xCurr, yCurr, zCurr);
                    if (!block.isAir((IBlockAccess)world, xCurr, yCurr, zCurr)) {
                        if (xCurr < actualMinX) {
                            actualMinX = xCurr;
                        }
                        if (yCurr < actualMinY) {
                            actualMinY = yCurr;
                        }
                        if (zCurr < actualMinZ) {
                            actualMinZ = zCurr;
                        }
                        if (xCurr > actualMaxX) {
                            actualMaxX = xCurr;
                        }
                        if (yCurr > actualMaxY) {
                            actualMaxY = yCurr;
                        }
                        if (zCurr > actualMaxZ) {
                            actualMaxZ = zCurr;
                        }
                    }
                    ++yCurr;
                }
                ++zCurr;
            }
            ++xCurr;
        }
        boolean hasSatellite = false;
        boolean hasGuidance = false;
        int fluidCapacity = 0;
        if (this.verifyScan(bb, world)) {
            int yCurr = (int)bb.field_72338_b;
            while ((double)yCurr <= bb.field_72337_e) {
                int xCurr2 = (int)bb.field_72340_a;
                while ((double)xCurr2 <= bb.field_72336_d) {
                    int zCurr = (int)bb.field_72339_c;
                    while ((double)zCurr <= bb.field_72334_f) {
                        if (!world.func_147437_c(xCurr2, yCurr, zCurr)) {
                            TileEntity tile;
                            Block block = world.func_147439_a(xCurr2, yCurr, zCurr);
                            int meta = world.func_72805_g(xCurr2, yCurr, zCurr);
                            ++numBlocks;
                            if (block instanceof IRocketEngine) {
                                thrust += ((IRocketEngine)block).getThrust(world, xCurr2, yCurr, z);
                                fuelUse += ((IRocketEngine)block).getFuelConsumptionRate(world, xCurr2, yCurr, zCurr);
                                this.stats.addEngineLocation((float)(xCurr2 - actualMinX) - (float)(actualMaxX - actualMinX) / 2.0f, yCurr - actualMinY, (float)(zCurr - actualMinZ) - (float)(actualMaxZ - actualMinZ) / 2.0f);
                            }
                            if (block instanceof IFuelTank) {
                                fuel += ((IFuelTank)block).getMaxFill(world, xCurr2, yCurr, zCurr, world.func_72805_g(xCurr2, yCurr, zCurr));
                            }
                            if (block instanceof BlockSeat) {
                                if (this.stats.hasSeat()) {
                                    this.stats.addPassengerSeat((int)((float)(xCurr2 - actualMinX) - (float)(actualMaxX - actualMinX) / 2.0f), yCurr - actualMinY, (int)((float)(zCurr - actualMinZ) - (float)(actualMaxZ - actualMinZ) / 2.0f));
                                } else {
                                    this.stats.setSeatLocation((int)((float)(xCurr2 - actualMinX) - (float)(actualMaxX - actualMinX) / 2.0f), yCurr - actualMinY, (int)((float)(zCurr - actualMinZ) - (float)(actualMaxZ - actualMinZ) / 2.0f));
                                }
                            }
                            if (block instanceof IMiningDrill) {
                                drillPower += ((IMiningDrill)block).getMiningSpeed(world, xCurr2, yCurr, zCurr);
                            }
                            if (block instanceof IIntake) {
                                this.stats.setStatTag("intakePower", (Integer)this.stats.getStatTag("intakePower") + ((IIntake)block).getIntakeAmt(meta));
                            }
                            if ((tile = world.func_147438_o(xCurr2, yCurr, zCurr)) instanceof TileSatelliteHatch) {
                                hasSatellite = true;
                            }
                            if (tile instanceof TileGuidanceComputer) {
                                hasGuidance = true;
                            }
                            if (tile instanceof IFluidHandler) {
                                for (FluidTankInfo info : ((IFluidHandler)tile).getTankInfo(ForgeDirection.UNKNOWN)) {
                                    fluidCapacity += info.capacity;
                                }
                            }
                        }
                        ++zCurr;
                    }
                    ++xCurr2;
                }
                ++yCurr;
            }
            this.stats.setFuelRate(FuelRegistry.FuelType.LIQUID, fuelUse);
            this.stats.setWeight(numBlocks);
            this.stats.setThrust(thrust);
            this.stats.setFuelCapacity(FuelRegistry.FuelType.LIQUID, fuel);
            this.stats.setDrillingPower(drillPower);
            this.stats.setStatTag("liquidCapacity", fluidCapacity);
            this.status = (float)this.getFuel() < this.getNeededFuel() * (float)(1 + fluidCapacity / 1000) ? TileRocketBuilder.ErrorCodes.NOFUEL : ((float)this.getThrust() < this.getNeededThrust() ? TileRocketBuilder.ErrorCodes.NOENGINES : TileRocketBuilder.ErrorCodes.SUCCESS);
        }
    }

    @Override
    public float getNeededFuel() {
        return this.getAcceleration() > 0.0f ? (float)this.stats.getFuelRate(FuelRegistry.FuelType.LIQUID) : 0.0f;
    }

    @Override
    protected boolean verifyScan(AxisAlignedBB bb, World world) {
        return true;
    }
}

