/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import cpw.mods.fml.relauncher.Side;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.item.ItemPackedStructure;
import zmaster587.advancedRocketry.item.ItemStationChip;
import zmaster587.advancedRocketry.stations.SpaceObject;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.tile.TileRocketBuilder;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IDataSync;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleSlotArray;
import zmaster587.libVulpes.inventory.modules.ModuleSync;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.inventory.modules.ModuleTexturedSlotArray;
import zmaster587.libVulpes.util.EmbeddedInventory;

public class TileStationBuilder
extends TileRocketBuilder
implements IInventory {
    EmbeddedInventory inventory = new EmbeddedInventory(4);
    Long storedId;

    public TileStationBuilder() {
        this.status = TileRocketBuilder.ErrorCodes.EMPTY;
    }

    @Override
    public boolean canScan() {
        if (!super.canScan()) {
            return false;
        }
        ItemStack stack = new ItemStack(AdvancedRocketryBlocks.blockLoader, 1, 1);
        if (this.inventory.func_70301_a(0) == null || !stack.func_77969_a(this.inventory.func_70301_a(0))) {
            this.status = TileRocketBuilder.ErrorCodes.NOSATELLITEHATCH;
            return false;
        }
        if (this.inventory.func_70301_a(1) == null || AdvancedRocketryItems.itemSpaceStationChip != this.inventory.func_70301_a(1).func_77973_b()) {
            this.status = TileRocketBuilder.ErrorCodes.NOSATELLITECHIP;
            return false;
        }
        if (this.inventory.func_70301_a(2) != null || this.inventory.func_70301_a(3) != null) {
            this.status = TileRocketBuilder.ErrorCodes.OUTPUTBLOCKED;
            return false;
        }
        return true;
    }

    @Override
    public void scanRocket(World world, int x, int y, int z, AxisAlignedBB bb) {
        int actualMinX = (int)bb.field_72336_d;
        int actualMinY = (int)bb.field_72337_e;
        int actualMinZ = (int)bb.field_72334_f;
        int actualMaxX = (int)bb.field_72340_a;
        int actualMaxY = (int)bb.field_72338_b;
        int actualMaxZ = (int)bb.field_72339_c;
        int xCurr = (int)bb.field_72340_a;
        while ((double)xCurr <= bb.field_72336_d) {
            int zCurr = (int)bb.field_72339_c;
            while ((double)zCurr <= bb.field_72334_f) {
                int yCurr = (int)bb.field_72338_b;
                while ((double)yCurr <= bb.field_72337_e) {
                    Block block = world.func_147439_a(xCurr, yCurr, zCurr);
                    if (!block.isAir((IBlockAccess)world, xCurr, yCurr, zCurr)) {
                        if (xCurr < actualMinX) {
                            actualMinX = xCurr;
                        }
                        if (yCurr < actualMinY) {
                            actualMinY = yCurr;
                        }
                        if (zCurr < actualMinZ) {
                            actualMinZ = zCurr;
                        }
                        if (xCurr > actualMaxX) {
                            actualMaxX = xCurr;
                        }
                        if (yCurr > actualMaxY) {
                            actualMaxY = yCurr;
                        }
                        if (zCurr > actualMaxZ) {
                            actualMaxZ = zCurr;
                        }
                    }
                    ++yCurr;
                }
                ++zCurr;
            }
            ++xCurr;
        }
        this.status = TileRocketBuilder.ErrorCodes.SUCCESS_STATION;
    }

    @Override
    public void assembleRocket() {
        if (!this.field_145850_b.field_72995_K) {
            ItemStack outputStack;
            if (this.bbCache == null) {
                return;
            }
            this.scanRocket(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.bbCache);
            if (this.status != TileRocketBuilder.ErrorCodes.SUCCESS_STATION) {
                return;
            }
            StorageChunk storageChunk = StorageChunk.cutWorldBB(this.field_145850_b, this.bbCache);
            SpaceObject object = null;
            if (this.storedId == null) {
                object = new SpaceObject();
                SpaceObjectManager.getSpaceManager().registerSpaceObject(object, -1);
                outputStack = new ItemStack(AdvancedRocketryItems.itemSpaceStation, 1, object.getId());
            } else {
                outputStack = new ItemStack(AdvancedRocketryItems.itemSpaceStation, 1, (int)this.storedId.longValue());
            }
            ((ItemPackedStructure)outputStack.func_77973_b()).setStructure(outputStack, storageChunk);
            this.inventory.func_70299_a(2, outputStack);
            if (this.storedId == null) {
                outputStack = new ItemStack(AdvancedRocketryItems.itemSpaceStationChip, 1);
                ItemStationChip.setUUID(outputStack, object.getId());
                this.inventory.func_70299_a(3, outputStack);
            }
            this.status = TileRocketBuilder.ErrorCodes.FINISHED;
            this.storedId = null;
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    @Override
    protected void updateText() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.getRocketPadBounds(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) == null) {
                this.setStatus(TileRocketBuilder.ErrorCodes.INCOMPLETESTRCUTURE.ordinal());
            } else if (TileRocketBuilder.ErrorCodes.INCOMPLETESTRCUTURE.equals((Object)this.getStatus())) {
                this.setStatus(TileRocketBuilder.ErrorCodes.UNSCANNED.ordinal());
            }
        }
        this.errorText.setText(this.status.getErrorCode());
    }

    @Override
    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModulePower(160, 30, (IUniversalEnergy)this));
        modules.add((ModuleBase)new ModuleProgress(149, 30, 2, verticalProgressBar, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleButton(5, 34, 0, "Scan", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonScan));
        ModuleButton buttonBuild = new ModuleButton(5, 60, 1, "Build", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild);
        modules.add((ModuleBase)buttonBuild);
        buttonBuild.setColor(-56798);
        this.errorText = new ModuleText(5, 22, "", -222);
        modules.add((ModuleBase)this.errorText);
        modules.add((ModuleBase)new ModuleSync(4, (IDataSync)this));
        this.updateText();
        modules.add((ModuleBase)new ModuleSlotArray(90, 40, (IInventory)this.inventory, 0, 1));
        modules.add((ModuleBase)new ModuleTexturedSlotArray(108, 40, (IInventory)this.inventory, 1, 2, TextureResources.idChip));
        modules.add((ModuleBase)new ModuleSlotArray(90, 60, (IInventory)this.inventory, 2, 4));
        return modules;
    }

    @Override
    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        boolean isScanningFlag = !this.isScanning() && this.canScan();
        super.useNetworkData(player, side, id, nbt);
        if (id == 1 && isScanningFlag) {
            this.inventory.func_70298_a(0, 1);
            this.storedId = ItemStationChip.getUUID(this.inventory.func_70301_a(1));
            if (this.storedId == 0L) {
                this.storedId = null;
            }
            if (this.storedId == null) {
                this.inventory.func_70298_a(1, 1);
            }
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.inventory.writeToNBT(nbt);
        if (this.storedId != null) {
            nbt.func_74772_a("storedID", this.storedId.longValue());
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.inventory.readFromNBT(nbt);
        if (nbt.func_74764_b("storedID")) {
            this.storedId = nbt.func_74763_f("storedID");
        }
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory.func_70301_a(slot);
    }

    public ItemStack func_70298_a(int slot, int amt) {
        return this.inventory.func_70298_a(slot, amt);
    }

    public ItemStack func_70304_b(int slot) {
        return this.inventory.func_70304_b(slot);
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory.func_70299_a(slot, stack);
    }

    public String func_145825_b() {
        return "tile.stationBuilder.name";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.inventory.func_70300_a(player);
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack stack) {
        return this.inventory.func_94041_b(slot, stack);
    }
}

