/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.EntityRocketBase;
import zmaster587.advancedRocketry.api.IFuelTank;
import zmaster587.advancedRocketry.api.IInfrastructure;
import zmaster587.advancedRocketry.api.IMiningDrill;
import zmaster587.advancedRocketry.api.IRocketEngine;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.api.StatsRocket;
import zmaster587.advancedRocketry.api.fuel.FuelRegistry;
import zmaster587.advancedRocketry.block.BlockSeat;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.tile.TileGuidanceComputer;
import zmaster587.advancedRocketry.tile.hatch.TileSatelliteHatch;
import zmaster587.advancedRocketry.util.StorageChunk;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.block.RotatableBlock;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.interfaces.ILinkableTile;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IDataSync;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.IProgressBar;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.inventory.modules.ModuleProgress;
import zmaster587.libVulpes.inventory.modules.ModuleSync;
import zmaster587.libVulpes.inventory.modules.ModuleText;
import zmaster587.libVulpes.items.ItemLinker;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.tile.IMultiblock;
import zmaster587.libVulpes.tile.TileEntityRFConsumer;
import zmaster587.libVulpes.util.BlockPosition;
import zmaster587.libVulpes.util.INetworkMachine;
import zmaster587.libVulpes.util.IconResource;
import zmaster587.libVulpes.util.ZUtils;

public class TileRocketBuilder
extends TileEntityRFConsumer
implements IButtonInventory,
INetworkMachine,
IDataSync,
IModularInventory,
IProgressBar,
ILinkableTile {
    private final int MAX_SIZE = 16;
    private final int MIN_SIZE = 3;
    private final int MAX_SIZE_Y = 64;
    private final int MIN_SIZE_Y = 4;
    private final int MAXSCANDELAY = 10;
    private final int ENERGYFOROP = 100;
    protected static final ResourceLocation backdrop = new ResourceLocation("advancedrocketry", "textures/gui/rocketBuilder.png");
    private static final ProgressBarImage horizontalProgressBar = new ProgressBarImage(89, 9, 81, 17, 176, 0, 80, 15, 0, 2, ForgeDirection.EAST, backdrop);
    protected static final ProgressBarImage verticalProgressBar = new ProgressBarImage(76, 93, 8, 52, 176, 15, 2, 38, 3, 2, ForgeDirection.UP, backdrop);
    private ModuleText thrustText;
    private ModuleText weightText;
    private ModuleText fuelText;
    private ModuleText accelerationText;
    protected ModuleText errorText;
    private int totalProgress;
    private int progress;
    private int prevProgress = 0;
    private boolean building = false;
    private int lastRocketID;
    protected StatsRocket stats;
    protected AxisAlignedBB bbCache;
    protected ErrorCodes status;
    private List<BlockPosition> blockPos = new LinkedList<BlockPosition>();

    public TileRocketBuilder() {
        super(100000);
        this.status = ErrorCodes.UNSCANNED;
        this.stats = new StatsRocket();
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void func_145843_s() {
        super.func_145843_s();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
        for (BlockPosition pos : this.blockPos) {
            TileEntity tile = this.field_145850_b.func_147438_o(pos.x, (int)pos.y, pos.z);
            if (!(tile instanceof IMultiblock)) continue;
            ((IMultiblock)tile).setIncomplete();
        }
    }

    public void onChunkUnload() {
        super.onChunkUnload();
        MinecraftForge.EVENT_BUS.unregister((Object)this);
    }

    public ErrorCodes getStatus() {
        return this.status;
    }

    public StatsRocket getRocketStats() {
        return this.stats;
    }

    public AxisAlignedBB getBBCache() {
        return this.bbCache;
    }

    public int getTotalProgress() {
        return this.totalProgress;
    }

    public void setTotalProgress(int scanTotalBlocks) {
        this.totalProgress = scanTotalBlocks;
    }

    public int getProgress() {
        return this.progress;
    }

    public void setProgress(int scanTime) {
        this.progress = scanTime;
    }

    public double getNormallizedProgress() {
        return (double)this.progress / (double)(this.totalProgress * 10);
    }

    public float getAcceleration() {
        return this.stats.getAcceleration();
    }

    public int getWeight() {
        return this.stats.getWeight();
    }

    public int getThrust() {
        return this.stats.getThrust();
    }

    public float getNeededThrust() {
        return this.getWeight();
    }

    public float getNeededFuel() {
        return this.getAcceleration() > 0.0f ? (float)this.stats.getFuelRate(FuelRegistry.FuelType.LIQUID) * MathHelper.func_76129_c((float)((float)(2 * (Configuration.orbit - this.field_145848_d)) / this.getAcceleration())) : 0.0f;
    }

    public int getFuel() {
        return (int)((double)this.stats.getFuelCapacity(FuelRegistry.FuelType.LIQUID) * Configuration.fuelCapacityMultiplier);
    }

    public boolean isBuilding() {
        return this.building;
    }

    public void setBuilding(boolean building) {
        this.building = building;
    }

    public void setStatus(int value) {
        this.status = ErrorCodes.values()[value];
    }

    public boolean canUpdate() {
        return true;
    }

    public boolean shouldRenderInPass(int pass) {
        return pass == 1;
    }

    public int getPowerPerOperation() {
        return 100;
    }

    public void performFunction() {
        if (this.progress >= this.totalProgress * 10) {
            if (!this.field_145850_b.field_72995_K) {
                if (this.building) {
                    this.assembleRocket();
                } else {
                    this.scanRocket(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.bbCache);
                }
            }
            this.totalProgress = -1;
            this.progress = 0;
            this.prevProgress = 0;
            this.building = false;
            if (this.thrustText != null) {
                this.updateText();
            }
        }
        ++this.progress;
        if (!this.field_145850_b.field_72995_K && this.energy.getEnergyStored() < this.getPowerPerOperation() && this.progress - this.prevProgress > 0) {
            this.prevProgress = this.progress;
            PacketHandler.sendToNearby((BasePacket)new PacketMachine((INetworkMachine)this, 2), (int)this.field_145850_b.field_73011_w.field_76574_g, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (double)32.0);
        }
    }

    public boolean canPerformFunction() {
        return this.isScanning();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.isScanning() && this.bbCache != null) {
            return this.bbCache;
        }
        return super.getRenderBoundingBox();
    }

    public boolean isScanning() {
        return this.totalProgress > 0;
    }

    public void scanRocket(World world, int x, int y, int z, AxisAlignedBB bb) {
        int yCurr;
        int thrust = 0;
        int fuelUse = 0;
        int fuel = 0;
        int numBlocks = 0;
        float drillPower = 0.0f;
        this.stats.reset();
        int actualMinX = (int)bb.field_72336_d;
        int actualMinY = (int)bb.field_72337_e;
        int actualMinZ = (int)bb.field_72334_f;
        int actualMaxX = (int)bb.field_72340_a;
        int actualMaxY = (int)bb.field_72338_b;
        int actualMaxZ = (int)bb.field_72339_c;
        int xCurr = (int)bb.field_72340_a;
        while ((double)xCurr <= bb.field_72336_d) {
            int zCurr = (int)bb.field_72339_c;
            while ((double)zCurr <= bb.field_72334_f) {
                yCurr = (int)bb.field_72338_b;
                while ((double)yCurr <= bb.field_72337_e) {
                    Block block = world.func_147439_a(xCurr, yCurr, zCurr);
                    if (!block.isAir((IBlockAccess)world, xCurr, yCurr, zCurr)) {
                        if (xCurr < actualMinX) {
                            actualMinX = xCurr;
                        }
                        if (yCurr < actualMinY) {
                            actualMinY = yCurr;
                        }
                        if (zCurr < actualMinZ) {
                            actualMinZ = zCurr;
                        }
                        if (xCurr > actualMaxX) {
                            actualMaxX = xCurr;
                        }
                        if (yCurr > actualMaxY) {
                            actualMaxY = yCurr;
                        }
                        if (zCurr > actualMaxZ) {
                            actualMaxZ = zCurr;
                        }
                    }
                    ++yCurr;
                }
                ++zCurr;
            }
            ++xCurr;
        }
        boolean hasSatellite = false;
        boolean hasGuidance = false;
        if (this.verifyScan(bb, world)) {
            yCurr = (int)bb.field_72338_b;
            while ((double)yCurr <= bb.field_72337_e) {
                int xCurr2 = (int)bb.field_72340_a;
                while ((double)xCurr2 <= bb.field_72336_d) {
                    int zCurr = (int)bb.field_72339_c;
                    while ((double)zCurr <= bb.field_72334_f) {
                        if (!world.func_147437_c(xCurr2, yCurr, zCurr)) {
                            TileEntity tile;
                            Block block = world.func_147439_a(xCurr2, yCurr, zCurr);
                            ++numBlocks;
                            if (block instanceof IRocketEngine) {
                                thrust += ((IRocketEngine)block).getThrust(world, xCurr2, yCurr, zCurr);
                                fuelUse += ((IRocketEngine)block).getFuelConsumptionRate(world, xCurr2, yCurr, zCurr);
                                this.stats.addEngineLocation((float)(xCurr2 - actualMinX) - (float)(actualMaxX - actualMinX) / 2.0f, yCurr - actualMinY, (float)(zCurr - actualMinZ) - (float)(actualMaxZ - actualMinZ) / 2.0f);
                            }
                            if (block instanceof IFuelTank) {
                                fuel += ((IFuelTank)block).getMaxFill(world, xCurr2, yCurr, zCurr, world.func_72805_g(xCurr2, yCurr, zCurr));
                            }
                            if (block instanceof BlockSeat) {
                                if (this.stats.hasSeat()) {
                                    this.stats.addPassengerSeat((int)((float)(xCurr2 - actualMinX) - (float)(actualMaxX - actualMinX) / 2.0f), yCurr - actualMinY, (int)((float)(zCurr - actualMinZ) - (float)(actualMaxZ - actualMinZ) / 2.0f));
                                } else {
                                    this.stats.setSeatLocation((int)((float)(xCurr2 - actualMinX) - (float)(actualMaxX - actualMinX) / 2.0f), yCurr - actualMinY, (int)((float)(zCurr - actualMinZ) - (float)(actualMaxZ - actualMinZ) / 2.0f));
                                }
                            }
                            if (block instanceof IMiningDrill) {
                                drillPower += ((IMiningDrill)block).getMiningSpeed(world, xCurr2, yCurr, zCurr);
                            }
                            if ((tile = world.func_147438_o(xCurr2, yCurr, zCurr)) instanceof TileSatelliteHatch) {
                                hasSatellite = true;
                            }
                            if (tile instanceof TileGuidanceComputer) {
                                hasGuidance = true;
                            }
                        }
                        ++zCurr;
                    }
                    ++xCurr2;
                }
                ++yCurr;
            }
            this.stats.setFuelRate(FuelRegistry.FuelType.LIQUID, fuelUse);
            this.stats.setWeight(numBlocks);
            this.stats.setThrust(thrust);
            this.stats.setFuelCapacity(FuelRegistry.FuelType.LIQUID, fuel);
            this.stats.setDrillingPower(drillPower);
            this.status = !hasGuidance && !hasSatellite ? ErrorCodes.NOGUIDANCE : ((float)this.getFuel() < this.getNeededFuel() ? ErrorCodes.NOFUEL : ((float)this.getThrust() < this.getNeededThrust() ? ErrorCodes.NOENGINES : ErrorCodes.SUCCESS));
        }
    }

    public void assembleRocket() {
        StorageChunk storageChunk;
        if (this.bbCache == null || this.field_145850_b.field_72995_K) {
            return;
        }
        this.scanRocket(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.bbCache);
        if (this.status != ErrorCodes.SUCCESS) {
            return;
        }
        try {
            storageChunk = StorageChunk.cutWorldBB(this.field_145850_b, this.bbCache);
        }
        catch (NegativeArraySizeException e) {
            return;
        }
        EntityRocket rocket = new EntityRocket(this.field_145850_b, storageChunk, this.stats.copy(), this.bbCache.field_72340_a + (this.bbCache.field_72336_d - this.bbCache.field_72340_a) / 2.0 + 0.5, this.field_145848_d, this.bbCache.field_72339_c + (this.bbCache.field_72334_f - this.bbCache.field_72339_c) / 2.0 + 0.5);
        this.field_145850_b.func_72838_d((Entity)rocket);
        NBTTagCompound nbtdata = new NBTTagCompound();
        rocket.func_70109_d(nbtdata);
        PacketHandler.sendToNearby((BasePacket)new PacketEntity((INetworkEntity)rocket, 0, nbtdata), (int)rocket.field_70170_p.field_73011_w.field_76574_g, (int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e, (double)64.0);
        this.stats.reset();
        this.status = ErrorCodes.FINISHED;
        this.func_70296_d();
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (IInfrastructure infrastructure : this.getConnectedInfrastructure()) {
            rocket.linkInfrastructure(infrastructure);
        }
    }

    public AxisAlignedBB getRocketPadBounds(World world, int x, int y, int z) {
        int i;
        int zSize;
        int xSize;
        int zMin;
        int xMin;
        ForgeDirection direction = RotatableBlock.getFront((int)world.func_72805_g(x, y, z)).getOpposite();
        int yCurrent = y - 1;
        int xCurrent = x + direction.offsetX;
        int zCurrent = z + direction.offsetZ;
        int xMax = xMin = xCurrent;
        int zMax = zMin = zCurrent;
        if (world.field_72995_K) {
            return null;
        }
        if (direction.offsetX != 0) {
            xSize = ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)direction, (int)xCurrent, (int)yCurrent, (int)zCurrent, (int)16, (Block)AdvancedRocketryBlocks.blockLaunchpad);
            zMin = ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)ForgeDirection.NORTH, (int)xCurrent, (int)yCurrent, (int)zCurrent, (int)16, (Block)AdvancedRocketryBlocks.blockLaunchpad);
            zMax = ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)ForgeDirection.SOUTH, (int)xCurrent, (int)yCurrent, (int)(zCurrent + 1), (int)(16 - zMin), (Block)AdvancedRocketryBlocks.blockLaunchpad);
            zSize = zMin + zMax;
            zMin = zCurrent - zMin + 1;
            zMax = zCurrent + zMax;
            if (direction.offsetX > 0) {
                xMax = xCurrent + xSize - 1;
            }
            if (direction.offsetX < 0) {
                xMin = xCurrent - xSize + 1;
            }
        } else {
            zSize = ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)direction, (int)xCurrent, (int)yCurrent, (int)zCurrent, (int)16, (Block)AdvancedRocketryBlocks.blockLaunchpad);
            xMin = ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)ForgeDirection.WEST, (int)xCurrent, (int)yCurrent, (int)zCurrent, (int)16, (Block)AdvancedRocketryBlocks.blockLaunchpad);
            xMax = ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)ForgeDirection.EAST, (int)(xCurrent + 1), (int)yCurrent, (int)zCurrent, (int)(16 - xMin), (Block)AdvancedRocketryBlocks.blockLaunchpad);
            xSize = xMin + xMax;
            xMin = xCurrent - xMin + 1;
            xMax = xCurrent + xMax;
            if (direction.offsetZ > 0) {
                zMax = zCurrent + zSize - 1;
            }
            if (direction.offsetZ < 0) {
                zMin = zCurrent - zSize + 1;
            }
        }
        int maxTowerSize = 0;
        for (i = xMin; i <= xMax; ++i) {
            if (world.func_147439_a(i, yCurrent, zMin - 1) == AdvancedRocketryBlocks.blockStructureTower) {
                maxTowerSize = Math.max(maxTowerSize, ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)ForgeDirection.UP, (int)i, (int)yCurrent, (int)(zMin - 1), (int)64, (Block)AdvancedRocketryBlocks.blockStructureTower));
            }
            if (world.func_147439_a(i, yCurrent, zMax + 1) != AdvancedRocketryBlocks.blockStructureTower) continue;
            maxTowerSize = Math.max(maxTowerSize, ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)ForgeDirection.UP, (int)i, (int)yCurrent, (int)(zMax + 1), (int)64, (Block)AdvancedRocketryBlocks.blockStructureTower));
        }
        for (i = zMin; i <= zMax; ++i) {
            if (world.func_147439_a(xMin - 1, yCurrent, i) == AdvancedRocketryBlocks.blockStructureTower) {
                maxTowerSize = Math.max(maxTowerSize, ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)ForgeDirection.UP, (int)(xMin - 1), (int)yCurrent, (int)i, (int)64, (Block)AdvancedRocketryBlocks.blockStructureTower));
            }
            if (world.func_147439_a(xMax + 1, yCurrent, i) != AdvancedRocketryBlocks.blockStructureTower) continue;
            maxTowerSize = Math.max(maxTowerSize, ZUtils.getContinuousBlockLength((World)world, (ForgeDirection)ForgeDirection.UP, (int)(xMax + 1), (int)yCurrent, (int)i, (int)64, (Block)AdvancedRocketryBlocks.blockStructureTower));
        }
        if (maxTowerSize < 4 || xSize < 3 || zSize < 3) {
            return null;
        }
        return AxisAlignedBB.func_72330_a((double)xMin, (double)(yCurrent + 1), (double)zMin, (double)xMax, (double)(yCurrent + maxTowerSize - 1), (double)zMax);
    }

    protected boolean verifyScan(AxisAlignedBB bb, World world) {
        boolean whole = true;
        block0: for (int xx = (int)bb.field_72340_a; xx <= (int)bb.field_72336_d; ++xx) {
            for (int zz = (int)bb.field_72339_c; zz <= (int)bb.field_72334_f && whole; ++zz) {
                if (world.func_147439_a(xx, (int)bb.field_72338_b - 1, zz) == AdvancedRocketryBlocks.blockLaunchpad) continue;
                whole = false;
                break block0;
            }
        }
        return whole;
    }

    public int getVolume(World world, int x, int y, int z, AxisAlignedBB bb) {
        return (int)((bb.field_72336_d - bb.field_72340_a) * (bb.field_72337_e - bb.field_72338_b) * (bb.field_72334_f - bb.field_72339_c));
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.stats.writeToNBT(nbt);
        nbt.func_74768_a("scanTime", this.progress);
        nbt.func_74768_a("scanTotalBlocks", this.totalProgress);
        nbt.func_74757_a("building", this.building);
        nbt.func_74768_a("status", this.status.ordinal());
        if (this.bbCache != null) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74780_a("minX", this.bbCache.field_72340_a);
            tag.func_74780_a("minY", this.bbCache.field_72338_b);
            tag.func_74780_a("minZ", this.bbCache.field_72339_c);
            tag.func_74780_a("maxX", this.bbCache.field_72336_d);
            tag.func_74780_a("maxY", this.bbCache.field_72337_e);
            tag.func_74780_a("maxZ", this.bbCache.field_72334_f);
            nbt.func_74782_a("bb", (NBTBase)tag);
        }
        if (!this.blockPos.isEmpty()) {
            int[] array = new int[this.blockPos.size() * 3];
            int counter = 0;
            for (BlockPosition pos : this.blockPos) {
                array[counter] = pos.x;
                array[counter + 1] = pos.y;
                array[counter + 2] = pos.z;
                counter += 3;
            }
            nbt.func_74783_a("infrastructureLocations", array);
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.stats.readFromNBT(nbt);
        this.prevProgress = this.progress = nbt.func_74762_e("scanTime");
        this.totalProgress = nbt.func_74762_e("scanTotalBlocks");
        this.status = ErrorCodes.values()[nbt.func_74762_e("status")];
        this.building = nbt.func_74767_n("building");
        if (nbt.func_74764_b("bb")) {
            NBTTagCompound tag = nbt.func_74775_l("bb");
            this.bbCache = AxisAlignedBB.func_72330_a((double)tag.func_74769_h("minX"), (double)tag.func_74769_h("minY"), (double)tag.func_74769_h("minZ"), (double)tag.func_74769_h("maxX"), (double)tag.func_74769_h("maxY"), (double)tag.func_74769_h("maxZ"));
        }
        this.blockPos.clear();
        if (nbt.func_74764_b("infrastructureLocations")) {
            int[] array = nbt.func_74759_k("infrastructureLocations");
            for (int counter = 0; counter < array.length; counter += 3) {
                this.blockPos.add(new BlockPosition(array[counter], array[counter + 1], array[counter + 2]));
            }
        }
    }

    public Packet func_145844_m() {
        super.func_145844_m();
        NBTTagCompound nbt = new NBTTagCompound();
        this.func_145841_b(nbt);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, nbt);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public void startBuild(int x, int y, int z) {
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 2) {
            out.writeInt(this.energy.getEnergyStored());
            out.writeInt(this.progress);
        } else if (id == 3) {
            out.writeInt(this.lastRocketID);
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte id, NBTTagCompound nbt) {
        if (id == 2) {
            nbt.func_74768_a("pwr", in.readInt());
            nbt.func_74768_a("tik", in.readInt());
        } else if (id == 3) {
            nbt.func_74768_a("id", in.readInt());
        }
    }

    public boolean canScan() {
        return this.bbCache != null;
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 0) {
            AxisAlignedBB bb;
            this.bbCache = bb = this.getRocketPadBounds(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (!this.canScan()) {
                return;
            }
            this.totalProgress = (int)(Configuration.buildSpeedMultiplier * (float)this.getVolume(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.bbCache) / 10.0f);
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (id == 1) {
            AxisAlignedBB bb;
            if (this.isScanning()) {
                return;
            }
            this.building = true;
            this.bbCache = bb = this.getRocketPadBounds(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            if (!this.canScan()) {
                return;
            }
            this.totalProgress = (int)(Configuration.buildSpeedMultiplier * (float)this.getVolume(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, this.bbCache) / 10.0f);
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (id == 2) {
            this.energy.setEnergyStored(nbt.func_74762_e("pwr"));
            this.progress = nbt.func_74762_e("tik");
        } else if (id == 3) {
            EntityRocket rocket = (EntityRocket)this.field_145850_b.func_73045_a(nbt.func_74762_e("id"));
            for (IInfrastructure infrastructure : this.getConnectedInfrastructure()) {
                rocket.linkInfrastructure(infrastructure);
            }
        }
    }

    protected void updateText() {
        this.thrustText.setText(this.isScanning() ? "Thrust: ???" : String.format("Thrust: %dN", this.getThrust()));
        this.weightText.setText(this.isScanning() ? "Weight: ???" : String.format("Weight: %dN", this.getWeight()));
        this.fuelText.setText(this.isScanning() ? "Fuel: ???" : String.format("Fuel: %dmb/s", this.getRocketStats().getFuelRate(FuelRegistry.FuelType.LIQUID)));
        this.accelerationText.setText(this.isScanning() ? "Acc: ???" : String.format("Acc: %.2fm/s\u00b2", Float.valueOf(this.getAcceleration() * 20.0f)));
        if (!this.field_145850_b.field_72995_K) {
            if (this.getRocketPadBounds(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) == null) {
                this.setStatus(ErrorCodes.INCOMPLETESTRCUTURE.ordinal());
            } else if (ErrorCodes.INCOMPLETESTRCUTURE.equals((Object)this.getStatus())) {
                this.setStatus(ErrorCodes.UNSCANNED.ordinal());
            }
        }
        this.errorText.setText(this.getStatus().getErrorCode());
    }

    public List<ModuleBase> getModules(int ID, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        modules.add((ModuleBase)new ModulePower(160, 90, (IUniversalEnergy)this));
        if (this.field_145850_b.field_72995_K) {
            modules.add((ModuleBase)new ModuleImage(4, 9, new IconResource(4, 9, 168, 74, backdrop)));
        }
        modules.add((ModuleBase)new ModuleProgress(89, 47, 0, horizontalProgressBar, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(89, 66, 1, horizontalProgressBar, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(89, 28, 3, horizontalProgressBar, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(89, 9, 4, horizontalProgressBar, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleProgress(149, 90, 2, verticalProgressBar, (IProgressBar)this));
        modules.add((ModuleBase)new ModuleButton(5, 94, 0, "Scan", (IButtonInventory)this, TextureResources.buttonScan));
        ModuleButton buttonBuild = new ModuleButton(5, 120, 1, "Build", (IButtonInventory)this, TextureResources.buttonBuild);
        modules.add((ModuleBase)buttonBuild);
        buttonBuild.setColor(-56798);
        this.thrustText = new ModuleText(8, 15, "", -14483678);
        modules.add((ModuleBase)this.thrustText);
        this.weightText = new ModuleText(8, 34, "", -14483678);
        modules.add((ModuleBase)this.weightText);
        this.fuelText = new ModuleText(8, 52, "", -14483678);
        modules.add((ModuleBase)this.fuelText);
        this.accelerationText = new ModuleText(8, 71, "", -14483678);
        modules.add((ModuleBase)this.accelerationText);
        this.errorText = new ModuleText(5, 84, "", -222);
        modules.add((ModuleBase)this.errorText);
        this.updateText();
        for (int i = 0; i < 5; ++i) {
            modules.add((ModuleBase)new ModuleSync(i, (IDataSync)this));
        }
        return modules;
    }

    public String getModularInventoryName() {
        return "";
    }

    public float getNormallizedProgress(int id) {
        if (this.isScanning() && id != 2) {
            return 0.0f;
        }
        switch (id) {
            case 0: {
                return this.getAcceleration() > 0.0f ? MathHelper.func_76131_a((float)(0.5f + 0.5f * (((float)this.getFuel() - this.getNeededFuel()) / this.getNeededFuel())), (float)0.0f, (float)1.0f) : 0.0f;
            }
            case 1: {
                return MathHelper.func_76131_a((float)(0.5f + this.getAcceleration() * 10.0f), (float)0.0f, (float)1.0f);
            }
            case 2: {
                return (float)this.getNormallizedProgress();
            }
            case 3: {
                return this.getWeight() > 0 ? 0.5f : 0.0f;
            }
            case 4: {
                return this.getThrust() > 0 ? 0.9f : 0.0f;
            }
        }
        return 0.0f;
    }

    public void setProgress(int id, int progress) {
        if (id == 2) {
            this.setProgress(progress);
        }
    }

    public int getProgress(int id) {
        if (id == 2) {
            return this.getProgress();
        }
        return 0;
    }

    public int getTotalProgress(int id) {
        if (id == 2) {
            return this.getTotalProgress();
        }
        return 0;
    }

    public void setTotalProgress(int id, int progress) {
        if (id == 2) {
            this.setTotalProgress(progress);
            this.updateText();
        }
    }

    public void setData(int id, int value) {
        switch (id) {
            case 0: {
                this.getRocketStats().setFuelRate(FuelRegistry.FuelType.LIQUID, value);
                break;
            }
            case 1: {
                this.getRocketStats().setWeight(value);
                break;
            }
            case 2: {
                this.getRocketStats().setThrust(value);
                break;
            }
            case 3: {
                this.getRocketStats().setFuelCapacity(FuelRegistry.FuelType.LIQUID, value);
                break;
            }
            case 4: {
                this.setStatus(value);
            }
        }
        this.updateText();
    }

    public int getData(int id) {
        switch (id) {
            case 0: {
                return this.getRocketStats().getFuelRate(FuelRegistry.FuelType.LIQUID);
            }
            case 1: {
                return this.getRocketStats().getWeight();
            }
            case 2: {
                return this.getRocketStats().getThrust();
            }
            case 3: {
                return this.getRocketStats().getFuelCapacity(FuelRegistry.FuelType.LIQUID);
            }
            case 4: {
                return this.getStatus().ordinal();
            }
        }
        return 0;
    }

    public void onInventoryButtonPressed(int buttonId) {
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, (byte)buttonId));
        this.updateText();
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public boolean canConnectEnergy(ForgeDirection arg0) {
        return true;
    }

    public boolean onLinkStart(ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        return true;
    }

    public boolean onLinkComplete(ItemStack item, TileEntity entity, EntityPlayer player, World world) {
        ItemLinker cfr_ignored_0 = (ItemLinker)item.func_77973_b();
        ItemLinker cfr_ignored_1 = (ItemLinker)item.func_77973_b();
        ItemLinker cfr_ignored_2 = (ItemLinker)item.func_77973_b();
        TileEntity tile = world.func_147438_o(ItemLinker.getMasterX((ItemStack)item), ItemLinker.getMasterY((ItemStack)item), ItemLinker.getMasterZ((ItemStack)item));
        if (tile instanceof IInfrastructure) {
            BlockPosition pos = new BlockPosition(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e);
            if (!this.blockPos.contains(pos)) {
                this.blockPos.add(pos);
            }
            if (this.getBBCache() == null) {
                this.bbCache = this.getRocketPadBounds(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            }
            if (this.getBBCache() != null) {
                List rockets = this.field_145850_b.func_72872_a(EntityRocketBase.class, this.bbCache);
                for (EntityRocketBase rocket : rockets) {
                    rocket.linkInfrastructure((IInfrastructure)tile);
                }
            }
            if (!this.field_145850_b.field_72995_K) {
                player.func_145747_a((IChatComponent)new ChatComponentText("Linked Sucessfully"));
                if (tile instanceof IMultiblock) {
                    ((IMultiblock)tile).setMasterBlock(this.field_145851_c, this.field_145848_d, this.field_145849_e);
                }
            }
            ItemLinker.resetPosition((ItemStack)item);
            return true;
        }
        return false;
    }

    public void removeConnectedInfrastructure(TileEntity tile) {
        this.blockPos.remove(new BlockPosition(tile.field_145851_c, tile.field_145848_d, tile.field_145849_e));
        if (this.getBBCache() == null) {
            this.bbCache = this.getRocketPadBounds(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.getBBCache() != null) {
            List rockets = this.field_145850_b.func_72872_a(EntityRocketBase.class, this.bbCache);
            for (EntityRocketBase rocket : rockets) {
                rocket.unlinkInfrastructure((IInfrastructure)tile);
            }
        }
    }

    public List<IInfrastructure> getConnectedInfrastructure() {
        LinkedList<IInfrastructure> infrastructure = new LinkedList<IInfrastructure>();
        Iterator<BlockPosition> iter = this.blockPos.iterator();
        while (iter.hasNext()) {
            BlockPosition position = iter.next();
            TileEntity tile = this.field_145850_b.func_147438_o(position.x, (int)position.y, position.z);
            tile = this.field_145850_b.func_147438_o(position.x, (int)position.y, position.z);
            if (tile instanceof IInfrastructure) {
                infrastructure.add((IInfrastructure)tile);
                continue;
            }
            iter.remove();
        }
        return infrastructure;
    }

    @SubscribeEvent
    public void onRocketLand(RocketEvent.RocketLandedEvent event) {
        List rockets;
        EntityRocketBase rocket = (EntityRocketBase)event.entity;
        if (this.getBBCache() == null) {
            this.bbCache = this.getRocketPadBounds(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.getBBCache() != null && (rockets = this.field_145850_b.func_72872_a(EntityRocketBase.class, this.bbCache)).contains((Object)rocket)) {
            this.lastRocketID = rocket.func_145782_y();
            for (IInfrastructure infrastructure : this.getConnectedInfrastructure()) {
                rocket.linkInfrastructure(infrastructure);
            }
            PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketMachine((INetworkMachine)this, 3), (Entity)rocket);
        }
    }

    protected static enum ErrorCodes {
        SUCCESS("Clear for liftoff!"),
        NOFUEL("Not enough fuel capacity!"),
        NOSEAT("Missing Seat or satellite!"),
        NOENGINES("You do not have enough thrust!"),
        NOGUIDANCE("Missing Guidance Computer"),
        UNSCANNED("Rocket unscanned."),
        SUCCESS_STATION("Ready!"),
        EMPTY("Nothing here"),
        FINISHED("Build Complete!"),
        INCOMPLETESTRCUTURE("Invalid Launch Pad Structure!"),
        NOSATELLITEHATCH("Missing Sat Bay"),
        NOSATELLITECHIP("Missing Chip"),
        OUTPUTBLOCKED("Output slot blocked");

        String code;

        private ErrorCodes(String code) {
            this.code = code;
        }

        public String getErrorCode() {
            return this.code;
        }
    }
}

