/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import zmaster587.advancedRocketry.world.util.WorldDummy;
import zmaster587.libVulpes.tile.multiblock.hatch.TileFluidHatch;
import zmaster587.libVulpes.util.IAdjBlockUpdate;

public class TileFluidTank
extends TileFluidHatch
implements IAdjBlockUpdate {
    private long lastUpdateTime;
    private static final int MAX_UPDATE = 20;
    private boolean fluidChanged = false;

    public TileFluidTank() {
    }

    public TileFluidTank(int i) {
        super(i);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    private void checkForUpdate() {
        if (this.fluidChanged && this.field_145850_b instanceof WorldDummy || this.field_145850_b.func_82737_E() - this.lastUpdateTime > 20L) {
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            this.lastUpdateTime = this.field_145850_b.func_82737_E();
            this.fluidChanged = false;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource == null) {
            return 0;
        }
        TileFluidTank handler = this.getFluidTankInDirection(ForgeDirection.DOWN);
        int amt = 0;
        if (handler != null) {
            amt = handler.fill(from, resource, doFill);
        }
        FluidStack resource2 = resource.copy();
        resource2.amount -= amt;
        if (resource2.amount > 0) {
            amt += super.fill(from, resource2, doFill);
        }
        if (amt > 0 && doFill) {
            this.fluidChanged = true;
        }
        this.checkForUpdate();
        return amt;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        TileFluidTank handler = this.getFluidTankInDirection(ForgeDirection.UP);
        FluidStack stack = null;
        if (handler != null && handler.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid != null && this.fluidTank.getFluid() != null && this.fluidTank.getFluid().getFluidID() == handler.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid.getFluidID()) {
            stack = handler.drain(from, maxDrain, doDrain);
        }
        if (stack != null) {
            return stack;
        }
        FluidStack stack2 = super.drain(from, maxDrain - (stack != null ? stack.amount : 0), doDrain);
        if (stack != null && stack2 != null) {
            stack2.amount += stack.amount;
        }
        if (stack2 != null && doDrain) {
            this.fluidChanged = true;
        }
        this.checkForUpdate();
        return stack2;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        if (this.fluidTank.getFluid() == null || resource.getFluidID() != this.fluidTank.getFluid().getFluidID()) {
            return null;
        }
        return this.drain(from, resource.amount, doDrain);
    }

    public TileFluidTank getFluidTankInDirection(ForgeDirection direction) {
        TileEntity tile = this.field_145850_b.func_147438_o(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
        if (tile instanceof TileFluidTank) {
            return (TileFluidTank)tile;
        }
        return null;
    }

    protected void writeToNBTHelper(NBTTagCompound nbtTagCompound) {
        super.writeToNBTHelper(nbtTagCompound);
        this.fluidTank.writeToNBT(nbtTagCompound);
    }

    protected void readFromNBTHelper(NBTTagCompound nbtTagCompound) {
        super.readFromNBTHelper(nbtTagCompound);
        this.fluidTank.readFromNBT(nbtTagCompound);
    }

    protected boolean useBucket(int slot, ItemStack stack) {
        FluidStack othertank;
        TileFluidTank handler;
        boolean bucketUsed = super.useBucket(slot, stack);
        if (bucketUsed && (handler = this.getFluidTankInDirection(ForgeDirection.DOWN)) != null && ((othertank = handler.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid) == null || othertank.amount < handler.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].capacity)) {
            this.fluidTank.drain(handler.fill(ForgeDirection.UNKNOWN, this.fluidTank.getFluid(), true), true);
        }
        return bucketUsed;
    }

    public void onAdjacentBlockUpdated() {
        TileFluidTank tank = this.getFluidTankInDirection(ForgeDirection.UP);
        if (tank != null && tank.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid != null) {
            if (this.fluidTank.getFluid() == null) {
                this.fluidTank.fill(tank.fluidTank.drain(this.fluidTank.getCapacity(), true), true);
            } else if (tank.getTankInfo((ForgeDirection)ForgeDirection.UNKNOWN)[0].fluid.getFluidID() == this.fluidTank.getFluid().getFluidID()) {
                this.fluidTank.fill(tank.drain(ForgeDirection.UNKNOWN, this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount(), false), true);
                tank.fluidTank.drain(this.fluidTank.getCapacity() - this.fluidTank.getFluidAmount(), true);
            }
            this.func_70296_d();
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }
}

