/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.tile;

import cpw.mods.fml.relauncher.Side;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.atmosphere.AtmosphereRegister;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.inventory.TextureResources;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketMachine;
import zmaster587.libVulpes.util.INetworkMachine;

public class TileAtmosphereDetector
extends TileEntity
implements IModularInventory,
IButtonInventory,
INetworkMachine {
    IAtmosphere atmosphereToDetect = AtmosphereType.AIR;

    public boolean canUpdate() {
        return true;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_72820_D() % 10L == 0L) {
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            boolean detectedAtm = false;
            if (AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.field_76574_g) == null) {
                detectedAtm = this.atmosphereToDetect == AtmosphereType.AIR;
            } else {
                for (int i = 1; i < ForgeDirection.values().length; ++i) {
                    ForgeDirection direction = ForgeDirection.getOrientation((int)i);
                    boolean bl = detectedAtm = !this.field_145850_b.func_147439_a(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ).func_149662_c() && this.atmosphereToDetect == AtmosphereHandler.getOxygenHandler(this.field_145850_b.field_73011_w.field_76574_g).getAtmosphereType(this.field_145851_c + direction.offsetX, this.field_145848_d + direction.offsetY, this.field_145849_e + direction.offsetZ);
                    if (detectedAtm) break;
                }
            }
            if (meta == 1 != detectedAtm) {
                this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, detectedAtm ? 1 : 0, 3);
            }
        }
    }

    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> modules = new LinkedList<ModuleBase>();
        LinkedList<ModuleButton> btns = new LinkedList<ModuleButton>();
        Iterator<IAtmosphere> atmIter = AtmosphereRegister.getInstance().getAtmosphereList().iterator();
        int i = 0;
        while (atmIter.hasNext()) {
            IAtmosphere atm = atmIter.next();
            btns.add(new ModuleButton(60, 4 + i * 24, i, LibVulpes.proxy.getLocalizedString(atm.getUnlocalizedName()), (IButtonInventory)this, TextureResources.buttonBuild));
            ++i;
        }
        ModuleContainerPan panningContainer = new ModuleContainerPan(5, 20, btns, new LinkedList(), TextureResources.starryBG, 165, 120, 0, 500);
        modules.add((ModuleBase)panningContainer);
        return modules;
    }

    public String getModularInventoryName() {
        return "atmosphereDetector";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    public void onInventoryButtonPressed(int buttonId) {
        this.atmosphereToDetect = AtmosphereRegister.getInstance().getAtmosphereList().get(buttonId);
        PacketHandler.sendToServer((BasePacket)new PacketMachine((INetworkMachine)this, 0));
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 0) {
            PacketBuffer buf = new PacketBuffer(out);
            try {
                buf.writeShort(this.atmosphereToDetect.getUnlocalizedName().length());
                buf.func_150785_a(this.atmosphereToDetect.getUnlocalizedName());
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if (packetId == 0) {
            PacketBuffer buf = new PacketBuffer(in);
            try {
                nbt.func_74778_a("uName", buf.func_150789_c((int)buf.readShort()));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 0) {
            String name = nbt.func_74779_i("uName");
            this.atmosphereToDetect = AtmosphereRegister.getInstance().getAtmosphere(name);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74778_a("atmName", this.atmosphereToDetect.getUnlocalizedName());
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.atmosphereToDetect = AtmosphereRegister.getInstance().getAtmosphere(nbt.func_74779_i("atmName"));
    }
}

