/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.stations;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.satellite.IDataHandler;
import zmaster587.advancedRocketry.stations.SpaceObjectBase;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.world.util.MultiData;

public class SpaceObjectAsteroid
extends SpaceObjectBase
implements IDataHandler {
    HashMap<Block, Integer> compositionMapping;
    int numberOfBlocks;
    long uuid;
    MultiData data = new MultiData();

    public SpaceObjectAsteroid() {
        this.data.setMaxData(5000);
        this.setId(-1);
    }

    public SpaceObjectAsteroid(HashMap<Block, Integer> compositionMapping, long uuid, int numBlocks) {
        this();
        this.numberOfBlocks = numBlocks;
        this.compositionMapping = compositionMapping;
        this.uuid = uuid;
    }

    public boolean registered() {
        return this.getId() != -1;
    }

    public long getAsteroidId() {
        return this.uuid;
    }

    public void setAsteroidId(long id) {
        this.uuid = id;
    }

    public HashMap<Block, Integer> getCompositionMapping() {
        return this.compositionMapping;
    }

    public int getNumberOfBlocks() {
        return this.numberOfBlocks;
    }

    public void registerWithSpaceObjectManager() {
        SpaceObjectManager.getSpaceManager().registerTemporarySpaceObject(this, -1, DimensionManager.getWorld((int)Configuration.spaceDimId).func_82737_E() + 100000L);
    }

    public static void generateAsteroid(World world, int x, int y, int z) {
    }

    @Override
    public void writeToNbt(NBTTagCompound nbt) {
        super.writeToNbt(nbt);
        NBTTagList list = new NBTTagList();
        for (Map.Entry<Block, Integer> entry : this.compositionMapping.entrySet()) {
            NBTTagCompound tag = new NBTTagCompound();
            tag.func_74768_a("id", Block.func_149682_b((Block)entry.getKey()));
            tag.func_74768_a("amt", entry.getValue().intValue());
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("composition", (NBTBase)list);
        nbt.func_74768_a("numBlocks", this.numberOfBlocks);
        nbt.func_74772_a("uuid", this.uuid);
        this.data.writeToNBT(nbt);
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        super.readFromNbt(nbt);
        NBTTagList list = nbt.func_150295_c("composition", 10);
        this.compositionMapping.clear();
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int blockId = tag.func_74762_e("id");
            int rarity = tag.func_74762_e("amt");
            this.compositionMapping.put(Block.func_149729_e((int)blockId), rarity);
        }
        this.numberOfBlocks = nbt.func_74762_e("numBlocks");
        this.uuid = nbt.func_74763_f("uuid");
        this.data.readFromNBT(nbt);
    }

    @Override
    public int extractData(int maxAmount, DataStorage.DataType type, ForgeDirection dir, boolean commit) {
        return 0;
    }

    @Override
    public int addData(int maxAmount, DataStorage.DataType type, ForgeDirection dir, boolean commit) {
        return 0;
    }

    @Override
    public void setProperties(IDimensionProperties properties) {
    }

    @Override
    public float getOrbitalDistance() {
        return this.getProperties().getParentOrbitalDistance();
    }

    @Override
    public void setOrbitalDistance(float finalVel) {
    }
}

