/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.stations;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.api.stations.IStorageChunk;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.inventory.IPlanetDefiner;
import zmaster587.advancedRocketry.network.PacketSpaceStationInfo;
import zmaster587.advancedRocketry.network.PacketStationUpdate;
import zmaster587.advancedRocketry.tile.station.TileDockingPort;
import zmaster587.advancedRocketry.util.StationLandingLocation;
import zmaster587.libVulpes.block.BlockFullyRotatable;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.BlockPosition;

public class SpaceObject
implements ISpaceObject,
IPlanetDefiner {
    private int launchPosX;
    private int launchPosZ;
    private int posX;
    private int posZ;
    private boolean created = false;
    private int altitude;
    private float orbitalDistance;
    private int destinationDimId = 0;
    private int fuelAmount;
    private final int MAX_FUEL = 1000;
    private BlockPosition spawnLocation;
    private List<StationLandingLocation> spawnLocations;
    private List<BlockPosition> warpCoreLocation;
    private Set<Integer> knownPlanetList;
    private HashMap<BlockPosition, String> dockingPoints;
    private long transitionEta = -1L;
    private ForgeDirection direction;
    private double[] rotation;
    private double[] angularVelocity;
    private long lastTimeModification = 0L;
    private DimensionProperties properties = (DimensionProperties)DimensionManager.defaultSpaceDimensionProperties.clone();
    public boolean hasWarpCores = false;

    public SpaceObject() {
        this.spawnLocations = new LinkedList<StationLandingLocation>();
        this.warpCoreLocation = new LinkedList<BlockPosition>();
        this.dockingPoints = new HashMap();
        this.knownPlanetList = new HashSet<Integer>();
        this.angularVelocity = new double[3];
        this.rotation = new double[3];
    }

    @Override
    public long getExpireTime() {
        return Long.MAX_VALUE;
    }

    @Override
    public void beginTransition(long time) {
        if (time > 0L) {
            this.transitionEta = time;
        }
    }

    @Override
    public long getTransitionTime() {
        return this.transitionEta;
    }

    public void discoverPlanet(int pid) {
        this.knownPlanetList.add(pid);
        PacketHandler.sendToAll((BasePacket)new PacketSpaceStationInfo(this.getId(), this));
    }

    @Override
    public int getId() {
        return this.properties.getId();
    }

    @Override
    public DimensionProperties getProperties() {
        return this.properties;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void setProperties(IDimensionProperties properties) {
        this.properties = (DimensionProperties)properties;
    }

    @Override
    public int getOrbitingPlanetId() {
        return this.properties.getParentPlanet();
    }

    public void setForwardDirection(ForgeDirection direction) {
        this.direction = direction;
    }

    @Override
    public ForgeDirection getForwardDirection() {
        if (this.direction == null) {
            return ForgeDirection.NORTH;
        }
        return this.direction;
    }

    public int getAltitude() {
        return this.altitude;
    }

    @Override
    public double getRotation(ForgeDirection dir) {
        return (this.rotation[this.getIDFromDir(dir)] + this.getDeltaRotation(dir) * (double)(this.getWorldTime() - this.lastTimeModification)) % 360.0;
    }

    private int getIDFromDir(ForgeDirection facing) {
        if (facing == ForgeDirection.EAST) {
            return 0;
        }
        if (facing == ForgeDirection.UP) {
            return 1;
        }
        return 2;
    }

    @Override
    public void setRotation(double rotation, ForgeDirection facing) {
        this.rotation[this.getIDFromDir((ForgeDirection)facing)] = rotation;
    }

    @Override
    public double getDeltaRotation(ForgeDirection facing) {
        return this.angularVelocity[this.getIDFromDir(facing)];
    }

    @Override
    public void setDeltaRotation(double rotation, ForgeDirection facing) {
        this.rotation[this.getIDFromDir((ForgeDirection)facing)] = this.getRotation(facing);
        this.lastTimeModification = this.getWorldTime();
        this.angularVelocity[this.getIDFromDir((ForgeDirection)facing)] = rotation;
    }

    @Override
    public double getMaxRotationalAcceleration() {
        return 2.0E-5;
    }

    private long getWorldTime() {
        return AdvancedRocketry.proxy.getWorldTimeUniversal(Configuration.spaceDimId);
    }

    public int getLaunchPosX() {
        return this.launchPosX;
    }

    public int getLaunchPosZ() {
        return this.launchPosZ;
    }

    public int getOrbitalPosX() {
        return this.posX;
    }

    public int getOrbitalPosZ() {
        return this.posZ;
    }

    public double getOrbitalVelocity() {
        return 0.0;
    }

    @Override
    public BlockPosition getSpawnLocation() {
        return this.spawnLocation;
    }

    public void addWarpCore(BlockPosition position) {
        this.warpCoreLocation.add(position);
        this.hasWarpCores = true;
    }

    public void removeWarpCore(BlockPosition position) {
        this.warpCoreLocation.remove(position);
        if (this.warpCoreLocation.isEmpty()) {
            this.hasWarpCores = false;
        }
    }

    public List<BlockPosition> getWarpCoreLocations() {
        return this.warpCoreLocation;
    }

    public boolean hasUsableWarpCore() {
        return this.hasWarpCores && this.properties.getParentPlanet() != Integer.MIN_VALUE && this.getDestOrbitingBody() != this.getOrbitingPlanetId();
    }

    public int getFuelAmount() {
        return this.fuelAmount;
    }

    public int getMaxFuelAmount() {
        return 1000;
    }

    public void setFuelAmount(int amt) {
        this.fuelAmount = amt;
    }

    public int addFuel(int amt) {
        if (amt < 0) {
            return amt;
        }
        int oldFuelAmt = this.fuelAmount;
        this.fuelAmount = Math.min(this.fuelAmount + amt, 1000);
        amt = this.fuelAmount - oldFuelAmt;
        if (FMLCommonHandler.instance().getSide().isServer()) {
            PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(this, PacketStationUpdate.Type.FUEL_UPDATE));
        }
        return amt;
    }

    public int useFuel(int amt) {
        if (amt > this.getFuelAmount()) {
            return 0;
        }
        this.fuelAmount -= amt;
        if (FMLCommonHandler.instance().getSide().isServer()) {
            PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(this, PacketStationUpdate.Type.FUEL_UPDATE));
        }
        return amt;
    }

    @Override
    public void addLandingPad(int x, int z, String name) {
        StationLandingLocation pos = new StationLandingLocation(new BlockPosition(x, 0, z), name);
        if (!this.spawnLocations.contains(pos)) {
            this.spawnLocations.add(pos);
            pos.setOccupied(false);
        }
    }

    public void addDockingPosition(int x, int y, int z, String str) {
        BlockPosition pos = new BlockPosition(x, y, z);
        this.dockingPoints.put(pos, str);
    }

    @Override
    public void removeLandingPad(int x, int z) {
        BlockPosition pos = new BlockPosition(x, 0, z);
        Iterator<StationLandingLocation> itr = this.spawnLocations.iterator();
        while (itr.hasNext()) {
            StationLandingLocation loc = itr.next();
            if (!loc.getPos().equals((Object)pos)) continue;
            itr.remove();
        }
    }

    public void removeDockingPosition(int x, int y, int z) {
        BlockPosition pos = new BlockPosition(x, y, z);
        this.dockingPoints.remove(pos);
    }

    @Override
    public BlockPosition getNextLandingPad(boolean commit) {
        for (StationLandingLocation pos : this.spawnLocations) {
            if (pos.getOccupied()) continue;
            if (commit) {
                pos.setOccupied(true);
            }
            return pos.getPos();
        }
        return null;
    }

    public List<StationLandingLocation> getLandingPads() {
        return this.spawnLocations;
    }

    @Override
    public boolean hasFreeLandingPad() {
        for (StationLandingLocation pos : this.spawnLocations) {
            if (pos.getOccupied()) continue;
            return true;
        }
        return false;
    }

    public void setPadStatus(BlockPosition pos, boolean full) {
        this.setPadStatus(pos.x, pos.z, full);
    }

    public StationLandingLocation getPadAtLocation(int x, int z) {
        return this.getPadAtLocation(new BlockPosition(x, 0, z));
    }

    public StationLandingLocation getPadAtLocation(BlockPosition pos) {
        pos.y = 0;
        for (StationLandingLocation loc : this.spawnLocations) {
            if (!loc.equals(pos)) continue;
            return loc;
        }
        return null;
    }

    public void setPadName(World worldObj, int x, int y, int z, String name) {
        this.setPadName(worldObj, new BlockPosition(x, 0, z), name);
    }

    public void setPadName(World worldObj, BlockPosition pos, String name) {
        StationLandingLocation loc = this.getPadAtLocation(pos);
        if (loc != null) {
            loc.setName(name);
        }
        if (!worldObj.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketSpaceStationInfo(this.getId(), this));
        }
    }

    @Override
    public void setPadStatus(int x, int z, boolean full) {
        StationLandingLocation pos = new StationLandingLocation(new BlockPosition(x, 0, z));
        for (StationLandingLocation loc : this.spawnLocations) {
            if (!loc.equals(pos)) continue;
            loc.setOccupied(full);
        }
    }

    @Override
    public void setId(int id) {
        this.properties.setId(id);
    }

    @Override
    public void setPos(int posX, int posY) {
        this.posX = posX;
        this.posZ = posY;
    }

    public void setLaunchPos(int posX, int posY) {
        this.launchPosX = posX;
        this.launchPosZ = posY;
    }

    @Override
    public void setSpawnLocation(int x, int y, int z) {
        this.spawnLocation = new BlockPosition(x, y, z);
    }

    @Override
    public void setOrbitingBody(int id) {
        if (id == this.getOrbitingPlanetId()) {
            return;
        }
        this.properties.setParentPlanet(DimensionManager.getInstance().getDimensionProperties(id), false);
        if (id != Integer.MIN_VALUE) {
            this.destinationDimId = id;
        }
    }

    @Override
    public void setDestOrbitingBody(int id) {
        this.destinationDimId = id;
        if (FMLCommonHandler.instance().getSide().isServer()) {
            PacketHandler.sendToAll((BasePacket)new PacketStationUpdate(this, PacketStationUpdate.Type.DEST_ORBIT_UPDATE));
        }
    }

    @Override
    public int getDestOrbitingBody() {
        return this.destinationDimId;
    }

    @Override
    public void onModuleUnpack(IStorageChunk chunk) {
        if (net.minecraftforge.common.DimensionManager.isDimensionRegistered((int)Configuration.spaceDimId) && net.minecraftforge.common.DimensionManager.getWorld((int)Configuration.spaceDimId) == null) {
            net.minecraftforge.common.DimensionManager.initDimension((int)Configuration.spaceDimId);
        }
        WorldServer worldObj = net.minecraftforge.common.DimensionManager.getWorld((int)Configuration.spaceDimId);
        if (!this.created) {
            chunk.pasteInWorld((World)worldObj, this.spawnLocation.x - chunk.getSizeX() / 2, this.spawnLocation.y - chunk.getSizeY() / 2, this.spawnLocation.z - chunk.getSizeZ() / 2);
            this.created = true;
            this.setLaunchPos(this.posX, this.posZ);
            this.setPos(this.posX, this.posZ);
        } else {
            List<TileEntity> tiles = chunk.getTileEntityList();
            LinkedList<String> targetIds = new LinkedList<String>();
            LinkedList<TileEntity> myPoss = new LinkedList<TileEntity>();
            BlockPosition pos = null;
            TileDockingPort destTile = null;
            TileDockingPort srcTile = null;
            for (TileEntity tileEntity : tiles) {
                if (!(tileEntity instanceof TileDockingPort)) continue;
                targetIds.add(((TileDockingPort)tileEntity).getTargetId());
                myPoss.add(tileEntity);
            }
            for (Map.Entry entry : this.dockingPoints.entrySet()) {
                if (!targetIds.contains(entry.getValue())) continue;
                int loc = targetIds.indexOf(entry.getValue());
                pos = (BlockPosition)entry.getKey();
                TileEntity tile = worldObj.func_147438_o(pos.x, (int)pos.y, pos.z);
                if (!(tile instanceof TileDockingPort)) continue;
                destTile = (TileDockingPort)tile;
                srcTile = (TileDockingPort)((Object)myPoss.get(loc));
                break;
            }
            if (destTile != null) {
                ForgeDirection stationFacing = BlockFullyRotatable.getFront((int)destTile.func_145832_p());
                ForgeDirection forgeDirection = BlockFullyRotatable.getFront((int)srcTile.func_145832_p());
                ForgeDirection cross = forgeDirection.getRotation(stationFacing);
                if (cross == forgeDirection) {
                    if (forgeDirection == stationFacing) {
                        if (cross == ForgeDirection.DOWN || cross == ForgeDirection.UP) {
                            chunk.rotateBy(ForgeDirection.NORTH);
                            chunk.rotateBy(ForgeDirection.NORTH);
                        } else {
                            chunk.rotateBy(ForgeDirection.UP);
                            chunk.rotateBy(ForgeDirection.UP);
                        }
                    }
                } else if (cross.getOpposite() != forgeDirection) {
                    chunk.rotateBy(stationFacing.offsetY == 0 ? cross : cross.getOpposite());
                }
                int xCoord = (stationFacing.offsetX == 0 ? -srcTile.field_145851_c : srcTile.field_145851_c * stationFacing.offsetX) + stationFacing.offsetX + destTile.field_145851_c;
                int yCoord = (stationFacing.offsetY == 0 ? -srcTile.field_145848_d : srcTile.field_145848_d * stationFacing.offsetY) + stationFacing.offsetY + destTile.field_145848_d;
                int zCoord = (stationFacing.offsetZ == 0 ? -srcTile.field_145849_e : srcTile.field_145849_e * stationFacing.offsetZ) + stationFacing.offsetZ + destTile.field_145849_e;
                chunk.pasteInWorld((World)worldObj, xCoord, yCoord, zCoord);
                worldObj.func_147468_f(destTile.field_145851_c + stationFacing.offsetX, destTile.field_145848_d + stationFacing.offsetY, destTile.field_145849_e + stationFacing.offsetZ);
                worldObj.func_147468_f(destTile.field_145851_c, destTile.field_145848_d, destTile.field_145849_e);
            }
        }
    }

    @Override
    public void writeToNbt(NBTTagCompound nbt) {
        NBTTagCompound tag;
        this.properties.writeToNBT(nbt);
        nbt.func_74757_a("created", this.created);
        nbt.func_74768_a("id", this.getId());
        nbt.func_74768_a("launchposX", this.launchPosX);
        nbt.func_74768_a("launchposY", this.launchPosZ);
        nbt.func_74768_a("posX", this.posX);
        nbt.func_74768_a("posY", this.posZ);
        nbt.func_74768_a("alitude", this.altitude);
        nbt.func_74768_a("spawnX", this.spawnLocation.x);
        nbt.func_74768_a("spawnY", (int)this.spawnLocation.y);
        nbt.func_74768_a("spawnZ", this.spawnLocation.z);
        nbt.func_74768_a("destinationDimId", this.destinationDimId);
        nbt.func_74768_a("fuel", this.fuelAmount);
        nbt.func_74780_a("rotationX", this.rotation[0]);
        nbt.func_74780_a("rotationY", this.rotation[1]);
        nbt.func_74780_a("rotationZ", this.rotation[2]);
        nbt.func_74780_a("deltaRotationX", this.angularVelocity[0]);
        nbt.func_74780_a("deltaRotationY", this.angularVelocity[1]);
        nbt.func_74780_a("deltaRotationZ", this.angularVelocity[2]);
        int[] array = new int[this.knownPlanetList.size()];
        int j = 0;
        for (int i : this.knownPlanetList) {
            array[j++] = i;
        }
        nbt.func_74783_a("knownPlanets", array);
        if (this.direction != null) {
            nbt.func_74768_a("direction", this.direction.ordinal());
        }
        if (this.transitionEta > -1L) {
            nbt.func_74772_a("transitionEta", this.transitionEta);
        }
        NBTTagList list = new NBTTagList();
        for (StationLandingLocation stationLandingLocation : this.spawnLocations) {
            tag = new NBTTagCompound();
            tag.func_74757_a("occupied", stationLandingLocation.getOccupied());
            tag.func_74783_a("pos", new int[]{stationLandingLocation.getPos().x, stationLandingLocation.getPos().z});
            if (stationLandingLocation.getName() != null && !stationLandingLocation.getName().isEmpty()) {
                tag.func_74778_a("name", stationLandingLocation.getName());
            }
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("spawnPositions", (NBTBase)list);
        list = new NBTTagList();
        for (BlockPosition blockPosition : this.warpCoreLocation) {
            tag = new NBTTagCompound();
            tag.func_74783_a("pos", new int[]{blockPosition.x, blockPosition.y, blockPosition.z});
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("warpCorePositions", (NBTBase)list);
        list = new NBTTagList();
        for (Map.Entry entry : this.dockingPoints.entrySet()) {
            tag = new NBTTagCompound();
            BlockPosition pos = (BlockPosition)entry.getKey();
            String str = (String)entry.getValue();
            tag.func_74783_a("pos", new int[]{pos.x, pos.y, pos.z});
            tag.func_74778_a("id", str);
            list.func_74742_a((NBTBase)tag);
        }
        nbt.func_74782_a("dockingPositons", (NBTBase)list);
    }

    @Override
    public void readFromNbt(NBTTagCompound nbt) {
        BlockPosition pos;
        int i;
        this.properties.readFromNBT(nbt);
        if ((int)this.orbitalDistance != this.properties.getParentOrbitalDistance()) {
            this.orbitalDistance = this.properties.getParentOrbitalDistance();
        }
        this.destinationDimId = nbt.func_74762_e("destinationDimId");
        this.launchPosX = nbt.func_74762_e("launchposX");
        this.launchPosZ = nbt.func_74762_e("launchposY");
        this.posX = nbt.func_74762_e("posX");
        this.posZ = nbt.func_74762_e("posY");
        this.created = nbt.func_74767_n("created");
        this.altitude = nbt.func_74762_e("altitude");
        this.fuelAmount = nbt.func_74762_e("fuel");
        this.spawnLocation = new BlockPosition(nbt.func_74762_e("spawnX"), nbt.func_74762_e("spawnY"), nbt.func_74762_e("spawnZ"));
        this.properties.setId(nbt.func_74762_e("id"));
        this.rotation[0] = nbt.func_74769_h("rotationX");
        this.rotation[1] = nbt.func_74769_h("rotationY");
        this.rotation[2] = nbt.func_74769_h("rotationZ");
        this.angularVelocity[0] = nbt.func_74769_h("deltaRotationX");
        this.angularVelocity[1] = nbt.func_74769_h("deltaRotationY");
        this.angularVelocity[2] = nbt.func_74769_h("deltaRotationZ");
        int[] array = nbt.func_74759_k("knownPlanets");
        boolean j = false;
        for (int i2 : array) {
            this.knownPlanetList.add(i2);
        }
        if (nbt.func_74764_b("direction")) {
            this.direction = ForgeDirection.getOrientation((int)nbt.func_74762_e("direction"));
        }
        if (nbt.func_74764_b("transitionEta")) {
            this.transitionEta = nbt.func_74763_f("transitionEta");
        }
        NBTTagList list = nbt.func_150295_c("spawnPositions", 10);
        this.spawnLocations.clear();
        for (i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int[] posInt = tag.func_74759_k("pos");
            pos = new BlockPosition(posInt[0], 0, posInt[1]);
            StationLandingLocation loc = new StationLandingLocation(pos, tag.func_74779_i("name"));
            this.spawnLocations.add(loc);
            loc.setOccupied(tag.func_74767_n("occupied"));
        }
        list = nbt.func_150295_c("warpCorePositions", 10);
        this.warpCoreLocation.clear();
        this.hasWarpCores = false;
        for (i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int[] posInt = tag.func_74759_k("pos");
            pos = new BlockPosition(posInt[0], posInt[1], posInt[2]);
            this.warpCoreLocation.add(pos);
            this.hasWarpCores = true;
        }
        list = nbt.func_150295_c("dockingPositons", 10);
        this.dockingPoints.clear();
        for (i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound tag = list.func_150305_b(i);
            int[] posInt = tag.func_74759_k("pos");
            pos = new BlockPosition(posInt[0], posInt[1], posInt[2]);
            String str = tag.func_74779_i("id");
            this.dockingPoints.put(pos, str);
        }
    }

    @Override
    public boolean hasCustomSpawnLocation() {
        return false;
    }

    @Override
    public float getOrbitalDistance() {
        return this.orbitalDistance;
    }

    @Override
    public void setOrbitalDistance(float finalVel) {
        if ((int)this.orbitalDistance != this.properties.getParentOrbitalDistance()) {
            this.properties.setParentOrbitalDistance((int)this.orbitalDistance);
        }
        this.orbitalDistance = finalVel;
    }

    @Override
    public boolean isPlanetKnown(IDimensionProperties properties) {
        return !Configuration.planetsMustBeDiscovered || this.knownPlanetList.contains(properties.getId()) || DimensionManager.getInstance().knownPlanets.contains(properties.getId());
    }

    @Override
    public boolean isStarKnown(StellarBody body) {
        return true;
    }
}

