/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.satellite;

import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.oredict.OreDictionary;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.item.ItemOreScanner;

public class SatelliteOreMapping
extends SatelliteBase {
    int blockCenterX;
    int blockCenterZ;
    public static ArrayList<Integer> oreList = new ArrayList();
    ItemStack inv;
    int selectedSlot = -1;

    public void setSelectedSlot(int i) {
        if (this.canFilterOre()) {
            this.selectedSlot = i;
        }
    }

    public int getSelectedSlot() {
        return this.selectedSlot;
    }

    @Override
    public String getInfo(World world) {
        return "Operational";
    }

    @Override
    public boolean acceptsItemInConstruction(ItemStack item) {
        int flag = SatelliteRegistry.getSatelliteProperty(item).getPropertyFlag();
        return SatelliteProperties.Property.MAIN.isOfType(flag) || SatelliteProperties.Property.POWER_GEN.isOfType(flag) || SatelliteProperties.Property.DATA.isOfType(flag);
    }

    @Override
    public boolean isAcceptableControllerItemStack(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemOreScanner;
    }

    @Override
    public ItemStack getContollerItemStack(ItemStack satIdChip, SatelliteProperties properties) {
        ItemStack stack = new ItemStack(AdvancedRocketryItems.itemOreScanner);
        ItemOreScanner scanner = (ItemOreScanner)AdvancedRocketryItems.itemOreScanner;
        scanner.setSatelliteID(stack, properties.getId());
        return stack;
    }

    @Override
    public boolean performAction(EntityPlayer player, World world, int x, int y, int z) {
        player.openGui((Object)AdvancedRocketry.instance, 100, world, x, y, z);
        return true;
    }

    public static int[][] scanChunk(World world, int offsetX, int offsetZ, int radius, int blocksPerPixel, ItemStack block) {
        blocksPerPixel = Math.max(blocksPerPixel, 1);
        int[][] ret = new int[radius * 2 / blocksPerPixel][radius * 2 / blocksPerPixel];
        Chunk chunk = world.func_72938_d(offsetX, offsetZ);
        IChunkProvider provider = world.func_72863_F();
        for (int z = -radius; z < radius; z += blocksPerPixel) {
            for (int x = -radius; x < radius; x += blocksPerPixel) {
                int oreCount = 0;
                int otherCount = 0;
                for (int y = world.func_72800_K(); y > 0; --y) {
                    for (int deltaY = 0; deltaY < blocksPerPixel; ++deltaY) {
                        for (int deltaZ = 0; deltaZ < blocksPerPixel; ++deltaZ) {
                            if (world.func_147437_c(x + offsetX, y, z + offsetZ)) continue;
                            boolean found = false;
                            if (world.func_147439_a(x + offsetX, y, z + offsetZ).getDrops(world, x + offsetX, y, z + offsetZ, world.func_72805_g(x + offsetX, y, z + offsetZ), 0) != null) {
                                for (ItemStack stack : world.func_147439_a(x + offsetX, y, z + offsetZ).getDrops(world, x + offsetX, y, z + offsetZ, world.func_72805_g(x + offsetX, y, z + offsetZ), 0)) {
                                    if (stack.func_77973_b() != block.func_77973_b() || stack.func_77960_j() != block.func_77960_j()) continue;
                                    ++oreCount;
                                    found = true;
                                }
                            }
                            if (found) continue;
                            ++otherCount;
                        }
                    }
                }
                oreCount = (int)((double)oreCount / Math.pow(blocksPerPixel, 2.0));
                otherCount = (int)((double)otherCount / Math.pow(blocksPerPixel, 2.0));
                if (Thread.interrupted()) {
                    return null;
                }
                ret[(x + radius) / blocksPerPixel][(z + radius) / blocksPerPixel] = (int)((float)oreCount / (float)Math.max(otherCount, 1) * 65535.0f);
            }
        }
        return ret;
    }

    public static int[][] scanChunk(World world, int offsetX, int offsetZ, int radius, int blocksPerPixel) {
        blocksPerPixel = Math.max(blocksPerPixel, 1);
        int[][] ret = new int[radius * 2 / blocksPerPixel][radius * 2 / blocksPerPixel];
        Chunk chunk = world.func_72938_d(offsetX, offsetZ);
        IChunkProvider provider = world.func_72863_F();
        if (oreList.isEmpty()) {
            String[] strings;
            for (String str : strings = OreDictionary.getOreNames()) {
                if (!str.startsWith("ore") && !str.startsWith("dust") && !str.startsWith("gem")) continue;
                oreList.add(OreDictionary.getOreID((String)str));
            }
        }
        for (int z = -radius; z < radius; z += blocksPerPixel) {
            for (int x = -radius; x < radius; x += blocksPerPixel) {
                int oreCount = 0;
                int otherCount = 0;
                for (int y = world.func_72800_K(); y > 0; --y) {
                    for (int deltaY = 0; deltaY < blocksPerPixel; ++deltaY) {
                        for (int deltaZ = 0; deltaZ < blocksPerPixel; ++deltaZ) {
                            if (world.func_147437_c(x + offsetX, y, z + offsetZ)) continue;
                            boolean exists = false;
                            block6: for (int i : oreList) {
                                ArrayList itemlist = OreDictionary.getOres((Integer)i);
                                for (ItemStack item : itemlist) {
                                    if (item.func_77973_b() != Item.func_150898_a((Block)world.func_147439_a(x + offsetX, y, z + offsetZ))) continue;
                                    exists = true;
                                    break block6;
                                }
                            }
                            if (exists) {
                                ++oreCount;
                                continue;
                            }
                            ++otherCount;
                        }
                    }
                }
                oreCount = (int)((double)oreCount / Math.pow(blocksPerPixel, 2.0));
                otherCount = (int)((double)otherCount / Math.pow(blocksPerPixel, 2.0));
                if (Thread.interrupted()) {
                    return null;
                }
                ret[(x + radius) / blocksPerPixel][(z + radius) / blocksPerPixel] = (int)((float)oreCount / (float)Math.max(otherCount, 1) * 65535.0f);
            }
        }
        return ret;
    }

    @Override
    public double failureChance() {
        return 0.0;
    }

    @Override
    public String getName() {
        return "Ore Mapper";
    }

    @Override
    public boolean canTick() {
        return false;
    }

    @Override
    public void tickEntity() {
    }

    public int getZoomRadius() {
        return Math.min(this.satelliteProperties.getPowerGeneration(), 7);
    }

    public boolean canFilterOre() {
        return this.satelliteProperties.getMaxDataStorage() == 3000;
    }
}

