/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.satellite;

import cpw.mods.fml.common.eventhandler.Event;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.entity.EntityLaserNode;
import zmaster587.advancedRocketry.event.BlockBreakEvent;
import zmaster587.advancedRocketry.satellite.SatelliteLaserNoDrill;
import zmaster587.libVulpes.util.ZUtils;

public class SatelliteLaser
extends SatelliteLaserNoDrill {
    private EntityLaserNode laser;
    private ForgeChunkManager.Ticket ticketLaser;
    protected boolean finished = false;

    public SatelliteLaser(IInventory boundChest) {
        super(boundChest);
    }

    @Override
    public boolean isAlive() {
        return this.laser != null && !this.laser.field_70128_L && this.laser.field_70170_p != null;
    }

    @Override
    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public boolean getJammed() {
        return this.jammed;
    }

    @Override
    public void setJammed(boolean newJam) {
        this.jammed = newJam;
    }

    @Override
    public void deactivateLaser() {
        if (this.laser != null) {
            this.laser.func_70106_y();
            this.laser = null;
        }
        if (this.ticketLaser != null) {
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)this.ticketLaser);
        }
        this.finished = false;
    }

    @Override
    public boolean activateLaser(World world, int x, int z) {
        this.ticketLaser = ForgeChunkManager.requestTicket((Object)AdvancedRocketry.instance, (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (this.ticketLaser != null) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)this.ticketLaser, (ChunkCoordIntPair)new ChunkCoordIntPair(x >> 4, z >> 4));
            int y = 64;
            if (world.func_72938_d((int)x, (int)z).field_76636_d) {
                int current = 0;
                for (int i = 0; i < 9; ++i) {
                    current = world.func_72825_h(x + i % 3 - 1, z + i / 3 - 1);
                    if (current <= y) continue;
                    y = current;
                }
                if (y < 1) {
                    y = 255;
                }
            } else {
                y = 255;
            }
            this.laser = new EntityLaserNode(world, x, y, z);
            this.laser.field_98038_p = true;
            world.func_72838_d((Entity)this.laser);
            return true;
        }
        return false;
    }

    @Override
    public void performOperation() {
        for (int i = 0; i < 9; ++i) {
            int x = (int)this.laser.field_70165_t + i % 3 - 1;
            int z = (int)this.laser.field_70161_v + i / 3 - 1;
            Block dropBlock = this.laser.field_70170_p.func_147439_a(x, (int)this.laser.field_70163_u, z);
            BlockBreakEvent.LaserBreakEvent event = new BlockBreakEvent.LaserBreakEvent(x, (int)this.laser.field_70163_u, z);
            MinecraftForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) continue;
            if (dropBlock == null || dropBlock.func_149688_o().func_76222_j() || dropBlock.func_149688_o().func_76224_d()) {
                this.laser.field_70170_p.func_147465_d(x, (int)this.laser.field_70163_u, z, AdvancedRocketryBlocks.blockLightSource, 0, 3);
                continue;
            }
            ArrayList items = dropBlock.getDrops(this.laser.field_70170_p, x, (int)this.laser.field_70163_u, z, this.laser.field_70170_p.func_72805_g(x, (int)this.laser.field_70163_u, z), 0);
            if (!dropBlock.func_149688_o().func_76218_k() || dropBlock == Blocks.field_150357_h) continue;
            if (items.isEmpty()) {
                this.laser.field_70170_p.func_147465_d((int)this.laser.field_70165_t, (int)this.laser.field_70163_u, (int)this.laser.field_70161_v, AdvancedRocketryBlocks.blockLightSource, 0, 3);
                continue;
            }
            if (this.boundChest != null) {
                ItemStack[] stacks = new ItemStack[items.size()];
                stacks = items.toArray(stacks);
                ZUtils.mergeInventory((ItemStack[])stacks, (IInventory)this.boundChest);
                if (!ZUtils.isInvEmpty((ItemStack[])stacks)) {
                    this.deactivateLaser();
                    this.jammed = true;
                    return;
                }
            }
            this.laser.field_70170_p.func_147465_d(x, (int)this.laser.field_70163_u, z, AdvancedRocketryBlocks.blockLightSource, 0, 3);
        }
        boolean blockInWay = false;
        block1: do {
            if (this.laser.field_70163_u < 1.0) {
                this.laser.func_70106_y();
                this.laser = null;
                this.finished = true;
                break;
            }
            this.laser.func_70107_b((int)this.laser.field_70165_t, this.laser.field_70163_u - 1.0, (int)this.laser.field_70161_v);
            for (int i = 0; i < 9; ++i) {
                int x = (int)this.laser.field_70165_t + i % 3 - 1;
                int z = (int)this.laser.field_70161_v + i / 3 - 1;
                Block dropBlock = this.laser.field_70170_p.func_147439_a(x, (int)this.laser.field_70163_u, z);
                if (!dropBlock.func_149688_o().func_76218_k() || dropBlock == Blocks.field_150357_h) continue;
                if (dropBlock == null || dropBlock.func_149688_o().func_76224_d()) {
                    this.laser.field_70170_p.func_147468_f(x, (int)this.laser.field_70163_u, z);
                    continue;
                }
                if (dropBlock == null) continue;
                blockInWay = true;
                continue block1;
            }
        } while (!blockInWay);
    }

    @Override
    public String getInfo(World world) {
        return null;
    }

    @Override
    public String getName() {
        return "Laser";
    }

    @Override
    public boolean performAction(EntityPlayer player, World world, int x, int y, int z) {
        this.performOperation();
        return false;
    }

    @Override
    public double failureChance() {
        return 0.0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74757_a("finished", this.finished);
        nbt.func_74757_a("jammed", this.jammed);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        this.finished = nbt.func_74767_n("finished");
        this.jammed = nbt.func_74767_n("jammed");
    }

    @Override
    public boolean canTick() {
        return false;
    }

    @Override
    public void tickEntity() {
    }
}

