/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.satellite;

import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.DimensionManager;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.item.ItemBiomeChanger;
import zmaster587.advancedRocketry.satellite.SatelliteEnergy;
import zmaster587.advancedRocketry.util.BiomeHandler;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.util.BlockPosition;

public class SatelliteBiomeChanger
extends SatelliteEnergy
implements IUniversalEnergy {
    private int biomeId;
    private int radius = 4;
    private List<BlockPosition> toChangeList = new LinkedList<BlockPosition>();
    private Set<Byte> discoveredBiomes = new HashSet<Byte>();
    private static int MAX_SIZE = 1024;

    public void setBiome(int biomeId) {
        this.biomeId = biomeId;
    }

    public int getBiome() {
        return this.biomeId;
    }

    public Set<Byte> discoveredBiomes() {
        return this.discoveredBiomes;
    }

    public void addBiome(int biome) {
        byte byteBiome = (byte)biome;
        if (biome != BiomeGenBase.field_76779_k.field_76756_M && biome != BiomeGenBase.field_76778_j.field_76756_M && biome != BiomeGenBase.field_76781_i.field_76756_M && biome != AdvancedRocketryBiomes.spaceBiome.field_76756_M) {
            this.discoveredBiomes.add(byteBiome);
        }
    }

    @Override
    public String getInfo(World world) {
        return "Ready";
    }

    @Override
    public String getName() {
        return "Biome Changer";
    }

    @Override
    public ItemStack getContollerItemStack(ItemStack satIdChip, SatelliteProperties properties) {
        ItemBiomeChanger idChipItem = (ItemBiomeChanger)satIdChip.func_77973_b();
        idChipItem.setSatellite(satIdChip, properties);
        return satIdChip;
    }

    @Override
    public boolean isAcceptableControllerItemStack(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ItemBiomeChanger;
    }

    @Override
    public boolean canTick() {
        return true;
    }

    @Override
    public void tickEntity() {
        WorldServer world = DimensionManager.getWorld((int)this.getDimensionId());
        if (world != null) {
            for (int i = 0; i < 10; ++i) {
                if (world.func_82737_E() % 1L != 0L || this.toChangeList.isEmpty()) continue;
                if (this.extractEnergy(10, true) != 10) break;
                this.extractEnergy(10, false);
                BlockPosition pos = this.toChangeList.remove(world.field_73012_v.nextInt(this.toChangeList.size()));
                BiomeHandler.changeBiome((World)world, this.biomeId, pos.x, pos.z);
            }
        }
    }

    public void addBlockToList(BlockPosition pos) {
        if (this.toChangeList.size() < MAX_SIZE) {
            this.toChangeList.add(pos);
        }
    }

    @Override
    public boolean performAction(EntityPlayer player, World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return false;
        }
        HashSet set = new HashSet();
        this.radius = 16;
        MAX_SIZE = 1024;
        for (int xx = -this.radius + x; xx < this.radius + x; ++xx) {
            for (int zz = -this.radius + z; zz < this.radius + z; ++zz) {
                this.addBlockToList(new BlockPosition(xx, 0, zz));
            }
        }
        return false;
    }

    @Override
    public double failureChance() {
        return 0.0;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        int i;
        super.writeToNBT(nbt);
        nbt.func_74768_a("biomeId", this.biomeId);
        int[] array = new int[this.toChangeList.size() * 3];
        Iterator<BlockPosition> itr = this.toChangeList.iterator();
        for (i = 0; i < this.toChangeList.size(); i += 3) {
            BlockPosition pos = itr.next();
            array[i] = pos.x;
            array[i + 1] = pos.y;
            array[i + 2] = pos.z;
        }
        nbt.func_74782_a("posList", (NBTBase)new NBTTagIntArray(array));
        array = new int[this.discoveredBiomes.size()];
        i = 0;
        for (byte biome : this.discoveredBiomes) {
            array[i] = biome;
            ++i;
        }
        nbt.func_74782_a("biomeList", (NBTBase)new NBTTagIntArray(array));
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int i;
        super.readFromNBT(nbt);
        this.biomeId = nbt.func_74762_e("biomeId");
        int[] array = nbt.func_74759_k("posList");
        this.toChangeList.clear();
        for (i = 0; i < array.length; i += 3) {
            this.toChangeList.add(new BlockPosition(array[i], array[i + 1], array[i + 2]));
        }
        array = nbt.func_74759_k("biomeList");
        this.discoveredBiomes.clear();
        for (i = 0; i < array.length; ++i) {
            this.discoveredBiomes.add((byte)array[i]);
        }
    }

    public void setEnergyStored(int amt) {
        this.battery.setEnergyStored(amt);
    }

    public int extractEnergy(int amt, boolean simulate) {
        WorldServer world;
        if (this.getDimensionId() != -1 && (world = DimensionManager.getWorld((int)this.getDimensionId())) != null) {
            this.battery.acceptEnergy(this.energyCreated((World)world), false);
        }
        return this.battery.extractEnergy(amt, simulate);
    }

    public int getEnergyStored() {
        WorldServer world;
        if (this.getDimensionId() != -1 && (world = DimensionManager.getWorld((int)this.getDimensionId())) != null) {
            this.battery.acceptEnergy(this.energyCreated((World)world), false);
        }
        return this.battery.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.battery.getMaxEnergyStored();
    }

    public void setMaxEnergyStored(int max) {
        this.battery.setMaxEnergyStored(max);
    }

    public int acceptEnergy(int amt, boolean simulate) {
        return this.battery.acceptEnergy(amt, simulate);
    }
}

