/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.logging.Logger;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.event.PlanetEventHandler;
import zmaster587.advancedRocketry.stations.SpaceObject;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.network.BasePacket;

public class PacketStationUpdate
extends BasePacket {
    ISpaceObject spaceObject;
    int stationNumber;
    Type type;

    public PacketStationUpdate() {
    }

    public PacketStationUpdate(ISpaceObject dimProperties, Type type) {
        this.spaceObject = (SpaceObject)dimProperties;
        this.stationNumber = dimProperties.getId();
        this.type = type;
    }

    public void write(ByteBuf out) {
        out.writeInt(this.stationNumber);
        out.writeInt(this.type.ordinal());
        switch (this.type) {
            case DEST_ORBIT_UPDATE: {
                out.writeInt(this.spaceObject.getDestOrbitingBody());
                break;
            }
            case ORBIT_UPDATE: {
                out.writeInt(this.spaceObject.getOrbitingPlanetId());
                break;
            }
            case FUEL_UPDATE: {
                if (!(this.spaceObject instanceof SpaceObject)) break;
                out.writeInt(((SpaceObject)this.spaceObject).getFuelAmount());
                break;
            }
            case ROTANGLE_UPDATE: {
                out.writeDouble(this.spaceObject.getRotation(ForgeDirection.EAST));
                out.writeDouble(this.spaceObject.getRotation(ForgeDirection.UP));
                out.writeDouble(this.spaceObject.getRotation(ForgeDirection.NORTH));
                out.writeDouble(this.spaceObject.getDeltaRotation(ForgeDirection.EAST));
                out.writeDouble(this.spaceObject.getDeltaRotation(ForgeDirection.UP));
                out.writeDouble(this.spaceObject.getDeltaRotation(ForgeDirection.NORTH));
                break;
            }
            case ALTITUDE_UPDATE: {
                out.writeFloat(this.spaceObject.getOrbitalDistance());
                break;
            }
            case DIM_PROPERTY_UPDATE: {
                NBTTagCompound nbt = new NBTTagCompound();
                try {
                    this.spaceObject.getProperties().writeToNBT(nbt);
                    PacketBuffer packetBuffer = new PacketBuffer(out);
                    try {
                        packetBuffer.func_150786_a(nbt);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    break;
                }
                catch (NullPointerException e) {
                    out.writeBoolean(true);
                    Logger.getLogger("advancedRocketry").warning("Dimension " + this.stationNumber + " has thrown an exception trying to write NBT, deleting!");
                    DimensionManager.getInstance().deleteDimension(this.stationNumber);
                }
            }
        }
    }

    public void readClient(ByteBuf in) {
        this.stationNumber = in.readInt();
        this.spaceObject = SpaceObjectManager.getSpaceManager().getSpaceStation(this.stationNumber);
        this.type = Type.values()[in.readInt()];
        switch (this.type) {
            case DEST_ORBIT_UPDATE: {
                this.spaceObject.setDestOrbitingBody(in.readInt());
                break;
            }
            case ORBIT_UPDATE: {
                this.spaceObject.setOrbitingBody(in.readInt());
                break;
            }
            case FUEL_UPDATE: {
                if (!(this.spaceObject instanceof SpaceObject)) break;
                ((SpaceObject)this.spaceObject).setFuelAmount(in.readInt());
                break;
            }
            case ROTANGLE_UPDATE: {
                this.spaceObject.setRotation(in.readDouble(), ForgeDirection.EAST);
                this.spaceObject.setRotation(in.readDouble(), ForgeDirection.UP);
                this.spaceObject.setRotation(in.readDouble(), ForgeDirection.NORTH);
                this.spaceObject.setDeltaRotation(in.readDouble(), ForgeDirection.EAST);
                this.spaceObject.setDeltaRotation(in.readDouble(), ForgeDirection.UP);
                this.spaceObject.setDeltaRotation(in.readDouble(), ForgeDirection.NORTH);
                break;
            }
            case SIGNAL_WHITE_BURST: {
                PlanetEventHandler.runBurst(Minecraft.func_71410_x().field_71441_e.func_82737_E() + 20L, 20L);
                break;
            }
            case ALTITUDE_UPDATE: {
                this.spaceObject.setOrbitalDistance(in.readFloat());
                break;
            }
            case DIM_PROPERTY_UPDATE: {
                NBTTagCompound nbt;
                PacketBuffer packetBuffer = new PacketBuffer(in);
                try {
                    nbt = packetBuffer.func_150793_b();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return;
                }
                this.spaceObject.getProperties().readFromNBT(nbt);
            }
        }
    }

    public void read(ByteBuf in) {
    }

    public void executeClient(EntityPlayer thePlayer) {
    }

    public void executeServer(EntityPlayerMP player) {
    }

    public static enum Type {
        DEST_ORBIT_UPDATE,
        ORBIT_UPDATE,
        SIGNAL_WHITE_BURST,
        FUEL_UPDATE,
        ROTANGLE_UPDATE,
        DIM_PROPERTY_UPDATE,
        ALTITUDE_UPDATE;

    }
}

