/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.stations.SpaceObject;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.network.BasePacket;

public class PacketSpaceStationInfo
extends BasePacket {
    SpaceObject spaceObject;
    int stationNumber;

    public PacketSpaceStationInfo() {
    }

    public PacketSpaceStationInfo(int stationNumber, ISpaceObject spaceObject) {
        this.spaceObject = (SpaceObject)spaceObject;
        this.stationNumber = stationNumber;
    }

    public void write(ByteBuf out) {
        NBTTagCompound nbt = new NBTTagCompound();
        out.writeInt(this.stationNumber);
        boolean flag = false;
        if (!flag) {
            try {
                this.spaceObject.getProperties().writeToNBT(nbt);
                PacketBuffer packetBuffer = new PacketBuffer(out);
                out.writeBoolean(false);
                try {
                    packetBuffer.func_150785_a(SpaceObjectManager.getSpaceManager().getItentifierFromClass(this.spaceObject.getClass()));
                    packetBuffer.func_150786_a(nbt);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                packetBuffer.writeBoolean(this.spaceObject.hasWarpCores);
                out.writeInt(this.spaceObject.getForwardDirection().ordinal());
            }
            catch (NullPointerException e) {
                out.writeBoolean(true);
                Logger.getLogger("advancedRocketry").warning("Dimension " + this.stationNumber + " has thrown an exception trying to write NBT, deleting!");
                DimensionManager.getInstance().deleteDimension(this.stationNumber);
            }
        } else {
            out.writeBoolean(flag);
        }
    }

    public void readClient(ByteBuf in) {
        PacketBuffer packetBuffer = new PacketBuffer(in);
        this.stationNumber = in.readInt();
        if (in.readBoolean()) {
            if (DimensionManager.getInstance().isDimensionCreated(this.stationNumber)) {
                DimensionManager.getInstance().deleteDimension(this.stationNumber);
            }
        } else {
            NBTTagCompound nbt;
            String clazzId;
            try {
                clazzId = packetBuffer.func_150789_c(127);
                nbt = packetBuffer.func_150793_b();
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            boolean hasWarpCores = in.readBoolean();
            int direction = in.readInt();
            ISpaceObject iObject = SpaceObjectManager.getSpaceManager().getSpaceStation(this.stationNumber);
            this.spaceObject = (SpaceObject)iObject;
            if (iObject == null) {
                ISpaceObject object = SpaceObjectManager.getSpaceManager().getNewSpaceObjectFromIdentifier(clazzId);
                object.setProperties(DimensionProperties.createFromNBT(this.stationNumber, nbt));
                ((SpaceObject)object).setForwardDirection(ForgeDirection.values()[direction]);
                ((SpaceObject)object).hasWarpCores = hasWarpCores;
                SpaceObjectManager.getSpaceManager().registerSpaceObjectClient(object, object.getOrbitingPlanetId(), this.stationNumber);
            } else {
                iObject.setProperties(DimensionProperties.createFromNBT(this.stationNumber, nbt));
                ((SpaceObject)iObject).setForwardDirection(ForgeDirection.values()[direction]);
                ((SpaceObject)iObject).hasWarpCores = hasWarpCores;
            }
        }
    }

    public void read(ByteBuf in) {
    }

    public void executeClient(EntityPlayer thePlayer) {
    }

    public void executeServer(EntityPlayerMP player) {
    }
}

