/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.libVulpes.network.BasePacket;

public class PacketDimInfo
extends BasePacket {
    DimensionProperties dimProperties;
    NBTTagCompound dimNBT;
    int dimNumber;
    boolean deleteDim;
    List<ItemStack> artifacts = new LinkedList<ItemStack>();

    public PacketDimInfo() {
    }

    public PacketDimInfo(int dimNumber, DimensionProperties dimProperties) {
        this();
        this.dimProperties = dimProperties;
        this.dimNumber = dimNumber;
    }

    public void write(ByteBuf out) {
        boolean flag;
        NBTTagCompound nbt = new NBTTagCompound();
        out.writeInt(this.dimNumber);
        boolean bl = flag = this.dimProperties == null;
        if (!flag) {
            try {
                this.dimProperties.writeToNBT(nbt);
                PacketBuffer packetBuffer = new PacketBuffer(out);
                out.writeBoolean(false);
                try {
                    packetBuffer.func_150786_a(nbt);
                    out.writeShort(this.dimProperties.getRequiredArtifacts().size());
                    for (ItemStack i : this.dimProperties.getRequiredArtifacts()) {
                        NBTTagCompound nbt2 = new NBTTagCompound();
                        i.func_77955_b(nbt2);
                        packetBuffer.func_150786_a(nbt2);
                    }
                }
                catch (Exception exception) {
                }
            }
            catch (NullPointerException e) {
                out.writeBoolean(true);
                e.printStackTrace();
                Logger.getLogger("advancedRocketry").warning("Dimension " + this.dimNumber + " has thrown an exception trying to write NBT, deleting!");
                DimensionManager.getInstance().deleteDimension(this.dimNumber);
            }
        } else {
            out.writeBoolean(flag);
        }
    }

    public void readClient(ByteBuf in) {
        PacketBuffer packetBuffer = new PacketBuffer(in);
        this.dimNumber = in.readInt();
        this.deleteDim = in.readBoolean();
        if (!this.deleteDim) {
            NBTTagCompound nbt;
            try {
                this.dimNBT = nbt = packetBuffer.func_150793_b();
                int number = packetBuffer.readShort();
                for (int i = 0; i < number; ++i) {
                    NBTTagCompound nbt2 = packetBuffer.func_150793_b();
                    this.artifacts.add(ItemStack.func_77949_a((NBTTagCompound)nbt2));
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return;
            }
            this.dimProperties = new DimensionProperties(this.dimNumber);
            this.dimProperties.readFromNBT(nbt);
        }
    }

    public void read(ByteBuf in) {
    }

    public void executeClient(EntityPlayer thePlayer) {
        if (this.deleteDim) {
            if (DimensionManager.getInstance().isDimensionCreated(this.dimNumber)) {
                DimensionManager.getInstance().deleteDimension(this.dimNumber);
            }
        } else if (this.dimProperties != null) {
            if (this.dimNumber == 0) {
                DimensionManager.overworldProperties = this.dimProperties;
            } else if (DimensionManager.getInstance().isDimensionCreated(this.dimNumber)) {
                this.dimProperties.oreProperties = DimensionManager.getInstance().getDimensionProperties((int)this.dimNumber).oreProperties;
                this.dimProperties.getRequiredArtifacts().clear();
                this.dimProperties.getRequiredArtifacts().addAll(this.artifacts);
                this.dimProperties.customIcon = DimensionManager.getInstance().getDimensionProperties((int)this.dimNumber).customIcon;
                DimensionManager.getInstance().setDimProperties(this.dimNumber, this.dimProperties);
            } else {
                this.dimProperties = new DimensionProperties(this.dimNumber);
                this.dimProperties.readFromNBT(this.dimNBT);
                DimensionManager.getInstance().registerDimNoUpdate(this.dimProperties, true);
            }
        }
    }

    public void executeServer(EntityPlayerMP player) {
    }
}

