/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.WorldServer;
import zmaster587.advancedRocketry.api.ISatelliteIdItem;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteProperties;
import zmaster587.advancedRocketry.dimension.DimensionManager;

public class ItemSatelliteIdentificationChip
extends Item
implements ISatelliteIdItem {
    private static String name = "name";

    public boolean func_77645_m() {
        return false;
    }

    public long getSatelliteId(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            return nbt.func_74763_f("satelliteId");
        }
        return -1L;
    }

    public SatelliteBase getSatellite(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            long satId = nbt.func_74763_f("satelliteId");
            SatelliteBase satellite = DimensionManager.getInstance().getSatellite(satId);
            if (satellite != null) {
                WorldServer world;
                if (!nbt.func_74764_b("dimId") || nbt.func_74762_e("dimId") == -1) {
                    nbt.func_74768_a("dimId", satellite.getDimensionId());
                }
                if ((world = net.minecraftforge.common.DimensionManager.getWorld((int)satellite.getDimensionId())) != null) {
                    nbt.func_74778_a(name, world.field_73011_w.func_80007_l());
                }
            }
            return satellite;
        }
        return null;
    }

    public void setSatellite(ItemStack stack, SatelliteBase satellite) {
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        nbt.func_74778_a("satelliteName", satellite.getName());
        nbt.func_74768_a("dimId", satellite.getDimensionId());
        nbt.func_74772_a("satelliteId", satellite.getId());
    }

    @Override
    public void setSatellite(ItemStack stack, SatelliteProperties satellite) {
        this.erase(stack);
        SatelliteBase satellite2 = SatelliteRegistry.getSatallite(satellite.getSatelliteType());
        if (satellite2 != null) {
            NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
            nbt.func_74778_a("satelliteName", satellite2.getName());
            nbt.func_74772_a("satelliteId", satellite.getId());
            stack.func_77982_d(nbt);
        }
    }

    public void erase(ItemStack stack) {
        stack.func_77982_d(null);
    }

    public void setDim(ItemStack stack, int dimId) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        nbt.func_74768_a("dimId", dimId);
    }

    public String getSatelliteName(ItemStack stack) {
        if (stack.func_77942_o()) {
            NBTTagCompound nbt = stack.func_77978_p();
            return nbt.func_74779_i("satelliteName");
        }
        return "";
    }

    public int getWorldId(ItemStack stack) {
        NBTTagCompound nbt;
        if (stack.func_77942_o() && (nbt = stack.func_77978_p()).func_74764_b("dimId")) {
            return nbt.func_74762_e("dimId");
        }
        return -1;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        int worldId = this.getWorldId(stack);
        long satId = this.getSatelliteId(stack);
        String satelliteName = this.getSatelliteName(stack);
        if (satId != -1L) {
            if (worldId != -1) {
                if (stack.func_77978_p().func_74764_b(name)) {
                    list.add("ID: " + satId);
                    list.add("Planet: " + stack.func_77978_p().func_74779_i(name));
                    list.add("Satellite: " + satelliteName);
                } else {
                    list.add("Planet: Unknown");
                    list.add("Satellite: Contact Lost");
                }
            } else {
                list.add("ID: " + satId);
                list.add("Planet: Unknown");
                list.add("Satellite: " + satelliteName);
            }
        } else {
            list.add("Unprogrammed");
        }
    }
}

