/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.IFluidContainerItem;
import zmaster587.advancedRocketry.tile.TileFluidTank;

public class ItemBlockFluidTank
extends ItemBlock
implements IFluidContainerItem {
    public ItemBlockFluidTank(Block block) {
        super(block);
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        super.func_77624_a(stack, player, list, bool);
        FluidStack fluidStack = ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack);
        if (fluidStack == null) {
            list.add("Empty");
        } else {
            list.add(fluidStack.getLocalizedName() + ": " + fluidStack.amount + "/64000mb");
        }
    }

    public boolean placeBlockAt(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ, int metadata) {
        TileEntity tile;
        boolean bool = super.placeBlockAt(stack, player, world, x, y, z, side, hitX, hitY, hitZ, metadata);
        if (!world.field_72995_K && (tile = world.func_147438_o(x, y, z)) != null && tile instanceof TileFluidTank) {
            TileFluidTank handler = (TileFluidTank)tile;
            ItemStack stack2 = stack.func_77946_l();
            stack2.field_77994_a = 1;
            handler.fill(ForgeDirection.DOWN, ((IFluidContainerItem)stack.func_77973_b()).getFluid(stack), true);
        }
        return bool;
    }

    public FluidStack getFluid(ItemStack container) {
        if (!container.func_77942_o()) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)container.func_77978_p());
    }

    public int getCapacity(ItemStack container) {
        return 64000;
    }

    public int fill(ItemStack container, FluidStack resource, boolean doFill) {
        NBTTagCompound nbt;
        FluidTank tank = new FluidTank(64000);
        if (container.func_77942_o()) {
            nbt = container.func_77978_p();
            tank.readFromNBT(nbt);
        } else {
            nbt = new NBTTagCompound();
        }
        int i = tank.fill(resource, doFill);
        tank.writeToNBT(nbt);
        container.func_77982_d(nbt);
        return i;
    }

    public FluidStack drain(ItemStack container, int maxDrain, boolean doDrain) {
        NBTTagCompound nbt;
        FluidTank tank = new FluidTank(64000);
        if (container.func_77942_o()) {
            nbt = container.func_77978_p();
            tank.readFromNBT(nbt);
        } else {
            nbt = new NBTTagCompound();
        }
        FluidStack i = tank.drain(maxDrain, doDrain);
        tank.writeToNBT(nbt);
        container.func_77982_d(nbt);
        return i;
    }
}

