/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.item.ItemSatelliteIdentificationChip;
import zmaster587.advancedRocketry.network.PacketSatellite;
import zmaster587.advancedRocketry.satellite.SatelliteBiomeChanger;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.inventory.GuiHandler;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.IModularInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.inventory.modules.ModuleContainerPan;
import zmaster587.libVulpes.inventory.modules.ModuleImage;
import zmaster587.libVulpes.inventory.modules.ModulePower;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.INetworkItem;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.network.PacketItemModifcation;

public class ItemBiomeChanger
extends ItemSatelliteIdentificationChip
implements IModularInventory,
IButtonInventory,
INetworkItem {
    public List<ModuleBase> getModules(int id, EntityPlayer player) {
        LinkedList<ModuleBase> list = new LinkedList<ModuleBase>();
        SatelliteBiomeChanger sat = (SatelliteBiomeChanger)this.getSatellite(player.func_71045_bC());
        if (player.field_70170_p.field_72995_K) {
            list.add((ModuleBase)new ModuleImage(24, 14, TextureResources.earthCandyIcon));
        }
        LinkedList<ModuleButton> list2 = new LinkedList<ModuleButton>();
        int j = 0;
        for (byte biomeByte : sat.discoveredBiomes()) {
            BiomeGenBase biome = BiomeGenBase.func_150568_d((int)biomeByte);
            list2.add(new ModuleButton(32, 16 + 24 * j++, biome.field_76756_M, biome.field_76791_y, (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonBuild));
        }
        ModuleContainerPan pan = new ModuleContainerPan(32, 16, list2, new LinkedList(), null, 128, 128, 0, -64, 0, 1000);
        list.add((ModuleBase)pan);
        list.add((ModuleBase)new ModuleButton(120, 124, -1, "Scan Biome", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonScan));
        list.add((ModuleBase)new ModulePower(16, 48, (IUniversalEnergy)sat));
        return list;
    }

    @Override
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean arg5) {
        SatelliteBase sat = DimensionManager.getInstance().getSatellite(this.getSatelliteId(stack));
        SatelliteBiomeChanger mapping = null;
        if (sat instanceof SatelliteBiomeChanger) {
            mapping = (SatelliteBiomeChanger)sat;
        }
        if (!stack.func_77942_o()) {
            list.add("Unprogrammed");
        } else if (mapping == null) {
            list.add("Satellite not yet launched");
        } else if (mapping.getDimensionId() == player.field_70170_p.field_73011_w.field_76574_g) {
            list.add("Connected");
            list.add("Selected Biome: " + BiomeGenBase.func_150568_d((int)mapping.getBiome()).field_76791_y);
            list.add("Num Biomes Scanned: " + mapping.discoveredBiomes().size());
        } else {
            list.add("Not Connected");
        }
        super.func_77624_a(stack, player, list, arg5);
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        SatelliteBase sat;
        if (!world.field_72995_K && (sat = DimensionManager.getInstance().getSatellite(this.getSatelliteId(stack))) != null) {
            if (player.func_70093_af()) {
                if (this.getSatellite(stack) != null) {
                    PacketHandler.sendToPlayer((BasePacket)new PacketSatellite(this.getSatellite(stack)), (EntityPlayer)player);
                    player.openGui((Object)LibVulpes.instance, GuiHandler.guiId.MODULARNOINV.ordinal(), world, -1, -1, 0);
                }
                return super.func_77659_a(stack, world, player);
            }
            sat.performAction(player, world, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
        }
        return super.func_77659_a(stack, world, player);
    }

    private int getBiomeId(ItemStack stack) {
        SatelliteBase sat = this.getSatellite(stack);
        if (sat != null && sat instanceof SatelliteBiomeChanger) {
            return ((SatelliteBiomeChanger)sat).getBiome();
        }
        return -1;
    }

    private void setBiomeId(ItemStack stack, int id) {
        SatelliteBase sat;
        if (BiomeGenBase.func_150568_d((int)id) != null && (sat = this.getSatellite(stack)) != null && sat instanceof SatelliteBiomeChanger) {
            ((SatelliteBiomeChanger)sat).setBiome(id);
        }
    }

    public String getModularInventoryName() {
        return "item.biomeChanger.name";
    }

    public boolean canInteractWithContainer(EntityPlayer entity) {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void onInventoryButtonPressed(int buttonId) {
        ItemStack stack = Minecraft.func_71410_x().field_71439_g.func_70694_bm();
        if (stack != null && stack.func_77973_b() == this) {
            this.setBiomeId(stack, buttonId);
            PacketHandler.sendToServer((BasePacket)new PacketItemModifcation((INetworkItem)this, (EntityPlayer)Minecraft.func_71410_x().field_71439_g, 0));
        }
    }

    public void writeDataToNetwork(ByteBuf out, byte id, ItemStack stack) {
        if (id == 0) {
            out.writeInt(this.getBiomeId(stack));
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt, ItemStack stack) {
        if (packetId == 0) {
            nbt.func_74768_a("biome", in.readInt());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt, ItemStack stack) {
        if (id == 0) {
            int biomeId = nbt.func_74762_e("biome");
            if (biomeId == -1) {
                ((SatelliteBiomeChanger)this.getSatellite(stack)).addBiome(player.field_70170_p.func_72807_a((int)((int)player.field_70165_t), (int)((int)player.field_70161_v)).field_76756_M);
            } else {
                this.setBiomeId(stack, biomeId);
            }
            player.func_71053_j();
        }
    }
}

