/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.inventory.modules;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.ICrafting;
import net.minecraft.inventory.Slot;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.advancedRocketry.inventory.modules.SlotData;
import zmaster587.advancedRocketry.util.IDataInventory;
import zmaster587.libVulpes.inventory.modules.IButtonInventory;
import zmaster587.libVulpes.inventory.modules.ModuleBase;
import zmaster587.libVulpes.inventory.modules.ModuleButton;
import zmaster587.libVulpes.util.IconResource;

public class ModuleData
extends ModuleBase
implements IButtonInventory {
    static final int barYSize = 38;
    static final int barXSize = 6;
    static final int textureOffsetX = 0;
    static final int textureOffsetY = 215;
    DataStorage[] data;
    int[] prevData;
    int prevDataType;
    int slot;
    IDataInventory chipStorage;
    IconResource icon = TextureResources.ioSlot;
    ModuleButton buttonStore;
    ModuleButton buttonLoad;

    public ModuleData(int offsetX, int offsetY, int slot, IDataInventory chipStorage, DataStorage ... data) {
        super(offsetX, offsetY);
        this.data = data;
        this.prevData = new int[data.length];
        this.chipStorage = chipStorage;
        this.slot = slot;
        this.buttonStore = new ModuleButton(10 + offsetX, offsetY, 0, "", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonDown, "Store to Chip", 16, 10);
        this.buttonLoad = new ModuleButton(12 + offsetX, 36 + offsetY, 1, "", (IButtonInventory)this, zmaster587.libVulpes.inventory.TextureResources.buttonLeft, "Store to buffer", 10, 16);
    }

    public List<GuiButton> addButtons(int x, int y) {
        List list = this.buttonLoad.addButtons(x, y);
        list.addAll(this.buttonStore.addButtons(x, y));
        return list;
    }

    public void onInventoryButtonPressed(int buttonId) {
        if (buttonId == 0) {
            this.chipStorage.storeData(this.slot);
        } else if (buttonId == 1) {
            this.chipStorage.loadData(this.slot);
        }
    }

    public void actionPerform(GuiButton button) {
        this.buttonStore.actionPerform(button);
        this.buttonLoad.actionPerform(button);
    }

    public List<Slot> getSlots(Container container) {
        this.slotList.add(new SlotData(this.chipStorage, this.slot, this.offsetX + 10, this.offsetY + 16));
        return this.slotList;
    }

    public int numberOfChangesToSend() {
        return this.data.length + 1;
    }

    public boolean needsUpdate(int localId) {
        if (localId < this.data.length) {
            return this.data[localId].getData() != this.prevData[localId];
        }
        return this.data[0].getDataType().ordinal() != this.prevDataType;
    }

    protected void updatePreviousState(int localId) {
        if (localId < this.data.length) {
            this.prevData[localId] = this.data[localId].getData();
        } else {
            this.prevDataType = this.data[0].getDataType().ordinal();
        }
    }

    public void sendChanges(Container container, ICrafting crafter, int variableId, int localId) {
        if (localId < this.data.length) {
            crafter.func_71112_a(container, variableId, this.data[localId].getData());
        } else {
            crafter.func_71112_a(container, variableId, this.data[0].getDataType().ordinal());
        }
    }

    public void onChangeRecieved(int slot, int value) {
        if (slot < this.data.length) {
            this.data[slot].setData(value, DataStorage.DataType.UNDEFINED);
        } else {
            this.data[0].setDataType(DataStorage.DataType.values()[value]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderForeground(int guiOffsetX, int guiOffsetY, int mouseX, int mouseY, float zLevel, GuiContainer gui, FontRenderer font) {
        this.buttonLoad.renderForeground(guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        this.buttonStore.renderForeground(guiOffsetX, guiOffsetY, mouseX, mouseY, zLevel, gui, font);
        int relativeX = mouseX - this.offsetX;
        int relativeY = mouseY - this.offsetY;
        if (relativeX > 0 && relativeX < 6 && relativeY > 0 && relativeY < 38) {
            int totalData = 0;
            int totalMaxData = 0;
            for (DataStorage datum : this.data) {
                totalData += datum.getData();
                totalMaxData += datum.getMaxData();
            }
            LinkedList<String> list = new LinkedList<String>();
            list.add(totalData + " / " + totalMaxData + " Data");
            list.add("Type: " + I18n.func_135052_a((String)this.data[0].getDataType().toString(), (Object[])new Object[0]));
            this.drawTooltip(gui, list, mouseX, mouseY, zLevel, font);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void renderBackground(GuiContainer gui, int x, int y, int mouseX, int mouseY, FontRenderer font) {
        this.buttonLoad.renderBackground(gui, x, y, mouseX, mouseY, font);
        this.buttonStore.renderBackground(gui, x, y, mouseX, mouseY, font);
        for (Slot slot : this.slotList) {
            gui.func_73729_b(x + slot.field_75223_e - 1, y + slot.field_75221_f - 1, this.icon.getxLoc(), this.icon.getyLoc(), this.icon.getxSize(), this.icon.getySize());
        }
        int totalData = 0;
        int totalMaxData = 0;
        for (DataStorage datum : this.data) {
            totalData += datum.getData();
            totalMaxData += datum.getMaxData();
        }
        float percent = (float)totalData / (float)totalMaxData;
        gui.func_73729_b(this.offsetX + x, this.offsetY + y, 176, 18, 8, 40);
        gui.func_73729_b(this.offsetX + x - 1, this.offsetY + y + 38 + 4, 19, 171, 10, 10);
        gui.func_73729_b(this.offsetX + x + 1, 1 + this.offsetY + y + (38 - (int)(percent * 38.0f)), 0, 38 - (int)(percent * 38.0f) + 215, 6, (int)(percent * 38.0f));
    }
}

