/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.inventory;

import java.nio.IntBuffer;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.client.render.ClientDynamicTexture;
import zmaster587.advancedRocketry.inventory.ContainerOreMappingSatallite;
import zmaster587.advancedRocketry.satellite.SatelliteOreMapping;
import zmaster587.libVulpes.render.RenderHelper;
import zmaster587.libVulpes.util.VulpineMath;

public class GuiOreMappingSatellite
extends GuiContainer {
    ClientDynamicTexture texture;
    Thread currentMapping;
    TileEntity masterConsole;
    boolean merged = false;
    private static final int SCREEN_SIZE = 146;
    private int maxZoom = 128;
    private static final int MAXRADIUS = 16;
    private static final int FANCYSCANMAXSIZE = 57;
    private int fancyScanOffset;
    private long prevWorldTickTime;
    private int prevSlot;
    private int mouseValue;
    private int scanSize = 2;
    private int radius = 1;
    private int xSelected;
    private int zSelected;
    private int xCenter;
    private int zCenter;
    private int playerPosZ;
    private int playerPosX;
    private static final ResourceLocation backdrop = new ResourceLocation("advancedrocketry", "textures/gui/VideoSatallite.png");
    int[][] oreMap;
    World world;
    SatelliteOreMapping tile;
    Runnable mapper = new Runnable(){

        @Override
        public void run() {
            GuiOreMappingSatellite.this.oreMap = SatelliteOreMapping.scanChunk(GuiOreMappingSatellite.this.world, GuiOreMappingSatellite.this.xCenter, GuiOreMappingSatellite.this.zCenter, GuiOreMappingSatellite.this.scanSize / 2, GuiOreMappingSatellite.this.radius);
            GuiOreMappingSatellite.this.merged = GuiOreMappingSatellite.this.oreMap != null;
        }
    };

    public GuiOreMappingSatellite(SatelliteOreMapping tile, EntityPlayer inventoryPlayer) {
        super((Container)new ContainerOreMappingSatallite(tile, inventoryPlayer.field_71071_by));
        this.world = inventoryPlayer.field_70170_p;
        this.prevSlot = -1;
        this.tile = tile;
        this.playerPosX = this.xCenter = (int)inventoryPlayer.field_70165_t;
        this.playerPosZ = this.zCenter = (int)inventoryPlayer.field_70161_v;
        if (tile != null) {
            this.maxZoom = (int)Math.pow(2.0, tile.getZoomRadius());
        }
        if (this.maxZoom == 1) {
            this.tile = null;
        }
        this.scanSize = this.maxZoom;
        this.prevWorldTickTime = this.world.func_82737_E();
        this.fancyScanOffset = 0;
    }

    public boolean func_73868_f() {
        return false;
    }

    private void runMapperWithSelection() {
        if (this.tile == null) {
            return;
        }
        this.currentMapping.interrupt();
        this.resetTexture();
        if (this.prevSlot == -1) {
            this.currentMapping = new Thread(this.mapper);
            this.currentMapping.setName("Ore Scan");
        } else {
            this.currentMapping = new Thread(new ItemMapper(this.field_147002_h.func_75139_a(this.prevSlot).func_75211_c()));
            this.currentMapping.setName("Ore Scan");
        }
        this.currentMapping.start();
    }

    protected void func_146286_b(int x, int y, int button) {
        super.func_146286_b(x, y, button);
        if (this.tile == null) {
            return;
        }
        int xOffset = 47 + (this.field_146294_l - 240) / 2;
        int yOffset = 20 + (this.field_146295_m - 192) / 2;
        if (button == 0 && this.tile.getSelectedSlot() != this.prevSlot) {
            this.prevSlot = this.tile.getSelectedSlot();
            this.runMapperWithSelection();
        }
        if (x < xOffset || x > xOffset + 146 || y < yOffset || y > yOffset + 146) {
            return;
        }
        if (this.oreMap != null) {
            double numPixels = (float)this.scanSize / (float)(146 * this.radius);
            this.mouseValue = this.oreMap[(int)((double)(x - xOffset) * numPixels)][(int)((double)(y - yOffset) * numPixels)] / 255;
            this.xSelected = (int)((double)(x - xOffset) * numPixels) + this.xCenter - this.radius * this.scanSize / 2;
            this.zSelected = (int)((double)(y - yOffset) * numPixels) + this.zCenter - this.radius * this.scanSize / 2;
        }
    }

    protected void func_73869_a(char c, int i) {
        if (i == 17) {
            this.zCenter -= this.radius;
            this.runMapperWithSelection();
        } else if (i == 31) {
            this.zCenter += this.radius;
            this.runMapperWithSelection();
        } else if (i == 30) {
            this.xCenter -= this.radius;
            this.runMapperWithSelection();
        } else if (i == 32) {
            this.xCenter += this.radius;
            this.runMapperWithSelection();
        } else if (i == 208) {
            this.scanSize = Math.min(this.scanSize * 2, this.maxZoom);
            this.runMapperWithSelection();
        } else if (i == 200) {
            if (this.scanSize / 2 / this.radius > 0) {
                this.scanSize = Math.max(this.scanSize / 2, 2);
                this.runMapperWithSelection();
            }
        } else {
            super.func_73869_a(c, i);
        }
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.texture = new ClientDynamicTexture(Math.max(this.scanSize / this.radius, 1), Math.max(this.scanSize / this.radius, 1));
        ItemStack stack = this.field_147002_h.func_75139_a(0).func_75211_c();
        if (this.tile != null) {
            this.currentMapping = new Thread(this.mapper);
            this.currentMapping.setName("Ore Scan");
            this.currentMapping.start();
        }
    }

    private void resetTexture() {
        GL11.glDeleteTextures((int)this.texture.getTextureId());
        this.texture = new ClientDynamicTexture(Math.max(this.scanSize / this.radius, 1), Math.max(this.scanSize / this.radius, 1));
    }

    public void func_146281_b() {
        super.func_146281_b();
        GL11.glDeleteTextures((int)this.texture.getTextureId());
        if (this.currentMapping != null) {
            this.currentMapping.interrupt();
        }
    }

    protected void func_146979_b(int p_146979_1_, int p_146979_2_) {
        int slot;
        Tessellator tessellator = Tessellator.field_78398_a;
        GL11.glDisable((int)3553);
        GL11.glColor3f((float)0.0f, (float)0.8f, (float)0.0f);
        tessellator.func_78382_b();
        tessellator.func_78377_a(-21.0, (double)(82 + this.fancyScanOffset), (double)this.field_73735_i);
        tessellator.func_78377_a(0.0, (double)(84 + this.fancyScanOffset), (double)this.field_73735_i);
        tessellator.func_78377_a(0.0, (double)(81 + this.fancyScanOffset), (double)this.field_73735_i);
        tessellator.func_78377_a(-21.0, (double)(81 + this.fancyScanOffset), (double)this.field_73735_i);
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        tessellator.func_78377_a(-21.0, (double)(82 - this.fancyScanOffset + 57), (double)this.field_73735_i);
        tessellator.func_78377_a(0.0, (double)(84 - this.fancyScanOffset + 57), (double)this.field_73735_i);
        tessellator.func_78377_a(0.0, (double)(81 - this.fancyScanOffset + 57), (double)this.field_73735_i);
        tessellator.func_78377_a(-21.0, (double)(81 - this.fancyScanOffset + 57), (double)this.field_73735_i);
        tessellator.func_78381_a();
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)772);
        GL11.glColor4f((float)0.5f, (float)0.5f, (float)0.0f, (float)(0.3f + (float)Math.sin(Math.PI * (double)((float)this.fancyScanOffset / 57.0f)) / 3.0f));
        tessellator.func_78382_b();
        tessellator.func_78377_a(173.0, 141.0, (double)this.field_73735_i);
        tessellator.func_78377_a(194.0, 141.0, (double)this.field_73735_i);
        tessellator.func_78377_a(194.0, 82.0, (double)this.field_73735_i);
        tessellator.func_78377_a(173.0, 82.0, (double)this.field_73735_i);
        tessellator.func_78381_a();
        GL11.glEnable((int)3553);
        GL11.glDisable((int)3042);
        if (this.world.func_82737_E() - this.prevWorldTickTime >= 1L) {
            this.prevWorldTickTime = this.world.func_82737_E();
            this.fancyScanOffset = this.fancyScanOffset >= 57 ? 0 : ++this.fancyScanOffset;
        }
        if (this.tile != null && (slot = this.tile.getSelectedSlot()) != -1) {
            GL11.glDisable((int)3553);
            GL11.glColor3f((float)0.0f, (float)0.8f, (float)0.0f);
            tessellator.func_78382_b();
            tessellator.func_78374_a((double)(13 + 18 * slot), 171.0, (double)this.field_73735_i, 0.0, 1.0);
            tessellator.func_78374_a((double)(29 + 18 * slot), 171.0, (double)this.field_73735_i, 1.0, 1.0);
            tessellator.func_78374_a((double)(29 + 18 * slot), 155.0, (double)this.field_73735_i, 1.0, 0.0);
            tessellator.func_78374_a((double)(13 + 18 * slot), 155.0, (double)this.field_73735_i, 0.0, 0.0);
            tessellator.func_78381_a();
            GL11.glEnable((int)3553);
        }
    }

    protected void func_146976_a(float p_146976_1_, int p_146976_2_, int p_146976_3_) {
        int x = (this.field_146294_l - 240) / 2;
        int y = (this.field_146295_m - 192) / 2;
        if (this.merged) {
            IntBuffer buffer = this.texture.getByteBuffer();
            int scanWidth = Math.max(this.scanSize / this.radius, 1);
            for (int yt = 0; yt < this.texture.getImage().getHeight() * this.texture.getImage().getWidth(); ++yt) {
                buffer.put(yt, this.oreMap[yt % scanWidth][yt / scanWidth] | 0xFF000000);
            }
            buffer.flip();
            this.texture.setByteBuffer(buffer);
            this.merged = false;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.field_71446_o.func_110577_a(backdrop);
        this.func_73729_b(x, y, 0, 0, 240, 192);
        GL11.glBindTexture((int)3553, (int)this.texture.getTextureId());
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78382_b();
        tessellator.func_78374_a((double)(47 + x), (double)(20 + y + 146), (double)this.field_73735_i, 0.0, 1.0);
        tessellator.func_78374_a((double)(47 + x + 146), (double)(20 + y + 146), (double)this.field_73735_i, 1.0, 1.0);
        tessellator.func_78374_a((double)(47 + x + 146), (double)(20 + y), (double)this.field_73735_i, 1.0, 0.0);
        tessellator.func_78374_a((double)(47 + x), (double)(20 + y), (double)this.field_73735_i, 0.0, 0.0);
        tessellator.func_78381_a();
        float offsetX = this.playerPosX - this.xCenter;
        float offsetY = this.zCenter - this.playerPosZ;
        double numPixels = 146 / this.scanSize;
        float radius = 2.0f;
        if (Math.abs(offsetX) < (float)(this.scanSize / 2) && Math.abs(offsetY) < (float)(this.scanSize / 2)) {
            offsetX = (float)((double)offsetX * numPixels);
            offsetY = (float)((double)offsetY * numPixels);
            GL11.glDisable((int)3553);
            GL11.glColor3f((float)0.4f, (float)1.0f, (float)0.4f);
            tessellator.func_78382_b();
            RenderHelper.renderNorthFaceWithUV((Tessellator)tessellator, (double)this.field_73735_i, (double)(offsetX + 47.0f + (float)x + 73.0f - radius), (double)(offsetY + 20.0f + (float)y + 73.0f - radius), (double)(offsetX + 47.0f + (float)x + 73.0f + radius), (double)(offsetY + 20.0f + (float)y + 73.0f + radius), (double)0.0, (double)1.0, (double)0.0, (double)1.0);
            tessellator.func_78381_a();
            GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glEnable((int)3553);
            this.func_73732_a(this.field_146289_q, "You", (int)(offsetX + 47.0f + (float)x + 73.0f - radius), (int)(offsetY + 20.0f + (float)y + 73.0f - radius) - 10, 0xF0F0F0);
        }
        this.field_146297_k.field_71446_o.func_110577_a(backdrop);
        this.func_73729_b(197 + x, 31 + y, 0, 192, 32, 14);
        this.func_73728_b((int)(32.0 * VulpineMath.log2((double)(this.scanSize - 1)) / 8.0) + 199 + x, 34 + y, 45 + y, -4190449);
        this.func_73731_b(this.field_146289_q, "Zoom", 198 + x, 22 + y, 0xF0F0F0);
        this.func_73731_b(this.field_146289_q, "X: " + this.xSelected, 6 + x, 33 + y, 0xF0F0F0);
        this.func_73731_b(this.field_146289_q, "Z: " + this.zSelected, 6 + x, 49 + y, 0xF0F0F0);
    }

    class ItemMapper
    implements Runnable {
        private ItemStack myBlock;

        ItemMapper(ItemStack block) {
            this.myBlock = block.func_77946_l();
        }

        @Override
        public void run() {
            GuiOreMappingSatellite.this.oreMap = SatelliteOreMapping.scanChunk(GuiOreMappingSatellite.this.world, GuiOreMappingSatellite.this.xCenter, GuiOreMappingSatellite.this.zCenter, GuiOreMappingSatellite.this.scanSize / 2, GuiOreMappingSatellite.this.radius, this.myBlock);
            GuiOreMappingSatellite.this.merged = GuiOreMappingSatellite.this.oreMap != null;
        }
    }
}

