/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.guihook.GuiContainerManager;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidContainerItem;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.integration.nei.PositionedFluidStack;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.libVulpes.client.util.ProgressBarImage;
import zmaster587.libVulpes.interfaces.IRecipe;
import zmaster587.libVulpes.recipe.RecipesMachine;
import zmaster587.libVulpes.util.ZUtils;

public abstract class TemplateNEI
extends TemplateRecipeHandler {
    protected abstract Class getMachine();

    protected abstract ProgressBarImage getProgressBar();

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(58, 6, 41, 54), this.getRecipeName(), new Object[0]));
    }

    public void loadCraftingRecipes(ItemStack result) {
        super.loadCraftingRecipes(result);
        Iterator iterator = RecipesMachine.getInstance().getRecipes(this.getMachine()).iterator();
        while (iterator.hasNext()) {
            ItemStack stack;
            IRecipe i;
            IRecipe newRecipe = i = (IRecipe)iterator.next();
            boolean match = false;
            Iterator iterator2 = i.getOutput().iterator();
            while (iterator2.hasNext() && !(match = NEIServerUtils.areStacksSameTypeCrafting((ItemStack)(stack = (ItemStack)iterator2.next()), (ItemStack)result) || ZUtils.areOresSameTypeOreDict((ItemStack)stack, (ItemStack)result))) {
            }
            if (!match && (FluidContainerRegistry.isFilledContainer((ItemStack)result) || result.func_77973_b() instanceof IFluidContainerItem || Block.func_149634_a((Item)result.func_77973_b()) != Blocks.field_150350_a && FluidRegistry.lookupFluidForBlock((Block)Block.func_149634_a((Item)result.func_77973_b())) != null)) {
                FluidStack fluidStack = null;
                if (result.func_77973_b() instanceof IFluidContainerItem) {
                    fluidStack = ((IFluidContainerItem)result.func_77973_b()).getFluid(result);
                } else if (FluidContainerRegistry.isFilledContainer((ItemStack)result) && FluidContainerRegistry.isFilledContainer((ItemStack)result)) {
                    fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)result);
                }
                for (FluidStack stack2 : ((RecipesMachine.Recipe)i).getFluidOutputs()) {
                    if ((fluidStack == null || fluidStack.getFluid() != stack2.getFluid()) && (Block.func_149634_a((Item)result.func_77973_b()) == Blocks.field_150350_a || FluidRegistry.lookupFluidForBlock((Block)Block.func_149634_a((Item)result.func_77973_b())) != stack2.getFluid())) continue;
                    match = true;
                    break;
                }
            }
            if (!match) continue;
            CachedMachineRecipe recipe = new CachedMachineRecipe((IRecipe)((RecipesMachine.Recipe)i));
            recipe.computeVisuals();
            this.arecipes.add(recipe);
            match = false;
        }
    }

    public void loadAllRecipes() {
        for (IRecipe i : RecipesMachine.getInstance().getRecipes(this.getMachine())) {
            this.arecipes.add(new CachedMachineRecipe((IRecipe)((RecipesMachine.Recipe)i)));
        }
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        super.loadCraftingRecipes(outputId, results);
        if (outputId.equals(this.getRecipeName())) {
            this.loadAllRecipes();
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (IRecipe irecipe : RecipesMachine.getInstance().getRecipes(this.getMachine())) {
            CachedMachineRecipe recipe = new CachedMachineRecipe(((RecipesMachine.Recipe)irecipe).getRecipeAsAllItemsOnly());
            boolean match = false;
            for (PositionedStack posStack : recipe.getIngredients()) {
                if (!posStack.item.func_77969_a(ingredient) && !ZUtils.areOresSameTypeOreDict((ItemStack)posStack.item, (ItemStack)ingredient)) continue;
                recipe.setIngredientPermutation(recipe.ingredients, ingredient);
                this.arecipes.add(recipe);
                match = true;
                break;
            }
            if (match || !FluidContainerRegistry.isFilledContainer((ItemStack)ingredient) && !(ingredient.func_77973_b() instanceof IFluidContainerItem) && (Block.func_149634_a((Item)ingredient.func_77973_b()) == Blocks.field_150350_a || FluidRegistry.lookupFluidForBlock((Block)Block.func_149634_a((Item)ingredient.func_77973_b())) == null)) continue;
            FluidStack fluidStack = null;
            if (ingredient.func_77973_b() instanceof IFluidContainerItem) {
                fluidStack = ((IFluidContainerItem)ingredient.func_77973_b()).getFluid(ingredient);
            } else if (FluidContainerRegistry.isFilledContainer((ItemStack)ingredient) && FluidContainerRegistry.isFilledContainer((ItemStack)ingredient)) {
                fluidStack = FluidContainerRegistry.getFluidForFilledItem((ItemStack)ingredient);
            }
            for (FluidStack stack : ((RecipesMachine.Recipe)irecipe).getFluidIngredients()) {
                if ((fluidStack == null || fluidStack.getFluid() != stack.getFluid()) && (Block.func_149634_a((Item)ingredient.func_77973_b()) == Blocks.field_150350_a || FluidRegistry.lookupFluidForBlock((Block)Block.func_149634_a((Item)ingredient.func_77973_b())) != stack.getFluid())) continue;
                recipe.setIngredientPermutation(recipe.ingredients, ingredient);
                this.arecipes.add(recipe);
                continue block0;
            }
        }
    }

    public int recipiesPerPage() {
        return 1;
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)3, (int)3, (int)7, (int)16, (int)163, (int)55);
    }

    public void drawForeground(int recipe) {
        super.drawForeground(recipe);
        this.drawFluidTanks((CachedMachineRecipe)((Object)this.arecipes.get(recipe)));
        GuiDraw.drawString((String)(((CachedMachineRecipe)((Object)this.arecipes.get(recipe))).getEnergy() + " RF/t"), (int)4, (int)60, (int)0x3D3D3D, (boolean)false);
        GuiDraw.drawString((String)(((CachedMachineRecipe)((Object)this.arecipes.get(recipe))).getTime() / 20 + " Seconds"), (int)4, (int)70, (int)0x3D3D3D, (boolean)false);
    }

    public void drawExtras(int recipe) {
        ProgressBarImage progressBar = this.getProgressBar();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureResources.progressBars);
        GuiDraw.drawTexturedModalRect((int)65, (int)3, (int)progressBar.getBackOffsetX(), (int)progressBar.getBackOffsetY(), (int)progressBar.getBackWidth(), (int)progressBar.getBackHeight());
        this.drawProgressBar(65 + progressBar.getInsetX(), 3 + progressBar.getInsetY(), progressBar.getForeOffsetX(), progressBar.getForeOffsetY(), progressBar.getForeWidth(), progressBar.getForeHeight(), 50, progressBar.getDirection().getRotation(ForgeDirection.SOUTH).ordinal());
    }

    public void drawFluidTanks(CachedMachineRecipe r) {
        if (r.getFluids() != null) {
            for (PositionedFluidStack fluidTank : r.getFluids()) {
                fluidTank.draw();
            }
        }
    }

    public List<String> provideTooltip(GuiRecipe guiRecipe, List<String> currenttip, CachedMachineRecipe crecipe, Point relMouse) {
        if (crecipe.getFluids() != null) {
            for (PositionedFluidStack tank : crecipe.getFluids()) {
                if (relMouse.x <= tank.posX || relMouse.x >= tank.posX + 16 || relMouse.y <= tank.posY || relMouse.y >= tank.posY + 16) continue;
                tank.handleTooltip(currenttip);
            }
        }
        return currenttip;
    }

    public List<String> handleTooltip(GuiRecipe guiRecipe, List<String> currenttip, int recipe) {
        super.handleTooltip(guiRecipe, currenttip, recipe);
        CachedMachineRecipe crecipe = (CachedMachineRecipe)((Object)this.arecipes.get(recipe));
        if (GuiContainerManager.shouldShowTooltip((GuiContainer)guiRecipe)) {
            Point mouse = GuiDraw.getMousePosition();
            Point offset = guiRecipe.getRecipePosition(recipe);
            Point relMouse = new Point(mouse.x - (guiRecipe.field_146294_l - 176) / 2 - offset.x, mouse.y - (guiRecipe.field_146295_m - 166) / 2 - offset.y);
            currenttip = this.provideTooltip(guiRecipe, currenttip, crecipe, relMouse);
        }
        return currenttip;
    }

    public String getGuiTexture() {
        return "advancedrocketry:textures/gui/GenericNeiBackground.png";
    }

    public class CachedMachineRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private ArrayList<PositionedStack> ingredients;
        private ArrayList<PositionedStack> result;
        private ArrayList<PositionedFluidStack> fluids;
        private int energy;
        private int time;

        CachedMachineRecipe(IRecipe rec) {
            super((TemplateRecipeHandler)TemplateNEI.this);
            this.result = new ArrayList();
            this.fluids = new ArrayList();
            int inputIndex = 0;
            int outputIndex = 0;
            int i = 0;
            while (i < rec.getOutput().size()) {
                this.result.add(new PositionedStack(rec.getOutput().get(i), 112 + 18 * (i % 3), 4 + 18 * (i / 3)));
                ++i;
                ++outputIndex;
            }
            this.ingredients = new ArrayList();
            i = 0;
            while (i < rec.getIngredients().size()) {
                this.ingredients.add(new PositionedStack(rec.getIngredients().get(i), 4 + 18 * (i % 3), 4 + 18 * (i / 3)));
                ++i;
                ++inputIndex;
            }
            i = 0;
            while (i < rec.getFluidIngredients().size()) {
                this.fluids.add(new PositionedFluidStack((FluidStack)rec.getFluidIngredients().get(i), 4 + 18 * (inputIndex % 3), 4 + 18 * (inputIndex / 3)));
                ++i;
                ++inputIndex;
            }
            i = 0;
            while (i < rec.getFluidOutputs().size()) {
                this.fluids.add(new PositionedFluidStack((FluidStack)rec.getFluidOutputs().get(i), 112 + 18 * (outputIndex % 3), 4 + 18 * (outputIndex / 3)));
                ++i;
                ++outputIndex;
            }
            this.energy = rec.getPower();
            this.time = rec.getTime();
        }

        public void computeVisuals() {
            for (PositionedStack p : this.ingredients) {
                p.generatePermutations();
            }
        }

        public List<PositionedStack> getResults() {
            return this.result;
        }

        public List<PositionedStack> getOtherStacks() {
            return this.getResults();
        }

        public PositionedStack getResult() {
            return null;
        }

        public List<PositionedStack> getIngredients() {
            return this.getCycledIngredients(TemplateNEI.this.cycleticks / 20, this.ingredients);
        }

        public List<PositionedFluidStack> getFluids() {
            return this.fluids;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getTime() {
            return this.time;
        }
    }
}

