/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.integration.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.recipe.GuiCraftingRecipe;
import codechicken.nei.recipe.GuiUsageRecipe;
import java.awt.Point;
import java.util.List;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.api.AdvancedRocketryFluids;

public class PositionedFluidStack {
    public FluidStack tank;
    public int posX;
    public int posY;
    public String overlayTexture;
    public Point overlayTexturePos;
    public boolean flowingTexture = false;
    public boolean showAmount = true;
    public boolean perTick = false;
    public static final int size = 16;

    public PositionedFluidStack(FluidStack tank, int x, int y, String overlayTexture, Point overlayTexturePos) {
        this.posX = x;
        this.posY = y;
        this.tank = tank;
        this.overlayTexture = overlayTexture;
        this.overlayTexturePos = overlayTexturePos;
    }

    public PositionedFluidStack(FluidStack tank, int x, int y) {
        this(tank, x, y, null, null);
    }

    public List<String> handleTooltip(List<String> currenttip) {
        if (this.tank == null || this.tank == null || this.tank.getFluid() == null || this.tank.amount <= 0) {
            return currenttip;
        }
        currenttip.add(this.tank.getLocalizedName());
        if (this.showAmount) {
            currenttip.add(EnumChatFormatting.GRAY.toString() + this.tank.amount + (this.perTick ? " mB/t" : " mB"));
        }
        return currenttip;
    }

    public boolean transfer(boolean usage) {
        if (this.tank != null && this.tank.amount > 0) {
            return !(usage ? !GuiUsageRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{this.tank}) : !GuiCraftingRecipe.openRecipeGui((String)"liquid", (Object[])new Object[]{this.tank}));
        }
        return false;
    }

    public void draw() {
        if (this.tank == null || this.tank == null || this.tank.getFluid() == null || this.tank.amount <= 0) {
            return;
        }
        IIcon fluidIcon = null;
        fluidIcon = this.flowingTexture && this.tank.getFluid().getFlowingIcon() != null ? this.tank.getFluid().getFlowingIcon() : (this.tank.getFluid().getStillIcon() != null ? this.tank.getFluid().getStillIcon() : AdvancedRocketryFluids.fluidRocketFuel.getFlowingIcon());
        GuiDraw.changeTexture((ResourceLocation)TextureMap.field_110575_b);
        int color = this.tank.getFluid().getColor(this.tank);
        GL11.glColor3ub((byte)((byte)(color >> 16 & 0xFF)), (byte)((byte)(color >> 8 & 0xFF)), (byte)((byte)(color & 0xFF)));
        GL11.glDisable((int)3042);
        int amount = Math.max(16, 1);
        int posY = this.posY + 16 - amount;
        for (int i = 0; i < 16; i += 16) {
            for (int j = 0; j < amount; j += 16) {
                int drawWidth = Math.min(16 - i, 16);
                int drawHeight = Math.min(amount - j, 16);
                int drawX = this.posX + i;
                int drawY = posY + j;
                double minU = fluidIcon.func_94209_e();
                double maxU = fluidIcon.func_94212_f();
                double minV = fluidIcon.func_94206_g();
                double maxV = fluidIcon.func_94210_h();
                Tessellator tessellator = Tessellator.field_78398_a;
                tessellator.func_78382_b();
                tessellator.func_78374_a((double)drawX, (double)(drawY + drawHeight), 0.0, minU, minV + (maxV - minV) * (double)drawHeight / 16.0);
                tessellator.func_78374_a((double)(drawX + drawWidth), (double)(drawY + drawHeight), 0.0, minU + (maxU - minU) * (double)drawWidth / 16.0, minV + (maxV - minV) * (double)drawHeight / 16.0);
                tessellator.func_78374_a((double)(drawX + drawWidth), (double)drawY, 0.0, minU + (maxU - minU) * (double)drawWidth / 16.0, minV);
                tessellator.func_78374_a((double)drawX, (double)drawY, 0.0, minU, minV);
                tessellator.func_78381_a();
            }
        }
        GL11.glEnable((int)3042);
        if (this.overlayTexture != null && this.overlayTexturePos != null) {
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiDraw.changeTexture((String)this.overlayTexture);
            GuiDraw.drawTexturedModalRect((int)this.posX, (int)this.posY, (int)this.overlayTexturePos.x, (int)this.overlayTexturePos.y, (int)16, (int)16);
        }
    }
}

