/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.nio.IntBuffer;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.IRenderHandler;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.IPlanetaryProvider;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.api.armor.IFillableArmor;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.client.render.ClientDynamicTexture;
import zmaster587.advancedRocketry.client.render.planet.RenderPlanetarySky;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.entity.EntityRocket;
import zmaster587.advancedRocketry.inventory.TextureResources;
import zmaster587.libVulpes.api.IArmorComponent;
import zmaster587.libVulpes.api.IModularArmor;
import zmaster587.libVulpes.client.ResourceIcon;
import zmaster587.libVulpes.render.RenderHelper;
import zmaster587.libVulpes.util.ZUtils;

public class RocketEventHandler
extends Gui {
    private ResourceLocation background = TextureResources.rocketHud;
    private static ClientDynamicTexture earth;
    private static ClientDynamicTexture outerBounds;
    private static final int getImgSize = 512;
    private static final int outerImgSize = 64;
    private static boolean mapReady;
    private static boolean mapNeedsBinding;
    private static IRenderHandler prevRenderHanlder;
    private static IntBuffer table;
    private static IntBuffer outerBoundsTable;
    public static GuiBox suitPanel;
    public static GuiBox oxygenBar;
    public static GuiBox hydrogenBar;
    public static GuiBox atmBar;
    private static GuiBox currentlySelectedBox;
    private static final int numTicksToDisplay = 100;
    private static String displayString;
    private static long lastDisplayTime;

    @SubscribeEvent
    public void onRocketDeorbit(RocketEvent.RocketDeOrbitingEvent event) {
        if (event.world.field_72995_K) {
            this.prepareOrbitalMap(event);
            ForgeHooksClient.getSkyBlendColour((World)event.world, (int)0, (int)0, (int)0);
            if (!(event.world.field_73011_w instanceof IPlanetaryProvider)) {
                prevRenderHanlder = event.world.field_73011_w.getSkyRenderer();
                event.world.field_73011_w.setSkyRenderer((IRenderHandler)new RenderPlanetarySky());
            }
        }
    }

    @SubscribeEvent
    public void onRocketLaunch(RocketEvent.RocketLaunchEvent event) {
        if (event.world.field_72995_K && event.entity.field_70154_o != null && event.entity.field_70154_o.equals((Object)Minecraft.func_71410_x().field_71439_g)) {
            this.prepareOrbitalMap(event);
            prevRenderHanlder = event.world.field_73011_w.getSkyRenderer();
            event.world.field_73011_w.setSkyRenderer((IRenderHandler)new RenderPlanetarySky());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void setOverlay(long endTime, String msg) {
        displayString = msg;
        lastDisplayTime = endTime;
    }

    @SideOnly(value=Side.CLIENT)
    public static void destroyOrbitalTextures(World world) {
        if (!(world.field_73011_w instanceof IPlanetaryProvider)) {
            world.field_73011_w.setSkyRenderer(prevRenderHanlder);
            prevRenderHanlder = null;
        }
        if (earth != null) {
            GL11.glDeleteTextures((int)earth.getTextureId());
        }
        if (outerBounds != null) {
            GL11.glDeleteTextures((int)outerBounds.getTextureId());
        }
        outerBounds = null;
        earth = null;
        mapReady = false;
    }

    @SideOnly(value=Side.CLIENT)
    private void prepareOrbitalMap(RocketEvent event) {
        mapReady = false;
        if (earth == null) {
            earth = new ClientDynamicTexture(512, 512);
            outerBounds = new ClientDynamicTexture(64, 64);
        }
        if (event.world.field_73011_w.field_76574_g == Configuration.spaceDimId) {
            RocketEventHandler.destroyOrbitalTextures(event.world);
            return;
        }
        final World worldObj = event.world;
        final Entity entity = event.entity;
        new Thread(new Runnable(){

            @Override
            public void run() {
                table = earth.getByteBuffer();
                outerBoundsTable = outerBounds.getByteBuffer();
                long[] rightEdge = new long[]{0L, 0L, 0L};
                long[] leftEdge = rightEdge;
                long[] bottomEdge = rightEdge;
                long[] topEdge = rightEdge;
                long[] total = rightEdge;
                int numChunksLoaded = 0;
                for (int i = 0; i < 262144; ++i) {
                    int intColor;
                    int b;
                    int g;
                    int r;
                    int color2;
                    int yPosition;
                    int xOffset = i % 512;
                    int yOffset = i / 512;
                    int xPosition = (int)entity.field_70165_t - 256 + xOffset;
                    int zPosition = (int)entity.field_70161_v - 256 + yOffset;
                    Chunk chunk = worldObj.func_72938_d(xPosition, zPosition);
                    if (!chunk.field_76636_d || chunk.func_76621_g()) continue;
                    ++numChunksLoaded;
                    int heightValue = chunk.func_76611_b(xPosition + (chunk.field_76635_g >= 0 ? -(Math.abs(chunk.field_76635_g) << 4) : Math.abs(chunk.field_76635_g) << 4), zPosition + (chunk.field_76647_h >= 0 ? -(Math.abs(chunk.field_76647_h) << 4) : Math.abs(chunk.field_76647_h) << 4));
                    MapColor color = MapColor.field_151660_b;
                    Block block = null;
                    for (yPosition = heightValue; yPosition > 0 && (color = (block = worldObj.func_147439_a(xPosition, yPosition, zPosition)).func_149728_f(worldObj.func_72805_g(xPosition, yPosition, zPosition))) == MapColor.field_151660_b; --yPosition) {
                    }
                    if (block == Blocks.field_150349_c || block == Blocks.field_150329_H) {
                        color2 = worldObj.func_72807_a(xPosition, zPosition).func_150558_b(xPosition, yPosition, zPosition);
                        r = color2 & 0xFF;
                        g = color2 >>> 8 & 0xFF;
                        b = color2 >>> 16 & 0xFF;
                        intColor = b | g << 8 | r << 16;
                    } else if (block == Blocks.field_150362_t || block == Blocks.field_150361_u) {
                        color2 = worldObj.func_72807_a(xPosition, zPosition).func_150571_c(xPosition, yPosition, zPosition);
                        r = color2 & 0xFF;
                        g = color2 >>> 8 & 0xFF;
                        b = color2 >>> 16 & 0xFF;
                        intColor = b | g << 8 | r << 16;
                    } else {
                        intColor = (color.field_76291_p & 0xFF) << 16 | color.field_76291_p >>> 16 & 0xFF | color.field_76291_p & 0xFF00;
                    }
                    table.put(i, intColor | 0xFF000000);
                    total[0] = total[0] + (long)(intColor & 0xFF);
                    total[1] = total[1] + (long)((intColor & 0xFF00) >>> 8);
                    total[2] = total[2] + (long)((intColor & 0xFF0000) >>> 16);
                }
                int multiplierGreen = 1;
                int multiplierBlue = 1;
                total[0] = ZUtils.getAverageColor((long)total[0], (long)(total[1] * (long)multiplierGreen), (long)(total[2] * (long)multiplierBlue), (int)numChunksLoaded);
                Random random = new Random();
                int randomMax = 42;
                for (int i = 0; i < 4096; ++i) {
                    int randR = randomMax - random.nextInt(randomMax) / 2;
                    int randG = randomMax - random.nextInt(randomMax) / 2 << 8;
                    int randB = randomMax - random.nextInt(randomMax) / 2 << 16;
                    int color = MathHelper.func_76125_a((int)((int)((total[0] & 0xFFL) + (long)randR)), (int)0, (int)255) | MathHelper.func_76125_a((int)((int)(total[0] & 0xFF00L) + randG), (int)256, (int)65280) | MathHelper.func_76125_a((int)((int)((total[0] & 0xFF0000L) + (long)randB)), (int)65536, (int)0xFF0000);
                    outerBoundsTable.put(i, color | 0xFF000000);
                }
                outerBoundsTable.flip();
                table.flip();
                mapNeedsBinding = true;
                mapReady = true;
            }
        }, "Planet Texture Creator").start();
    }

    public static void onPostWorldRender(float partialTicks) {
        if (!mapReady) {
            return;
        }
        if (mapNeedsBinding) {
            mapNeedsBinding = false;
            earth.setByteBuffer(table);
            outerBounds.setByteBuffer(outerBoundsTable);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)-5.0f, (float)0.0f);
        GL11.glPushAttrib((int)3009);
        GL11.glEnable((int)3042);
        GL11.glDisable((int)2912);
        GL11.glAlphaFunc((int)516, (float)0.01f);
        GL11.glBlendFunc((int)770, (int)771);
        float brightness = 16.0f;
        if (Minecraft.func_71410_x().field_71451_h != null && Minecraft.func_71410_x().field_71451_h.field_70170_p != null) {
            brightness = Minecraft.func_71410_x().field_71451_h.field_70170_p.func_72971_b(partialTicks);
        }
        double deltaY = (Minecraft.func_71410_x().field_71451_h.field_70163_u - Minecraft.func_71410_x().field_71451_h.field_70137_T) * (double)partialTicks;
        double size = 2560.0 / (72.0 - Minecraft.func_71410_x().field_71451_h.field_70163_u - deltaY);
        Tessellator tess = Tessellator.field_78398_a;
        tess.func_78382_b();
        GL11.glBindTexture((int)3553, (int)outerBounds.getTextureId());
        double size2 = size * 16.0;
        float brightness2 = brightness * 0.43f;
        tess.func_78369_a(brightness2, brightness2, brightness2, MathHelper.func_76131_a((float)(((float)Minecraft.func_71410_x().field_71451_h.field_70163_u - 200.0f) / 50.0f), (float)0.0f, (float)1.0f));
        RenderHelper.renderTopFaceWithUV((Tessellator)tess, (double)-10.1, (double)size2, (double)size2, (double)(-size2), (double)(-size2), (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        tess.func_78381_a();
        tess.func_78382_b();
        GL11.glBindTexture((int)3553, (int)earth.getTextureId());
        float opacityFromHeight = MathHelper.func_76131_a((float)(((float)Minecraft.func_71410_x().field_71451_h.field_70163_u - 200.0f) / 100.0f), (float)0.0f, (float)1.0f);
        tess.func_78369_a(brightness, brightness, brightness, opacityFromHeight);
        RenderHelper.renderTopFaceWithUV((Tessellator)tess, (double)-10.0, (double)size, (double)size, (double)(-size), (double)(-size), (double)0.0, (double)1.0, (double)0.0, (double)1.0);
        tess.func_78381_a();
        Vec3 skyColor = Minecraft.func_71410_x().field_71451_h.field_70170_p.field_73011_w.getSkyColor((Entity)Minecraft.func_71410_x().field_71451_h, partialTicks);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glDisable((int)3553);
        GL11.glBindTexture((int)3553, (int)0);
        tess.func_78382_b();
        tess.func_78369_a((float)skyColor.field_72450_a, (float)skyColor.field_72448_b, (float)skyColor.field_72449_c, 0.05f);
        size = 51200.0 / (180.0 - Minecraft.func_71410_x().field_71451_h.field_70163_u - deltaY);
        int i = 0;
        while ((float)i < 5.0f * MathHelper.func_76131_a((float)(((float)DimensionManager.getInstance().getDimensionProperties(Minecraft.func_71410_x().field_71451_h.field_70170_p.field_73011_w.field_76574_g).getAtmosphereDensity() * 0.01f * (float)Minecraft.func_71410_x().field_71451_h.field_70163_u - 280.0f) / 150.0f), (float)0.0f, (float)2.0f)) {
            RenderHelper.renderTopFace((Tessellator)tess, (double)(-9.0 + (double)i * 0.6), (double)size, (double)size, (double)(-size), (double)(-size));
            ++i;
        }
        GL11.glEnable((int)3553);
        tess.func_78381_a();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2912);
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }

    @SubscribeEvent
    public void onScreenRender(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Entity ride = Minecraft.func_71410_x().field_71439_g.field_70154_o;
            if (ride instanceof EntityRocket) {
                EntityRocket rocket = (EntityRocket)ride;
                GL11.glEnable((int)3042);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.background);
                this.func_73729_b(0, 0, 0, 0, 17, 252);
                float percentOrbit = MathHelper.func_76131_a((float)((float)((rocket.field_70163_u - (double)rocket.field_70170_p.field_73011_w.func_76557_i()) / (double)(Configuration.orbit - rocket.field_70170_p.field_73011_w.func_76557_i()))), (float)0.0f, (float)1.0f);
                this.func_73729_b(3, 8 + (int)(79.0f * (1.0f - percentOrbit)), 17, 0, 6, 6);
                this.func_73729_b(3, 94 + (int)(69.0 * (0.5 - (double)(MathHelper.func_76131_a((float)((float)rocket.field_70181_x), (float)-1.0f, (float)1.0f) / 2.0f))), 17, 0, 6, 6);
                int size = (int)(68.0f * ((float)rocket.getFuelAmount() / (float)rocket.getFuelCapacity()));
                this.func_73729_b(3, 242 - size, 17, 75 - size, 3, size);
                GL11.glDisable((int)3042);
                String str = rocket.getTextOverlay();
                if (!str.isEmpty()) {
                    String[] strs = str.split("\n");
                    int numLines = 0;
                    for (String partStr : strs) {
                        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                        float scale = str.length() < 50 ? 1.0f : 0.5f;
                        int screenX = (int)((float)event.resolution.func_78326_a() / (scale * 6.0f) - (float)(fontRenderer.func_78256_a(partStr) / 2));
                        int screenY = (int)((float)(event.resolution.func_78328_b() / 18) / scale) + numLines * 18;
                        GL11.glPushMatrix();
                        GL11.glScalef((float)(3.0f * scale), (float)(3.0f * scale), (float)(3.0f * scale));
                        fontRenderer.func_78261_a(partStr, screenX, screenY, 0xFFFFFF);
                        GL11.glPopMatrix();
                        ++numLines;
                    }
                }
            }
            ItemStack chestPiece = Minecraft.func_71410_x().field_71439_g.func_71124_b(3);
            if (!Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d && chestPiece != null && chestPiece.func_77973_b() instanceof IFillableArmor) {
                float size = (float)((IFillableArmor)chestPiece.func_77973_b()).getAirRemaining(chestPiece) / (float)((IFillableArmor)chestPiece.func_77973_b()).getMaxAir(chestPiece);
                GL11.glEnable((int)3042);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(this.background);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                int width = 83;
                int screenX = oxygenBar.getRenderX();
                int screenY = oxygenBar.getRenderY();
                this.func_73729_b(screenX, screenY, 23, 0, width, 17);
                this.func_73729_b(screenX, screenY, 23, 17, (int)((float)width * size), 17);
            }
            if (!Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d && Minecraft.func_71410_x().field_71439_g.func_71124_b(4) != null && Minecraft.func_71410_x().field_71439_g.func_71124_b(4).func_77973_b() instanceof IModularArmor) {
                for (int i = 1; i < 5; ++i) {
                    this.renderModuleSlots(Minecraft.func_71410_x().field_71439_g.func_71124_b(i), 4 - i, (RenderGameOverlayEvent)event);
                }
            }
            if (Minecraft.func_71410_x().field_71441_e.func_82737_E() - AtmosphereHandler.lastSuffocationTime < 0L) {
                AtmosphereHandler.lastSuffocationTime = 0L;
            }
            if (Minecraft.func_71410_x().field_71441_e.func_82737_E() - AtmosphereHandler.lastSuffocationTime < 100L) {
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                String str = "";
                if (AtmosphereHandler.currentAtm != null) {
                    str = AtmosphereHandler.currentAtm.getDisplayMessage();
                }
                int screenX = event.resolution.func_78326_a() / 6 - fontRenderer.func_78256_a(str) / 2;
                int screenY = event.resolution.func_78328_b() / 18;
                GL11.glPushMatrix();
                GL11.glScalef((float)3.0f, (float)3.0f, (float)3.0f);
                fontRenderer.func_78261_a(str, screenX, screenY, 0xFF5656);
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                Minecraft.func_71410_x().func_110434_K().func_110577_a(TextureResources.progressBars);
                this.func_73729_b(screenX + fontRenderer.func_78256_a(str) / 2 - 8, screenY - 16, 0, 156, 16, 16);
                GL11.glPopMatrix();
            }
            if (Minecraft.func_71410_x().field_71441_e.func_82737_E() <= lastDisplayTime) {
                FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
                GL11.glPushMatrix();
                GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
                int loc = 0;
                for (String str : displayString.split("\n")) {
                    int screenX = event.resolution.func_78326_a() / 4 - fontRenderer.func_78256_a(str) / 2;
                    int screenY = event.resolution.func_78328_b() / 12 + loc * event.resolution.func_78328_b() / 12;
                    fontRenderer.func_78261_a(str, screenX, screenY, 0xFF5656);
                    ++loc;
                }
                GL11.glColor3f((float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glPopMatrix();
            }
        }
        this.mouseInputEvent(new InputEvent.MouseInputEvent());
    }

    @SubscribeEvent
    public void mouseInputEvent(InputEvent.MouseInputEvent event) {
        if (!Configuration.lockUI && !Mouse.isGrabbed()) {
            if (Mouse.isButtonDown((int)2)) {
                ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
                int i = scaledresolution.func_78326_a();
                int j = scaledresolution.func_78328_b();
                int mouseX = Mouse.getX() * i / Minecraft.func_71410_x().field_71443_c;
                int mouseY = j - Mouse.getY() * j / Minecraft.func_71410_x().field_71440_d - 1;
                if (currentlySelectedBox == null && mouseX >= suitPanel.getX(i) && mouseX < suitPanel.getX(i) + RocketEventHandler.suitPanel.sizeX && mouseY >= suitPanel.getY(j) && mouseY < suitPanel.getY(j) + RocketEventHandler.suitPanel.sizeY) {
                    currentlySelectedBox = suitPanel;
                }
                if (currentlySelectedBox == null && mouseX >= oxygenBar.getX(i) && mouseX < oxygenBar.getX(i) + RocketEventHandler.oxygenBar.sizeX && mouseY >= oxygenBar.getY(j) && mouseY < oxygenBar.getY(j) + RocketEventHandler.oxygenBar.sizeY) {
                    currentlySelectedBox = oxygenBar;
                }
                if (currentlySelectedBox == null && mouseX >= hydrogenBar.getX(i) && mouseX < hydrogenBar.getX(i) + RocketEventHandler.hydrogenBar.sizeX && mouseY >= hydrogenBar.getY(j) && mouseY < hydrogenBar.getY(j) + RocketEventHandler.hydrogenBar.sizeY) {
                    currentlySelectedBox = hydrogenBar;
                }
                if (currentlySelectedBox == null && mouseX >= atmBar.getX(i) && mouseX < atmBar.getX(i) + RocketEventHandler.atmBar.sizeX && mouseY >= atmBar.getY(j) && mouseY < atmBar.getY(j) + RocketEventHandler.atmBar.sizeY) {
                    currentlySelectedBox = atmBar;
                }
                if (currentlySelectedBox != null) {
                    currentlySelectedBox.setRenderX(mouseX, i);
                    currentlySelectedBox.setRenderY(mouseY, j);
                }
            } else {
                currentlySelectedBox = null;
            }
        }
    }

    private void renderModuleSlots(ItemStack armorStack, int slot, RenderGameOverlayEvent event) {
        int index = 1;
        float color = 0.85f + 0.15f * MathHelper.func_76126_a((float)((float)Math.PI * 2 * (float)(Minecraft.func_71410_x().field_71441_e.func_82737_E() % 60L) / 60.0f));
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        float alpha = 0.6f;
        if (armorStack != null && armorStack.func_77973_b() instanceof IModularArmor) {
            int size = 24;
            int screenY = suitPanel.getRenderY() + (slot - 1) * (size + 8) + 32;
            int screenX = suitPanel.getRenderX();
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureResources.frameHUDBG);
            Tessellator.field_78398_a.func_78382_b();
            RenderHelper.renderNorthFaceWithUV((Tessellator)Tessellator.field_78398_a, (double)(this.field_73735_i - 1.0f), (double)(screenX - 4), (double)(screenY - 4), (double)(screenX + size), (double)(screenY + size + 4), (double)0.0, (double)0.5, (double)0.0, (double)1.0);
            Tessellator.field_78398_a.func_78381_a();
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureResources.frameHUDBG);
            Tessellator.field_78398_a.func_78382_b();
            RenderHelper.renderNorthFaceWithUV((Tessellator)Tessellator.field_78398_a, (double)(this.field_73735_i - 1.0f), (double)(screenX + size), (double)(screenY - 3), (double)(screenX + 2 + size), (double)(screenY + size + 3), (double)0.5, (double)0.5, (double)0.0, (double)0.0);
            Tessellator.field_78398_a.func_78381_a();
            GL11.glColor4f((float)color, (float)color, (float)color, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureResources.armorSlots[slot]);
            Tessellator.field_78398_a.func_78382_b();
            RenderHelper.renderNorthFaceWithUV((Tessellator)Tessellator.field_78398_a, (double)(this.field_73735_i - 1.0f), (double)screenX, (double)screenY, (double)(screenX + size), (double)(screenY + size), (double)0.0, (double)1.0, (double)1.0, (double)0.0);
            Tessellator.field_78398_a.func_78381_a();
            List stacks = ((IModularArmor)armorStack.func_77973_b()).getComponents(armorStack);
            for (ItemStack stack : stacks) {
                GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                ((IArmorComponent)stack.func_77973_b()).renderScreen(stack, stacks, event, (Gui)this);
                ResourceIcon icon = ((IArmorComponent)stack.func_77973_b()).getComponentIcon(stack);
                ResourceLocation texture = icon.getResourceLocation();
                if (texture == null) continue;
                screenX = suitPanel.getRenderX() + 4 + index * (size + 2);
                Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureResources.frameHUDBG);
                Tessellator.field_78398_a.func_78382_b();
                RenderHelper.renderNorthFaceWithUV((Tessellator)Tessellator.field_78398_a, (double)(this.field_73735_i - 1.0f), (double)(screenX - 4), (double)(screenY - 4), (double)(screenX + size - 2), (double)(screenY + size + 4), (double)0.5, (double)0.5, (double)0.0, (double)1.0);
                Tessellator.field_78398_a.func_78381_a();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(texture);
                GL11.glColor4f((float)color, (float)color, (float)color, (float)alpha);
                Tessellator.field_78398_a.func_78382_b();
                RenderHelper.renderNorthFaceWithUV((Tessellator)Tessellator.field_78398_a, (double)(this.field_73735_i - 1.0f), (double)screenX, (double)screenY, (double)(screenX + size), (double)(screenY + size), (double)icon.func_94209_e(), (double)icon.func_94212_f(), (double)icon.func_94210_h(), (double)icon.func_94206_g());
                Tessellator.field_78398_a.func_78381_a();
                ++index;
            }
            screenX = index * (size + 2) + suitPanel.getRenderX() - 12;
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Minecraft.func_71410_x().field_71446_o.func_110577_a(TextureResources.frameHUDBG);
            Tessellator.field_78398_a.func_78382_b();
            RenderHelper.renderNorthFaceWithUV((Tessellator)Tessellator.field_78398_a, (double)(this.field_73735_i - 1.0f), (double)(screenX + 12), (double)(screenY - 4), (double)(screenX + size), (double)(screenY + size + 4), (double)0.75, (double)1.0, (double)0.0, (double)1.0);
            Tessellator.field_78398_a.func_78381_a();
        }
        GL11.glDisable((int)3042);
    }

    static {
        mapReady = false;
        mapNeedsBinding = false;
        prevRenderHanlder = null;
        suitPanel = new GuiBox(8, 8, 24, 24);
        oxygenBar = new GuiBox(8, -57, 80, 48);
        hydrogenBar = new GuiBox(8, -74, 80, 48);
        atmBar = new GuiBox(8, 27, 200, 48);
        currentlySelectedBox = null;
        displayString = "";
        lastDisplayTime = -1000L;
    }

    public static class GuiBox {
        private int x;
        private int y;
        int modeX = -1;
        int modeY = -1;
        int sizeX;
        int sizeY;
        boolean isVisible = true;

        public GuiBox(int x, int y, int sizeX, int sizeY) {
            this.setRawX(x);
            this.setRawY(y);
            this.sizeX = sizeX;
            this.sizeY = sizeY;
        }

        public int getX(int scaledW) {
            if (this.modeX == 1) {
                return scaledW - this.getRawX();
            }
            if (this.modeX == 0) {
                return scaledW / 2 - this.getRawX();
            }
            return this.getRawX();
        }

        public int getY(int scaledH) {
            if (this.modeY == 1) {
                return scaledH - this.getRawY();
            }
            if (this.modeY == 0) {
                return scaledH / 2 - this.getRawY();
            }
            return this.getRawY();
        }

        public void setRenderX(int x, double scaleX) {
            double i = scaleX;
            if ((double)x < i / 3.0) {
                this.modeX = -1;
                this.setRawX(x);
            } else if ((double)x > i * 2.0 / 3.0) {
                this.setRawX((int)(i - (double)x));
                this.modeX = 1;
            } else {
                this.setRawX((int)(i / 2.0 - (double)x));
                this.modeX = 0;
            }
        }

        public void setRenderY(int y, double scaleY) {
            double i = scaleY;
            if ((double)y < i / 3.0) {
                this.modeY = -1;
                this.setRawY(y);
            } else if ((double)y > i * 2.0 / 3.0) {
                this.setRawY((int)(i - (double)y));
                this.modeY = 1;
            } else {
                this.setRawY((int)(i / 2.0 - (double)y));
                this.modeY = 0;
            }
        }

        public int getRenderX() {
            ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            int i = scaledresolution.func_78326_a();
            if (this.modeX == 1) {
                return i - this.getRawX();
            }
            if (this.modeX == 0) {
                return i / 2 - this.getRawX();
            }
            return this.getRawX();
        }

        public int getRenderY() {
            ScaledResolution scaledresolution = new ScaledResolution(Minecraft.func_71410_x(), Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
            int i = scaledresolution.func_78328_b();
            if (this.modeY == 1) {
                return i - this.getRawY();
            }
            if (this.modeY == 0) {
                return i / 2 - this.getRawY();
            }
            return this.getRawY();
        }

        public int getRawX() {
            return this.x;
        }

        public void setRawX(int x) {
            this.x = x;
        }

        public int getRawY() {
            return this.y;
        }

        public void setRawY(int y) {
            this.y = y;
        }

        public void setSizeModeX(int int1) {
            this.modeX = int1;
        }

        public void setSizeModeY(int int1) {
            this.modeY = int1;
        }

        public int getSizeModeX() {
            return this.modeX;
        }

        public int getSizeModeY() {
            return this.modeY;
        }
    }
}

