/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.event;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetworkManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.stats.StatBase;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.event.EntityViewRenderEvent;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.entity.player.PlayerOpenContainerEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.terraingen.OreGenEvent;
import net.minecraftforge.event.terraingen.PopulateChunkEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.achievements.ARAchivements;
import zmaster587.advancedRocketry.api.AdvancedRocketryBlocks;
import zmaster587.advancedRocketry.api.AdvancedRocketryItems;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.IPlanetaryProvider;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.event.RocketEventHandler;
import zmaster587.advancedRocketry.network.PacketDimInfo;
import zmaster587.advancedRocketry.network.PacketSpaceStationInfo;
import zmaster587.advancedRocketry.network.PacketStellarInfo;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.util.BiomeHandler;
import zmaster587.advancedRocketry.util.TransitionEntity;
import zmaster587.advancedRocketry.world.provider.WorldProviderPlanet;
import zmaster587.advancedRocketry.world.util.TeleporterNoPortal;
import zmaster587.libVulpes.api.IModularArmor;
import zmaster587.libVulpes.api.LibVulpesItems;
import zmaster587.libVulpes.api.material.MaterialRegistry;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;

public class PlanetEventHandler {
    public static long time = 0L;
    private static long endTime;
    private static long duration;
    private static Map<Long, TransitionEntity> transitionMap;
    private static HashSet<WeakReference<EntityPlayer>> inventoryCheckPlayerBypassMap;
    static final ItemStack component;

    public static void addDelayedTransition(long tick, TransitionEntity entity) {
        transitionMap.put(tick, entity);
    }

    @SubscribeEvent
    public void sleepEvent(PlayerSleepInBedEvent event) {
        if (event.entity.field_70170_p.field_73011_w instanceof WorldProviderPlanet && AtmosphereHandler.hasAtmosphereHandler(event.entity.field_70170_p.field_73011_w.field_76574_g) && !AtmosphereHandler.getOxygenHandler(event.entity.field_70170_p.field_73011_w.field_76574_g).getAtmosphereType(event.x, event.y, event.z).isBreathable()) {
            event.result = EntityPlayer.EnumStatus.OTHER_PROBLEM;
        }
    }

    @SubscribeEvent
    public void onCrafting(PlayerEvent.ItemCraftedEvent event) {
        if (event.crafting != null) {
            Item item = event.crafting.func_77973_b();
            if (item == LibVulpesItems.itemHoloProjector) {
                event.player.func_71029_a((StatBase)ARAchivements.holographic);
            } else if (item == Item.func_150898_a((Block)AdvancedRocketryBlocks.blockRollingMachine)) {
                event.player.func_71029_a((StatBase)ARAchivements.rollin);
            } else if (item == Item.func_150898_a((Block)AdvancedRocketryBlocks.blockCrystallizer)) {
                event.player.func_71029_a((StatBase)ARAchivements.crystalline);
            } else if (item == Item.func_150898_a((Block)AdvancedRocketryBlocks.blockLathe)) {
                event.player.func_71029_a((StatBase)ARAchivements.spinDoctor);
            } else if (item == Item.func_150898_a((Block)AdvancedRocketryBlocks.blockElectrolyser)) {
                event.player.func_71029_a((StatBase)ARAchivements.electrifying);
            } else if (item == Item.func_150898_a((Block)AdvancedRocketryBlocks.blockArcFurnace)) {
                event.player.func_71029_a((StatBase)ARAchivements.feelTheHeat);
            } else if (item == Item.func_150898_a((Block)AdvancedRocketryBlocks.blockWarpCore)) {
                event.player.func_71029_a((StatBase)ARAchivements.warp);
            } else if (item == Item.func_150898_a((Block)AdvancedRocketryBlocks.blockPlatePress)) {
                event.player.func_71029_a((StatBase)ARAchivements.blockPresser);
            }
        }
    }

    @SubscribeEvent
    public void onWorldGen(OreGenEvent.GenerateMinable event) {
        if (event.world.field_73011_w instanceof WorldProviderPlanet && DimensionManager.getInstance().getDimensionProperties(event.world.field_73011_w.field_76574_g).getOreGenProperties(event.world) != null) {
            switch (event.type) {
                case COAL: 
                case DIAMOND: 
                case GOLD: 
                case IRON: 
                case LAPIS: 
                case QUARTZ: 
                case REDSTONE: 
                case CUSTOM: {
                    event.setResult(Event.Result.DENY);
                    break;
                }
                default: {
                    event.setResult(Event.Result.DEFAULT);
                }
            }
        }
    }

    @SubscribeEvent
    public void onPickup(PlayerEvent.ItemPickupEvent event) {
        if (event.pickedUp != null) {
            Item item = event.pickedUp.func_92059_d().func_77973_b();
            zmaster587.libVulpes.api.material.Material mat = MaterialRegistry.getMaterialFromItemStack((ItemStack)event.pickedUp.func_92059_d());
            if (mat != null && mat.getUnlocalizedName().contains("Dilithium")) {
                event.player.func_71029_a((StatBase)ARAchivements.dilithiumCrystals);
            }
        }
    }

    @SubscribeEvent
    public void playerTick(LivingEvent.LivingUpdateEvent event) {
        if (event.entity.field_70170_p.field_72995_K && event.entity.field_70163_u > 260.0 && event.entity.field_70163_u < 270.0 && event.entity.field_70181_x < -0.1) {
            RocketEventHandler.destroyOrbitalTextures(event.entity.field_70170_p);
        }
        if (event.entity.func_70090_H() && AtmosphereType.LOWOXYGEN.isImmune(event.entityLiving)) {
            event.entity.func_70050_g(300);
        }
        if (!event.entity.field_70170_p.field_72995_K && event.entity.field_70170_p.func_82737_E() % 20L == 0L && event.entity instanceof EntityPlayer && DimensionManager.getInstance().getDimensionProperties(event.entity.field_70170_p.field_73011_w.field_76574_g).getName().equals("Luna") && event.entity.func_70092_e(67.0, 80.0, 2347.0) < 512.0) {
            ((EntityPlayer)event.entity).func_71029_a((StatBase)ARAchivements.weReallyWentToTheMoon);
        }
    }

    @SubscribeEvent
    public void blockPlaceEvent(PlayerInteractEvent event) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)event.face);
        if (!event.world.field_72995_K && PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK == event.action && event.entityPlayer != null && AtmosphereHandler.getOxygenHandler(event.world.field_73011_w.field_76574_g) != null && !AtmosphereHandler.getOxygenHandler(event.world.field_73011_w.field_76574_g).getAtmosphereType(event.x + direction.offsetX, event.y + direction.offsetY, event.z + direction.offsetZ).allowsCombustion() && event.entityPlayer.func_71045_bC() != null) {
            if (event.entityPlayer.func_71045_bC().func_77973_b() == Item.func_150898_a((Block)Blocks.field_150478_aa) && event.world.func_147439_a(event.x, event.y, event.z).isSideSolid((IBlockAccess)event.world, event.x, event.y, event.z, direction)) {
                event.setCanceled(true);
                event.world.func_147449_b(event.x + direction.offsetX, event.y + direction.offsetY, event.z + direction.offsetZ, AdvancedRocketryBlocks.blockUnlitTorch);
            } else if (Configuration.torchBlocks.contains(Block.func_149634_a((Item)event.entityPlayer.func_71045_bC().func_77973_b()))) {
                event.setCanceled(true);
            } else if (event.entityPlayer.func_71045_bC().func_77973_b() == Items.field_151033_d || event.entityPlayer.func_71045_bC().func_77973_b() == Items.field_151059_bz || event.entityPlayer.func_71045_bC().func_77973_b() == Items.field_151065_br || event.entityPlayer.func_71045_bC().func_77973_b() == Items.field_151072_bj || event.entityPlayer.func_71045_bC().func_77973_b() == Items.field_151129_at) {
                event.setCanceled(true);
            }
        }
        if (!event.world.field_72995_K && event.entityPlayer != null && event.action == PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK && event.entityPlayer.func_71045_bC() != null && event.entityPlayer.func_71045_bC().func_77973_b() == Items.field_151104_aV && event.world.field_73011_w instanceof WorldProviderPlanet) {
            AdvancedRocketryItems.itemAstroBed.func_77648_a(event.entityPlayer.func_71045_bC(), event.entityPlayer, event.entityPlayer.field_70170_p, event.x, event.y, event.z, event.face, 0.0f, 0.0f, 0.0f);
            event.setCanceled(true);
        }
        if (!event.world.field_72995_K && event.entityPlayer != null && event.entityPlayer.func_71045_bC() != null && event.entityPlayer.func_71045_bC().func_77973_b() == Item.func_150898_a((Block)AdvancedRocketryBlocks.blockGenericSeat) && event.world.func_147439_a(event.x, event.y, event.z) == Blocks.field_150335_W) {
            event.entityPlayer.func_71029_a((StatBase)ARAchivements.beerOnTheSun);
        }
    }

    @Mod.EventHandler
    public void disconnected(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        DimensionManager.getInstance().unregisterAllDimensions();
    }

    public static void addPlayerToInventoryBypass(EntityPlayer player) {
        inventoryCheckPlayerBypassMap.add(new WeakReference<EntityPlayer>(player));
    }

    public static void removePlayerFromInventoryBypass(EntityPlayer player) {
        Iterator<WeakReference<EntityPlayer>> iter = inventoryCheckPlayerBypassMap.iterator();
        while (iter.hasNext()) {
            WeakReference<EntityPlayer> player2 = iter.next();
            if (player2.get() != player && player2.get() != null) continue;
            iter.remove();
        }
    }

    public static boolean canPlayerBypassInvChecks(EntityPlayer player) {
        for (WeakReference<EntityPlayer> player2 : inventoryCheckPlayerBypassMap) {
            if (player2.get() != player) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void containerOpen(PlayerOpenContainerEvent event) {
        if (PlanetEventHandler.canPlayerBypassInvChecks(event.entityPlayer)) {
            if (event.entityPlayer.field_71070_bA.field_75152_c == 0) {
                PlanetEventHandler.removePlayerFromInventoryBypass(event.entityPlayer);
            } else {
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        TickEvent.Phase cfr_ignored_0 = event.phase;
        if (event.phase == TickEvent.Phase.END) {
            DimensionManager.getInstance().tickDimensions();
            ++time;
            if (!transitionMap.isEmpty()) {
                Iterator<Map.Entry<Long, TransitionEntity>> itr = transitionMap.entrySet().iterator();
                while (itr.hasNext()) {
                    Map.Entry<Long, TransitionEntity> entry = itr.next();
                    TransitionEntity ent = entry.getValue();
                    if (ent.entity.field_70170_p.func_82737_E() < entry.getKey()) continue;
                    ent.entity.func_70012_b((double)ent.location.x, (double)ent.location.y, (double)ent.location.z, ent.entity.field_70177_z, ent.entity.field_70125_A);
                    MinecraftServer.func_71276_C().func_71203_ab().transferPlayerToDimension((EntityPlayerMP)ent.entity, ent.dimId, (Teleporter)new TeleporterNoPortal(MinecraftServer.func_71276_C().func_71218_a(ent.dimId)));
                    ent.entity.func_70078_a(ent.entity2);
                    itr.remove();
                }
            }
        }
    }

    @SubscribeEvent
    public void tickClient(TickEvent.ClientTickEvent event) {
        TickEvent.Phase cfr_ignored_0 = event.phase;
        if (event.phase == TickEvent.Phase.END) {
            DimensionManager.getInstance().tickDimensionsClient();
        }
    }

    @SubscribeEvent
    public void playerLoggedInEvent(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        int i;
        Object object = DimensionManager.getInstance().getStarIds().iterator();
        while (object.hasNext()) {
            i = object.next();
            PacketHandler.sendToDispatcher((BasePacket)new PacketStellarInfo(i, DimensionManager.getInstance().getStar(i)), (NetworkManager)event.manager);
        }
        object = DimensionManager.getInstance().getRegisteredDimensions();
        i = ((Integer[])object).length;
        for (int j = 0; j < i; ++j) {
            int i2 = object[j];
            PacketHandler.sendToDispatcher((BasePacket)new PacketDimInfo(i2, DimensionManager.getInstance().getDimensionProperties(i2)), (NetworkManager)event.manager);
        }
        for (ISpaceObject obj : SpaceObjectManager.getSpaceManager().getSpaceObjects()) {
            PacketHandler.sendToDispatcher((BasePacket)new PacketSpaceStationInfo(obj.getId(), obj), (NetworkManager)event.manager);
        }
        PacketHandler.sendToDispatcher((BasePacket)new PacketDimInfo(0, DimensionManager.getInstance().getDimensionProperties(0)), (NetworkManager)event.manager);
    }

    @SubscribeEvent
    public void worldLoadEvent(WorldEvent.Load event) {
        if (!event.world.field_72995_K) {
            AtmosphereHandler.registerWorld(event.world.field_73011_w.field_76574_g);
        }
    }

    @SubscribeEvent
    public void worldUnloadEvent(WorldEvent.Unload event) {
        if (!event.world.field_72995_K) {
            AtmosphereHandler.unregisterWorld(event.world.field_73011_w.field_76574_g);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void runBurst(long endTime, long duration) {
        PlanetEventHandler.endTime = endTime;
        PlanetEventHandler.duration = duration;
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void fogColor(EntityViewRenderEvent.FogColors event) {
        Block block = ActiveRenderInfo.func_151460_a((World)event.entity.field_70170_p, (EntityLivingBase)event.entity, (float)((float)event.renderPartialTicks));
        if (block.func_149688_o() == Material.field_151586_h) {
            return;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(event.entity.field_71093_bK);
        if (properties != null) {
            float fog = properties.getAtmosphereDensityAtHeight(event.entity.field_70163_u);
            if (event.entity.field_70170_p.field_73011_w instanceof IPlanetaryProvider) {
                Vec3 color = event.entity.field_70170_p.field_73011_w.getSkyColor((Entity)event.entity, 0.0f);
                event.red = (float)Math.min(color.field_72450_a * (double)1.4f, 1.0);
                event.green = (float)Math.min(color.field_72448_b * (double)1.4f, 1.0);
                event.blue = (float)Math.min(color.field_72449_c * (double)1.4f, 1.0);
            }
            if (endTime > 0L) {
                double amt = (double)(endTime - Minecraft.func_71410_x().field_71441_e.func_82737_E()) / (double)duration;
                if (amt < 0.0) {
                    endTime = 0L;
                } else {
                    event.blue = event.red = (float)amt;
                    event.green = event.red;
                }
            } else {
                event.red *= fog;
                event.green *= fog;
                event.blue *= fog;
            }
        }
    }

    @SubscribeEvent
    public void serverTickEvent(TickEvent.WorldTickEvent event) {
        List list;
        if (Configuration.allowTerraforming && event.world.field_73011_w.getClass() == WorldProviderPlanet.class && DimensionManager.getInstance().getDimensionProperties(event.world.field_73011_w.field_76574_g).isTerraformed() && (list = ((WorldServer)event.world).field_73059_b.field_73245_g).size() > 0) {
            for (int i = 0; i < Configuration.terraformingBlockSpeed; ++i) {
                Chunk chunk = (Chunk)list.get(event.world.field_73012_v.nextInt(list.size()));
                int coord = event.world.field_73012_v.nextInt(256);
                int x = (coord & 0xF) + chunk.field_76635_g * 16;
                int z = (coord >> 4) + chunk.field_76647_h * 16;
                BiomeHandler.changeBiome(event.world, ((WorldProviderPlanet)event.world.field_73011_w).chunkMgrTerraformed.func_76935_a((int)x, (int)z).field_76756_M, x, z);
            }
        }
    }

    @SubscribeEvent
    public void chunkLoadEvent(PopulateChunkEvent.Post event) {
        if (Configuration.allowTerraforming && event.world.field_73011_w.getClass() == WorldProviderPlanet.class && DimensionManager.getInstance().getDimensionProperties(event.world.field_73011_w.field_76574_g).isTerraformed()) {
            Chunk chunk = event.world.func_72964_e(event.chunkX, event.chunkZ);
            PlanetEventHandler.modifyChunk(event.world, (WorldProviderPlanet)event.world.field_73011_w, chunk);
        }
    }

    @SubscribeEvent
    public void chunkLoadEvent(ChunkEvent.Load event) {
    }

    public static void modifyChunk(World world, WorldProviderPlanet provider, Chunk chunk) {
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                BiomeHandler.changeBiome(world, provider.chunkMgrTerraformed.func_76935_a((int)(x + chunk.field_76635_g * 16), (int)(z + chunk.field_76647_h * 16)).field_76756_M, chunk, x + chunk.field_76635_g * 16, z + chunk.field_76647_h * 16);
            }
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void fogColor(EntityViewRenderEvent.RenderFogEvent event) {
        if (event.fogMode == -1) {
            return;
        }
        DimensionProperties properties = DimensionManager.getInstance().getDimensionProperties(event.entity.field_71093_bK);
        if (properties != null && event.block != Blocks.field_150355_j && event.block != Blocks.field_150353_l) {
            float far;
            float near;
            float fog = properties.getAtmosphereDensityAtHeight(event.entity.field_70163_u);
            GL11.glFogi((int)2917, (int)9729);
            float f1 = event.farPlaneDistance;
            int atmosphere = properties.getAtmosphereDensity();
            ItemStack armor = Minecraft.func_71410_x().field_71439_g.func_82169_q(3);
            if (armor != null && armor.func_77973_b() instanceof IModularArmor) {
                for (ItemStack i : ((IModularArmor)armor.func_77973_b()).getComponents(armor)) {
                    if (!i.func_77969_a(component)) continue;
                    atmosphere = Math.min(atmosphere, 100);
                    break;
                }
            }
            if (AtmosphereHandler.currentPressure != -1) {
                atmosphere = AtmosphereHandler.currentPressure;
            }
            if (atmosphere > 100) {
                near = 0.75f * f1 * (2.0f - (float)(atmosphere * atmosphere) / 10000.0f);
                far = f1;
            } else {
                near = 0.75f * f1 * (2.0f - (float)atmosphere / 100.0f);
                far = f1 * (2.002f - (float)atmosphere / 100.0f);
            }
            GL11.glFogf((int)2915, (float)near);
            GL11.glFogf((int)2916, (float)far);
            GL11.glFogf((int)2914, (float)0.0f);
        }
    }

    @SubscribeEvent
    public void worldSaveEvent(WorldEvent.Save event) {
        if (event.world.field_73011_w.field_76574_g == 0) {
            DimensionManager.getInstance().saveDimensions("advRocketry");
        }
    }

    @SubscribeEvent
    public void fallEvent(LivingFallEvent event) {
        if (event.entity.field_70170_p.field_73011_w instanceof IPlanetaryProvider) {
            IPlanetaryProvider planet = (IPlanetaryProvider)event.entity.field_70170_p.field_73011_w;
            event.distance = (float)((double)event.distance * planet.getGravitationalMultiplier((int)event.entity.field_70165_t, (int)event.entity.field_70161_v));
        }
    }

    static {
        transitionMap = new HashMap<Long, TransitionEntity>();
        inventoryCheckPlayerBypassMap = new HashSet();
        component = new ItemStack(AdvancedRocketryItems.itemUpgrade, 1, 4);
    }
}

