/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.event;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.cable.NetworkRegistry;
import zmaster587.advancedRocketry.tile.cables.TilePipe;

public class CableTickHandler {
    @SubscribeEvent
    public void onTick(TickEvent.ServerTickEvent tick) {
        if (tick.phase == TickEvent.Phase.END) {
            NetworkRegistry.dataNetwork.tickAllNetworks();
            NetworkRegistry.energyNetwork.tickAllNetworks();
            NetworkRegistry.liquidNetwork.tickAllNetworks();
        }
    }

    @SubscribeEvent
    public void chunkLoadedEvent(ChunkEvent.Load event) {
        Map map = event.getChunk().field_150816_i;
        Iterator iter = map.entrySet().iterator();
        try {
            while (iter.hasNext()) {
                Object obj = iter.next().getValue();
                if (!(obj instanceof TilePipe)) continue;
                ((TilePipe)((Object)obj)).markForUpdate();
            }
        }
        catch (ConcurrentModificationException e) {
            AdvancedRocketry.logger.warn("You have been visited by the rare pepe.. I mean error of pipes not loading, this is not good, some pipe systems may not work right away.  But it's better than a corrupt world");
        }
    }

    @SubscribeEvent
    public void onBlockBroken(BlockEvent.BreakEvent event) {
        if (event.block.hasTileEntity(event.blockMetadata)) {
            TileEntity homeTile = event.world.func_147438_o(event.x, event.y, event.z);
            if (homeTile instanceof TilePipe) {
                TileEntity tile;
                ((TilePipe)homeTile).setDestroyed();
                ((TilePipe)homeTile).setInvalid();
                int pipecount = 0;
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    tile = event.world.func_147438_o(event.x + dir.offsetX, event.y + dir.offsetY, event.z + dir.offsetZ);
                    if (!(tile instanceof TilePipe)) continue;
                    ++pipecount;
                }
                if (pipecount > 1) {
                    for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                        tile = event.world.func_147438_o(event.x + dir.offsetX, event.y + dir.offsetY, event.z + dir.offsetZ);
                        if (!(tile instanceof TilePipe)) continue;
                        ((TilePipe)tile).getNetworkHandler().removeNetworkByID(((TilePipe)tile).getNetworkID());
                        ((TilePipe)tile).setInvalid();
                    }
                }
                if (pipecount == 0) {
                    ((TilePipe)homeTile).getNetworkHandler().removeNetworkByID(((TilePipe)homeTile).getNetworkID());
                }
                ((TilePipe)homeTile).func_70296_d();
            } else if (homeTile != null) {
                for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
                    TileEntity tile = event.world.func_147438_o(event.x + dir.offsetX, event.y + dir.offsetY, event.z + dir.offsetZ);
                    if (!(tile instanceof TilePipe)) continue;
                    ((TilePipe)tile).getNetworkHandler().removeFromAllTypes((TilePipe)tile, homeTile);
                }
            }
        }
    }
}

