/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.entity;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.Iterator;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.Teleporter;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.common.MinecraftForge;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.RocketEvent;
import zmaster587.advancedRocketry.event.PlanetEventHandler;
import zmaster587.advancedRocketry.tile.multiblock.TileSpaceElevator;
import zmaster587.advancedRocketry.util.DimensionBlockPosition;
import zmaster587.advancedRocketry.util.TransitionEntity;
import zmaster587.advancedRocketry.world.util.TeleporterNoPortal;
import zmaster587.libVulpes.LibVulpes;
import zmaster587.libVulpes.interfaces.INetworkEntity;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketEntity;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.BlockPosition;

public class EntityElevatorCapsule
extends Entity
implements INetworkEntity {
    public static final double MAX_HEIGHT = Configuration.orbit;
    public static final double MAX_STANDTIME = 200.0;
    byte motion;
    int standTime;
    int idleTime;
    DimensionBlockPosition dstTilePos;
    DimensionBlockPosition srcTilePos;
    private static final byte PACKET_WRITE_DST_INFO = 0;
    private static final byte PACKET_RECIEVE_NBT = 1;
    private static final byte PACKET_LAUNCH_EVENT = 2;
    private static final byte PACKET_DEORBIT = 3;
    private static final byte PACKET_WRITE_SRC_INFO = 4;
    protected static final int motionDir = 2;
    protected static final int standTimeCounter = 3;

    public EntityElevatorCapsule(World worldIn) {
        super(worldIn);
        this.func_70105_a(3.0f, 3.0f);
        this.motion = 0;
        this.field_70158_ak = true;
    }

    public boolean isAscending() {
        return this.field_70180_af.func_75683_a(2) > 0;
    }

    public boolean isDescending() {
        return this.field_70180_af.func_75683_a(2) < 0;
    }

    public boolean isInMotion() {
        return this.field_70180_af.func_75683_a(2) != 0;
    }

    public void setCapsuleMotion(int motion) {
        this.field_70180_af.func_75692_b(2, (Object)((byte)motion));
        this.motion = (byte)motion;
    }

    public int getStandTime() {
        this.standTime = this.field_70180_af.func_75679_c(3);
        return this.standTime;
    }

    public void setStandTime(int time) {
        this.field_70180_af.func_75692_b(3, (Object)this.standTime);
    }

    public int decrStandTime() {
        this.standTime = this.getStandTime() - 1;
        this.field_70180_af.func_75692_b(3, (Object)this.standTime);
        return this.standTime;
    }

    protected void func_70088_a() {
        this.field_70180_af.func_75682_a(2, (Object)this.motion);
        this.field_70180_af.func_75682_a(3, (Object)this.standTime);
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        int[] loc;
        this.setCapsuleMotion(nbt.func_74771_c("motionDir"));
        if (nbt.func_74764_b("dstDimid")) {
            this.dstTilePos = new DimensionBlockPosition(-1, null);
            this.dstTilePos.dimid = nbt.func_74762_e("dstDimid");
            loc = nbt.func_74759_k("dstLoc");
            this.dstTilePos.pos = new BlockPosition(loc[0], loc[1], loc[2]);
        } else {
            this.dstTilePos = null;
        }
        if (nbt.func_74764_b("srcDimid")) {
            this.srcTilePos = new DimensionBlockPosition(-1, null);
            this.srcTilePos.dimid = nbt.func_74762_e("srcDimid");
            loc = nbt.func_74759_k("srcLoc");
            this.srcTilePos.pos = new BlockPosition(loc[0], loc[1], loc[2]);
        } else {
            this.srcTilePos = null;
        }
    }

    public void func_145769_d(int id) {
        super.func_145769_d(id);
        if (this.field_70170_p.field_72995_K) {
            PacketHandler.sendToServer((BasePacket)new PacketEntity((INetworkEntity)this, 1));
        }
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74774_a("motionDir", this.motion);
        if (this.dstTilePos != null) {
            nbt.func_74768_a("dstDimid", this.dstTilePos.dimid);
            nbt.func_74783_a("dstLoc", new int[]{this.dstTilePos.pos.x, this.dstTilePos.pos.y, this.dstTilePos.pos.z});
        }
        if (this.srcTilePos != null) {
            nbt.func_74768_a("srcDimid", this.srcTilePos.dimid);
            nbt.func_74783_a("srcLoc", new int[]{this.srcTilePos.pos.x, this.srcTilePos.pos.y, this.srcTilePos.pos.z});
        }
    }

    public boolean shouldRiderSit() {
        return false;
    }

    public void setDst(DimensionBlockPosition location) {
        this.dstTilePos = location;
        if (!this.field_70170_p.field_72995_K) {
            PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, 0), (Entity)this);
        }
    }

    public void setSourceTile(DimensionBlockPosition location) {
        this.srcTilePos = location;
        if (!this.field_70170_p.field_72995_K) {
            PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, 4), (Entity)this);
        }
    }

    public void func_71027_c(int newDimId) {
        this.travelToDimension(newDimId, this.field_70165_t, Configuration.orbit, this.field_70161_v);
    }

    public void travelToDimension(int newDimId, double posX, double y, double posZ) {
        if (!this.field_70170_p.field_72995_K && !this.field_70128_L) {
            double x = posX;
            double z = posZ;
            Entity rider = this.field_70153_n;
            if (rider != null) {
                rider.func_70078_a(null);
            }
            this.field_70170_p.field_72984_F.func_76320_a("changeDimension");
            MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
            int j = this.field_71093_bK;
            WorldServer worldserver = minecraftserver.func_71218_a(j);
            WorldServer worldserver1 = minecraftserver.func_71218_a(newDimId);
            this.field_71093_bK = newDimId;
            this.field_70128_L = false;
            this.field_70170_p.field_72984_F.func_76320_a("reposition");
            minecraftserver.func_71203_ab().transferEntityToWorld((Entity)this, j, worldserver, worldserver1, (Teleporter)new TeleporterNoPortal(worldserver1));
            this.field_70170_p.field_72984_F.func_76318_c("reloading");
            Entity entity = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)this), (World)worldserver1);
            if (entity != null) {
                entity.func_82141_a((Entity)this, true);
                entity.field_98038_p = true;
                entity.func_70012_b(x, y, z, this.field_70177_z, this.field_70125_A);
                worldserver1.func_72838_d(entity);
                if (rider != null) {
                    PlanetEventHandler.addDelayedTransition(worldserver.func_82737_E() + 1L, new TransitionEntity(worldserver.func_82737_E() + 1L, rider, this.field_71093_bK, new BlockPosition((int)posX, Configuration.orbit, (int)posZ), entity));
                }
            }
            this.func_70106_y();
            this.field_70170_p.field_72984_F.func_76319_b();
            worldserver.func_82742_i();
            worldserver1.func_82742_i();
            this.field_70170_p.field_72984_F.func_76319_b();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_70030_z() {
        super.func_70030_z();
        this.field_70158_ak = true;
        if (!this.field_70170_p.field_72995_K && this.field_70173_aa == 5) {
            if (this.dstTilePos != null) {
                this.setDst(this.dstTilePos);
            }
            if (this.srcTilePos != null) {
                this.setSourceTile(this.srcTilePos);
            }
        }
        if (this.isAscending()) {
            this.field_70181_x = this.field_70163_u > 255.0 ? 2.85 : 0.85;
            if (!this.field_70170_p.field_72995_K) {
                List list = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_70046_E().func_72317_d(0.0, 3.0, 0.0).func_72314_b(0.0, 1.5, 0.0));
                for (Entity ent : list) {
                    if (this.field_70153_n != null) continue;
                    ent.func_70078_a((Entity)this);
                }
                if (this.field_70163_u > MAX_HEIGHT) {
                    double landingLocZ;
                    double landingLocX;
                    this.setCapsuleMotion(-1);
                    WorldServer world = DimensionManager.getWorld((int)this.dstTilePos.dimid);
                    if (world == null) {
                        DimensionManager.initDimension((int)this.dstTilePos.dimid);
                        world = DimensionManager.getWorld((int)this.dstTilePos.dimid);
                    }
                    if (world != null) {
                        TileEntity tile = world.func_147438_o(this.dstTilePos.pos.x, (int)this.dstTilePos.pos.y, this.dstTilePos.pos.z);
                        if (!(tile instanceof TileSpaceElevator)) {
                            this.func_70106_y();
                            return;
                        }
                        landingLocX = ((TileSpaceElevator)tile).getLandingLocationX();
                        landingLocZ = ((TileSpaceElevator)tile).getLandingLocationZ();
                    } else {
                        this.dstTilePos = this.srcTilePos;
                        world = this.field_70170_p;
                        TileEntity tile = world.func_147438_o(this.dstTilePos.pos.x, (int)this.dstTilePos.pos.y, this.dstTilePos.pos.z);
                        if (!(tile instanceof TileSpaceElevator)) {
                            this.func_70106_y();
                            return;
                        }
                        landingLocX = ((TileSpaceElevator)tile).getLandingLocationX();
                        landingLocZ = ((TileSpaceElevator)tile).getLandingLocationZ();
                    }
                    this.travelToDimension(this.dstTilePos.dimid, landingLocX, Configuration.orbit, landingLocZ);
                    MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDeOrbitingEvent(this));
                }
            }
            this.func_70091_d(0.0, this.field_70181_x, 0.0);
            return;
        }
        if (this.isDescending()) {
            this.field_70181_x = this.field_70163_u > 255.0 ? -2.85 : -0.85;
            if (this.field_70170_p.field_72995_K) {
                this.func_70091_d(0.0, this.field_70181_x, 0.0);
                return;
            }
            if (this.field_70173_aa == 20) {
                PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, 3), (Entity)this);
            }
            List list = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_70046_E().func_72317_d(0.0, 3.0, 0.0).func_72314_b(0.0, 1.5, 0.0));
            for (Entity ent : list) {
                if (this.field_70153_n != null) continue;
                ent.func_70078_a((Entity)this);
            }
            if (!(this.field_70163_u <= (double)this.dstTilePos.pos.y)) {
                this.func_70091_d(0.0, this.field_70181_x, 0.0);
                return;
            }
            this.setCapsuleMotion(0);
            this.func_70107_b(this.dstTilePos.pos.x, this.dstTilePos.pos.y, this.dstTilePos.pos.z);
            TileEntity e = this.field_70170_p.func_147438_o(this.dstTilePos.pos.x, (int)this.dstTilePos.pos.y, this.dstTilePos.pos.z);
            if (e instanceof TileSpaceElevator) {
                ((TileSpaceElevator)e).notifyLanded(this);
                this.standTime = 0;
            } else {
                this.func_70106_y();
            }
            if (this.field_70153_n == null) return;
            this.field_70153_n.func_70078_a(null);
            return;
        }
        List list = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_70046_E().func_72317_d(0.0, 3.0, 0.0).func_72314_b(0.0, 1.5, 0.0));
        if (!this.field_70170_p.field_72995_K) {
            TileEntity srcTile = null;
            if (list.isEmpty()) {
                this.standTime = 0;
            } else if (this.dstTilePos != null && this.dstTilePos.dimid != this.field_70170_p.field_73011_w.field_76574_g && TileSpaceElevator.isDstValid(this.field_70170_p, this.dstTilePos, new BlockPosition((int)this.field_70165_t, (int)this.field_70163_u, (int)this.field_70161_v))) {
                ++this.standTime;
            }
            if (this.srcTilePos != null && this.srcTilePos.pos != null) {
                srcTile = this.field_70170_p.func_147438_o(this.srcTilePos.pos.x, (int)this.srcTilePos.pos.y, this.srcTilePos.pos.z);
            }
            if (srcTile != null && srcTile instanceof TileSpaceElevator && !((TileSpaceElevator)srcTile).getMachineEnabled()) {
                this.standTime = 0;
            }
            this.setStandTime(this.standTime);
            if (!((double)this.standTime > 200.0)) return;
            if (this.srcTilePos == null) return;
            if (this.srcTilePos.pos == null) return;
            srcTile = this.field_70170_p.func_147438_o(this.srcTilePos.pos.x, (int)this.srcTilePos.pos.y, this.srcTilePos.pos.z);
            if (!(srcTile instanceof TileSpaceElevator)) return;
            if (!((TileSpaceElevator)srcTile).attemptLaunch()) return;
            this.setCapsuleMotion(1);
            List list2 = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_70046_E().func_72317_d(0.0, 3.0, 0.0).func_72314_b(0.0, 1.5, 0.0));
            Iterator iterator = list2.iterator();
            while (true) {
                if (!iterator.hasNext()) {
                    MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLaunchEvent(this));
                    PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, 2), (Entity)this);
                    return;
                }
                Entity ent = (Entity)iterator.next();
                if (this.field_70153_n != null) continue;
                ent.func_70078_a((Entity)this);
            }
        }
        if (list.isEmpty()) return;
        TileEntity srcTile = null;
        if (this.srcTilePos != null && this.srcTilePos.pos != null) {
            srcTile = this.field_70170_p.func_147438_o(this.srcTilePos.pos.x, (int)this.srcTilePos.pos.y, this.srcTilePos.pos.z);
        }
        if (srcTile != null && srcTile instanceof TileSpaceElevator && !((TileSpaceElevator)srcTile).getMachineEnabled()) {
            AdvancedRocketry.proxy.displayMessage(LibVulpes.proxy.getLocalizedString("msg.spaceElevator.turnedOff"), 5);
            return;
        }
        if (this.dstTilePos != null) {
            AdvancedRocketry.proxy.displayMessage(LibVulpes.proxy.getLocalizedString("msg.spaceElevator.ascentReady") + ": " + (int)((200.0 - (double)this.getStandTime()) / 20.0) + "\nDST " + this.dstTilePos, 5);
            return;
        }
        AdvancedRocketry.proxy.displayMessage(LibVulpes.proxy.getLocalizedString("msg.label.noneSelected"), 5);
    }

    public double func_70042_X() {
        return 0.3;
    }

    public AxisAlignedBB func_70046_E() {
        return AxisAlignedBB.func_72330_a((double)this.field_70121_D.field_72340_a, (double)(this.field_70121_D.field_72338_b - 1.0), (double)this.field_70121_D.field_72339_c, (double)this.field_70121_D.field_72336_d, (double)(this.field_70121_D.field_72337_e - 3.0), (double)this.field_70121_D.field_72334_f);
    }

    public AxisAlignedBB func_70114_g(Entity e) {
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double par1) {
        return par1 < 1.6777216E7;
    }

    public void writeDataToNetwork(ByteBuf out, byte id) {
        if (id == 0) {
            out.writeBoolean(this.dstTilePos != null);
            if (this.dstTilePos != null) {
                out.writeInt(this.dstTilePos.dimid);
                out.writeInt(this.dstTilePos.pos.x);
                out.writeInt((int)this.dstTilePos.pos.y);
                out.writeInt(this.dstTilePos.pos.z);
            }
        } else if (id == 4) {
            out.writeBoolean(this.dstTilePos != null);
            if (this.srcTilePos != null) {
                out.writeInt(this.srcTilePos.dimid);
                out.writeInt(this.srcTilePos.pos.x);
                out.writeInt((int)this.srcTilePos.pos.y);
                out.writeInt(this.srcTilePos.pos.z);
            }
        }
    }

    public void readDataFromNetwork(ByteBuf in, byte packetId, NBTTagCompound nbt) {
        if ((packetId == 0 || packetId == 4) && in.readBoolean()) {
            nbt.func_74768_a("dimid", in.readInt());
            nbt.func_74768_a("x", in.readInt());
            nbt.func_74768_a("y", in.readInt());
            nbt.func_74768_a("z", in.readInt());
        }
    }

    public void useNetworkData(EntityPlayer player, Side side, byte id, NBTTagCompound nbt) {
        if (id == 0 && this.field_70170_p.field_72995_K) {
            this.dstTilePos = nbt.func_74764_b("dimid") ? new DimensionBlockPosition(nbt.func_74762_e("dimid"), new BlockPosition(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"))) : null;
        } else if (id == 4 && this.field_70170_p.field_72995_K) {
            this.srcTilePos = nbt.func_74764_b("dimid") ? new DimensionBlockPosition(nbt.func_74762_e("dimid"), new BlockPosition(nbt.func_74762_e("x"), nbt.func_74762_e("y"), nbt.func_74762_e("z"))) : null;
        } else if (id == 1) {
            PacketHandler.sendToPlayersTrackingEntity((BasePacket)new PacketEntity((INetworkEntity)this, 0), (Entity)this);
        } else if (id == 2 && this.field_70170_p.field_72995_K) {
            List list = this.field_70170_p.func_72872_a(EntityPlayer.class, this.func_70046_E());
            for (Entity ent : list) {
                if (this.field_70153_n != null) continue;
                ent.func_70078_a((Entity)this);
            }
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketLaunchEvent(this));
        } else if (id == 3 && this.field_70170_p.field_72995_K) {
            MinecraftForge.EVENT_BUS.post((Event)new RocketEvent.RocketDeOrbitingEvent(this));
        }
    }
}

