/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.dimension;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.MathHelper;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.BiomeManager;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import org.apache.commons.lang3.ArrayUtils;
import scala.util.Random;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryBiomes;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.SatelliteRegistry;
import zmaster587.advancedRocketry.api.atmosphere.AtmosphereRegister;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.atmosphere.AtmosphereType;
import zmaster587.advancedRocketry.dimension.DimensionManager;
import zmaster587.advancedRocketry.network.PacketDimInfo;
import zmaster587.advancedRocketry.network.PacketSatellite;
import zmaster587.advancedRocketry.util.OreGenProperties;
import zmaster587.advancedRocketry.world.ChunkManagerPlanet;
import zmaster587.advancedRocketry.world.provider.WorldProviderPlanet;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;
import zmaster587.libVulpes.util.BlockPosition;
import zmaster587.libVulpes.util.VulpineMath;
import zmaster587.libVulpes.util.ZUtils;

public class DimensionProperties
implements Cloneable,
IDimensionProperties {
    public static final ResourceLocation atmosphere = new ResourceLocation("advancedrocketry:textures/planets/Atmosphere2.png");
    public static final ResourceLocation atmosphereLEO = new ResourceLocation("advancedrocketry:textures/planets/AtmosphereLEO.png");
    public static final ResourceLocation atmGlow = new ResourceLocation("advancedrocketry:textures/planets/atmGlow.png");
    public static final ResourceLocation planetRings = new ResourceLocation("advancedrocketry:textures/planets/rings.png");
    public static final ResourceLocation planetRingShadow = new ResourceLocation("advancedrocketry:textures/planets/ringShadow.png");
    public static final ResourceLocation shadow = new ResourceLocation("advancedrocketry:textures/planets/shadow.png");
    public static final ResourceLocation shadow3 = new ResourceLocation("advancedrocketry:textures/planets/shadow3.png");
    public static final int MAX_ATM_PRESSURE = 200;
    public static final int MIN_ATM_PRESSURE = 0;
    public static final int MAX_DISTANCE = 200;
    public static final int MIN_DISTANCE = 0;
    public static final int MAX_GRAVITY = 200;
    public static final int MIN_GRAVITY = 0;
    public boolean isNativeDimension;
    public float[] skyColor;
    public float[] fogColor;
    public float[] ringColor;
    public float gravitationalMultiplier;
    public int orbitalDist;
    private int atmosphereDensity;
    private int originalAtmosphereDensity;
    public int averageTemperature;
    public int rotationalPeriod;
    public double orbitTheta;
    StellarBody star;
    int starId;
    private String name = "Temp";
    public float[] sunriseSunsetColors;
    private LinkedList<BiomeManager.BiomeEntry> allowedBiomes;
    private LinkedList<BiomeManager.BiomeEntry> terraformedBiomes;
    private boolean isRegistered = false;
    private boolean isTerraformed = false;
    public boolean hasRings = false;
    public double prevOrbitalTheta;
    public double orbitalPhi;
    public double rotationalPhi;
    public OreGenProperties oreProperties = null;
    public String customIcon;
    public List<ItemStack> requiredArtifacts;
    private HashSet<Integer> childPlanets;
    private int parentPlanet;
    private int planetId;
    private boolean isStation;
    private boolean isGasGiant;
    private HashMap<Long, SatelliteBase> satallites;
    private HashMap<Long, SatelliteBase> tickingSatallites;
    private List<Fluid> harvestableAtmosphere;
    private HashSet<BlockPosition> beaconLocations;

    public DimensionProperties(int id) {
        this.resetProperties();
        this.planetId = id;
        this.parentPlanet = -1;
        this.childPlanets = new HashSet();
        this.orbitalPhi = 0.0;
        this.ringColor = new float[]{0.4f, 0.4f, 0.7f};
        this.allowedBiomes = new LinkedList();
        this.terraformedBiomes = new LinkedList();
        this.satallites = new HashMap();
        this.requiredArtifacts = new LinkedList<ItemStack>();
        this.tickingSatallites = new HashMap();
        this.isNativeDimension = true;
        this.isGasGiant = false;
        this.hasRings = false;
        this.customIcon = "";
        this.harvestableAtmosphere = new LinkedList<Fluid>();
        this.beaconLocations = new HashSet();
    }

    @Override
    public boolean isGasGiant() {
        return this.isGasGiant;
    }

    public void setGasGiant() {
        this.isGasGiant = true;
    }

    public boolean hasRings() {
        return this.hasRings;
    }

    public void setHasRings(boolean value) {
        this.hasRings = value;
    }

    public DimensionProperties(int id, String name) {
        this(id);
        this.name = name;
    }

    public DimensionProperties(int id, boolean shouldRegister) {
        this(id);
        this.isStation = !shouldRegister;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    public OreGenProperties getOreGenProperties(World world) {
        if (this.oreProperties != null) {
            return this.oreProperties;
        }
        return OreGenProperties.getOresForPressure(AtmosphereTypes.getAtmosphereTypeFromValue(this.originalAtmosphereDensity), Temps.getTempFromValue(this.averageTemperature));
    }

    public void resetProperties() {
        this.fogColor = new float[]{1.0f, 1.0f, 1.0f};
        this.skyColor = new float[]{1.0f, 1.0f, 1.0f};
        this.sunriseSunsetColors = new float[]{0.7f, 0.2f, 0.2f, 1.0f};
        this.ringColor = new float[]{0.4f, 0.4f, 0.7f};
        this.gravitationalMultiplier = 1.0f;
        this.rotationalPeriod = 24000;
        this.orbitalDist = 100;
        this.atmosphereDensity = 100;
        this.originalAtmosphereDensity = 100;
        this.childPlanets = new HashSet();
        this.requiredArtifacts = new LinkedList<ItemStack>();
        this.parentPlanet = -1;
        this.starId = 0;
        this.averageTemperature = 100;
        this.hasRings = false;
        this.harvestableAtmosphere = new LinkedList<Fluid>();
        this.beaconLocations = new HashSet();
    }

    public List<Fluid> getHarvestableGasses() {
        return this.harvestableAtmosphere;
    }

    public List<ItemStack> getRequiredArtifacts() {
        return this.requiredArtifacts;
    }

    @Override
    public float getGravitationalMultiplier() {
        return this.gravitationalMultiplier;
    }

    @Override
    public void setGravitationalMultiplier(float mult) {
        this.gravitationalMultiplier = mult;
    }

    @Override
    public float[] getSunColor() {
        return this.getStar().getColor();
    }

    public void setStar(StellarBody star) {
        this.starId = star.getId();
        this.star = star;
        if (!this.isMoon() && !this.isStation()) {
            this.star.addPlanet(this);
        }
    }

    public void setStar(int id) {
        this.starId = id;
        if (DimensionManager.getInstance().getStar(id) != null) {
            this.setStar(DimensionManager.getInstance().getStar(id));
        }
    }

    @Override
    public StellarBody getStar() {
        if (this.star == null) {
            this.star = DimensionManager.getInstance().getStar(this.starId);
        }
        return this.star;
    }

    @Override
    public int getStarId() {
        return this.starId;
    }

    public void addBeaconLocation(World world, BlockPosition pos) {
        this.beaconLocations.add(pos);
        DimensionManager.getInstance().knownPlanets.add(this.getId());
        if (!world.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketDimInfo(this.getId(), this));
        }
    }

    public HashSet<BlockPosition> getBeacons() {
        return this.beaconLocations;
    }

    public void removeBeaconLocation(World world, BlockPosition pos) {
        this.beaconLocations.remove(pos);
        if (this.beaconLocations.isEmpty() && !Configuration.initiallyKnownPlanets.contains(this.getId())) {
            DimensionManager.getInstance().knownPlanets.remove(this.getId());
        }
        if (!world.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketDimInfo(this.getId(), this));
        }
    }

    @Override
    public ResourceLocation getPlanetIcon() {
        if (this.customIcon != null && !this.customIcon.isEmpty()) {
            try {
                return PlanetIcons.valueOf(this.customIcon.toUpperCase()).resource;
            }
            catch (IllegalArgumentException e) {
                return PlanetIcons.UNKNOWN.resource;
            }
        }
        AtmosphereTypes atmType = AtmosphereTypes.getAtmosphereTypeFromValue(this.atmosphereDensity);
        Temps tempType = Temps.getTempFromValue(this.averageTemperature);
        if (this.isGasGiant()) {
            return PlanetIcons.GASGIANTBLUE.resource;
        }
        if (tempType == Temps.TOOHOT) {
            return PlanetIcons.MARSLIKE.resource;
        }
        if (atmType != AtmosphereTypes.NONE && VulpineMath.isBetween((int)tempType.ordinal(), (int)Temps.COLD.ordinal(), (int)Temps.TOOHOT.ordinal())) {
            return PlanetIcons.EARTHLIKE.resource;
        }
        if (tempType.compareTo(Temps.COLD) > 0) {
            if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
                return PlanetIcons.MOON.resource;
            }
            return PlanetIcons.ICEWORLD.resource;
        }
        if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
            if (tempType.compareTo(Temps.COLD) < 0) {
                return PlanetIcons.MARSLIKE.resource;
            }
            return PlanetIcons.MOON.resource;
        }
        return PlanetIcons.LAVA.resource;
    }

    public ResourceLocation getPlanetIconLEO() {
        if (this.customIcon != null && !this.customIcon.isEmpty()) {
            try {
                return PlanetIcons.valueOf(this.customIcon.toUpperCase()).resourceLEO;
            }
            catch (IllegalArgumentException e) {
                return PlanetIcons.UNKNOWN.resource;
            }
        }
        AtmosphereTypes atmType = AtmosphereTypes.getAtmosphereTypeFromValue(this.atmosphereDensity);
        Temps tempType = Temps.getTempFromValue(this.averageTemperature);
        if (this.isGasGiant()) {
            return PlanetIcons.GASGIANTBLUE.resourceLEO;
        }
        if (tempType == Temps.TOOHOT) {
            return PlanetIcons.MARSLIKE.resourceLEO;
        }
        if (atmType != AtmosphereTypes.NONE && VulpineMath.isBetween((int)tempType.ordinal(), (int)Temps.COLD.ordinal(), (int)Temps.TOOHOT.ordinal())) {
            return PlanetIcons.EARTHLIKE.resourceLEO;
        }
        if (tempType.compareTo(Temps.COLD) > 0) {
            if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
                return PlanetIcons.MOON.resourceLEO;
            }
            return PlanetIcons.ICEWORLD.resourceLEO;
        }
        if (atmType.compareTo(AtmosphereTypes.LOW) > 0) {
            if (tempType.compareTo(Temps.COLD) < 0) {
                return PlanetIcons.MARSLIKE.resourceLEO;
            }
            return PlanetIcons.MOON.resourceLEO;
        }
        return PlanetIcons.LAVA.resourceLEO;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public int getId() {
        return this.planetId;
    }

    @Override
    public int getParentPlanet() {
        return this.parentPlanet;
    }

    @Override
    public DimensionProperties getParentProperties() {
        if (this.parentPlanet != -1) {
            return DimensionManager.getInstance().getDimensionProperties(this.parentPlanet);
        }
        return null;
    }

    @Override
    public int getParentOrbitalDistance() {
        return this.orbitalDist;
    }

    @Override
    public int getSolarOrbitalDistance() {
        if (this.parentPlanet != -1) {
            return this.getParentProperties().getSolarOrbitalDistance();
        }
        return this.orbitalDist;
    }

    public double getSolarTheta() {
        if (this.parentPlanet != -1) {
            return this.getParentProperties().getSolarTheta();
        }
        return this.orbitTheta;
    }

    public void setParentPlanet(DimensionProperties parent) {
        this.setParentPlanet(parent, true);
    }

    public void setParentPlanet(DimensionProperties parent, boolean update) {
        if (update) {
            if (this.parentPlanet != -1) {
                this.getParentProperties().childPlanets.remove(new Integer(this.getId()));
            }
            if (parent == null) {
                this.parentPlanet = -1;
            } else {
                this.parentPlanet = parent.getId();
                this.star = parent.getStar();
                if (parent.getId() != -1) {
                    parent.childPlanets.add(this.getId());
                }
            }
        } else if (parent == null) {
            this.parentPlanet = -1;
        } else {
            this.star = parent.getStar();
            this.parentPlanet = parent.getId();
        }
    }

    @Override
    public boolean hasChildren() {
        return !this.childPlanets.isEmpty();
    }

    @Override
    public boolean isMoon() {
        return this.parentPlanet != -1 && this.parentPlanet != Integer.MIN_VALUE;
    }

    @Override
    public boolean isTerraformed() {
        return this.isTerraformed;
    }

    @Override
    public int getAtmosphereDensity() {
        return this.atmosphereDensity;
    }

    @Override
    public void setAtmosphereDensity(int atmosphereDensity) {
        int prevAtm = this.atmosphereDensity;
        this.atmosphereDensity = atmosphereDensity;
        if (AtmosphereTypes.getAtmosphereTypeFromValue(prevAtm) != AtmosphereTypes.getAtmosphereTypeFromValue(this.atmosphereDensity)) {
            this.setTerraformedBiomes(this.getViableBiomes());
            this.isTerraformed = true;
            ((ChunkManagerPlanet)((WorldProviderPlanet)net.minecraftforge.common.DimensionManager.getProvider((int)this.getId())).chunkMgrTerraformed).resetCache();
        }
        PacketHandler.sendToAll((BasePacket)new PacketDimInfo(this.getId(), this));
    }

    public void setAtmosphereDensityDirect(int atmosphereDensity) {
        this.originalAtmosphereDensity = this.atmosphereDensity = atmosphereDensity;
    }

    public boolean isStation() {
        return this.isStation;
    }

    @Override
    public IAtmosphere getAtmosphere() {
        if (this.hasAtmosphere()) {
            if (AtmosphereTypes.getAtmosphereTypeFromValue(this.getAtmosphereDensity()) == AtmosphereTypes.HIGHPRESSURE) {
                return AtmosphereType.HIGHPRESSURE;
            }
            return AtmosphereType.AIR;
        }
        return AtmosphereType.VACUUM;
    }

    public static ResourceLocation getAtmosphereResource() {
        return atmosphere;
    }

    public static ResourceLocation getShadowResource() {
        return shadow;
    }

    public static ResourceLocation getAtmosphereLEOResource() {
        return atmosphereLEO;
    }

    @Override
    public boolean hasAtmosphere() {
        return AtmosphereTypes.getAtmosphereTypeFromValue(this.atmosphereDensity).compareTo(AtmosphereTypes.NONE) < 0;
    }

    @Override
    public Set<Integer> getChildPlanets() {
        return this.childPlanets;
    }

    @Override
    public int getPathLengthToStar() {
        if (this.isMoon()) {
            return 1 + this.getParentProperties().getPathLengthToStar();
        }
        return 1;
    }

    public boolean addChildPlanet(DimensionProperties child) {
        if (child == this) {
            return false;
        }
        this.childPlanets.add(child.getId());
        child.setParentPlanet(this);
        return true;
    }

    public void removeChild(int id) {
        this.childPlanets.remove(id);
    }

    @Override
    public void addSatallite(SatelliteBase satellite, World world) {
        if (this.satallites.containsKey(satellite.getId())) {
            this.satallites.remove(satellite.getId());
            this.tickingSatallites.remove(satellite.getId());
        }
        this.satallites.put(satellite.getId(), satellite);
        satellite.setDimensionId(world);
        if (satellite.canTick()) {
            this.tickingSatallites.put(satellite.getId(), satellite);
        }
        if (!world.field_72995_K) {
            PacketHandler.sendToAll((BasePacket)new PacketSatellite(satellite));
        }
    }

    @Override
    public void addSatallite(SatelliteBase satallite) {
        if (this.satallites.containsKey(satallite.getId())) {
            this.satallites.remove(satallite.getId());
            this.tickingSatallites.remove(satallite.getId());
        }
        this.satallites.put(satallite.getId(), satallite);
        if (satallite.canTick()) {
            this.tickingSatallites.put(satallite.getId(), satallite);
        }
    }

    @Override
    public SatelliteBase removeSatellite(long satalliteId) {
        SatelliteBase satallite = this.satallites.remove(satalliteId);
        if (satallite != null && satallite.canTick() && this.tickingSatallites.containsKey(satalliteId)) {
            this.tickingSatallites.get(satalliteId).setDead();
        }
        return satallite;
    }

    @Override
    public SatelliteBase getSatellite(long id) {
        return this.satallites.get(id);
    }

    public void tick() {
        Iterator<SatelliteBase> iterator = this.tickingSatallites.values().iterator();
        while (iterator.hasNext()) {
            SatelliteBase satallite = iterator.next();
            satallite.tickEntity();
            if (!satallite.isDead()) continue;
            iterator.remove();
            this.satallites.remove(satallite.getId());
        }
        this.prevOrbitalTheta = this.orbitTheta;
        this.orbitTheta += (double)(201 - this.orbitalDist) * 5.0E-6;
    }

    public void updateOrbit() {
        this.prevOrbitalTheta = this.orbitTheta;
        this.orbitTheta = (double)(AdvancedRocketry.proxy.getWorldTimeUniversal(this.getId()) * (long)(201 - this.orbitalDist)) * 2.0E-6 % (Math.PI * 2);
    }

    public boolean hasRivers() {
        return AtmosphereTypes.getAtmosphereTypeFromValue(this.originalAtmosphereDensity).compareTo(AtmosphereTypes.LOW) <= 0 && Temps.getTempFromValue(this.averageTemperature).isInRange(Temps.COLD, Temps.HOT);
    }

    public List<BiomeManager.BiomeEntry> getBiomes() {
        return this.allowedBiomes;
    }

    public List<BiomeManager.BiomeEntry> getTerraformedBiomes() {
        return this.terraformedBiomes;
    }

    public boolean isBiomeblackListed(BiomeGenBase biome) {
        return AdvancedRocketryBiomes.instance.getBlackListedBiomes().contains(biome.field_76756_M);
    }

    public List<BiomeGenBase> getViableBiomes() {
        Random random = new Random(System.nanoTime());
        ArrayList<BiomeGenBase> viableBiomes = new ArrayList<BiomeGenBase>();
        if (this.atmosphereDensity > AtmosphereTypes.LOW.value && random.nextInt(3) == 0) {
            LinkedList<BiomeGenBase> list = new LinkedList<BiomeGenBase>(AdvancedRocketryBiomes.instance.getSingleBiome());
            while (list.size() > 1) {
                BiomeGenBase biome = (BiomeGenBase)list.get(random.nextInt(list.size()));
                Temps temp = Temps.getTempFromValue(this.averageTemperature);
                if (biome.func_150561_m() == BiomeGenBase.TempCategory.COLD && temp.isInRange(Temps.FRIGID, Temps.NORMAL) || (biome.func_150561_m() == BiomeGenBase.TempCategory.MEDIUM || biome.func_150561_m() == BiomeGenBase.TempCategory.OCEAN) && temp.isInRange(Temps.COLD, Temps.HOT) || biome.func_150561_m() == BiomeGenBase.TempCategory.WARM && temp.isInRange(Temps.NORMAL, Temps.HOT)) {
                    viableBiomes.add(biome);
                    return viableBiomes;
                }
                list.remove(biome);
            }
        }
        if (this.atmosphereDensity <= AtmosphereTypes.LOW.value) {
            viableBiomes.add(AdvancedRocketryBiomes.moonBiome);
        } else if (this.averageTemperature > Temps.TOOHOT.getTemp()) {
            viableBiomes.add(AdvancedRocketryBiomes.hotDryBiome);
        } else if (this.averageTemperature > Temps.HOT.getTemp()) {
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null || !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) && !BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.OCEAN) || this.isBiomeblackListed(biome)) continue;
                viableBiomes.add(biome);
            }
        } else if (this.averageTemperature > Temps.NORMAL.getTemp()) {
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || this.isBiomeblackListed(biome)) continue;
                viableBiomes.add(biome);
            }
            viableBiomes.addAll(Arrays.asList(BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)));
        } else if (this.averageTemperature > Temps.COLD.getTemp()) {
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.HOT) || this.isBiomeblackListed(biome)) continue;
                viableBiomes.add(biome);
            }
            viableBiomes.addAll(Arrays.asList(BiomeDictionary.getBiomesForType((BiomeDictionary.Type)BiomeDictionary.Type.OCEAN)));
        } else if (this.averageTemperature > Temps.FRIGID.getTemp()) {
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || this.isBiomeblackListed(biome)) continue;
                viableBiomes.add(biome);
            }
        } else {
            for (BiomeGenBase biome : BiomeGenBase.func_150565_n()) {
                if (biome == null || BiomeDictionary.isBiomeOfType((BiomeGenBase)biome, (BiomeDictionary.Type)BiomeDictionary.Type.COLD) || this.isBiomeblackListed(biome)) continue;
                viableBiomes.add(biome);
            }
        }
        if (viableBiomes.size() > 5) {
            viableBiomes = ZUtils.copyRandomElements(viableBiomes, (int)5);
        }
        if (this.atmosphereDensity > AtmosphereTypes.HIGHPRESSURE.value && Temps.getTempFromValue(this.averageTemperature).isInRange(Temps.NORMAL, Temps.HOT)) {
            viableBiomes.addAll(AdvancedRocketryBiomes.instance.getHighPressureBiomes());
        }
        return viableBiomes;
    }

    public void addBiome(BiomeGenBase biome) {
        ArrayList<BiomeGenBase> biomes = new ArrayList<BiomeGenBase>();
        biomes.add(biome);
        this.allowedBiomes.addAll(this.getBiomesEntries(biomes));
    }

    public boolean addBiome(int biomeId) {
        BiomeGenBase biome = BiomeGenBase.func_150568_d((int)biomeId);
        if (biomeId == 0 || biome != BiomeGenBase.field_76771_b) {
            ArrayList<BiomeGenBase> biomes = new ArrayList<BiomeGenBase>();
            biomes.add(biome);
            this.allowedBiomes.addAll(this.getBiomesEntries(biomes));
            return true;
        }
        return false;
    }

    public void addBiomes(List<BiomeGenBase> biomes) {
        this.allowedBiomes.addAll(this.getBiomesEntries(biomes));
    }

    public void setBiomes(List<BiomeGenBase> biomes) {
        this.allowedBiomes.clear();
        this.addBiomes(biomes);
    }

    public void setBiomeEntries(List<BiomeManager.BiomeEntry> biomes) {
        if (biomes != this.allowedBiomes) {
            this.allowedBiomes.clear();
            this.allowedBiomes.addAll(biomes);
        }
    }

    public void setTerraformedBiomes(List<BiomeGenBase> biomes) {
        this.terraformedBiomes.clear();
        this.terraformedBiomes.addAll(this.getBiomesEntries(biomes));
    }

    public void addBiomeType(BiomeDictionary.Type type) {
        ArrayList<BiomeGenBase> entryList = new ArrayList<BiomeGenBase>();
        entryList.addAll(Arrays.asList(BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)));
        entryList.remove(BiomeGenBase.field_76778_j);
        entryList.remove(BiomeGenBase.field_76779_k);
        Iterator iter = entryList.iterator();
        while (iter.hasNext()) {
            BiomeGenBase nextbiome = (BiomeGenBase)iter.next();
            for (BiomeManager.BiomeEntry entry : this.allowedBiomes) {
                if (!BiomeDictionary.areBiomesEquivalent((BiomeGenBase)entry.biome, (BiomeGenBase)nextbiome)) continue;
                iter.remove();
            }
        }
        this.allowedBiomes.addAll(this.getBiomesEntries(entryList));
    }

    public void removeBiomeType(BiomeDictionary.Type type) {
        ArrayList<BiomeGenBase> entryList = new ArrayList<BiomeGenBase>();
        entryList.addAll(Arrays.asList(BiomeDictionary.getBiomesForType((BiomeDictionary.Type)type)));
        for (BiomeGenBase biome : entryList) {
            Iterator iterator = this.allowedBiomes.iterator();
            while (iterator.hasNext()) {
                if (!BiomeDictionary.areBiomesEquivalent((BiomeGenBase)((BiomeManager.BiomeEntry)iterator.next()).biome, (BiomeGenBase)biome)) continue;
                iterator.remove();
            }
        }
    }

    private ArrayList<BiomeManager.BiomeEntry> getBiomesEntries(List<BiomeGenBase> biomeIds) {
        ArrayList<BiomeManager.BiomeEntry> biomeEntries = new ArrayList<BiomeManager.BiomeEntry>();
        for (BiomeGenBase biomes : biomeIds) {
            if (biomes == BiomeGenBase.field_76769_d) {
                biomeEntries.add(new BiomeManager.BiomeEntry(BiomeGenBase.field_76769_d, 30));
                continue;
            }
            if (biomes == BiomeGenBase.field_150588_X) {
                biomeEntries.add(new BiomeManager.BiomeEntry(BiomeGenBase.field_150588_X, 20));
                continue;
            }
            if (biomes == BiomeGenBase.field_76772_c) {
                biomeEntries.add(new BiomeManager.BiomeEntry(BiomeGenBase.field_76772_c, 10));
                continue;
            }
            boolean notFound = true;
            block1: for (BiomeManager.BiomeType types : BiomeManager.BiomeType.values()) {
                for (BiomeManager.BiomeEntry entry : BiomeManager.getBiomes((BiomeManager.BiomeType)types)) {
                    if (biomes == null) {
                        AdvancedRocketry.logger.warn("Null biomes loaded for DIMID: " + this.getId());
                        continue;
                    }
                    if (entry.biome.field_76756_M != biomes.field_76756_M) continue;
                    biomeEntries.add(entry);
                    notFound = false;
                    break block1;
                }
            }
            if (!notFound || biomes == null) continue;
            biomeEntries.add(new BiomeManager.BiomeEntry(biomes, 30));
        }
        return biomeEntries;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        int i;
        ArrayList<Object> biomesList;
        int f;
        NBTTagList list;
        if (nbt.func_74764_b("skyColor")) {
            list = nbt.func_150295_c("skyColor", 5);
            this.skyColor = new float[list.func_74745_c()];
            for (f = 0; f < list.func_74745_c(); ++f) {
                this.skyColor[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("ringColor")) {
            list = nbt.func_150295_c("ringColor", 5);
            this.ringColor = new float[list.func_74745_c()];
            for (f = 0; f < list.func_74745_c(); ++f) {
                this.ringColor[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("sunriseSunsetColors")) {
            list = nbt.func_150295_c("sunriseSunsetColors", 5);
            this.sunriseSunsetColors = new float[list.func_74745_c()];
            for (f = 0; f < list.func_74745_c(); ++f) {
                this.sunriseSunsetColors[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("fogColor")) {
            list = nbt.func_150295_c("fogColor", 5);
            this.fogColor = new float[list.func_74745_c()];
            for (f = 0; f < list.func_74745_c(); ++f) {
                this.fogColor[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("ringColor")) {
            list = nbt.func_150295_c("ringColor", 5);
            this.ringColor = new float[list.func_74745_c()];
            for (f = 0; f < list.func_74745_c(); ++f) {
                this.ringColor[f] = list.func_150308_e(f);
            }
        }
        if (nbt.func_74764_b("biomes")) {
            this.allowedBiomes.clear();
            int[] biomeIds = nbt.func_74759_k("biomes");
            biomesList = new ArrayList<BiomeGenBase>();
            for (i = 0; i < biomeIds.length; ++i) {
                biomesList.add(AdvancedRocketryBiomes.instance.getBiomeById(biomeIds[i]));
            }
            this.allowedBiomes.addAll(this.getBiomesEntries(biomesList));
        }
        if (nbt.func_74764_b("beaconLocations")) {
            list = nbt.func_150295_c("beaconLocations", 11);
            for (int i2 = 0; i2 < list.func_74745_c(); ++i2) {
                int[] location = list.func_150306_c(i2);
                this.beaconLocations.add(new BlockPosition(location[0], location[1], location[2]));
            }
            DimensionManager.getInstance().knownPlanets.add(this.getId());
        } else {
            this.beaconLocations.clear();
        }
        if (nbt.func_74764_b("biomesTerra")) {
            this.terraformedBiomes.clear();
            int[] biomeIds = nbt.func_74759_k("biomesTerra");
            biomesList = new ArrayList();
            for (i = 0; i < biomeIds.length; ++i) {
                biomesList.add(AdvancedRocketryBiomes.instance.getBiomeById(biomeIds[i]));
            }
            this.terraformedBiomes.addAll(this.getBiomesEntries(biomesList));
        }
        this.gravitationalMultiplier = nbt.func_74760_g("gravitationalMultiplier");
        this.orbitalDist = nbt.func_74762_e("orbitalDist");
        this.orbitTheta = nbt.func_74769_h("orbitTheta");
        this.atmosphereDensity = nbt.func_74762_e("atmosphereDensity");
        this.averageTemperature = nbt.func_74762_e("avgTemperature");
        this.rotationalPeriod = nbt.func_74762_e("rotationalPeriod");
        this.name = nbt.func_74779_i("name");
        this.isNativeDimension = nbt.func_74764_b("isNative") ? nbt.func_74767_n("isNative") : true;
        this.originalAtmosphereDensity = nbt.func_74764_b("originalAtmosphereDensity") ? nbt.func_74762_e("originalAtmosphereDensity") : this.atmosphereDensity;
        this.isGasGiant = nbt.func_74767_n("isGasGiant");
        this.isTerraformed = nbt.func_74767_n("terraformed");
        this.orbitalPhi = nbt.func_74769_h("orbitPhi");
        this.rotationalPhi = nbt.func_74769_h("rotationalPhi");
        this.hasRings = nbt.func_74767_n("hasRings");
        if (nbt.func_74764_b("childrenPlanets")) {
            for (int i3 : nbt.func_74759_k("childrenPlanets")) {
                this.childPlanets.add(i3);
            }
        }
        this.parentPlanet = nbt.func_74762_e("parentPlanet");
        this.setStar(DimensionManager.getInstance().getStar(nbt.func_74762_e("starId")));
        if (nbt.func_74764_b("satallites")) {
            NBTTagCompound allSatalliteNbt = nbt.func_74775_l("satallites");
            for (Object keyObject : allSatalliteNbt.func_150296_c()) {
                String key = (String)keyObject;
                Long longKey = Long.parseLong(key);
                NBTTagCompound satalliteNbt = allSatalliteNbt.func_74775_l(key);
                if (this.satallites.containsKey(longKey)) {
                    this.satallites.get(longKey).readFromNBT(satalliteNbt);
                    continue;
                }
                try {
                    SatelliteBase satallite = SatelliteRegistry.createFromNBT(satalliteNbt);
                    this.satallites.put(longKey, satallite);
                    if (!satallite.canTick()) continue;
                    this.tickingSatallites.put(satallite.getId(), satallite);
                }
                catch (NullPointerException e) {
                    AdvancedRocketry.logger.warn("Satellite with bad NBT detected, Removing");
                }
            }
        }
        if (this.isGasGiant) {
            NBTTagList fluidList = nbt.func_150295_c("fluids", 8);
            this.getHarvestableGasses().clear();
            for (int i4 = 0; i4 < fluidList.func_74745_c(); ++i4) {
                Fluid f2 = FluidRegistry.getFluid((String)fluidList.func_150307_f(i4));
                if (f2 == null) continue;
                this.getHarvestableGasses().add(f2);
            }
            if (this.getHarvestableGasses().isEmpty()) {
                this.getHarvestableGasses().addAll(AtmosphereRegister.getInstance().getHarvestableGasses());
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        int i;
        int[] biomeId;
        Object object;
        NBTTagList list;
        if (this.skyColor != null) {
            list = new NBTTagList();
            for (Object f : this.skyColor) {
                list.func_74742_a((NBTBase)new NBTTagFloat(f));
            }
            nbt.func_74782_a("skyColor", (NBTBase)list);
        }
        if (this.sunriseSunsetColors != null) {
            list = new NBTTagList();
            for (Object f : this.sunriseSunsetColors) {
                list.func_74742_a((NBTBase)new NBTTagFloat(f));
            }
            nbt.func_74782_a("sunriseSunsetColors", (NBTBase)list);
        }
        list = new NBTTagList();
        for (Object f : this.fogColor) {
            list.func_74742_a((NBTBase)new NBTTagFloat(f));
        }
        nbt.func_74782_a("fogColor", (NBTBase)list);
        if (this.hasRings) {
            list = new NBTTagList();
            object = this.ringColor;
            int n = ((float[])object).length;
            for (int j = 0; j < n; ++j) {
                Object f;
                f = object[j];
                list.func_74742_a((NBTBase)new NBTTagFloat(f));
            }
            nbt.func_74782_a("ringColor", (NBTBase)list);
        }
        if (!this.beaconLocations.isEmpty()) {
            list = new NBTTagList();
            object = this.beaconLocations.iterator();
            while (object.hasNext()) {
                BlockPosition pos = (BlockPosition)object.next();
                list.func_74742_a((NBTBase)new NBTTagIntArray(new int[]{pos.x, pos.y, pos.z}));
            }
            nbt.func_74782_a("beaconLocations", (NBTBase)list);
        }
        if (!this.allowedBiomes.isEmpty()) {
            biomeId = new int[this.allowedBiomes.size()];
            for (i = 0; i < this.allowedBiomes.size(); ++i) {
                biomeId[i] = this.allowedBiomes.get((int)i).biome.field_76756_M;
            }
            nbt.func_74783_a("biomes", biomeId);
        }
        if (!this.terraformedBiomes.isEmpty()) {
            biomeId = new int[this.terraformedBiomes.size()];
            for (i = 0; i < this.terraformedBiomes.size(); ++i) {
                biomeId[i] = this.terraformedBiomes.get((int)i).biome.field_76756_M;
            }
            nbt.func_74783_a("biomesTerra", biomeId);
        }
        nbt.func_74768_a("starId", this.starId);
        nbt.func_74776_a("gravitationalMultiplier", this.gravitationalMultiplier);
        nbt.func_74768_a("orbitalDist", this.orbitalDist);
        nbt.func_74780_a("orbitTheta", this.orbitTheta);
        nbt.func_74768_a("atmosphereDensity", this.atmosphereDensity);
        nbt.func_74768_a("originalAtmosphereDensity", this.originalAtmosphereDensity);
        nbt.func_74768_a("avgTemperature", this.averageTemperature);
        nbt.func_74768_a("rotationalPeriod", this.rotationalPeriod);
        nbt.func_74778_a("name", this.name);
        nbt.func_74757_a("isNative", this.isNativeDimension);
        nbt.func_74757_a("terraformed", this.isTerraformed);
        nbt.func_74757_a("isGasGiant", this.isGasGiant);
        nbt.func_74780_a("orbitPhi", this.orbitalPhi);
        nbt.func_74780_a("rotationalPhi", this.rotationalPhi);
        nbt.func_74757_a("hasRings", this.hasRings);
        if (!this.childPlanets.isEmpty()) {
            Integer[] intList = new Integer[this.childPlanets.size()];
            NBTTagIntArray childArray = new NBTTagIntArray(ArrayUtils.toPrimitive((Integer[])this.childPlanets.toArray(intList)));
            nbt.func_74782_a("childrenPlanets", (NBTBase)childArray);
        }
        nbt.func_74768_a("parentPlanet", this.parentPlanet);
        if (!this.satallites.isEmpty()) {
            NBTTagCompound allSatalliteNbt = new NBTTagCompound();
            for (Map.Entry<Long, SatelliteBase> entry : this.satallites.entrySet()) {
                NBTTagCompound satalliteNbt = new NBTTagCompound();
                entry.getValue().writeToNBT(satalliteNbt);
                allSatalliteNbt.func_74782_a(entry.getKey().toString(), (NBTBase)satalliteNbt);
            }
            nbt.func_74782_a("satallites", (NBTBase)allSatalliteNbt);
        }
        if (this.isGasGiant) {
            NBTTagList fluidList = new NBTTagList();
            for (Fluid f : this.getHarvestableGasses()) {
                fluidList.func_74742_a((NBTBase)new NBTTagString(f.getName()));
            }
            nbt.func_74782_a("fluids", (NBTBase)fluidList);
        }
    }

    public static DimensionProperties createFromNBT(int id, NBTTagCompound nbt) {
        DimensionProperties properties = new DimensionProperties(id);
        properties.readFromNBT(nbt);
        properties.planetId = id;
        return properties;
    }

    @Override
    public float getAtmosphereDensityAtHeight(double y) {
        return (float)this.atmosphereDensity * MathHelper.func_76131_a((float)((float)(1.0 + (256.0 - y) / 200.0)), (float)0.0f, (float)1.0f) / 100.0f;
    }

    public float[] getFogColorAtHeight(double y, Vec3 fogColor) {
        float atmDensity = this.getAtmosphereDensityAtHeight(y);
        return new float[]{(float)((double)atmDensity * fogColor.field_72450_a), (float)((double)atmDensity * fogColor.field_72448_b), (float)((double)atmDensity * fogColor.field_72449_c)};
    }

    public void setId(int id) {
        this.planetId = id;
    }

    @Override
    public void setParentOrbitalDistance(int orbitalDistance) {
        this.orbitalDist = orbitalDistance;
    }

    public String toString() {
        return String.format("Dimension ID: %d.  Dimension Name: %s.  Parent Star %d ", this.getId(), this.getName(), this.getStarId());
    }

    @Override
    public double getOrbitTheta() {
        return this.orbitTheta;
    }

    @Override
    public int getOrbitalDist() {
        return this.orbitalDist;
    }

    public static enum PlanetIcons {
        EARTHLIKE(new ResourceLocation("advancedrocketry:textures/planets/Earthlike.png")),
        LAVA(new ResourceLocation("advancedrocketry:textures/planets/Lava.png")),
        MARSLIKE(new ResourceLocation("advancedrocketry:textures/planets/marslike.png")),
        MOON(new ResourceLocation("advancedrocketry:textures/planets/moon.png")),
        WATERWORLD(new ResourceLocation("advancedrocketry:textures/planets/WaterWorld.png")),
        ICEWORLD(new ResourceLocation("advancedrocketry:textures/planets/IceWorld.png")),
        GASGIANTBLUE(new ResourceLocation("advancedrocketry:textures/planets/GasGiantBlue.png")),
        GASGIANTRED(new ResourceLocation("advancedrocketry:textures/planets/GasGiantOrange.png")),
        UNKNOWN(new ResourceLocation("advancedrocketry:textures/planets/Unknown.png"));

        private ResourceLocation resource;
        private ResourceLocation resourceLEO;

        private PlanetIcons(ResourceLocation resource) {
            this.resource = resource;
            this.resourceLEO = new ResourceLocation(resource.toString().substring(0, resource.toString().length() - 4) + "LEO.jpg");
        }

        private PlanetIcons(ResourceLocation resource, ResourceLocation leo) {
            this.resource = resource;
            this.resourceLEO = atmosphereLEO;
        }

        public ResourceLocation getResource() {
            return this.resource;
        }

        public ResourceLocation getResourceLEO() {
            return this.resourceLEO;
        }
    }

    public static enum AtmosphereTypes {
        HIGHPRESSURE(125),
        NORMAL(75),
        LOW(25),
        NONE(0);

        private int value;

        private AtmosphereTypes(int value) {
            this.value = value;
        }

        public int getAtmosphereValue() {
            return this.value;
        }

        public static AtmosphereTypes getAtmosphereTypeFromValue(int value) {
            for (AtmosphereTypes type : AtmosphereTypes.values()) {
                if (value <= type.value) continue;
                return type;
            }
            return NONE;
        }
    }

    public static enum Temps {
        TOOHOT(150),
        HOT(125),
        NORMAL(75),
        COLD(50),
        FRIGID(25),
        SNOWBALL(0);

        private int temp;

        private Temps(int i) {
            this.temp = i;
        }

        @Deprecated
        public int getTemp() {
            return this.temp;
        }

        public boolean isInRange(Temps lowerBound, Temps upperBound) {
            return this.compareTo(lowerBound) <= 0 && this.compareTo(upperBound) >= 0;
        }

        public static Temps getTempFromValue(int value) {
            for (Temps type : Temps.values()) {
                if (value <= type.temp) continue;
                return type;
            }
            return SNOWBALL;
        }
    }
}

