/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.dimension;

import cpw.mods.fml.common.FMLCommonHandler;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import org.apache.commons.io.FileUtils;
import zmaster587.advancedRocketry.AdvancedRocketry;
import zmaster587.advancedRocketry.api.AdvancedRocketryAPI;
import zmaster587.advancedRocketry.api.Configuration;
import zmaster587.advancedRocketry.api.dimension.IDimensionProperties;
import zmaster587.advancedRocketry.api.dimension.solar.IGalaxy;
import zmaster587.advancedRocketry.api.dimension.solar.StellarBody;
import zmaster587.advancedRocketry.api.satellite.SatelliteBase;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.network.PacketDimInfo;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.advancedRocketry.util.XMLPlanetLoader;
import zmaster587.libVulpes.network.BasePacket;
import zmaster587.libVulpes.network.PacketHandler;

public class DimensionManager
implements IGalaxy {
    private Random random;
    private static DimensionManager instance;
    public static final String workingPath = "advRocketry";
    public static final String tempFile = "/temp.dat";
    public static final String worldXML = "/planetDefs.xml";
    public static int dimOffset;
    public boolean hasBeenInitiallized = true;
    public static String prevBuild;
    public static boolean hasReachedMoon;
    public static boolean hasReachedWarp;
    public static Class<? extends WorldProvider> planetWorldProvider;
    private HashMap<Integer, DimensionProperties> dimensionList = new HashMap();
    private HashMap<Integer, StellarBody> starList = new HashMap();
    public static final int GASGIANT_DIMID_OFFSET = 256;
    private static long nextSatelliteId;
    private static StellarBody sol;
    public Set<Integer> knownPlanets;
    public static DimensionProperties overworldProperties;
    public static DimensionProperties defaultSpaceDimensionProperties;

    @Deprecated
    public static StellarBody getSol() {
        return instance.getStar(0);
    }

    public static DimensionManager getInstance() {
        return instance;
    }

    public DimensionManager() {
        sol = new StellarBody();
        sol.setTemperature(100);
        sol.setId(0);
        sol.setName("Sol");
        this.addStar(sol);
        overworldProperties = new DimensionProperties(0);
        overworldProperties.setAtmosphereDensityDirect(100);
        DimensionManager.overworldProperties.averageTemperature = 100;
        DimensionManager.overworldProperties.gravitationalMultiplier = 1.0f;
        DimensionManager.overworldProperties.orbitalDist = 100;
        DimensionManager.overworldProperties.skyColor = new float[]{1.0f, 1.0f, 1.0f};
        overworldProperties.setName("Earth");
        DimensionManager.overworldProperties.isNativeDimension = false;
        defaultSpaceDimensionProperties = new DimensionProperties(Integer.MIN_VALUE, false);
        defaultSpaceDimensionProperties.setAtmosphereDensityDirect(0);
        DimensionManager.defaultSpaceDimensionProperties.averageTemperature = 0;
        DimensionManager.defaultSpaceDimensionProperties.gravitationalMultiplier = 0.1f;
        DimensionManager.defaultSpaceDimensionProperties.orbitalDist = 100;
        DimensionManager.defaultSpaceDimensionProperties.skyColor = new float[]{0.0f, 0.0f, 0.0f};
        defaultSpaceDimensionProperties.setName("Space");
        DimensionManager.defaultSpaceDimensionProperties.fogColor = new float[]{0.0f, 0.0f, 0.0f};
        DimensionManager.defaultSpaceDimensionProperties.orbitalDist = 1;
        this.random = new Random(System.currentTimeMillis());
        this.knownPlanets = new HashSet<Integer>();
    }

    @Override
    public Integer[] getRegisteredDimensions() {
        Integer[] ret = new Integer[this.dimensionList.size()];
        return this.dimensionList.keySet().toArray(ret);
    }

    public Integer[] getLoadedDimensions() {
        return this.getRegisteredDimensions();
    }

    public long getNextSatelliteId() {
        return nextSatelliteId++;
    }

    @Override
    public SatelliteBase getSatellite(long satId) {
        SatelliteBase satellite;
        if (!this.hasBeenInitiallized && FMLCommonHandler.instance().getSide().isServer()) {
            DimensionManager.getInstance().loadDimensions(workingPath);
        }
        if ((satellite = overworldProperties.getSatellite(satId)) != null) {
            return satellite;
        }
        Integer[] integerArray = DimensionManager.getInstance().getLoadedDimensions();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            satellite = DimensionManager.getInstance().getDimensionProperties(i2).getSatellite(satId);
            if (satellite == null) continue;
            return satellite;
        }
        return null;
    }

    private String getNextName(int dimId) {
        return "Sol-" + dimId;
    }

    public void tickDimensions() {
        overworldProperties.tick();
        Integer[] integerArray = DimensionManager.getInstance().getLoadedDimensions();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            DimensionManager.getInstance().getDimensionProperties(i2).tick();
        }
    }

    public void tickDimensionsClient() {
        overworldProperties.updateOrbit();
        Integer[] integerArray = DimensionManager.getInstance().getLoadedDimensions();
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int i2 = integerArray[i];
            DimensionManager.getInstance().getDimensionProperties(i2).updateOrbit();
        }
    }

    public void setDimProperties(int dimId, DimensionProperties properties) {
        this.dimensionList.put(new Integer(dimId), properties);
    }

    public int getNextFreeDim(int offset) {
        for (int i = offset; i < 10000; ++i) {
            if (net.minecraftforge.common.DimensionManager.isDimensionRegistered((int)i) || this.dimensionList.containsKey(i)) continue;
            return i;
        }
        return -1;
    }

    public int getNextFreeStarId() {
        for (int i = 0; i < Integer.MAX_VALUE; ++i) {
            if (this.starList.containsKey(i)) continue;
            return i;
        }
        return -1;
    }

    public int getTemperature(StellarBody star, int orbitalDistance, int atmPressure) {
        return (star.getTemperature() + (100 - orbitalDistance) * 15 + atmPressure * 18) / 20;
    }

    public DimensionProperties generateRandom(int starId, int atmosphereFactor, int distanceFactor, int gravityFactor) {
        return this.generateRandom(starId, 100, 100, 100, atmosphereFactor, distanceFactor, gravityFactor);
    }

    public DimensionProperties generateRandom(int starId, String name, int atmosphereFactor, int distanceFactor, int gravityFactor) {
        return this.generateRandom(starId, name, 100, 100, 100, atmosphereFactor, distanceFactor, gravityFactor);
    }

    public DimensionProperties generateRandom(int starId, String name, int baseAtmosphere, int baseDistance, int baseGravity, int atmosphereFactor, int distanceFactor, int gravityFactor) {
        double minDistance;
        DimensionProperties properties = new DimensionProperties(this.getNextFreeDim(dimOffset));
        if (properties.getId() == -1) {
            return null;
        }
        if (name == "") {
            properties.setName(this.getNextName(properties.getId()));
        } else {
            properties.setName(name);
        }
        properties.setAtmosphereDensityDirect(MathHelper.func_76125_a((int)(baseAtmosphere + this.random.nextInt(atmosphereFactor) - atmosphereFactor / 2), (int)0, (int)200));
        int newDist = properties.orbitalDist = MathHelper.func_76125_a((int)(baseDistance + this.random.nextInt(distanceFactor)), (int)0, (int)200);
        properties.gravitationalMultiplier = Math.min(Math.max(0.05f, (float)(baseGravity + this.random.nextInt(gravityFactor) - gravityFactor / 2) / 100.0f), 1.3f);
        int walkDist = 0;
        do {
            minDistance = Double.MAX_VALUE;
            for (IDimensionProperties properties2 : this.getStar(starId).getPlanets()) {
                int dist = Math.abs(((DimensionProperties)properties2).orbitalDist - newDist);
                if (!(minDistance > (double)dist)) continue;
                minDistance = dist;
            }
            newDist = properties.orbitalDist + walkDist;
            walkDist = walkDist > -1 ? -walkDist - 1 : -walkDist;
        } while (minDistance < 4.0);
        properties.orbitalDist = newDist;
        properties.orbitalPhi = (this.random.nextGaussian() - 0.5) * 180.0;
        properties.rotationalPhi = (this.random.nextGaussian() - 0.5) * 180.0;
        properties.setStar(this.getStar(starId));
        properties.averageTemperature = this.getTemperature(properties.getStar(), properties.orbitalDist, properties.getAtmosphereDensity());
        properties.skyColor[0] = properties.skyColor[0] * (1.0f - MathHelper.func_76131_a((float)(this.random.nextFloat() * 0.1f + (float)(70 - properties.averageTemperature) / 100.0f), (float)0.2f, (float)1.0f));
        properties.skyColor[1] = properties.skyColor[1] * (1.0f - this.random.nextFloat() * 0.5f);
        properties.skyColor[2] = properties.skyColor[2] * (1.0f - MathHelper.func_76131_a((float)(this.random.nextFloat() * 0.1f + (float)(properties.averageTemperature - 70) / 100.0f), (float)0.0f, (float)1.0f));
        properties.rotationalPeriod = (int)(Math.pow(1.0f / properties.gravitationalMultiplier, 3.0) * 24000.0);
        properties.addBiomes(properties.getViableBiomes());
        this.registerDim(properties, true);
        return properties;
    }

    public DimensionProperties generateRandom(int starId, int baseAtmosphere, int baseDistance, int baseGravity, int atmosphereFactor, int distanceFactor, int gravityFactor) {
        return this.generateRandom(starId, "", baseAtmosphere, baseDistance, baseGravity, atmosphereFactor, distanceFactor, gravityFactor);
    }

    public DimensionProperties generateRandomGasGiant(int starId, String name, int baseAtmosphere, int baseDistance, int baseGravity, int atmosphereFactor, int distanceFactor, int gravityFactor) {
        double minDistance;
        DimensionProperties properties = new DimensionProperties(this.getNextFreeDim(dimOffset));
        if (name == "") {
            properties.setName(this.getNextName(properties.getId()));
        } else {
            properties.setName(name);
        }
        properties.setAtmosphereDensityDirect(MathHelper.func_76125_a((int)(baseAtmosphere + this.random.nextInt(atmosphereFactor) - atmosphereFactor / 2), (int)0, (int)200));
        properties.orbitalDist = MathHelper.func_76125_a((int)(baseDistance + this.random.nextInt(distanceFactor)), (int)0, (int)200);
        properties.gravitationalMultiplier = Math.min(Math.max(0.05f, (float)(baseGravity + this.random.nextInt(gravityFactor) - gravityFactor / 2) / 100.0f), 1.3f);
        do {
            minDistance = Double.MAX_VALUE;
            properties.orbitTheta = (double)this.random.nextInt(360) * (Math.PI * 2) / 360.0;
            for (IDimensionProperties properties2 : this.getStar(starId).getPlanets()) {
                double dist = Math.abs(((DimensionProperties)properties2).orbitTheta - properties.orbitTheta);
                if (!(dist < minDistance)) continue;
                minDistance = dist;
            }
        } while (minDistance < 0.07853981633974483);
        properties.setStar(this.getStar(starId));
        properties.averageTemperature = this.getTemperature(properties.getStar(), properties.orbitalDist, properties.getAtmosphereDensity());
        properties.setGasGiant();
        this.registerDim(properties, true);
        return properties;
    }

    @Override
    public boolean canTravelTo(int dimId) {
        return net.minecraftforge.common.DimensionManager.isDimensionRegistered((int)dimId) && dimId != -1 && !this.getDimensionProperties(dimId).isGasGiant();
    }

    public boolean registerDim(DimensionProperties properties, boolean registerWithForge) {
        boolean bool = this.registerDimNoUpdate(properties, registerWithForge);
        if (bool) {
            PacketHandler.sendToAll((BasePacket)new PacketDimInfo(properties.getId(), properties));
        }
        return bool;
    }

    public boolean registerDimNoUpdate(DimensionProperties properties, boolean registerWithForge) {
        int dimId = properties.getId();
        Integer dim = new Integer(dimId);
        if (this.dimensionList.containsKey(dim)) {
            return false;
        }
        if (registerWithForge && !properties.isGasGiant() && !net.minecraftforge.common.DimensionManager.isDimensionRegistered((int)dim)) {
            net.minecraftforge.common.DimensionManager.registerProviderType((int)properties.getId(), planetWorldProvider, (boolean)false);
            net.minecraftforge.common.DimensionManager.registerDimension((int)dimId, (int)dimId);
        }
        this.dimensionList.put(dimId, properties);
        return true;
    }

    public void unregisterAllDimensions() {
        for (Map.Entry<Integer, DimensionProperties> dimSet : this.dimensionList.entrySet()) {
            if (!dimSet.getValue().isNativeDimension || dimSet.getValue().isGasGiant()) continue;
            net.minecraftforge.common.DimensionManager.unregisterProviderType((int)dimSet.getKey());
            net.minecraftforge.common.DimensionManager.unregisterDimension((int)dimSet.getKey());
        }
        this.dimensionList.clear();
        this.starList.clear();
    }

    public void deleteDimension(int dimId) {
        DimensionProperties properties = this.dimensionList.get(dimId);
        if (properties == null) {
            return;
        }
        if (properties.getStar() != null) {
            properties.getStar().removePlanet(properties);
        }
        if (properties.isMoon()) {
            properties.getParentProperties().removeChild(properties.getId());
        }
        if (properties.hasChildren()) {
            Iterator<Integer> iterator = properties.getChildPlanets().iterator();
            while (iterator.hasNext()) {
                Integer child = iterator.next();
                iterator.remove();
                this.deleteDimension(child);
                PacketHandler.sendToAll((BasePacket)new PacketDimInfo(child, null));
            }
        }
        if (properties.isNativeDimension && net.minecraftforge.common.DimensionManager.isDimensionRegistered((int)dimId)) {
            net.minecraftforge.common.DimensionManager.unloadWorld((int)dimId);
            net.minecraftforge.common.DimensionManager.unregisterProviderType((int)dimId);
            net.minecraftforge.common.DimensionManager.unregisterDimension((int)dimId);
        }
        this.dimensionList.remove(new Integer(dimId));
        File file = new File(net.minecraftforge.common.DimensionManager.getCurrentSaveRootDirectory(), "advRocketry/DIM" + dimId);
        try {
            FileUtils.deleteDirectory((File)file);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public DimensionProperties getDimensionProperties(int dimId) {
        DimensionProperties properties = this.dimensionList.get(new Integer(dimId));
        if (dimId == Configuration.spaceDimId || dimId == Integer.MIN_VALUE) {
            return defaultSpaceDimensionProperties;
        }
        return properties == null ? overworldProperties : properties;
    }

    @Override
    public StellarBody getStar(int id) {
        StellarBody star = this.starList.get(new Integer(id));
        return star;
    }

    public Set<Integer> getStarIds() {
        return this.starList.keySet();
    }

    @Override
    public Collection<StellarBody> getStars() {
        return this.starList.values();
    }

    public void addStar(StellarBody star) {
        this.starList.put(star.getId(), star);
    }

    public void removeStar(int id) {
        this.starList.remove(id);
    }

    public void saveDimensions(String filePath) {
        NBTTagCompound nbt = new NBTTagCompound();
        NBTTagCompound dimListnbt = new NBTTagCompound();
        NBTTagCompound solarSystem = new NBTTagCompound();
        for (Map.Entry<Integer, StellarBody> entry : this.starList.entrySet()) {
            NBTTagCompound nBTTagCompound = new NBTTagCompound();
            entry.getValue().writeToNBT(nBTTagCompound);
            solarSystem.func_74782_a(entry.getKey().toString(), (NBTBase)nBTTagCompound);
        }
        nbt.func_74782_a("starSystems", (NBTBase)solarSystem);
        nbt.func_74772_a("nextSatelliteId", nextSatelliteId);
        NBTTagCompound dimNbt = new NBTTagCompound();
        for (Map.Entry<Integer, DimensionProperties> entry : this.dimensionList.entrySet()) {
            dimNbt = new NBTTagCompound();
            entry.getValue().writeToNBT(dimNbt);
            dimListnbt.func_74782_a(entry.getKey().toString(), (NBTBase)dimNbt);
        }
        nbt.func_74782_a("dimList", (NBTBase)dimListnbt);
        NBTTagCompound nBTTagCompound = new NBTTagCompound();
        nBTTagCompound.func_74757_a("hasReachedMoon", hasReachedMoon);
        nBTTagCompound.func_74757_a("hasReachedWarp", hasReachedWarp);
        nbt.func_74782_a("stat", (NBTBase)nBTTagCompound);
        NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
        SpaceObjectManager.getSpaceManager().writeToNBT(nBTTagCompound2);
        nbt.func_74782_a("spaceObjects", (NBTBase)nBTTagCompound2);
        String xmlOutput = XMLPlanetLoader.writeXML(this);
        try {
            File planetXMLOutput = new File(net.minecraftforge.common.DimensionManager.getCurrentSaveRootDirectory(), filePath + worldXML);
            if (!planetXMLOutput.exists()) {
                planetXMLOutput.createNewFile();
            }
            PrintWriter bufoutStream = new PrintWriter(planetXMLOutput);
            bufoutStream.write(xmlOutput);
            bufoutStream.close();
            File file = new File(net.minecraftforge.common.DimensionManager.getCurrentSaveRootDirectory(), filePath + tempFile);
            if (!file.exists()) {
                file.createNewFile();
            }
            File tmpFile = File.createTempFile("dimprops", null);
            FileOutputStream outStream = new FileOutputStream(tmpFile);
            try {
                CompressedStreamTools.func_74799_a((NBTTagCompound)nbt, (OutputStream)outStream);
                FileOutputStream properOstream = new FileOutputStream(file);
                FileInputStream inStream = new FileInputStream(tmpFile);
                byte[] buffer = new byte[1024];
                int numRead = 0;
                while ((numRead = inStream.read(buffer)) > 0) {
                    properOstream.write(buffer, 0, numRead);
                }
                inStream.close();
                properOstream.close();
                tmpFile.delete();
            }
            catch (Exception e) {
                AdvancedRocketry.logger.error("Cannot save advanced rocketry planet file");
                e.printStackTrace();
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean isDimensionCreated(int dimId) {
        return this.dimensionList.containsKey(new Integer(dimId)) || dimId == Configuration.spaceDimId;
    }

    public boolean loadDimensions(String filePath) {
        NBTTagCompound nbt;
        this.hasBeenInitiallized = true;
        try {
            File file = new File(net.minecraftforge.common.DimensionManager.getCurrentSaveRootDirectory(), filePath + tempFile);
            if (!file.exists()) {
                new File(file.getAbsolutePath().substring(0, file.getAbsolutePath().length() - file.getName().length())).mkdirs();
                file.createNewFile();
                return false;
            }
            FileInputStream inStream = new FileInputStream(file);
            nbt = CompressedStreamTools.func_74796_a((InputStream)inStream);
            inStream.close();
        }
        catch (EOFException e) {
            return false;
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return false;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        NBTTagCompound solarSystem = nbt.func_74775_l("starSystems");
        if (solarSystem.func_82582_d()) {
            return false;
        }
        NBTTagCompound stats = nbt.func_74775_l("stat");
        hasReachedMoon = stats.func_74767_n("hasReachedMoon");
        hasReachedWarp = stats.func_74767_n("hasReachedWarp");
        for (Object key : solarSystem.func_150296_c()) {
            NBTTagCompound solarNBT = solarSystem.func_74775_l((String)key);
            StellarBody star = new StellarBody();
            star.readFromNBT(solarNBT);
            this.starList.put(star.getId(), star);
        }
        nbt.func_74782_a("starSystems", (NBTBase)solarSystem);
        nextSatelliteId = nbt.func_74763_f("nextSatelliteId");
        NBTTagCompound dimListNbt = nbt.func_74775_l("dimList");
        for (Object key : dimListNbt.func_150296_c()) {
            String keyString = (String)key;
            DimensionProperties propeties = DimensionProperties.createFromNBT(Integer.parseInt(keyString), dimListNbt.func_74775_l(keyString));
            if (propeties != null) {
                int keyInt = Integer.parseInt(keyString);
                if (!net.minecraftforge.common.DimensionManager.isDimensionRegistered((int)keyInt) && propeties.isNativeDimension && !propeties.isGasGiant()) {
                    net.minecraftforge.common.DimensionManager.registerProviderType((int)keyInt, planetWorldProvider, (boolean)false);
                    net.minecraftforge.common.DimensionManager.registerDimension((int)keyInt, (int)keyInt);
                }
                this.dimensionList.put(new Integer(keyInt), propeties);
                continue;
            }
            Logger.getLogger("advancedRocketry").warning("Null Dimension Properties Recieved");
        }
        if (nbt.func_74764_b("spaceObjects")) {
            NBTTagCompound nbtTag = nbt.func_74775_l("spaceObjects");
            SpaceObjectManager.getSpaceManager().readFromNBT(nbtTag);
        }
        for (ISpaceObject i : SpaceObjectManager.getSpaceManager().getSpaceObjects()) {
            if (this.isDimensionCreated(i.getOrbitingPlanetId()) || i.getOrbitingPlanetId() == 0 || i.getOrbitingPlanetId() == Integer.MIN_VALUE) continue;
            AdvancedRocketry.logger.warn("Dimension ID " + i.getOrbitingPlanetId() + " is not registered and a space station is orbiting it, moving to dimid 0");
            i.setOrbitingBody(0);
        }
        prevBuild = nbt.func_74779_i("prevVersion");
        nbt.func_74778_a("prevVersion", "1.2.5");
        return true;
    }

    @Override
    public boolean areDimensionsInSamePlanetMoonSystem(int destinationDimId, int dimension) {
        if (dimension == Integer.MIN_VALUE || destinationDimId == Integer.MIN_VALUE) {
            return false;
        }
        DimensionProperties properties = this.getDimensionProperties(dimension);
        DimensionProperties properties2 = this.getDimensionProperties(destinationDimId);
        while (properties.getParentProperties() != null) {
            properties = properties.getParentProperties();
        }
        while (properties2.getParentProperties() != null) {
            properties2 = properties2.getParentProperties();
        }
        return this.areDimensionsInSamePlanetMoonSystem(properties, destinationDimId) || this.areDimensionsInSamePlanetMoonSystem(properties2, dimension);
    }

    private boolean areDimensionsInSamePlanetMoonSystem(DimensionProperties properties, int id) {
        if (properties.getId() == id) {
            return true;
        }
        for (int child : properties.getChildPlanets()) {
            if (!this.areDimensionsInSamePlanetMoonSystem(this.getDimensionProperties(child), id)) continue;
            return true;
        }
        return false;
    }

    public static DimensionProperties getEffectiveDimId(int dimId, int x, int z) {
        if (dimId == Configuration.spaceDimId) {
            ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(x, z);
            if (obj != null) {
                return (DimensionProperties)obj.getProperties().getParentProperties();
            }
            return defaultSpaceDimensionProperties;
        }
        return DimensionManager.getInstance().getDimensionProperties(dimId);
    }

    public static DimensionProperties getEffectiveDimId(World world, int x, int z) {
        int dimId = world.field_73011_w.field_76574_g;
        if (dimId == Configuration.spaceDimId) {
            ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(x, z);
            if (obj != null) {
                return (DimensionProperties)obj.getProperties().getParentProperties();
            }
            return defaultSpaceDimensionProperties;
        }
        return DimensionManager.getInstance().getDimensionProperties(dimId);
    }

    static {
        AdvancedRocketryAPI.dimensionManager = new DimensionManager();
        instance = AdvancedRocketryAPI.dimensionManager;
        dimOffset = 0;
    }
}

