/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.client.render.planet;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;
import zmaster587.advancedRocketry.api.stations.ISpaceObject;
import zmaster587.advancedRocketry.client.render.planet.RenderPlanetarySky;
import zmaster587.advancedRocketry.dimension.DimensionProperties;
import zmaster587.advancedRocketry.stations.SpaceObjectManager;
import zmaster587.libVulpes.render.RenderHelper;
import zmaster587.libVulpes.util.Vector3F;

public class RenderSpaceSky
extends RenderPlanetarySky {
    Minecraft mc = Minecraft.func_71410_x();

    @Override
    protected void renderPlanet2(Tessellator tessellator1, ResourceLocation icon, int locationX, int locationY, double zLevel, float planetOrbitalDistance, float alphaMultiplier, double angle, boolean hasAtmosphere, float[] atmColor, float[] ringColor, boolean isGasgiant, boolean hasRings) {
        float f15;
        ISpaceObject object = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords((int)this.mc.field_71439_g.field_70165_t, (int)this.mc.field_71439_g.field_70161_v);
        if (object == null) {
            return;
        }
        planetOrbitalDistance = object.getOrbitalDistance();
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glDisable((int)2912);
        GL11.glBlendFunc((int)1, (int)0);
        this.mc.field_71446_o.func_110577_a(icon);
        GL11.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
        GL11.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
        float f10 = 100.0f * (200.0f - planetOrbitalDistance) / 100.0f;
        float Xoffset = (float)((double)System.currentTimeMillis() / 1000000.0 % 1.0);
        float f14 = 1.0f + Xoffset;
        float f16 = f15 = 0.0f + Xoffset;
        float f17 = f14;
        tessellator1.func_78382_b();
        tessellator1.func_78369_a(1.0f, 1.0f, 1.0f, alphaMultiplier);
        tessellator1.func_78374_a((double)(-f10), -10.0, (double)f10, (double)f16, (double)f17);
        tessellator1.func_78374_a((double)f10, -10.0, (double)f10, (double)f14, (double)f17);
        tessellator1.func_78374_a((double)f10, -10.0, (double)(-f10), (double)f14, (double)f15);
        tessellator1.func_78374_a((double)(-f10), -10.0, (double)(-f10), (double)f16, (double)f15);
        tessellator1.func_78381_a();
        GL11.glPopAttrib();
        if (isGasgiant) {
            int i;
            GL11.glBlendFunc((int)770, (int)1);
            tessellator1.func_78382_b();
            this.mc.field_71446_o.func_110577_a(DimensionProperties.getAtmosphereLEOResource());
            double dist = -5.0 - (double)(4.0f * planetOrbitalDistance) / 200.0;
            double scalingMult = 1.0 - 0.9 * (double)planetOrbitalDistance / 200.0;
            int maxAmt = 6;
            float lng = (float)((double)Minecraft.func_71386_F() / 100000.0 % 1.0);
            for (i = 0; i < maxAmt; ++i) {
                tessellator1.func_78369_a(0.05f * ((float)maxAmt - (float)i / 6.0f), 0.4f * ((float)i / 6.0f), 1.0f, 0.4f);
                Xoffset = lng * ((float)i - (float)maxAmt / 4.0f);
                float Yoffset = -lng * (float)i;
                f14 = (float)i + Yoffset;
                f15 = 0.0f + Yoffset;
                f16 = 0.0f + Xoffset;
                f17 = (float)i + Xoffset;
                RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)(-10.0 + (double)i * scalingMult), (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)(-10.0 + (double)i * scalingMult), (double)0.0, (double)0.0, (double)f10, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)(-10.0 + (double)i * scalingMult), (double)(-f10), (double)0.0, (double)0.0, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)(-10.0 + (double)i * scalingMult), (double)0.0, (double)(-f10), (double)f10, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
            }
            tessellator1.func_78381_a();
            GL11.glDisable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            tessellator1.func_78382_b();
            tessellator1.func_78369_a(0.5f, 0.5f, 1.0f, 0.08f);
            for (i = 0; i < 5; ++i) {
                RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)(dist + (double)i * scalingMult), (double)0.0, (double)0.0, (double)f10, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)0.0, (double)0.0, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)(dist + (double)i * scalingMult), (double)0.0, (double)(-f10), (double)f10, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
            }
            tessellator1.func_78381_a();
            GL11.glEnable((int)3553);
        } else if (hasAtmosphere) {
            GL11.glBlendFunc((int)770, (int)1);
            tessellator1.func_78382_b();
            this.mc.field_71446_o.func_110577_a(DimensionProperties.getAtmosphereLEOResource());
            tessellator1.func_78369_a(1.0f, 1.0f, 1.0f, 0.8f);
            Xoffset = (float)((double)System.currentTimeMillis() / 100000.0 % 1.0);
            f14 = 1.0f + Xoffset;
            f16 = f15 = 0.0f + Xoffset;
            f17 = f14;
            RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)-10.0, (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
            RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)-10.0, (double)0.0, (double)0.0, (double)f10, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
            RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)-10.0, (double)(-f10), (double)0.0, (double)0.0, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
            RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)-10.0, (double)0.0, (double)(-f10), (double)f10, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
            tessellator1.func_78381_a();
            GL11.glDisable((int)3553);
            GL11.glBlendFunc((int)770, (int)771);
            tessellator1.func_78382_b();
            tessellator1.func_78369_a(atmColor[0], atmColor[1], atmColor[2], 0.08f);
            double dist = -5.0 - (double)(4.0f * planetOrbitalDistance) / 200.0;
            double scalingMult = 1.0 - 0.9 * (double)planetOrbitalDistance / 200.0;
            for (int i = 0; i < 5; ++i) {
                RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)(-f10), (double)0.0, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)(dist + (double)i * scalingMult), (double)0.0, (double)0.0, (double)f10, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)(dist + (double)i * scalingMult), (double)(-f10), (double)0.0, (double)0.0, (double)f10, (double)f14, (double)f15, (double)f16, (double)f17);
                RenderHelper.renderTopFaceWithUV((Tessellator)tessellator1, (double)(dist + (double)i * scalingMult), (double)0.0, (double)(-f10), (double)f10, (double)0.0, (double)f14, (double)f15, (double)f16, (double)f17);
            }
            tessellator1.func_78381_a();
            GL11.glEnable((int)3553);
        }
        tessellator1.func_78369_a(1.0f, 1.0f, 1.0f, 1.0f);
        GL11.glEnable((int)2912);
        GL11.glPopMatrix();
    }

    @Override
    protected ForgeDirection getRotationAxis(DimensionProperties properties, int x, int z) {
        try {
            return SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords(x, z).getForwardDirection().getRotation(ForgeDirection.UP);
        }
        catch (Exception e) {
            return ForgeDirection.EAST;
        }
    }

    @Override
    protected void rotateAroundAxis() {
        Vector3F<Float> axis = this.getRotateAxis();
        ISpaceObject obj = SpaceObjectManager.getSpaceManager().getSpaceStationFromBlockCoords((int)this.mc.field_71439_g.field_70165_t, (int)this.mc.field_71439_g.field_70161_v);
        GL11.glRotated((double)(obj.getRotation(ForgeDirection.UP) * 360.0), (double)0.0, (double)1.0, (double)0.0);
        GL11.glRotated((double)(obj.getRotation(ForgeDirection.EAST) * 360.0), (double)1.0, (double)0.0, (double)0.0);
    }

    @Override
    protected ResourceLocation getTextureForPlanet(DimensionProperties properties) {
        return properties.getPlanetIconLEO();
    }
}

