/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.cable;

import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;
import zmaster587.advancedRocketry.cable.CableNetwork;

public class LiquidNetwork
extends CableNetwork {
    private final int MAX_TRANSFER = 100;

    public static LiquidNetwork initNetwork() {
        Random random = new Random(System.currentTimeMillis());
        int id = random.nextInt();
        while (usedIds.contains(id)) {
            id = random.nextInt();
        }
        LiquidNetwork net = new LiquidNetwork();
        usedIds.add(id);
        net.networkID = id;
        return net;
    }

    @Override
    public void tick() {
        int amount = 100;
        if (this.sinks.isEmpty() || this.sources.isEmpty()) {
            return;
        }
        for (Map.Entry obj : this.sinks) {
            IFluidHandler fluidHandleSink = (IFluidHandler)obj.getKey();
            ForgeDirection dir = (ForgeDirection)obj.getValue();
            Iterator sourceItr = this.sources.iterator();
            Fluid fluid = null;
            if (fluidHandleSink.getTankInfo(dir) != null) {
                for (FluidTankInfo info : fluidHandleSink.getTankInfo(dir)) {
                    if (info == null || info.fluid == null) continue;
                    fluid = info.fluid.getFluid();
                    break;
                }
            }
            if (fluid == null) {
                block2: while (sourceItr.hasNext()) {
                    Map.Entry objSource = (Map.Entry)sourceItr.next();
                    IFluidHandler fluidHandleSource = (IFluidHandler)objSource.getKey();
                    if (fluidHandleSource.getTankInfo((ForgeDirection)objSource.getValue()) == null) continue;
                    for (FluidTankInfo srcInfo : fluidHandleSource.getTankInfo((ForgeDirection)objSource.getValue())) {
                        if (srcInfo == null || srcInfo.fluid == null) continue;
                        fluid = srcInfo.fluid.getFluid();
                        break block2;
                    }
                }
            }
            if (fluid == null) break;
            if (!fluidHandleSink.canFill(dir, fluid)) continue;
            sourceItr = this.sources.iterator();
            int maxFill = Math.min(fluidHandleSink.fill(dir, new FluidStack(fluid, amount), false), amount);
            int actualFill = 0;
            while (sourceItr.hasNext()) {
                Map.Entry objSource = (Map.Entry)sourceItr.next();
                IFluidHandler fluidHandleSource = (IFluidHandler)objSource.getKey();
                if (fluidHandleSource.canDrain((ForgeDirection)objSource.getValue(), fluid)) {
                    FluidStack fluid2 = fluidHandleSource.drain((ForgeDirection)objSource.getValue(), maxFill, true);
                    int buffer = fluid2 == null || fluid2.getFluidID() != fluid.getID() ? 0 : fluid2.amount;
                    maxFill -= buffer;
                    actualFill += buffer;
                }
                if (maxFill != 0) continue;
                break;
            }
            fluidHandleSink.fill(dir, new FluidStack(fluid, actualFill), true);
        }
    }
}

