/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.cable;

import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.cable.CableNetwork;
import zmaster587.libVulpes.api.IUniversalEnergy;
import zmaster587.libVulpes.util.UniversalBattery;

public class EnergyNetwork
extends CableNetwork
implements IUniversalEnergy {
    UniversalBattery battery = new UniversalBattery(500);

    public static EnergyNetwork initNetwork() {
        Random random = new Random(System.currentTimeMillis());
        int id = random.nextInt();
        while (usedIds.contains(id)) {
            id = random.nextInt();
        }
        EnergyNetwork net = new EnergyNetwork();
        usedIds.add(id);
        net.networkID = id;
        return net;
    }

    @Override
    public boolean merge(CableNetwork cableNetwork) {
        if (super.merge(cableNetwork)) {
            this.battery.acceptEnergy(((EnergyNetwork)cableNetwork).battery.getEnergyStored(), false);
            return true;
        }
        return false;
    }

    @Override
    public void tick() {
        IEnergyReceiver dataHandlerSink;
        int amountToMove;
        IEnergyReceiver dataHandlerSink2;
        Map.Entry obj;
        int amount = 1000;
        if (this.sinks.isEmpty() || this.sources.isEmpty() && this.battery.getEnergyStored() != 0) {
            return;
        }
        int demand = 0;
        int supply = this.battery.getEnergyStored();
        Iterator sinkItr = this.sinks.iterator();
        Iterator sourceItr = this.sources.iterator();
        while (sinkItr.hasNext()) {
            obj = (Map.Entry)sinkItr.next();
            dataHandlerSink2 = (IEnergyReceiver)obj.getKey();
            demand += dataHandlerSink2.receiveEnergy((ForgeDirection)obj.getValue(), amount, true);
        }
        while (sourceItr.hasNext()) {
            obj = (Map.Entry)sourceItr.next();
            dataHandlerSink2 = (IEnergyProvider)obj.getKey();
            supply += dataHandlerSink2.extractEnergy((ForgeDirection)obj.getValue(), amount, true);
        }
        int amountMoved = amountToMove = Math.min(supply, demand);
        for (Map.Entry obj2 : this.sinks) {
            dataHandlerSink = (IEnergyReceiver)obj2.getKey();
            amountToMove -= dataHandlerSink.receiveEnergy((ForgeDirection)obj2.getValue(), amountToMove, false);
        }
        amountMoved -= this.battery.extractEnergy(amountMoved, false);
        for (Map.Entry obj2 : this.sources) {
            dataHandlerSink = (IEnergyProvider)obj2.getKey();
            amountMoved -= dataHandlerSink.extractEnergy((ForgeDirection)obj2.getValue(), amountMoved, false);
        }
    }

    public void setEnergyStored(int amt) {
    }

    public int extractEnergy(int amt, boolean simulate) {
        return 0;
    }

    public int getEnergyStored() {
        return 0;
    }

    public int getMaxEnergyStored() {
        return 0;
    }

    public int acceptEnergy(int amt, boolean simulate) {
        return this.battery.acceptEnergy(amt, simulate);
    }

    public void setMaxEnergyStored(int max) {
    }
}

