/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.cable;

import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.api.DataStorage;
import zmaster587.advancedRocketry.api.satellite.IDataHandler;
import zmaster587.advancedRocketry.cable.CableNetwork;

public class DataNetwork
extends CableNetwork {
    public static DataNetwork initNetwork() {
        Random random = new Random(System.currentTimeMillis());
        int id = random.nextInt();
        while (usedIds.contains(id)) {
            id = random.nextInt();
        }
        DataNetwork net = new DataNetwork();
        usedIds.add(id);
        net.networkID = id;
        return net;
    }

    @Override
    public void tick() {
        int amount = 1;
        if (this.sinks.isEmpty() || this.sources.isEmpty()) {
            return;
        }
        for (DataStorage.DataType data : DataStorage.DataType.values()) {
            IDataHandler dataHandlerSink;
            int amountToMove;
            IDataHandler dataHandlerSink2;
            Map.Entry obj;
            if (data == DataStorage.DataType.UNDEFINED) continue;
            int demand = 0;
            int supply = 0;
            Iterator sinkItr = this.sinks.iterator();
            Iterator sourceItr = this.sources.iterator();
            while (sinkItr.hasNext()) {
                obj = (Map.Entry)sinkItr.next();
                dataHandlerSink2 = (IDataHandler)obj.getKey();
                demand += dataHandlerSink2.addData(amount, data, (ForgeDirection)obj.getValue(), false);
            }
            while (sourceItr.hasNext()) {
                obj = (Map.Entry)sourceItr.next();
                dataHandlerSink2 = (IDataHandler)obj.getKey();
                supply += dataHandlerSink2.extractData(amount, data, (ForgeDirection)obj.getValue(), false);
            }
            int amountMoved = amountToMove = Math.min(supply, demand);
            for (Map.Entry obj2 : this.sinks) {
                dataHandlerSink = (IDataHandler)obj2.getKey();
                amountToMove -= dataHandlerSink.addData(amountToMove, data, (ForgeDirection)obj2.getValue(), true);
            }
            for (Map.Entry obj2 : this.sources) {
                dataHandlerSink = (IDataHandler)obj2.getKey();
                amountMoved -= dataHandlerSink.extractData(amountMoved, data, (ForgeDirection)obj2.getValue(), true);
            }
        }
    }
}

