/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.cable;

import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.tile.cables.TilePipe;
import zmaster587.libVulpes.util.SingleEntry;

public class CableNetwork {
    int networkID;
    protected int numCables = 0;
    protected static HashSet<Integer> usedIds = new HashSet();
    CopyOnWriteArraySet<Map.Entry<TileEntity, ForgeDirection>> sources = new CopyOnWriteArraySet();
    CopyOnWriteArraySet<Map.Entry<TileEntity, ForgeDirection>> sinks = new CopyOnWriteArraySet();

    protected CableNetwork() {
    }

    public Set<Map.Entry<TileEntity, ForgeDirection>> getSources() {
        return this.sources;
    }

    public Set<Map.Entry<TileEntity, ForgeDirection>> getSinks() {
        return this.sinks;
    }

    public void addSource(TileEntity tile, ForgeDirection dir) {
        for (Map.Entry<TileEntity, ForgeDirection> entry : this.sources) {
            TileEntity tile2 = entry.getKey();
            if (tile2.equals(tile)) {
                return;
            }
            if (tile2.field_145851_c != tile.field_145851_c || tile2.field_145848_d != tile.field_145848_d || tile2.field_145849_e != tile.field_145849_e) continue;
            this.sources.remove(entry);
            break;
        }
        this.sources.add((Map.Entry<TileEntity, ForgeDirection>)new SingleEntry((Object)tile, (Object)dir));
    }

    public void addSink(TileEntity tile, ForgeDirection dir) {
        for (Map.Entry<TileEntity, ForgeDirection> entry : this.sinks) {
            TileEntity tile2 = entry.getKey();
            if (tile2.equals(tile)) {
                return;
            }
            if (tile2.field_145851_c != tile.field_145851_c || tile2.field_145848_d != tile.field_145848_d || tile2.field_145849_e != tile.field_145849_e) continue;
            this.sinks.remove(entry);
            break;
        }
        this.sinks.add((Map.Entry<TileEntity, ForgeDirection>)new SingleEntry((Object)tile, (Object)dir));
    }

    public void writeToNBT(NBTTagCompound nbt) {
    }

    public void readFromNBT(NBTTagCompound nbt) {
    }

    public static CableNetwork initWithID(int id) {
        CableNetwork net = new CableNetwork();
        net.networkID = id;
        return net;
    }

    public static CableNetwork initNetwork() {
        Random random = new Random(System.currentTimeMillis());
        int id = random.nextInt();
        while (usedIds.contains(id)) {
            id = random.nextInt();
        }
        CableNetwork net = new CableNetwork();
        usedIds.add(id);
        net.networkID = id;
        return net;
    }

    public int getNetworkID() {
        return this.networkID;
    }

    public void removeFromAll(TileEntity tile) {
        TileEntity tile2;
        for (Map.Entry<TileEntity, ForgeDirection> entry : this.sources) {
            tile2 = entry.getKey();
            if (tile2.field_145851_c != tile.field_145851_c || tile2.field_145848_d != tile.field_145848_d || tile2.field_145849_e != tile.field_145849_e) continue;
            this.sources.remove(entry);
            break;
        }
        for (Map.Entry<TileEntity, ForgeDirection> entry : this.sinks) {
            tile2 = entry.getKey();
            if (tile2.field_145851_c != tile.field_145851_c || tile2.field_145848_d != tile.field_145848_d || tile2.field_145849_e != tile.field_145849_e) continue;
            this.sinks.remove(entry);
            break;
        }
    }

    public String toString() {
        TileEntity tile;
        String output = "Sources: ";
        for (Map.Entry<TileEntity, ForgeDirection> obj : this.sources) {
            tile = obj.getKey();
            output = output + tile.field_145851_c + "," + tile.field_145848_d + "," + tile.field_145849_e + " ";
        }
        output = output + "    Sinks: ";
        for (Map.Entry<TileEntity, ForgeDirection> obj : this.sinks) {
            tile = obj.getKey();
            output = output + tile.field_145851_c + "," + tile.field_145848_d + "," + tile.field_145849_e + " ";
        }
        return output;
    }

    public boolean merge(CableNetwork cableNetwork) {
        boolean canMerge;
        this.sinks.addAll(cableNetwork.getSinks());
        for (Map.Entry<TileEntity, ForgeDirection> obj : cableNetwork.getSinks()) {
            canMerge = true;
            for (Map.Entry<TileEntity, ForgeDirection> obj2 : this.sinks) {
                if (obj.getKey().field_145851_c != obj2.getKey().field_145851_c || obj.getKey().field_145848_d != obj2.getKey().field_145848_d || obj.getKey().field_145849_e != obj2.getKey().field_145849_e || obj.getValue() != obj2.getValue()) continue;
                return false;
            }
            if (!canMerge) continue;
            this.sinks.add(obj);
        }
        for (Map.Entry<TileEntity, ForgeDirection> obj : cableNetwork.getSources()) {
            canMerge = true;
            for (Map.Entry<TileEntity, ForgeDirection> obj2 : this.sources) {
                if (obj.getKey().field_145851_c != obj2.getKey().field_145851_c || obj.getKey().field_145848_d != obj2.getKey().field_145848_d || obj.getKey().field_145849_e != obj2.getKey().field_145849_e || obj.getValue() != obj2.getValue()) continue;
                canMerge = false;
                return false;
            }
            if (!canMerge) continue;
            this.sources.add(obj);
        }
        return true;
    }

    public void tick() {
    }

    public void removePipeFromNetwork(TilePipe tilePipe) {
        --this.numCables;
    }

    public void addPipeToNetwork(TilePipe tilePipe) {
        ++this.numCables;
    }
}

