/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.block;

import java.util.HashMap;
import java.util.LinkedList;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import zmaster587.advancedRocketry.api.AreaBlob;
import zmaster587.advancedRocketry.api.util.IBlobHandler;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHandler;
import zmaster587.advancedRocketry.tile.oxygen.TileSeal;
import zmaster587.libVulpes.util.BlockPosition;

public class BlockSeal
extends Block {
    private HashMap<BlockPosition, BlobHandler> blobList = new HashMap();

    public BlockSeal(Material materialIn) {
        super(materialIn);
    }

    public void clearMap() {
        this.blobList.clear();
    }

    public boolean hasTileEntity(int meta) {
        return true;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileSeal();
    }

    public void func_149749_a(World worldIn, int x, int y, int z, Block block, int meta) {
        super.func_149749_a(worldIn, x, y, z, block, meta);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            BlobHandler handler = this.blobList.remove(new BlockPosition(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ));
            if (handler != null) {
                AtmosphereHandler.getOxygenHandler(worldIn.field_73011_w.field_76574_g).unregisterBlob(handler);
            }
            this.fireCheckAllDirections(worldIn, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir);
        }
    }

    public void func_149726_b(World worldIn, int x, int y, int z) {
        super.func_149726_b(worldIn, x, y, z);
        this.checkCompleteness(worldIn, x, y, z);
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            this.fireCheckAllDirections(worldIn, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir);
        }
    }

    public void fireCheckAllDirections(World worldIn, int x, int y, int z, ForgeDirection directionFrom) {
        for (ForgeDirection dir : ForgeDirection.VALID_DIRECTIONS) {
            if (directionFrom.getOpposite() == dir) continue;
            this.fireCheck(worldIn, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ);
        }
    }

    private void fireCheck(World worldIn, int x, int y, int z) {
        Block block = worldIn.func_147439_a(x, y, z);
        if (block == this) {
            BlockSeal blockSeal = (BlockSeal)block;
            blockSeal.checkCompleteness(worldIn, x, y, z);
        }
    }

    private boolean checkCompleteness(World worldIn, int x, int y, int z) {
        if ((worldIn.func_147439_a(x - 1, y + 1, z) == this && worldIn.func_147439_a(x + 1, y + 1, z) == this && worldIn.func_147439_a(x, y + 2, z) == this || worldIn.func_147439_a(x, y + 1, z + 1) == this && worldIn.func_147439_a(x, y + 1, z - 1) == this && worldIn.func_147439_a(x, y + 2, z) == this) && !this.blobList.containsKey(new BlockPosition(x, y + 1, z))) {
            BlockPosition hashPos = new BlockPosition(x, ++y, z);
            BlobHandler handler = new BlobHandler(worldIn, hashPos);
            this.blobList.put(hashPos, handler);
            AreaBlob blob = new AreaBlob(handler);
            blob.addBlock(hashPos, new LinkedList<AreaBlob>());
            AtmosphereHandler.getOxygenHandler(worldIn.field_73011_w.field_76574_g).registerBlob(handler, x, y, z, blob);
            return true;
        }
        if (worldIn.func_147439_a(x + 1, y, z + 1) == this && worldIn.func_147439_a(x + 1, y, z - 1) == this && worldIn.func_147439_a(x + 2, y, z) == this && !this.blobList.containsKey(new BlockPosition(x + 1, y, z))) {
            BlockPosition hashPos = new BlockPosition(++x, y, z);
            BlobHandler handler = new BlobHandler(worldIn, hashPos);
            this.blobList.put(hashPos, handler);
            AreaBlob blob = new AreaBlob(handler);
            blob.addBlock(hashPos, new LinkedList<AreaBlob>());
            AtmosphereHandler.getOxygenHandler(worldIn.field_73011_w.field_76574_g).registerBlob(handler, x, y, z, blob);
            return true;
        }
        return false;
    }

    private static class BlobHandler
    implements IBlobHandler {
        World world;
        BlockPosition pos;

        public BlobHandler(World world, BlockPosition pos) {
            this.world = world;
            this.pos = pos;
        }

        @Override
        public boolean canFormBlob() {
            return true;
        }

        @Override
        public World getWorld() {
            return this.world;
        }

        @Override
        public boolean canBlobsOverlap(BlockPosition blockPosition, AreaBlob blob) {
            return false;
        }

        @Override
        public int getMaxBlobRadius() {
            return 0;
        }

        @Override
        public BlockPosition getRootPosition() {
            return this.pos;
        }
    }
}

