/*
 * Decompiled with CFR 0.152.
 */
package zmaster587.advancedRocketry.atmosphere;

import net.minecraft.entity.EntityLivingBase;
import zmaster587.advancedRocketry.api.IAtmosphere;
import zmaster587.advancedRocketry.api.atmosphere.AtmosphereRegister;
import zmaster587.advancedRocketry.atmosphere.AtmosphereHighPressure;
import zmaster587.advancedRocketry.atmosphere.AtmosphereLowOxygen;
import zmaster587.advancedRocketry.atmosphere.AtmosphereVacuum;

public class AtmosphereType
implements IAtmosphere {
    public static final AtmosphereType AIR = new AtmosphereType(false, true, "air");
    public static final AtmosphereType PRESSURIZEDAIR = new AtmosphereType(false, true, "PressurizedAir");
    public static final AtmosphereType VACUUM = new AtmosphereVacuum();
    public static final AtmosphereType LOWOXYGEN = new AtmosphereLowOxygen(true, false, "lowO2");
    public static final AtmosphereType HIGHPRESSURE = new AtmosphereHighPressure(true, true, "HighPressure");
    private boolean allowsCombustion;
    private boolean isBreathable;
    private boolean canTick;
    private String name;

    public AtmosphereType(boolean canTick, boolean isBreathable, String name) {
        this.allowsCombustion = isBreathable;
        this.isBreathable = isBreathable;
        this.canTick = canTick;
        this.name = name;
    }

    public AtmosphereType(boolean canTick, boolean isBreathable, boolean allowsCombustion, String name) {
        this(canTick, isBreathable, name);
        this.allowsCombustion = allowsCombustion;
    }

    @Override
    public boolean canTick() {
        return this.canTick;
    }

    @Override
    public boolean isImmune(EntityLivingBase player) {
        return this.isBreathable;
    }

    @Override
    public boolean isBreathable() {
        return this.isBreathable;
    }

    @Override
    public boolean allowsCombustion() {
        return this.allowsCombustion;
    }

    public void setIsBreathable(boolean isBreathable) {
        this.isBreathable = isBreathable;
    }

    public void setAllowsCombustion(boolean allowsCombustion) {
        this.allowsCombustion = allowsCombustion;
    }

    @Override
    public String getDisplayMessage() {
        return "";
    }

    @Override
    public void onTick(EntityLivingBase player) {
    }

    @Override
    public String getUnlocalizedName() {
        return this.name;
    }

    static {
        AtmosphereRegister.getInstance().registerAtmosphere(AIR);
        AtmosphereRegister.getInstance().registerAtmosphere(PRESSURIZEDAIR);
        AtmosphereRegister.getInstance().registerAtmosphere(VACUUM);
        AtmosphereRegister.getInstance().registerAtmosphere(LOWOXYGEN);
        AtmosphereRegister.getInstance().registerAtmosphere(HIGHPRESSURE);
    }
}

